# Stone of Orthanc
# Copyright (C) 2012-2016 Sebastien Jodogne, Medical Physics
# Department, University Hospital of Liege, Belgium
# Copyright (C) 2017-2023 Osimis S.A., Belgium
# Copyright (C) 2021-2025 Sebastien Jodogne, ICTEAM UCLouvain, Belgium
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.


macro(GetFilenameFromPath TargetVariable Path)
#message(STATUS "GetFilenameFromPath (1): Path = ${Path} TargetVariable = ${${TargetVariable}}")
string(REPLACE "\\" "/" PathWithFwdSlashes "${Path}")
string(REGEX REPLACE "^.*/" "" ${TargetVariable} "${PathWithFwdSlashes}")
#message(STATUS "GetFilenameFromPath (2): Path = ${Path} Path = ${PathWithFwdSlashes} TargetVariable = ${TargetVariable}")
endmacro()

macro(GetFilePathWithoutLastExtension TargetVariable FilePath)
string(REGEX REPLACE "(^.*)\\.([^\\.]+)" "\\1" ${TargetVariable} "${FilePath}")
#message(STATUS "GetFileNameWithoutLastExtension: FilePath = ${FilePath} TargetVariable = ${${TargetVariable}}")
endmacro()

macro(Test_GetFilePathWithoutLastExtension)
set(tmp "/prout/zi/goui.goui.cpp")
GetFilePathWithoutLastExtension(TargetVariable "${tmp}")
if(NOT ("${TargetVariable}" STREQUAL "/prout/zi/goui.goui"))
  message(FATAL_ERROR "Test_GetFilePathWithoutLastExtension failed (1)")
else()
  #message(STATUS "Test_GetFilePathWithoutLastExtension: <<OK>>")
endif()
endmacro()

Test_GetFilePathWithoutLastExtension()

macro(Test_GetFilenameFromPath)
set(tmp "/prout/../../dada/zi/goui.goui.cpp")
GetFilenameFromPath(TargetVariable "${tmp}")
if(NOT ("${TargetVariable}" STREQUAL "goui.goui.cpp"))
  message(FATAL_ERROR "Test_GetFilenameFromPath failed")
else()
  #message(STATUS "Test_GetFilenameFromPath: <<OK>>")
endif()
endmacro()

Test_GetFilenameFromPath()

macro(SortFilesInSourceGroups)
  if(FALSE)
    foreach(source IN LISTS ORTHANC_STONE_SOURCES)
        # if("${source}" MATCHES ".*/pixman.*\\.c")
        #   message("pixman source: ${source}")
        # elseif("${source}" MATCHES ".*/pixman.*\\.c")
        #   message("pixman header: ${source}")
        # endif()
        
        if("${source}" MATCHES ".*\\.\\./.*")
          message("source raw: ${source}")
          #file(TO_CMAKE_PATH ${source} sourceCMakePath)
          get_filename_component(sourceCMakePath ${source} ABSOLUTE)
          message("source CMake: ${sourceCMakePath}")
        endif()

        # returns the containing directory with forward slashes
        # get_filename_component(source_path "${source}" PATH) 

        # converts / to \
        # string(REPLACE "/" "\\" source_path_msvc "${source_path}")
        #source_group("Stone ${source_path_msvc}" FILES "${source}")
    endforeach()
  endif()

  source_group("Orthanc Framework\\Sources" REGULAR_EXPRESSION ".*/orthanc/(Core|Plugins)/.*cpp")
  source_group("Orthanc Framework\\Headers" REGULAR_EXPRESSION ".*/orthanc/(Core|Plugins)/.*hpp")
  source_group("Orthanc Framework\\Headers" REGULAR_EXPRESSION ".*/orthanc/(Core|Plugins)/.*h")

  source_group("Stone Library\\Sources" REGULAR_EXPRESSION ".*/orthanc-stone/.*cpp")
  source_group("Stone Library\\Headers" REGULAR_EXPRESSION ".*/orthanc-stone/.*hpp")
  source_group("Stone Library\\Headers" REGULAR_EXPRESSION ".*/orthanc-stone/.*h")

  source_group("Stone Samples\\Source" REGULAR_EXPRESSION ".*orthanc-stone/OrthancStone/Samples/.*\\.cpp")
  source_group("Stone Samples\\Headers" REGULAR_EXPRESSION ".*orthanc-stone/OrthancStone/Samples/.*\\.h")

  source_group("ThirdParty\\cairo" REGULAR_EXPRESSION ".*${CMAKE_BINARY_DIR}/cairo[^/]*/.*")
  source_group("ThirdParty\\pixman" REGULAR_EXPRESSION ".*${CMAKE_BINARY_DIR}/pixman[^/]*/.*")
  source_group("ThirdParty\\base64" REGULAR_EXPRESSION ".*ThirdParty/base64.*")
  source_group("ThirdParty\\SDL2" REGULAR_EXPRESSION ".*${CMAKE_BINARY_DIR}/SDL2.*")
  source_group("ThirdParty\\glew" REGULAR_EXPRESSION ".*${CMAKE_BINARY_DIR}/glew.*")
  source_group("AUTOGENERATED" REGULAR_EXPRESSION ".*${CMAKE_BINARY_DIR}/AUTOGENERATED/.*")
  source_group("ThirdParty\\minizip" REGULAR_EXPRESSION ".*ThirdParty/minizip/.*")
  source_group("ThirdParty\\md5" REGULAR_EXPRESSION ".*ThirdParty/md5/.*")
endmacro()

