/*
 * Decompiled with CFR 0.152.
 */
package be.uclouvain.orthanc;

import be.uclouvain.orthanc.ImageFormat;
import be.uclouvain.orthanc.NativeSDK;
import be.uclouvain.orthanc.PixelFormat;

public class Image {
    private long self;

    protected Image(long l) {
        if (l == 0L) {
            throw new IllegalArgumentException("Null pointer");
        }
        this.self = l;
    }

    protected long getSelf() {
        return this.self;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this.self != 0L) {
            NativeSDK.OrthancPluginFreeImage(this.self);
            this.self = 0L;
        }
    }

    public static Image uncompressImage(byte[] byArray, ImageFormat imageFormat) {
        return new Image(NativeSDK.OrthancPluginUncompressImage(byArray, imageFormat.getValue()));
    }

    public static Image createImage(PixelFormat pixelFormat, int n, int n2) {
        return new Image(NativeSDK.OrthancPluginCreateImage(pixelFormat.getValue(), n, n2));
    }

    public static Image decodeDicomImage(byte[] byArray, int n) {
        return new Image(NativeSDK.OrthancPluginDecodeDicomImage(byArray, n));
    }

    public PixelFormat getImagePixelFormat() {
        return PixelFormat.getInstance(NativeSDK.OrthancPluginGetImagePixelFormat(this.self));
    }

    public int getImageWidth() {
        return NativeSDK.OrthancPluginGetImageWidth(this.self);
    }

    public int getImageHeight() {
        return NativeSDK.OrthancPluginGetImageHeight(this.self);
    }

    public int getImagePitch() {
        return NativeSDK.OrthancPluginGetImagePitch(this.self);
    }

    public Image convertPixelFormat(PixelFormat pixelFormat) {
        return new Image(NativeSDK.OrthancPluginConvertPixelFormat(this.self, pixelFormat.getValue()));
    }

    public void drawText(int n, String string, int n2, int n3, byte by, byte by2, byte by3) {
        NativeSDK.OrthancPluginDrawText(this.self, n, string, n2, n3, by, by2, by3);
    }
}

