/*
 * Decompiled with CFR 0.152.
 */
package be.uclouvain.orthanc;

import be.uclouvain.orthanc.DicomToJsonFlags;
import be.uclouvain.orthanc.DicomToJsonFormat;
import be.uclouvain.orthanc.Image;
import be.uclouvain.orthanc.InstanceOrigin;
import be.uclouvain.orthanc.LoadDicomInstanceMode;
import be.uclouvain.orthanc.NativeSDK;

public class DicomInstance {
    private long self;

    protected DicomInstance(long l) {
        if (l == 0L) {
            throw new IllegalArgumentException("Null pointer");
        }
        this.self = l;
    }

    protected long getSelf() {
        return this.self;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this.self != 0L) {
            NativeSDK.OrthancPluginFreeDicomInstance(this.self);
            this.self = 0L;
        }
    }

    public static DicomInstance createDicomInstance(byte[] byArray) {
        return new DicomInstance(NativeSDK.OrthancPluginCreateDicomInstance(byArray));
    }

    public static DicomInstance transcodeDicomInstance(byte[] byArray, String string) {
        return new DicomInstance(NativeSDK.OrthancPluginTranscodeDicomInstance(byArray, string));
    }

    public static DicomInstance loadDicomInstance(String string, LoadDicomInstanceMode loadDicomInstanceMode) {
        return new DicomInstance(NativeSDK.OrthancPluginLoadDicomInstance(string, loadDicomInstanceMode.getValue()));
    }

    public String getInstanceRemoteAet() {
        return NativeSDK.OrthancPluginGetInstanceRemoteAet(this.self);
    }

    public long getInstanceSize() {
        return NativeSDK.OrthancPluginGetInstanceSize(this.self);
    }

    public String getInstanceJson() {
        return NativeSDK.OrthancPluginGetInstanceJson(this.self);
    }

    public String getInstanceSimplifiedJson() {
        return NativeSDK.OrthancPluginGetInstanceSimplifiedJson(this.self);
    }

    public int hasInstanceMetadata(String string) {
        return NativeSDK.OrthancPluginHasInstanceMetadata(this.self, string);
    }

    public String getInstanceMetadata(String string) {
        return NativeSDK.OrthancPluginGetInstanceMetadata(this.self, string);
    }

    public InstanceOrigin getInstanceOrigin() {
        return InstanceOrigin.getInstance(NativeSDK.OrthancPluginGetInstanceOrigin(this.self));
    }

    public String getInstanceTransferSyntaxUid() {
        return NativeSDK.OrthancPluginGetInstanceTransferSyntaxUid(this.self);
    }

    public int hasInstancePixelData() {
        return NativeSDK.OrthancPluginHasInstancePixelData(this.self);
    }

    public int getInstanceFramesCount() {
        return NativeSDK.OrthancPluginGetInstanceFramesCount(this.self);
    }

    public byte[] getInstanceRawFrame(int n) {
        return NativeSDK.OrthancPluginGetInstanceRawFrame(this.self, n);
    }

    public Image getInstanceDecodedFrame(int n) {
        return new Image(NativeSDK.OrthancPluginGetInstanceDecodedFrame(this.self, n));
    }

    public byte[] serializeDicomInstance() {
        return NativeSDK.OrthancPluginSerializeDicomInstance(this.self);
    }

    public String getInstanceAdvancedJson(DicomToJsonFormat dicomToJsonFormat, DicomToJsonFlags dicomToJsonFlags, int n) {
        return NativeSDK.OrthancPluginGetInstanceAdvancedJson(this.self, dicomToJsonFormat.getValue(), dicomToJsonFlags.getValue(), n);
    }
}

