/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.support;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.AbstractMultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;

public class StandardServletMultipartResolver
implements MultipartResolver {
    private boolean resolveLazily = false;
    private boolean strictServletCompliance = false;

    public void setResolveLazily(boolean resolveLazily) {
        this.resolveLazily = resolveLazily;
    }

    public void setStrictServletCompliance(boolean strictServletCompliance) {
        this.strictServletCompliance = strictServletCompliance;
    }

    @Override
    public boolean isMultipart(HttpServletRequest request2) {
        return StringUtils.startsWithIgnoreCase(request2.getContentType(), this.strictServletCompliance ? "multipart/form-data" : "multipart/");
    }

    @Override
    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request2) throws MultipartException {
        return new StandardMultipartHttpServletRequest(request2, this.resolveLazily);
    }

    @Override
    public void cleanupMultipart(MultipartHttpServletRequest request2) {
        if (!(request2 instanceof AbstractMultipartHttpServletRequest) || ((AbstractMultipartHttpServletRequest)request2).isResolved()) {
            try {
                for (Part part : request2.getParts()) {
                    if (request2.getFile(part.getName()) == null) continue;
                    part.delete();
                }
            }
            catch (Throwable ex) {
                LogFactory.getLog(this.getClass()).warn("Failed to perform cleanup of multipart items", ex);
            }
        }
    }
}

