/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.cors;

import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class CorsUtils {
    public static boolean isCorsRequest(HttpServletRequest request2) {
        String origin = request2.getHeader("Origin");
        if (origin == null) {
            return false;
        }
        UriComponents originUrl = UriComponentsBuilder.fromOriginHeader(origin).build();
        String scheme = request2.getScheme();
        String host = request2.getServerName();
        int port = request2.getServerPort();
        return !ObjectUtils.nullSafeEquals(scheme, originUrl.getScheme()) || !ObjectUtils.nullSafeEquals(host, originUrl.getHost()) || CorsUtils.getPort(scheme, port) != CorsUtils.getPort(originUrl.getScheme(), originUrl.getPort());
    }

    private static int getPort(@Nullable String scheme, int port) {
        if (port == -1) {
            if ("http".equals(scheme) || "ws".equals(scheme)) {
                port = 80;
            } else if ("https".equals(scheme) || "wss".equals(scheme)) {
                port = 443;
            }
        }
        return port;
    }

    public static boolean isPreFlightRequest(HttpServletRequest request2) {
        return HttpMethod.OPTIONS.matches(request2.getMethod()) && request2.getHeader("Origin") != null && request2.getHeader("Access-Control-Request-Method") != null;
    }
}

