/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.http.ResponseCookie;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.test.web.reactive.server.WebTestClient;

public class CookieAssertions {
    private final ExchangeResult exchangeResult;
    private final WebTestClient.ResponseSpec responseSpec;

    public CookieAssertions(ExchangeResult exchangeResult, WebTestClient.ResponseSpec responseSpec) {
        this.exchangeResult = exchangeResult;
        this.responseSpec = responseSpec;
    }

    public WebTestClient.ResponseSpec valueEquals(String name, String value) {
        this.exchangeResult.assertWithDiagnostics(() -> {
            String message = this.getMessage(name);
            AssertionErrors.assertEquals(message, value, this.getCookie(name).getValue());
        });
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec value(String name, Matcher<? super String> matcher) {
        String value = this.getCookie(name).getValue();
        this.exchangeResult.assertWithDiagnostics(() -> {
            String message = this.getMessage(name);
            MatcherAssert.assertThat((String)message, (Object)value, (Matcher)matcher);
        });
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec value(String name, Consumer<String> consumer) {
        String value = this.getCookie(name).getValue();
        this.exchangeResult.assertWithDiagnostics(() -> consumer.accept(value));
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec exists(String name) {
        this.getCookie(name);
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec doesNotExist(String name) {
        ResponseCookie cookie = this.exchangeResult.getResponseCookies().getFirst(name);
        if (cookie != null) {
            String message = this.getMessage(name) + " exists with value=[" + cookie.getValue() + "]";
            this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.fail(message));
        }
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec maxAge(String name, Duration expected) {
        Duration maxAge = this.getCookie(name).getMaxAge();
        this.exchangeResult.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " maxAge";
            AssertionErrors.assertEquals(message, expected, maxAge);
        });
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec maxAge(String name, Matcher<? super Long> matcher) {
        long maxAge = this.getCookie(name).getMaxAge().getSeconds();
        this.exchangeResult.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " maxAge";
            MatcherAssert.assertThat((String)message, (Object)maxAge, (Matcher)matcher);
        });
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec path(String name, String expected) {
        String path = this.getCookie(name).getPath();
        this.exchangeResult.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " path";
            AssertionErrors.assertEquals(message, expected, path);
        });
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec path(String name, Matcher<? super String> matcher) {
        String path = this.getCookie(name).getPath();
        this.exchangeResult.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " path";
            MatcherAssert.assertThat((String)message, (Object)path, (Matcher)matcher);
        });
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec domain(String name, String expected) {
        String path = this.getCookie(name).getDomain();
        this.exchangeResult.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " domain";
            AssertionErrors.assertEquals(message, expected, path);
        });
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec domain(String name, Matcher<? super String> matcher) {
        String domain = this.getCookie(name).getDomain();
        this.exchangeResult.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " domain";
            MatcherAssert.assertThat((String)message, (Object)domain, (Matcher)matcher);
        });
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec secure(String name, boolean expected) {
        boolean isSecure = this.getCookie(name).isSecure();
        this.exchangeResult.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " secure";
            AssertionErrors.assertEquals(message, expected, isSecure);
        });
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec httpOnly(String name, boolean expected) {
        boolean isHttpOnly = this.getCookie(name).isHttpOnly();
        this.exchangeResult.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " httpOnly";
            AssertionErrors.assertEquals(message, expected, isHttpOnly);
        });
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec sameSite(String name, String expected) {
        String sameSite = this.getCookie(name).getSameSite();
        this.exchangeResult.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " sameSite";
            AssertionErrors.assertEquals(message, expected, sameSite);
        });
        return this.responseSpec;
    }

    private ResponseCookie getCookie(String name) {
        ResponseCookie cookie = this.exchangeResult.getResponseCookies().getFirst(name);
        if (cookie == null) {
            this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.fail("No cookie with name '" + name + "'"));
        }
        return Objects.requireNonNull(cookie);
    }

    private String getMessage(String cookie) {
        return "Response cookie '" + cookie + "'";
    }
}

