/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.response;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.mock.http.client.MockClientHttpResponse;
import org.springframework.test.web.client.ResponseCreator;
import org.springframework.util.Assert;

public class DefaultResponseCreator
implements ResponseCreator {
    private final int statusCode;
    private byte[] content = new byte[0];
    @Nullable
    private Resource contentResource;
    private final HttpHeaders headers = new HttpHeaders();

    protected DefaultResponseCreator(HttpStatus statusCode) {
        Assert.notNull((Object)statusCode, "HttpStatus must not be null");
        this.statusCode = statusCode.value();
    }

    protected DefaultResponseCreator(int statusCode) {
        this.statusCode = statusCode;
    }

    public DefaultResponseCreator body(String content) {
        this.content = content.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public DefaultResponseCreator body(byte[] content) {
        this.content = content;
        return this;
    }

    public DefaultResponseCreator body(Resource resource) {
        this.contentResource = resource;
        return this;
    }

    public DefaultResponseCreator contentType(MediaType mediaType) {
        this.headers.setContentType(mediaType);
        return this;
    }

    public DefaultResponseCreator location(URI location) {
        this.headers.setLocation(location);
        return this;
    }

    public DefaultResponseCreator headers(HttpHeaders headers) {
        this.headers.putAll(headers);
        return this;
    }

    @Override
    public ClientHttpResponse createResponse(@Nullable ClientHttpRequest request2) throws IOException {
        MockClientHttpResponse response = this.contentResource != null ? new MockClientHttpResponse(this.contentResource.getInputStream(), this.statusCode) : new MockClientHttpResponse(this.content, this.statusCode);
        response.getHeaders().putAll(this.headers);
        return response;
    }
}

