/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.mock.http.MockHttpInputMessage;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.JsonExpectationsHelper;
import org.springframework.test.util.XmlExpectationsHelper;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.w3c.dom.Node;

public class ContentRequestMatchers {
    private final XmlExpectationsHelper xmlHelper = new XmlExpectationsHelper();
    private final JsonExpectationsHelper jsonHelper = new JsonExpectationsHelper();

    protected ContentRequestMatchers() {
    }

    public RequestMatcher contentType(String expectedContentType) {
        return this.contentType(MediaType.parseMediaType(expectedContentType));
    }

    public RequestMatcher contentType(MediaType expectedContentType) {
        return request2 -> {
            MediaType actualContentType = request2.getHeaders().getContentType();
            AssertionErrors.assertTrue("Content type not set", actualContentType != null);
            AssertionErrors.assertEquals("Content type", expectedContentType, actualContentType);
        };
    }

    public RequestMatcher contentTypeCompatibleWith(String contentType) {
        return this.contentTypeCompatibleWith(MediaType.parseMediaType(contentType));
    }

    public RequestMatcher contentTypeCompatibleWith(MediaType contentType) {
        return request2 -> {
            MediaType actualContentType = request2.getHeaders().getContentType();
            AssertionErrors.assertTrue("Content type not set", actualContentType != null);
            if (actualContentType != null) {
                AssertionErrors.assertTrue("Content type [" + actualContentType + "] is not compatible with [" + contentType + "]", actualContentType.isCompatibleWith(contentType));
            }
        };
    }

    public RequestMatcher string(Matcher<? super String> matcher) {
        return request2 -> {
            MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
            MatcherAssert.assertThat((String)"Request content", (Object)mockRequest.getBodyAsString(), (Matcher)matcher);
        };
    }

    public RequestMatcher string(String expectedContent) {
        return request2 -> {
            MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
            AssertionErrors.assertEquals("Request content", expectedContent, mockRequest.getBodyAsString());
        };
    }

    public RequestMatcher bytes(byte[] expectedContent) {
        return request2 -> {
            MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
            AssertionErrors.assertEquals("Request content", expectedContent, mockRequest.getBodyAsBytes());
        };
    }

    public RequestMatcher formData(MultiValueMap<String, String> expected) {
        return this.formData(expected, true);
    }

    public RequestMatcher formDataContains(Map<String, String> expected) {
        LinkedMultiValueMap<String, String> multiValueMap = new LinkedMultiValueMap<String, String>(expected.size());
        expected.forEach(multiValueMap::add);
        return this.formData(multiValueMap, false);
    }

    private RequestMatcher formData(MultiValueMap<String, String> expectedMap, boolean containsExactly) {
        return request2 -> {
            MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
            MockHttpInputMessage message = new MockHttpInputMessage(mockRequest.getBodyAsBytes());
            message.getHeaders().putAll(mockRequest.getHeaders());
            Object actualMap = new FormHttpMessageConverter().read((Class)null, (HttpInputMessage)message);
            if (containsExactly) {
                AssertionErrors.assertEquals("Form data", expectedMap, actualMap);
            } else {
                AssertionErrors.assertTrue("Form data " + actualMap, expectedMap.size() <= actualMap.size());
                for (Map.Entry entry : expectedMap.entrySet()) {
                    String name = (String)entry.getKey();
                    List values = (List)entry.getValue();
                    AssertionErrors.assertTrue("No form parameter '" + name + "'", actualMap.get(name) != null);
                    AssertionErrors.assertTrue("Parameter value count " + values.size(), values.size() <= ((List)actualMap.get(name)).size());
                    for (int i2 = 0; i2 < values.size(); ++i2) {
                        AssertionErrors.assertEquals("Form parameter", values.get(i2), ((List)actualMap.get(name)).get(i2));
                    }
                }
            }
        };
    }

    public RequestMatcher multipartData(MultiValueMap<String, ?> expectedMap) {
        return this.multipartData(expectedMap, true);
    }

    public RequestMatcher multipartDataContains(Map<String, ?> expectedMap) {
        LinkedMultiValueMap map = new LinkedMultiValueMap(expectedMap.size());
        expectedMap.forEach(map::add);
        return this.multipartData(map, false);
    }

    private RequestMatcher multipartData(MultiValueMap<String, ?> expectedMap, boolean containsExactly) {
        return request2 -> {
            MultiValueMap<String, ?> actualMap = MultipartHelper.parse(request2);
            if (containsExactly) {
                AssertionErrors.assertEquals("Multipart request content: " + actualMap, expectedMap.size(), actualMap.size());
            }
            for (Map.Entry entry : expectedMap.entrySet()) {
                String name = (String)entry.getKey();
                List values = (List)entry.getValue();
                AssertionErrors.assertTrue("No Multipart '" + name + "'", actualMap.get(name) != null);
                AssertionErrors.assertTrue("Multipart value count " + values.size(), containsExactly ? values.size() == ((List)actualMap.get(name)).size() : values.size() <= ((List)actualMap.get(name)).size());
                for (int i2 = 0; i2 < values.size(); ++i2) {
                    Object expected = values.get(i2);
                    Object actual = ((List)actualMap.get(name)).get(i2);
                    if (expected instanceof Resource) {
                        expected = StreamUtils.copyToByteArray(((Resource)expected).getInputStream());
                    }
                    if (expected instanceof byte[]) {
                        AssertionErrors.assertTrue("Multipart is not a file", actual instanceof MultipartFile);
                        AssertionErrors.assertEquals("Multipart content", expected, ((MultipartFile)actual).getBytes());
                        continue;
                    }
                    if (expected instanceof String) {
                        AssertionErrors.assertTrue("Multipart is not a String", actual instanceof String);
                        AssertionErrors.assertEquals("Multipart content", expected, actual);
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected multipart value: " + expected.getClass());
                }
            }
        };
    }

    public RequestMatcher xml(final String expectedXmlContent) {
        return new AbstractXmlRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request2) throws Exception {
                ContentRequestMatchers.this.xmlHelper.assertXmlEqual(expectedXmlContent, request2.getBodyAsString());
            }
        };
    }

    public RequestMatcher node(final Matcher<? super Node> matcher) {
        return new AbstractXmlRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request2) throws Exception {
                ContentRequestMatchers.this.xmlHelper.assertNode(request2.getBodyAsString(), (Matcher<? super Node>)matcher);
            }
        };
    }

    public RequestMatcher source(final Matcher<? super Source> matcher) {
        return new AbstractXmlRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request2) throws Exception {
                ContentRequestMatchers.this.xmlHelper.assertSource(request2.getBodyAsString(), (Matcher<? super Source>)matcher);
            }
        };
    }

    public RequestMatcher json(String expectedJsonContent) {
        return this.json(expectedJsonContent, false);
    }

    public RequestMatcher json(String expectedJsonContent, boolean strict) {
        return request2 -> {
            try {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
                this.jsonHelper.assertJsonEqual(expectedJsonContent, mockRequest.getBodyAsString(), strict);
            }
            catch (Exception ex) {
                throw new AssertionError("Failed to parse expected or actual JSON request content", ex);
            }
        };
    }

    private static class MultipartHelper {
        private MultipartHelper() {
        }

        public static MultiValueMap<String, ?> parse(ClientHttpRequest request2) {
            MultipartHttpServletRequest servletRequest = MultipartHelper.adaptToMultipartRequest(request2);
            LinkedMultiValueMap<Object, Object> result = new LinkedMultiValueMap<Object, Object>();
            for (Map.Entry entry : servletRequest.getMultiFileMap().entrySet()) {
                for (MultipartFile value : (List)entry.getValue()) {
                    result.add(entry.getKey(), value);
                }
            }
            for (Map.Entry<Object, Object> entry : servletRequest.getParameterMap().entrySet()) {
                for (String value : (String[])entry.getValue()) {
                    result.add(entry.getKey(), value);
                }
            }
            return result;
        }

        private static MultipartHttpServletRequest adaptToMultipartRequest(ClientHttpRequest request2) {
            MockClientHttpRequest source = (MockClientHttpRequest)request2;
            MockHttpServletRequest target = new MockHttpServletRequest();
            target.setContent(source.getBodyAsBytes());
            source.getHeaders().forEach((name, values) -> values.forEach(v -> target.addHeader((String)name, v)));
            return new CommonsMultipartResolver().resolveMultipart(target);
        }
    }

    private static abstract class AbstractXmlRequestMatcher
    implements RequestMatcher {
        private AbstractXmlRequestMatcher() {
        }

        @Override
        public final void match(ClientHttpRequest request2) throws IOException, AssertionError {
            try {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
                this.matchInternal(mockRequest);
            }
            catch (Exception ex) {
                throw new AssertionError("Failed to parse expected or actual XML request content", ex);
            }
        }

        protected abstract void matchInternal(MockClientHttpRequest var1) throws Exception;
    }
}

