/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.Assert;

public abstract class AopTestUtils {
    public static <T> T getTargetObject(Object candidate) {
        Assert.notNull(candidate, "Candidate must not be null");
        try {
            Object target;
            if (AopUtils.isAopProxy((Object)candidate) && candidate instanceof Advised && (target = ((Advised)candidate).getTargetSource().getTarget()) != null) {
                return (T)target;
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to unwrap proxied object", ex);
        }
        return (T)candidate;
    }

    public static <T> T getUltimateTargetObject(Object candidate) {
        Assert.notNull(candidate, "Candidate must not be null");
        try {
            Object target;
            if (AopUtils.isAopProxy((Object)candidate) && candidate instanceof Advised && (target = ((Advised)candidate).getTargetSource().getTarget()) != null) {
                return AopTestUtils.getUltimateTargetObject(target);
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to unwrap proxied object", ex);
        }
        return (T)candidate;
    }
}

