/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.util;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class TestContextResourceUtils {
    private static final String SLASH = "/";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile(".*\\$\\{[^}]+\\}.*");

    public static String[] convertToClasspathResourcePaths(Class<?> clazz, String ... paths) {
        return TestContextResourceUtils.convertToClasspathResourcePaths(clazz, false, paths);
    }

    public static String[] convertToClasspathResourcePaths(Class<?> clazz, boolean preservePlaceholders, String ... paths) {
        String[] convertedPaths = new String[paths.length];
        for (int i2 = 0; i2 < paths.length; ++i2) {
            String path = paths[i2];
            convertedPaths[i2] = path.startsWith(SLASH) ? "classpath:" + path : (!ResourcePatternUtils.isUrl(path) ? "classpath:/" + ClassUtils.classPackageAsResourcePath(clazz) + SLASH + path : path);
            if (preservePlaceholders && PLACEHOLDER_PATTERN.matcher(convertedPaths[i2]).matches()) continue;
            convertedPaths[i2] = StringUtils.cleanPath(convertedPaths[i2]);
        }
        return convertedPaths;
    }

    public static Resource[] convertToResources(ResourceLoader resourceLoader, String ... paths) {
        return (Resource[])TestContextResourceUtils.stream(resourceLoader, paths).toArray(Resource[]::new);
    }

    public static List<Resource> convertToResourceList(ResourceLoader resourceLoader, String ... paths) {
        return TestContextResourceUtils.stream(resourceLoader, paths).collect(Collectors.toList());
    }

    private static Stream<Resource> stream(ResourceLoader resourceLoader, String ... paths) {
        return Arrays.stream(paths).map(resourceLoader::getResource);
    }
}

