/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.io.IOException;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.lang.Nullable;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.support.MergedTestPropertySources;
import org.springframework.test.context.support.TestPropertySourceAttributes;
import org.springframework.test.context.util.TestContextResourceUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class TestPropertySourceUtils {
    public static final String INLINED_PROPERTIES_PROPERTY_SOURCE_NAME = "Inlined Test Properties";
    private static final Log logger = LogFactory.getLog(TestPropertySourceUtils.class);

    static MergedTestPropertySources buildMergedTestPropertySources(Class<?> testClass) {
        ArrayList<TestPropertySourceAttributes> attributesList = new ArrayList<TestPropertySourceAttributes>();
        TestPropertySourceAttributes previousAttributes = null;
        for (List<MergedAnnotation<TestPropertySource>> aggregatedAnnotations : TestPropertySourceUtils.findRepeatableAnnotations(testClass, TestPropertySource.class)) {
            List<TestPropertySourceAttributes> aggregatedAttributesList = aggregatedAnnotations.stream().map(TestPropertySourceAttributes::new).collect(Collectors.toList());
            TestPropertySourceAttributes mergedAttributes = TestPropertySourceUtils.mergeTestPropertySourceAttributes(aggregatedAttributesList);
            if (mergedAttributes == null) continue;
            if (!TestPropertySourceUtils.duplicationDetected(mergedAttributes, previousAttributes)) {
                attributesList.add(mergedAttributes);
            }
            previousAttributes = mergedAttributes;
        }
        if (attributesList.isEmpty()) {
            return MergedTestPropertySources.empty();
        }
        return new MergedTestPropertySources(TestPropertySourceUtils.mergeLocations(attributesList), TestPropertySourceUtils.mergeProperties(attributesList));
    }

    @Nullable
    private static TestPropertySourceAttributes mergeTestPropertySourceAttributes(List<TestPropertySourceAttributes> aggregatedAttributesList) {
        TestPropertySourceAttributes mergedAttributes = null;
        TestPropertySourceAttributes previousAttributes = null;
        for (TestPropertySourceAttributes currentAttributes : aggregatedAttributesList) {
            if (mergedAttributes == null) {
                mergedAttributes = currentAttributes;
            } else if (!TestPropertySourceUtils.duplicationDetected(currentAttributes, previousAttributes)) {
                mergedAttributes.mergeWith(currentAttributes);
            }
            previousAttributes = currentAttributes;
        }
        return mergedAttributes;
    }

    private static boolean duplicationDetected(TestPropertySourceAttributes currentAttributes, @Nullable TestPropertySourceAttributes previousAttributes) {
        boolean duplicationDetected;
        boolean bl = duplicationDetected = currentAttributes.equals(previousAttributes) && !currentAttributes.isEmpty();
        if (duplicationDetected && logger.isDebugEnabled()) {
            logger.debug(String.format("Ignoring duplicate %s declaration on %s since it is also declared on %s", currentAttributes, currentAttributes.getDeclaringClass().getName(), previousAttributes.getDeclaringClass().getName()));
        }
        return duplicationDetected;
    }

    private static String[] mergeLocations(List<TestPropertySourceAttributes> attributesList) {
        ArrayList<String> locations = new ArrayList<String>();
        for (TestPropertySourceAttributes attrs : attributesList) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Processing locations for TestPropertySource attributes %s", attrs));
            }
            String[] locationsArray = TestContextResourceUtils.convertToClasspathResourcePaths(attrs.getDeclaringClass(), true, attrs.getLocations());
            locations.addAll(0, Arrays.asList(locationsArray));
            if (attrs.isInheritLocations()) continue;
            break;
        }
        return StringUtils.toStringArray(locations);
    }

    private static String[] mergeProperties(List<TestPropertySourceAttributes> attributesList) {
        ArrayList<String> properties = new ArrayList<String>();
        for (TestPropertySourceAttributes attrs : attributesList) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Processing inlined properties for TestPropertySource attributes %s", attrs));
            }
            String[] attrProps = attrs.getProperties();
            properties.addAll(0, Arrays.asList(attrProps));
            if (attrs.isInheritProperties()) continue;
            break;
        }
        return StringUtils.toStringArray(properties);
    }

    public static void addPropertiesFilesToEnvironment(ConfigurableApplicationContext context, String ... locations) {
        Assert.notNull((Object)context, "'context' must not be null");
        Assert.notNull((Object)locations, "'locations' must not be null");
        TestPropertySourceUtils.addPropertiesFilesToEnvironment(context.getEnvironment(), (ResourceLoader)context, locations);
    }

    public static void addPropertiesFilesToEnvironment(ConfigurableEnvironment environment, ResourceLoader resourceLoader, String ... locations) {
        Assert.notNull((Object)environment, "'environment' must not be null");
        Assert.notNull((Object)resourceLoader, "'resourceLoader' must not be null");
        Assert.notNull((Object)locations, "'locations' must not be null");
        try {
            for (String location : locations) {
                String resolvedLocation = environment.resolveRequiredPlaceholders(location);
                Resource resource = resourceLoader.getResource(resolvedLocation);
                environment.getPropertySources().addFirst(new ResourcePropertySource(resource));
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to add PropertySource to Environment", ex);
        }
    }

    public static void addInlinedPropertiesToEnvironment(ConfigurableApplicationContext context, String ... inlinedProperties) {
        Assert.notNull((Object)context, "'context' must not be null");
        Assert.notNull((Object)inlinedProperties, "'inlinedProperties' must not be null");
        TestPropertySourceUtils.addInlinedPropertiesToEnvironment(context.getEnvironment(), inlinedProperties);
    }

    public static void addInlinedPropertiesToEnvironment(ConfigurableEnvironment environment, String ... inlinedProperties) {
        Assert.notNull((Object)environment, "'environment' must not be null");
        Assert.notNull((Object)inlinedProperties, "'inlinedProperties' must not be null");
        if (!ObjectUtils.isEmpty(inlinedProperties)) {
            MapPropertySource ps;
            if (logger.isDebugEnabled()) {
                logger.debug("Adding inlined properties to environment: " + ObjectUtils.nullSafeToString(inlinedProperties));
            }
            if ((ps = (MapPropertySource)environment.getPropertySources().get(INLINED_PROPERTIES_PROPERTY_SOURCE_NAME)) == null) {
                ps = new MapPropertySource(INLINED_PROPERTIES_PROPERTY_SOURCE_NAME, (Map<String, Object>)new LinkedHashMap<String, Object>());
                environment.getPropertySources().addFirst(ps);
            }
            ((Map)ps.getSource()).putAll(TestPropertySourceUtils.convertInlinedPropertiesToMap(inlinedProperties));
        }
    }

    public static Map<String, Object> convertInlinedPropertiesToMap(String ... inlinedProperties) {
        Assert.notNull((Object)inlinedProperties, "'inlinedProperties' must not be null");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Properties props = new Properties();
        for (String pair : inlinedProperties) {
            if (!StringUtils.hasText(pair)) continue;
            try {
                props.load(new StringReader(pair));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to load test environment property from [" + pair + "]", ex);
            }
            Assert.state(props.size() == 1, () -> "Failed to load exactly one test environment property from [" + pair + "]");
            for (String name : props.stringPropertyNames()) {
                map.put(name, props.getProperty(name));
            }
            props.clear();
        }
        return map;
    }

    private static <T extends Annotation> List<List<MergedAnnotation<T>>> findRepeatableAnnotations(Class<?> clazz, Class<T> annotationType) {
        ArrayList<List<MergedAnnotation<T>>> listOfLists = new ArrayList<List<MergedAnnotation<T>>>();
        TestPropertySourceUtils.findRepeatableAnnotations(clazz, annotationType, listOfLists, new int[]{0});
        return listOfLists;
    }

    private static <T extends Annotation> void findRepeatableAnnotations(Class<?> clazz, Class<T> annotationType, List<List<MergedAnnotation<T>>> listOfLists, int[] aggregateIndex) {
        if (listOfLists.size() < aggregateIndex[0] + 1) {
            listOfLists.add(new ArrayList());
        }
        MergedAnnotations.from(clazz, MergedAnnotations.SearchStrategy.DIRECT).stream(annotationType).sorted(TestPropertySourceUtils.highMetaDistancesFirst()).forEach(annotation -> ((List)listOfLists.get(aggregateIndex[0])).add(0, annotation));
        aggregateIndex[0] = aggregateIndex[0] + 1;
        for (Class<?> ifc : clazz.getInterfaces()) {
            TestPropertySourceUtils.findRepeatableAnnotations(ifc, annotationType, listOfLists, aggregateIndex);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null & superclass != Object.class) {
            TestPropertySourceUtils.findRepeatableAnnotations(superclass, annotationType, listOfLists, aggregateIndex);
        }
        if (TestContextAnnotationUtils.searchEnclosingClass(clazz)) {
            TestPropertySourceUtils.findRepeatableAnnotations(clazz.getEnclosingClass(), annotationType, listOfLists, aggregateIndex);
        }
    }

    private static <A extends Annotation> Comparator<MergedAnnotation<A>> highMetaDistancesFirst() {
        return Comparator.comparingInt(MergedAnnotation::getDistance).reversed();
    }
}

