/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractGenericContextLoader;
import org.springframework.util.ObjectUtils;

public class GenericXmlContextLoader
extends AbstractGenericContextLoader {
    @Override
    protected BeanDefinitionReader createBeanDefinitionReader(GenericApplicationContext context) {
        return new XmlBeanDefinitionReader((BeanDefinitionRegistry)context);
    }

    @Override
    protected String getResourceSuffix() {
        return "-context.xml";
    }

    @Override
    protected void validateMergedContextConfiguration(MergedContextConfiguration mergedConfig) {
        if (mergedConfig.hasClasses()) {
            String msg = String.format("Test class [%s] has been configured with @ContextConfiguration's 'classes' attribute %s, but %s does not support annotated classes.", mergedConfig.getTestClass().getName(), ObjectUtils.nullSafeToString(mergedConfig.getClasses()), this.getClass().getSimpleName());
            logger.error(msg);
            throw new IllegalStateException(msg);
        }
    }
}

