/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.DynamicPropertySource;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.support.DynamicPropertiesContextCustomizer;

class DynamicPropertiesContextCustomizerFactory
implements ContextCustomizerFactory {
    DynamicPropertiesContextCustomizerFactory() {
    }

    @Override
    @Nullable
    public DynamicPropertiesContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        this.findMethods(testClass, methods);
        if (methods.isEmpty()) {
            return null;
        }
        return new DynamicPropertiesContextCustomizer(methods);
    }

    private void findMethods(Class<?> testClass, Set<Method> methods) {
        methods.addAll(MethodIntrospector.selectMethods(testClass, this::isAnnotated));
        if (TestContextAnnotationUtils.searchEnclosingClass(testClass)) {
            this.findMethods(testClass.getEnclosingClass(), methods);
        }
    }

    private boolean isAnnotated(Method method) {
        return MergedAnnotations.from(method).isPresent(DynamicPropertySource.class);
    }
}

