/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.core.Conventions;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class DependencyInjectionTestExecutionListener
extends AbstractTestExecutionListener {
    public static final String REINJECT_DEPENDENCIES_ATTRIBUTE = Conventions.getQualifiedAttributeName(DependencyInjectionTestExecutionListener.class, "reinjectDependencies");
    private static final Log logger = LogFactory.getLog(DependencyInjectionTestExecutionListener.class);

    @Override
    public final int getOrder() {
        return 2000;
    }

    @Override
    public void prepareTestInstance(TestContext testContext) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Performing dependency injection for test context [" + testContext + "].");
        }
        this.injectDependencies(testContext);
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        if (Boolean.TRUE.equals(testContext.getAttribute(REINJECT_DEPENDENCIES_ATTRIBUTE))) {
            if (logger.isDebugEnabled()) {
                logger.debug("Reinjecting dependencies for test context [" + testContext + "].");
            }
            this.injectDependencies(testContext);
        }
    }

    protected void injectDependencies(TestContext testContext) throws Exception {
        Object bean = testContext.getTestInstance();
        Class<?> clazz = testContext.getTestClass();
        AutowireCapableBeanFactory beanFactory = testContext.getApplicationContext().getAutowireCapableBeanFactory();
        beanFactory.autowireBeanProperties(bean, 0, false);
        beanFactory.initializeBean(bean, clazz.getName() + ".ORIGINAL");
        testContext.removeAttribute(REINJECT_DEPENDENCIES_ATTRIBUTE);
    }
}

