/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractGenericContextLoader;
import org.springframework.test.context.support.AnnotationConfigContextLoaderUtils;
import org.springframework.util.ObjectUtils;

public class AnnotationConfigContextLoader
extends AbstractGenericContextLoader {
    private static final Log logger = LogFactory.getLog(AnnotationConfigContextLoader.class);

    @Override
    public void processContextConfiguration(ContextConfigurationAttributes configAttributes) {
        if (!configAttributes.hasClasses() && this.isGenerateDefaultLocations()) {
            configAttributes.setClasses(this.detectDefaultConfigurationClasses(configAttributes.getDeclaringClass()));
        }
    }

    protected Class<?>[] detectDefaultConfigurationClasses(Class<?> declaringClass) {
        return AnnotationConfigContextLoaderUtils.detectDefaultConfigurationClasses(declaringClass);
    }

    @Override
    protected String[] modifyLocations(Class<?> clazz, String ... locations) {
        throw new UnsupportedOperationException("AnnotationConfigContextLoader does not support the modifyLocations(Class, String...) method");
    }

    @Override
    protected String[] generateDefaultLocations(Class<?> clazz) {
        throw new UnsupportedOperationException("AnnotationConfigContextLoader does not support the generateDefaultLocations(Class) method");
    }

    @Override
    protected String getResourceSuffix() {
        throw new UnsupportedOperationException("AnnotationConfigContextLoader does not support the getResourceSuffix() method");
    }

    @Override
    protected void validateMergedContextConfiguration(MergedContextConfiguration mergedConfig) {
        if (mergedConfig.hasLocations()) {
            String msg = String.format("Test class [%s] has been configured with @ContextConfiguration's 'locations' (or 'value') attribute %s, but %s does not support resource locations.", mergedConfig.getTestClass().getName(), ObjectUtils.nullSafeToString(mergedConfig.getLocations()), this.getClass().getSimpleName());
            logger.error(msg);
            throw new IllegalStateException(msg);
        }
    }

    @Override
    protected void loadBeanDefinitions(GenericApplicationContext context, MergedContextConfiguration mergedConfig) {
        Object[] componentClasses = mergedConfig.getClasses();
        if (logger.isDebugEnabled()) {
            logger.debug("Registering component classes: " + ObjectUtils.nullSafeToString(componentClasses));
        }
        new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)context).register((Class[])componentClasses);
    }

    @Override
    protected BeanDefinitionReader createBeanDefinitionReader(GenericApplicationContext context) {
        throw new UnsupportedOperationException("AnnotationConfigContextLoader does not support the createBeanDefinitionReader(GenericApplicationContext) method");
    }
}

