/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4.statements;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.runners.model.Statement;
import org.springframework.test.annotation.TestAnnotationUtils;

public class SpringRepeat
extends Statement {
    protected static final Log logger = LogFactory.getLog(SpringRepeat.class);
    private final Statement next;
    private final Method testMethod;
    private final int repeat;

    public SpringRepeat(Statement next, Method testMethod) {
        this(next, testMethod, TestAnnotationUtils.getRepeatCount(testMethod));
    }

    public SpringRepeat(Statement next, Method testMethod, int repeat) {
        this.next = next;
        this.testMethod = testMethod;
        this.repeat = Math.max(1, repeat);
    }

    public void evaluate() throws Throwable {
        for (int i2 = 0; i2 < this.repeat; ++i2) {
            if (this.repeat > 1 && logger.isInfoEnabled()) {
                logger.info(String.format("Repetition %d of test %s#%s()", i2 + 1, this.testMethod.getDeclaringClass().getSimpleName(), this.testMethod.getName()));
            }
            this.next.evaluate();
        }
    }
}

