/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.jdbc;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.jdbc.datasource.init.ScriptUtils;
import org.springframework.lang.Nullable;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.jdbc.SqlConfig;
import org.springframework.util.Assert;

class MergedSqlConfig {
    private static final String COMMENT_PREFIX = "commentPrefix";
    private static final String COMMENT_PREFIXES = "commentPrefixes";
    private final String dataSource;
    private final String transactionManager;
    private final SqlConfig.TransactionMode transactionMode;
    private final String encoding;
    private final String separator;
    private final String[] commentPrefixes;
    private final String blockCommentStartDelimiter;
    private final String blockCommentEndDelimiter;
    private final SqlConfig.ErrorMode errorMode;

    MergedSqlConfig(SqlConfig localSqlConfig, Class<?> testClass) {
        Assert.notNull((Object)localSqlConfig, "Local @SqlConfig must not be null");
        Assert.notNull(testClass, "testClass must not be null");
        AnnotationAttributes mergedAttributes = this.mergeAttributes(localSqlConfig, testClass);
        this.dataSource = mergedAttributes.getString("dataSource");
        this.transactionManager = mergedAttributes.getString("transactionManager");
        this.transactionMode = MergedSqlConfig.getEnum(mergedAttributes, "transactionMode", SqlConfig.TransactionMode.DEFAULT, SqlConfig.TransactionMode.INFERRED);
        this.encoding = mergedAttributes.getString("encoding");
        this.separator = MergedSqlConfig.getString(mergedAttributes, "separator", ";");
        this.commentPrefixes = MergedSqlConfig.getCommentPrefixes(mergedAttributes);
        this.blockCommentStartDelimiter = MergedSqlConfig.getString(mergedAttributes, "blockCommentStartDelimiter", "/*");
        this.blockCommentEndDelimiter = MergedSqlConfig.getString(mergedAttributes, "blockCommentEndDelimiter", "*/");
        this.errorMode = MergedSqlConfig.getEnum(mergedAttributes, "errorMode", SqlConfig.ErrorMode.DEFAULT, SqlConfig.ErrorMode.FAIL_ON_ERROR);
    }

    private AnnotationAttributes mergeAttributes(SqlConfig localSqlConfig, Class<?> testClass) {
        AnnotationAttributes localAttributes = AnnotationUtils.getAnnotationAttributes(localSqlConfig, false, false);
        MergedSqlConfig.enforceCommentPrefixAliases(localAttributes);
        SqlConfig globalSqlConfig = TestContextAnnotationUtils.findMergedAnnotation(testClass, SqlConfig.class);
        if (globalSqlConfig == null) {
            return localAttributes;
        }
        AnnotationAttributes globalAttributes = AnnotationUtils.getAnnotationAttributes(globalSqlConfig, false, false);
        MergedSqlConfig.enforceCommentPrefixAliases(globalAttributes);
        for (String key : globalAttributes.keySet()) {
            Object value = localAttributes.get(key);
            if (!MergedSqlConfig.isExplicitValue(value)) continue;
            globalAttributes.put(key, value);
            if (key.equals(COMMENT_PREFIX) && MergedSqlConfig.isEmptyArray(localAttributes.get(COMMENT_PREFIXES))) {
                globalAttributes.put(COMMENT_PREFIXES, value);
                continue;
            }
            if (!key.equals(COMMENT_PREFIXES) || !MergedSqlConfig.isEmptyString(localAttributes.get(COMMENT_PREFIX))) continue;
            globalAttributes.put(COMMENT_PREFIX, value);
        }
        return globalAttributes;
    }

    String getDataSource() {
        return this.dataSource;
    }

    String getTransactionManager() {
        return this.transactionManager;
    }

    SqlConfig.TransactionMode getTransactionMode() {
        return this.transactionMode;
    }

    String getEncoding() {
        return this.encoding;
    }

    String getSeparator() {
        return this.separator;
    }

    String[] getCommentPrefixes() {
        return this.commentPrefixes;
    }

    String getBlockCommentStartDelimiter() {
        return this.blockCommentStartDelimiter;
    }

    String getBlockCommentEndDelimiter() {
        return this.blockCommentEndDelimiter;
    }

    SqlConfig.ErrorMode getErrorMode() {
        return this.errorMode;
    }

    public String toString() {
        return new ToStringCreator(this).append("dataSource", this.dataSource).append("transactionManager", this.transactionManager).append("transactionMode", (Object)this.transactionMode).append("encoding", this.encoding).append("separator", this.separator).append(COMMENT_PREFIXES, this.commentPrefixes).append("blockCommentStartDelimiter", this.blockCommentStartDelimiter).append("blockCommentEndDelimiter", this.blockCommentEndDelimiter).append("errorMode", (Object)this.errorMode).toString();
    }

    private static <E extends Enum<?>> E getEnum(AnnotationAttributes attributes, String attributeName, E inheritedOrDefaultValue, E defaultValue) {
        Object value = attributes.getEnum(attributeName);
        if (value == inheritedOrDefaultValue) {
            value = defaultValue;
        }
        return value;
    }

    private static String getString(AnnotationAttributes attributes, String attributeName, String defaultValue) {
        String value = attributes.getString(attributeName);
        if (value.isEmpty()) {
            value = defaultValue;
        }
        return value;
    }

    private static void enforceCommentPrefixAliases(AnnotationAttributes attributes) {
        String commentPrefix = attributes.getString(COMMENT_PREFIX);
        String[] commentPrefixes = attributes.getStringArray(COMMENT_PREFIXES);
        boolean explicitCommentPrefix = !commentPrefix.isEmpty();
        boolean explicitCommentPrefixes = commentPrefixes.length != 0;
        Assert.isTrue(!explicitCommentPrefix || !explicitCommentPrefixes, "You may declare the 'commentPrefix' or 'commentPrefixes' attribute in @SqlConfig but not both");
        if (explicitCommentPrefix) {
            Assert.hasText(commentPrefix, "@SqlConfig(commentPrefix) must contain text");
            attributes.put(COMMENT_PREFIXES, new String[]{commentPrefix});
        } else if (explicitCommentPrefixes) {
            for (String prefix : commentPrefixes) {
                Assert.hasText(prefix, "@SqlConfig(commentPrefixes) must not contain empty prefixes");
            }
            attributes.put(COMMENT_PREFIX, commentPrefixes);
        } else {
            attributes.put(COMMENT_PREFIX, commentPrefixes);
        }
    }

    private static String[] getCommentPrefixes(AnnotationAttributes attributes) {
        Object[] commentPrefix = attributes.getStringArray(COMMENT_PREFIX);
        Object[] commentPrefixes = attributes.getStringArray(COMMENT_PREFIXES);
        Assert.state(Arrays.equals(commentPrefix, commentPrefixes), "Failed to properly handle 'commentPrefix' and 'commentPrefixes' aliases");
        return commentPrefixes.length != 0 ? commentPrefixes : ScriptUtils.DEFAULT_COMMENT_PREFIXES;
    }

    private static boolean isExplicitValue(@Nullable Object value) {
        return !MergedSqlConfig.isEmptyString(value) && !MergedSqlConfig.isEmptyArray(value) && value != SqlConfig.TransactionMode.DEFAULT && value != SqlConfig.ErrorMode.DEFAULT;
    }

    private static boolean isEmptyString(@Nullable Object value) {
        return value instanceof String && ((String)value).isEmpty();
    }

    private static boolean isEmptyArray(@Nullable Object value) {
        return value != null && value.getClass().isArray() && Array.getLength(value) == 0;
    }
}

