/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.util.Assert;

public class MockRequestDispatcher
implements RequestDispatcher {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String resource;

    public MockRequestDispatcher(String resource) {
        Assert.notNull((Object)resource, "Resource must not be null");
        this.resource = resource;
    }

    @Override
    public void forward(ServletRequest request2, ServletResponse response) {
        Assert.notNull((Object)request2, "Request must not be null");
        Assert.notNull((Object)response, "Response must not be null");
        Assert.state(!response.isCommitted(), "Cannot perform forward - response is already committed");
        this.getMockHttpServletResponse(response).setForwardedUrl(this.resource);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MockRequestDispatcher: forwarding to [" + this.resource + "]");
        }
    }

    @Override
    public void include(ServletRequest request2, ServletResponse response) {
        Assert.notNull((Object)request2, "Request must not be null");
        Assert.notNull((Object)response, "Response must not be null");
        this.getMockHttpServletResponse(response).addIncludedUrl(this.resource);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MockRequestDispatcher: including [" + this.resource + "]");
        }
    }

    protected MockHttpServletResponse getMockHttpServletResponse(ServletResponse response) {
        if (response instanceof MockHttpServletResponse) {
            return (MockHttpServletResponse)response;
        }
        if (response instanceof HttpServletResponseWrapper) {
            return this.getMockHttpServletResponse(((HttpServletResponseWrapper)response).getResponse());
        }
        throw new IllegalArgumentException("MockRequestDispatcher requires MockHttpServletResponse");
    }
}

