/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal.util;

import java.util.UUID;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.internal.batchsupport.LifecycleDelegatingTransport;
import org.simplejavamail.internal.modules.BatchModule;
import org.simplejavamail.internal.modules.ModuleLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportRunner.class);

    public static void sendMessage(@NotNull UUID clusterKey, Session session, final MimeMessage message, final Address[] allRecipients) throws MessagingException {
        TransportRunner.runOnSessionTransport(clusterKey, session, false, new TransportRunnable(){

            @Override
            public void run(Transport transport) throws MessagingException {
                transport.sendMessage(message, allRecipients);
                LOGGER.trace("...email sent");
            }
        });
    }

    public static void connect(@NotNull UUID clusterKey, Session session) throws MessagingException {
        TransportRunner.runOnSessionTransport(clusterKey, session, true, new TransportRunnable(){

            @Override
            public void run(Transport transport) {
                LOGGER.debug("...connection successful");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runOnSessionTransport(@NotNull UUID clusterKey, Session session, boolean stickySession, TransportRunnable runnable) throws MessagingException {
        if (ModuleLoader.batchModuleAvailable()) {
            TransportRunner.sendUsingConnectionPool(ModuleLoader.loadBatchModule(), clusterKey, session, stickySession, runnable);
        } else {
            try (Transport transport = session.getTransport();){
                transport.connect();
                runnable.run(transport);
            }
            finally {
                LOGGER.trace("closing transport");
            }
        }
    }

    private static void sendUsingConnectionPool(@NotNull BatchModule batchModule, @NotNull UUID clusterKey, Session session, boolean stickySession, TransportRunnable runnable) throws MessagingException {
        LifecycleDelegatingTransport delegatingTransport = batchModule.acquireTransport(clusterKey, session, stickySession);
        try {
            runnable.run(delegatingTransport.getTransport());
        }
        catch (Throwable t) {
            delegatingTransport.signalTransportFailed();
            throw t;
        }
        delegatingTransport.signalTransportUsed();
    }

    public static interface TransportRunnable {
        public void run(Transport var1) throws MessagingException;
    }
}

