/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import javax.net.ssl.SSLSocketFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.mailer.Mailer;
import org.simplejavamail.api.mailer.MailerRegularBuilder;
import org.simplejavamail.api.mailer.config.ServerConfig;
import org.simplejavamail.api.mailer.config.TransportStrategy;
import org.simplejavamail.config.ConfigLoader;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.internal.util.SimpleOptional;
import org.simplejavamail.mailer.internal.MailerGenericBuilderImpl;
import org.simplejavamail.mailer.internal.MailerImpl;
import org.simplejavamail.mailer.internal.ServerConfigImpl;

public class MailerRegularBuilderImpl
extends MailerGenericBuilderImpl<MailerRegularBuilderImpl>
implements MailerRegularBuilder<MailerRegularBuilderImpl> {
    private String host;
    private Integer port;
    private String username;
    private String password;
    @NotNull
    private TransportStrategy transportStrategy;
    private String customSSLFactory;
    private SSLSocketFactory customSSLFactoryInstance;

    @Deprecated
    public MailerRegularBuilderImpl() {
        if (ConfigLoader.hasProperty(ConfigLoader.Property.SMTP_HOST)) {
            this.withSMTPServerHost(Preconditions.assumeNonNull(ConfigLoader.getStringProperty(ConfigLoader.Property.SMTP_HOST)));
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.SMTP_PORT)) {
            this.withSMTPServerPort(Preconditions.assumeNonNull(ConfigLoader.getIntegerProperty(ConfigLoader.Property.SMTP_PORT)));
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.SMTP_USERNAME)) {
            this.withSMTPServerUsername(Preconditions.assumeNonNull(ConfigLoader.getStringProperty(ConfigLoader.Property.SMTP_USERNAME)));
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.SMTP_PASSWORD)) {
            this.withSMTPServerPassword(Preconditions.assumeNonNull(ConfigLoader.getStringProperty(ConfigLoader.Property.SMTP_PASSWORD)));
        }
        this.transportStrategy = TransportStrategy.SMTP;
        if (ConfigLoader.hasProperty(ConfigLoader.Property.TRANSPORT_STRATEGY)) {
            this.withTransportStrategy((TransportStrategy)((Object)Preconditions.assumeNonNull(ConfigLoader.getProperty(ConfigLoader.Property.TRANSPORT_STRATEGY))));
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.CUSTOM_SSLFACTORY_CLASS)) {
            this.withCustomSSLFactoryClass(Preconditions.assumeNonNull(ConfigLoader.getStringProperty(ConfigLoader.Property.CUSTOM_SSLFACTORY_CLASS)));
        }
    }

    @Override
    public MailerRegularBuilderImpl withTransportStrategy(@NotNull TransportStrategy transportStrategy) {
        this.transportStrategy = transportStrategy;
        return this;
    }

    @Override
    public MailerRegularBuilderImpl withSMTPServer(@Nullable String host, @Nullable Integer port, @Nullable String username, @Nullable String password) {
        return this.withSMTPServerHost(host).withSMTPServerPort(port).withSMTPServerUsername(username).withSMTPServerPassword(password);
    }

    @Override
    public MailerRegularBuilderImpl withSMTPServer(@Nullable String host, @Nullable Integer port, @Nullable String username) {
        return this.withSMTPServerHost(host).withSMTPServerPort(port).withSMTPServerUsername(username);
    }

    @Override
    public MailerRegularBuilderImpl withSMTPServer(@Nullable String host, @Nullable Integer port) {
        return this.withSMTPServerHost(host).withSMTPServerPort(port);
    }

    @Override
    public MailerRegularBuilderImpl withSMTPServerHost(@Nullable String host) {
        this.host = host;
        return this;
    }

    @Override
    public MailerRegularBuilderImpl withSMTPServerPort(@Nullable Integer port) {
        this.port = port;
        return this;
    }

    @Override
    public MailerRegularBuilderImpl withSMTPServerUsername(@Nullable String username) {
        this.username = username;
        return this;
    }

    @Override
    public MailerRegularBuilderImpl withSMTPServerPassword(@Nullable String password) {
        this.password = password;
        return this;
    }

    @Override
    public MailerRegularBuilderImpl withCustomSSLFactoryClass(@Nullable String customSSLFactory) {
        this.customSSLFactory = customSSLFactory;
        return this;
    }

    @Override
    public MailerRegularBuilderImpl withCustomSSLFactoryInstance(@Nullable SSLSocketFactory customSSLFactoryInstance) {
        this.customSSLFactoryInstance = customSSLFactoryInstance;
        return this;
    }

    @Override
    public Mailer buildMailer() {
        return new MailerImpl(this);
    }

    ServerConfig buildServerConfig() {
        this.vallidateServerConfig();
        int serverPort = SimpleOptional.ofNullable(this.port).orElse(this.transportStrategy.getDefaultServerPort());
        return new ServerConfigImpl(Preconditions.assumeNonNull(this.getHost()), serverPort, this.username, this.password, this.customSSLFactory, this.customSSLFactoryInstance);
    }

    private void vallidateServerConfig() {
        MiscUtil.checkArgumentNotEmpty(this.host, "SMTP server host missing");
    }

    @Override
    @Nullable
    public String getHost() {
        return this.host;
    }

    @Override
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Override
    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Override
    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Override
    @NotNull
    public TransportStrategy getTransportStrategy() {
        return this.transportStrategy;
    }

    @Override
    @Nullable
    public String getCustomSSLFactory() {
        return this.customSSLFactory;
    }
}

