/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressCriteria;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.mailer.CustomMailer;
import org.simplejavamail.api.mailer.config.EmailGovernance;
import org.simplejavamail.api.mailer.config.LoadBalancingStrategy;
import org.simplejavamail.api.mailer.config.OperationalConfig;
import org.simplejavamail.api.mailer.config.Pkcs12Config;
import org.simplejavamail.api.mailer.config.ProxyConfig;
import org.simplejavamail.config.ConfigLoader;
import org.simplejavamail.internal.modules.ModuleLoader;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.mailer.internal.EmailGovernanceImpl;
import org.simplejavamail.mailer.internal.InternalMailerBuilder;
import org.simplejavamail.mailer.internal.MailerException;
import org.simplejavamail.mailer.internal.OperationalConfigImpl;
import org.simplejavamail.mailer.internal.ProxyConfigImpl;

abstract class MailerGenericBuilderImpl<T extends MailerGenericBuilderImpl<?>>
implements InternalMailerBuilder<T> {
    private boolean async;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    @NotNull
    private Integer proxyBridgePort;
    private boolean debugLogging;
    @NotNull
    private Integer sessionTimeout;
    @NotNull
    private EnumSet<EmailAddressCriteria> emailAddressCriteria;
    @Nullable
    private Pkcs12Config pkcs12ConfigForSmimeSigning;
    @Nullable
    private ExecutorService executorService;
    @NotNull
    private Integer threadPoolSize;
    @NotNull
    private Integer threadPoolKeepAliveTime;
    @NotNull
    private UUID clusterKey;
    @NotNull
    private Integer connectionPoolCoreSize;
    @NotNull
    private Integer connectionPoolMaxSize;
    @NotNull
    private Integer connectionPoolClaimTimeoutMillis;
    @NotNull
    private Integer connectionPoolExpireAfterMillis;
    @NotNull
    private LoadBalancingStrategy connectionPoolLoadBalancingStrategy;
    @NotNull
    private List<String> sslHostsToTrust = new ArrayList<String>();
    private boolean trustAllSSLHost;
    private boolean verifyingServerIdentity;
    @NotNull
    private final Properties properties = new Properties();
    private boolean transportModeLoggingOnly;
    @Nullable
    private CustomMailer customMailer;

    MailerGenericBuilderImpl() {
        if (ConfigLoader.hasProperty(ConfigLoader.Property.PROXY_HOST)) {
            this.proxyHost = ConfigLoader.getStringProperty(ConfigLoader.Property.PROXY_HOST);
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.PROXY_USERNAME)) {
            this.proxyUsername = ConfigLoader.getStringProperty(ConfigLoader.Property.PROXY_USERNAME);
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.PROXY_PASSWORD)) {
            this.proxyPassword = ConfigLoader.getStringProperty(ConfigLoader.Property.PROXY_PASSWORD);
        }
        this.clusterKey = ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_CLUSTER_KEY) ? UUID.fromString(Preconditions.assumeNonNull(ConfigLoader.getStringProperty(ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_CLUSTER_KEY))) : UUID.randomUUID();
        this.proxyPort = Preconditions.assumeNonNull(ConfigLoader.valueOrPropertyAsInteger(null, ConfigLoader.Property.PROXY_PORT, 1080));
        this.proxyBridgePort = Preconditions.assumeNonNull(ConfigLoader.valueOrPropertyAsInteger(null, ConfigLoader.Property.PROXY_SOCKS5BRIDGE_PORT, 1081));
        this.debugLogging = Preconditions.assumeNonNull(ConfigLoader.valueOrPropertyAsBoolean(null, ConfigLoader.Property.JAVAXMAIL_DEBUG, false));
        this.sessionTimeout = Preconditions.assumeNonNull(ConfigLoader.valueOrPropertyAsInteger(null, ConfigLoader.Property.DEFAULT_SESSION_TIMEOUT_MILLIS, 60000));
        this.trustAllSSLHost = Preconditions.assumeNonNull(ConfigLoader.valueOrPropertyAsBoolean(null, ConfigLoader.Property.DEFAULT_TRUST_ALL_HOSTS, true));
        this.verifyingServerIdentity = Preconditions.assumeNonNull(ConfigLoader.valueOrPropertyAsBoolean(null, ConfigLoader.Property.DEFAULT_VERIFY_SERVER_IDENTITY, true));
        this.threadPoolSize = Preconditions.assumeNonNull(ConfigLoader.valueOrPropertyAsInteger(null, ConfigLoader.Property.DEFAULT_POOL_SIZE, 10));
        this.threadPoolKeepAliveTime = Preconditions.assumeNonNull(ConfigLoader.valueOrPropertyAsInteger(null, ConfigLoader.Property.DEFAULT_POOL_KEEP_ALIVE_TIME, 1));
        this.connectionPoolCoreSize = Preconditions.assumeNonNull(ConfigLoader.valueOrPropertyAsInteger(null, ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_CORE_SIZE, 0));
        this.connectionPoolMaxSize = Preconditions.assumeNonNull(ConfigLoader.valueOrPropertyAsInteger(null, ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_MAX_SIZE, 4));
        this.connectionPoolClaimTimeoutMillis = Preconditions.assumeNonNull(ConfigLoader.valueOrPropertyAsInteger(null, ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_CLAIMTIMEOUT_MILLIS, Integer.MAX_VALUE));
        this.connectionPoolExpireAfterMillis = Preconditions.assumeNonNull(ConfigLoader.valueOrPropertyAsInteger(null, ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_EXPIREAFTER_MILLIS, 5000));
        this.connectionPoolLoadBalancingStrategy = Preconditions.assumeNonNull(ConfigLoader.valueOrProperty(null, ConfigLoader.Property.DEFAULT_CONNECTIONPOOL_LOADBALANCING_STRATEGY, LoadBalancingStrategy.valueOf("ROUND_ROBIN")));
        this.transportModeLoggingOnly = Preconditions.assumeNonNull(ConfigLoader.valueOrPropertyAsBoolean(null, ConfigLoader.Property.TRANSPORT_MODE_LOGGING_ONLY, false));
        String trustedHosts = ConfigLoader.valueOrPropertyAsString(null, ConfigLoader.Property.DEFAULT_TRUSTED_HOSTS, null);
        if (trustedHosts != null) {
            this.sslHostsToTrust = Arrays.asList(trustedHosts.split(";"));
        }
        this.emailAddressCriteria = EmailAddressCriteria.RFC_COMPLIANT.clone();
        if (ConfigLoader.hasProperty(ConfigLoader.Property.SMIME_SIGNING_KEYSTORE)) {
            this.signByDefaultWithSmime(Pkcs12Config.builder().pkcs12Store(Preconditions.assumeNonNull(ConfigLoader.getStringProperty(ConfigLoader.Property.SMIME_SIGNING_KEYSTORE))).storePassword(Preconditions.checkNonEmptyArgument(ConfigLoader.getStringProperty(ConfigLoader.Property.SMIME_SIGNING_KEYSTORE_PASSWORD), "Keystore password property")).keyAlias(Preconditions.checkNonEmptyArgument(ConfigLoader.getStringProperty(ConfigLoader.Property.SMIME_SIGNING_KEY_ALIAS), "Key alias property")).keyPassword(Preconditions.checkNonEmptyArgument(ConfigLoader.getStringProperty(ConfigLoader.Property.SMIME_SIGNING_KEY_PASSWORD), "Key password property")).build());
        }
    }

    ProxyConfig buildProxyConfig() {
        this.validateProxy();
        return new ProxyConfigImpl(this.getProxyHost(), this.getProxyPort(), this.getProxyUsername(), this.getProxyPassword(), this.getProxyBridgePort());
    }

    private void validateProxy() {
        if (!MiscUtil.valueNullOrEmpty(this.proxyHost)) {
            MiscUtil.checkArgumentNotEmpty(this.proxyPort, "proxyHost provided, but not a proxyPort");
            if (!MiscUtil.valueNullOrEmpty(this.proxyUsername) && MiscUtil.valueNullOrEmpty(this.proxyPassword)) {
                throw new IllegalArgumentException("Proxy username provided but not a password");
            }
            if (MiscUtil.valueNullOrEmpty(this.proxyUsername) && !MiscUtil.valueNullOrEmpty(this.proxyPassword)) {
                throw new IllegalArgumentException("Proxy password provided but not a username");
            }
            if (!MiscUtil.valueNullOrEmpty(this.proxyUsername) && MiscUtil.valueNullOrEmpty(this.proxyBridgePort)) {
                throw new IllegalArgumentException("Cannot authenticate with proxy if no proxy bridge port is configured");
            }
        }
    }

    EmailGovernance buildEmailGovernance() {
        return new EmailGovernanceImpl(Preconditions.assumeNonNull(this.getEmailAddressCriteria()), this.getPkcs12ConfigForSmimeSigning());
    }

    OperationalConfig buildOperationalConfig() {
        return new OperationalConfigImpl(this.isAsync(), this.getProperties(), this.getSessionTimeout(), this.getThreadPoolSize(), this.getThreadPoolKeepAliveTime(), this.getClusterKey(), this.getConnectionPoolCoreSize(), this.getConnectionPoolMaxSize(), this.getConnectionPoolClaimTimeoutMillis(), this.getConnectionPoolExpireAfterMillis(), this.getConnectionPoolLoadBalancingStrategy(), this.isTransportModeLoggingOnly(), this.isDebugLogging(), this.getSslHostsToTrust(), this.isTrustAllSSLHost(), this.isVerifyingServerIdentity(), this.getExecutorService() != null ? this.getExecutorService() : this.determineDefaultExecutorService(), this.isExecutorServiceUserProvided(), this.getCustomMailer());
    }

    @Override
    public T async() {
        this.async = true;
        return (T)this;
    }

    @Override
    public T withProxy(@Nullable String proxyHost, @Nullable Integer proxyPort) {
        return (T)((MailerGenericBuilderImpl)this.withProxyHost(proxyHost)).withProxyPort(proxyPort);
    }

    @Override
    public T withProxy(@Nullable String proxyHost, @Nullable Integer proxyPort, @Nullable String proxyUsername, @Nullable String proxyPassword) {
        return (T)((MailerGenericBuilderImpl)((MailerGenericBuilderImpl)((MailerGenericBuilderImpl)this.withProxyHost(proxyHost)).withProxyPort(proxyPort)).withProxyUsername(proxyUsername)).withProxyPassword(proxyPassword);
    }

    @Override
    public T withProxyHost(@Nullable String proxyHost) {
        this.proxyHost = proxyHost;
        return (T)this;
    }

    @Override
    public T withProxyPort(@Nullable Integer proxyPort) {
        this.proxyPort = proxyPort;
        return (T)this;
    }

    @Override
    public T withProxyUsername(@Nullable String proxyUsername) {
        this.proxyUsername = proxyUsername;
        return (T)this;
    }

    @Override
    public T withProxyPassword(@Nullable String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return (T)this;
    }

    @Override
    public T withProxyBridgePort(@NotNull Integer proxyBridgePort) {
        this.proxyBridgePort = proxyBridgePort;
        return (T)this;
    }

    @Override
    public T withDebugLogging(@NotNull Boolean debugLogging) {
        this.debugLogging = debugLogging;
        return (T)this;
    }

    @Override
    public T withSessionTimeout(@NotNull Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return (T)this;
    }

    @Override
    public T withEmailAddressCriteria(@NotNull EnumSet<EmailAddressCriteria> emailAddressCriteria) {
        this.emailAddressCriteria = emailAddressCriteria.clone();
        return (T)this;
    }

    @Override
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Input stream being created should not be closed here")
    public T signByDefaultWithSmime(@NotNull File pkcs12StoreFile, @NotNull String storePassword, @NotNull String keyAlias, @NotNull String keyPassword) {
        try {
            return (T)this.signByDefaultWithSmime(new FileInputStream(pkcs12StoreFile), storePassword, keyAlias, keyPassword);
        }
        catch (IOException e) {
            throw new MailerException(String.format("Error reading from file: %s", pkcs12StoreFile), e);
        }
    }

    @Override
    public T signByDefaultWithSmime(@NotNull InputStream pkcs12StoreStream, @NotNull String storePassword, @NotNull String keyAlias, @NotNull String keyPassword) {
        byte[] pkcs12StoreData;
        try {
            pkcs12StoreData = MiscUtil.readInputStreamToBytes(pkcs12StoreStream);
        }
        catch (IOException e) {
            throw new MailerException("Was unable to read S/MIME data from input stream", e);
        }
        return (T)this.signByDefaultWithSmime(pkcs12StoreData, storePassword, keyAlias, keyPassword);
    }

    @Override
    public T signByDefaultWithSmime(@NotNull byte[] pkcs12StoreData, @NotNull String storePassword, @NotNull String keyAlias, @NotNull String keyPassword) {
        return (T)this.signByDefaultWithSmime(Pkcs12Config.builder().pkcs12Store(pkcs12StoreData).storePassword(storePassword).keyAlias(keyAlias).keyPassword(keyPassword).build());
    }

    @Override
    public T signByDefaultWithSmime(@NotNull Pkcs12Config pkcs12Config) {
        this.pkcs12ConfigForSmimeSigning = pkcs12Config;
        return (T)this;
    }

    @Override
    public T withExecutorService(@NotNull ExecutorService executorService) {
        this.executorService = executorService;
        return (T)this;
    }

    @Override
    public T withThreadPoolSize(@NotNull Integer threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
        return (T)this;
    }

    @Override
    public T withThreadPoolKeepAliveTime(@NotNull Integer threadPoolKeepAliveTime) {
        this.threadPoolKeepAliveTime = threadPoolKeepAliveTime;
        return (T)this;
    }

    @Override
    public T withClusterKey(@NotNull UUID clusterKey) {
        this.clusterKey = clusterKey;
        return (T)this;
    }

    @Override
    public T withConnectionPoolCoreSize(@NotNull Integer connectionPoolCoreSize) {
        this.connectionPoolCoreSize = connectionPoolCoreSize;
        return (T)this;
    }

    @Override
    public T withConnectionPoolMaxSize(@NotNull Integer connectionPoolMaxSize) {
        this.connectionPoolMaxSize = connectionPoolMaxSize;
        return (T)this;
    }

    @Override
    public T withConnectionPoolClaimTimeoutMillis(@NotNull Integer connectionPoolClaimTimeoutMillis) {
        this.connectionPoolClaimTimeoutMillis = connectionPoolClaimTimeoutMillis;
        return (T)this;
    }

    @Override
    public T withConnectionPoolExpireAfterMillis(@NotNull Integer connectionPoolExpireAfterMillis) {
        this.connectionPoolExpireAfterMillis = connectionPoolExpireAfterMillis;
        return (T)this;
    }

    @Override
    public T withConnectionPoolLoadBalancingStrategy(@NotNull LoadBalancingStrategy loadBalancingStrategy) {
        this.connectionPoolLoadBalancingStrategy = loadBalancingStrategy;
        return (T)this;
    }

    @Override
    public T withTransportModeLoggingOnly(@NotNull Boolean transportModeLoggingOnly) {
        this.transportModeLoggingOnly = transportModeLoggingOnly;
        return (T)this;
    }

    @Override
    public T trustingSSLHosts(String ... sslHostsToTrust) {
        this.sslHostsToTrust = Arrays.asList(sslHostsToTrust);
        return (T)this;
    }

    @Override
    public T trustingAllHosts(boolean trustAllHosts) {
        this.trustAllSSLHost = trustAllHosts;
        return (T)this;
    }

    @Override
    public T verifyingServerIdentity(boolean verifyingServerIdentity) {
        this.verifyingServerIdentity = verifyingServerIdentity;
        return (T)this;
    }

    @Override
    public T withProperties(@NotNull Properties properties) {
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            this.properties.put(property.getKey(), property.getValue());
        }
        return (T)this;
    }

    @Override
    public T withProperties(@NotNull Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            this.properties.put(property.getKey(), property.getValue());
        }
        return (T)this;
    }

    @Override
    public T withProperty(@NotNull String propertyName, @Nullable Object propertyValue) {
        if (propertyValue == null) {
            this.properties.remove(propertyName);
        } else {
            this.properties.put(propertyName, propertyValue.toString());
        }
        return (T)this;
    }

    @Override
    public T withCustomMailer(@NotNull CustomMailer customMailer) {
        this.customMailer = customMailer;
        return (T)this;
    }

    @Override
    public T resetSessionTimeout() {
        return (T)this.withSessionTimeout(60000);
    }

    @Override
    public T resetTrustingAllHosts() {
        return (T)this.trustingAllHosts(true);
    }

    @Override
    public T resetVerifyingServerIdentity() {
        return (T)this.verifyingServerIdentity(true);
    }

    @Override
    public T resetEmailAddressCriteria() {
        return (T)this.withEmailAddressCriteria((EnumSet)EmailAddressCriteria.RFC_COMPLIANT);
    }

    @Override
    public T resetExecutorService() {
        this.executorService = null;
        return (T)this;
    }

    @NotNull
    private ExecutorService determineDefaultExecutorService() {
        return ModuleLoader.batchModuleAvailable() ? ModuleLoader.loadBatchModule().createDefaultExecutorService(this.getThreadPoolSize(), this.getThreadPoolKeepAliveTime()) : Executors.newSingleThreadExecutor();
    }

    @Override
    public T resetThreadPoolSize() {
        return (T)this.withThreadPoolSize(10);
    }

    @Override
    public T resetThreadPoolKeepAliveTime() {
        return (T)this.withThreadPoolKeepAliveTime(1);
    }

    @Override
    public T resetClusterKey() {
        return (T)this.withClusterKey(UUID.randomUUID());
    }

    @Override
    public T resetConnectionPoolCoreSize() {
        return (T)this.withConnectionPoolCoreSize(0);
    }

    @Override
    public T resetConnectionPoolMaxSize() {
        return (T)this.withConnectionPoolCoreSize(4);
    }

    @Override
    public T resetConnectionPoolClaimTimeoutMillis() {
        return (T)this.withConnectionPoolExpireAfterMillis(Integer.MAX_VALUE);
    }

    @Override
    public T resetConnectionPoolExpireAfterMillis() {
        return (T)this.withConnectionPoolExpireAfterMillis(5000);
    }

    @Override
    public T resetConnectionPoolLoadBalancingStrategy() {
        return (T)this.withConnectionPoolLoadBalancingStrategy(LoadBalancingStrategy.valueOf("ROUND_ROBIN"));
    }

    @Override
    public T resetTransportModeLoggingOnly() {
        return (T)this.withTransportModeLoggingOnly(false);
    }

    @Override
    public T clearProxy() {
        return (T)((MailerGenericBuilderImpl)this.withProxy(null, null, null, null)).withProxyBridgePort(1081);
    }

    @Override
    public T clearEmailAddressCriteria() {
        return (T)this.withEmailAddressCriteria((EnumSet)EnumSet.noneOf(EmailAddressCriteria.class));
    }

    @Override
    public T clearSignByDefaultWithSmime() {
        this.pkcs12ConfigForSmimeSigning = null;
        return (T)this;
    }

    @Override
    public T clearTrustedSSLHosts() {
        return (T)this.trustingSSLHosts(new String[0]);
    }

    @Override
    public T clearProperties() {
        this.properties.clear();
        return (T)this;
    }

    @Override
    public boolean isAsync() {
        return this.async;
    }

    @Override
    @Nullable
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    @Nullable
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Override
    @Nullable
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Override
    @Nullable
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Override
    @NotNull
    public Integer getProxyBridgePort() {
        return this.proxyBridgePort;
    }

    @Override
    public boolean isDebugLogging() {
        return this.debugLogging;
    }

    @Override
    @NotNull
    public Integer getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    @NotNull
    public EnumSet<EmailAddressCriteria> getEmailAddressCriteria() {
        return this.emailAddressCriteria;
    }

    @Override
    @Nullable
    public Pkcs12Config getPkcs12ConfigForSmimeSigning() {
        return this.pkcs12ConfigForSmimeSigning;
    }

    @Override
    @Nullable
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public boolean isExecutorServiceUserProvided() {
        return this.executorService != null;
    }

    @Override
    @NotNull
    public Integer getThreadPoolSize() {
        return this.threadPoolSize;
    }

    @Override
    @NotNull
    public Integer getThreadPoolKeepAliveTime() {
        return this.threadPoolKeepAliveTime;
    }

    @Override
    @NotNull
    public UUID getClusterKey() {
        return this.clusterKey;
    }

    @Override
    @NotNull
    public Integer getConnectionPoolCoreSize() {
        return this.connectionPoolCoreSize;
    }

    @Override
    @NotNull
    public Integer getConnectionPoolMaxSize() {
        return this.connectionPoolMaxSize;
    }

    @Override
    @NotNull
    public Integer getConnectionPoolClaimTimeoutMillis() {
        return this.connectionPoolClaimTimeoutMillis;
    }

    @Override
    @NotNull
    public Integer getConnectionPoolExpireAfterMillis() {
        return this.connectionPoolExpireAfterMillis;
    }

    @Override
    @NotNull
    public LoadBalancingStrategy getConnectionPoolLoadBalancingStrategy() {
        return this.connectionPoolLoadBalancingStrategy;
    }

    @Override
    @NotNull
    public List<String> getSslHostsToTrust() {
        return this.sslHostsToTrust;
    }

    @Override
    public boolean isTrustAllSSLHost() {
        return this.trustAllSSLHost;
    }

    @Override
    public boolean isVerifyingServerIdentity() {
        return this.verifyingServerIdentity;
    }

    @Override
    public boolean isTransportModeLoggingOnly() {
        return this.transportModeLoggingOnly;
    }

    @Override
    @NotNull
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    @Nullable
    public CustomMailer getCustomMailer() {
        return this.customMailer;
    }
}

