/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.activation.MimetypesFileTypeMap;

class ImageMimeType {
    private static final String MIMETYPES = "image/xpm xpm\nimage/xbm xbm\nimage/x-xwindowdump xwd\nimage/x-xwd xwd\nimage/x-xpixmap xpm pm\nimage/x-xbm xbm\nimage/x-xbitmap xbm\nimage/x-windows-bmp bmp\nimage/x-tiff tif tiff\nimage/x-rgb rgb\nimage/x-quicktime qtif qti qif\nimage/x-portable-pixmap ppm\nimage/x-portable-greymap pgm\nimage/x-portable-graymap pgm\nimage/x-portable-bitmap pbm\nimage/x-portable-anymap pnm\nimage/x-pict pct\nimage/x-pcx pcx\nimage/x-niff niff nif\nimage/x-jps jps\nimage/x-jg art\nimage/x-icon ico\nimage/x-generic jpg tif wmf tiff bmp xpm png jpeg emf\nimage/x-eps eps\nimage/x-dwg svf dxf dwg\nimage/x-cmu-raster ras\nimage/vnd.xiff xif\nimage/vnd.wap.wbmp wbmp\nimage/vnd.rn-realpix rp\nimage/vnd.rn-realflash rf\nimage/vnd.net-fpx fpx\nimage/vnd.fpx fpx\nimage/vnd.dwg svf dxf dwg\nimage/vasa mcf\nimage/tiff tif tiff\nimage/svg+xml svgz svg\nimage/png x-png png PNG\nimage/pjpeg jpg jfif jpeg jpe\nimage/pict pic pict\nimage/naplps naplps nap\nimage/jutvision jut\nimage/jpeg jpg JPG jfif jpeg jfif-tbnl jpe\nimage/ief iefs ief\nimage/gif gif GIF\nimage/g3fax g3\nimage/florian flo turbot\nimage/fif fif\nimage/cmu-raster ras rast\nimage/bmp bmp bm";
    public static final MimetypesFileTypeMap IMAGE_MIMETYPES_FILE_TYPE_MAP = ImageMimeType.createMap();

    ImageMimeType() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MimetypesFileTypeMap createMap() {
        try (ByteArrayInputStream is = new ByteArrayInputStream(MIMETYPES.getBytes(StandardCharsets.UTF_8));){
            MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap(is);
            return mimetypesFileTypeMap;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getContentType(String fileName) {
        return ImageMimeType.getContentType(fileName, null);
    }

    public static String getContentType(String fileName, String charset) {
        String mimeType = IMAGE_MIMETYPES_FILE_TYPE_MAP.getContentType(fileName.toLowerCase());
        if (charset != null && (mimeType.startsWith("text/") || mimeType.contains("javascript"))) {
            mimeType = mimeType + ";charset=" + charset.toLowerCase();
        }
        return mimeType;
    }
}

