/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageHelper;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProduceException;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducer;

class MimeMessageProducerRelatedAlternative
extends MimeMessageProducer {
    MimeMessageProducerRelatedAlternative() {
    }

    @Override
    boolean compatibleWithEmail(@NotNull Email email) {
        return !MimeMessageProducerRelatedAlternative.emailContainsMixedContent(email) && MimeMessageProducerRelatedAlternative.emailContainsRelatedContent(email) && MimeMessageProducerRelatedAlternative.emailContainsAlternativeContent(email);
    }

    @Override
    public void populateMimeMessageMultipartStructure(@NotNull MimeMessage message, @NotNull Email email) throws MessagingException {
        MultipartStructureWrapper multipartStructureWrapper = new MultipartStructureWrapper();
        MimeMessageHelper.setTexts(email, multipartStructureWrapper.multipartAlternativeMessages);
        MimeMessageHelper.setEmbeddedImages(email, multipartStructureWrapper.multipartRootRelated);
        message.setContent(multipartStructureWrapper.multipartRootRelated);
    }

    private static class MultipartStructureWrapper {
        private final MimeMultipart multipartRootRelated = new MimeMultipart("related");
        private final MimeMultipart multipartAlternativeMessages;

        private MultipartStructureWrapper() {
            MimeBodyPart contentRelated = new MimeBodyPart();
            this.multipartAlternativeMessages = new MimeMultipart("alternative");
            MimeBodyPart contentAlternativeMessages = new MimeBodyPart();
            try {
                contentRelated.setContent(this.multipartRootRelated);
                this.multipartRootRelated.addBodyPart(contentAlternativeMessages);
                contentAlternativeMessages.setContent(this.multipartAlternativeMessages);
            }
            catch (MessagingException e) {
                throw new MimeMessageProduceException(e.getMessage(), e);
            }
        }
    }
}

