/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.mailer.config.Pkcs12Config;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducer;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerAlternative;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerMixed;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerMixedAlternative;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerMixedRelated;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerMixedRelatedAlternative;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerRelated;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerRelatedAlternative;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerSimple;

public final class MimeMessageProducerHelper {
    private static final List<MimeMessageProducer> mimeMessageProducers = Arrays.asList(new MimeMessageProducerSimple(), new MimeMessageProducerAlternative(), new MimeMessageProducerRelated(), new MimeMessageProducerMixed(), new MimeMessageProducerMixedRelated(), new MimeMessageProducerMixedAlternative(), new MimeMessageProducerRelatedAlternative(), new MimeMessageProducerMixedRelatedAlternative());

    private MimeMessageProducerHelper() {
    }

    public static MimeMessage produceMimeMessage(@NotNull Email email, @NotNull Session session, @Nullable Pkcs12Config defaultSmimeSigningStore) throws UnsupportedEncodingException, MessagingException {
        for (MimeMessageProducer mimeMessageProducer : mimeMessageProducers) {
            if (!mimeMessageProducer.compatibleWithEmail(email)) continue;
            return mimeMessageProducer.populateMimeMessage(email, session, defaultSmimeSigningStore);
        }
        throw new IllegalStateException("no compatible MimeMessageProducer found for email");
    }
}

