/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xml;

import java.io.IOException;
import java.util.Vector;
import org.hl7.fhir.utilities.xml.XMLWriterState;

public class XMLWriterStateStack {
    private Vector<XMLWriterState> items = new Vector();

    public int size() {
        return this.items.size();
    }

    public boolean empty() {
        return this.items.size() == 0;
    }

    public XMLWriterState current() throws IOException {
        if (this.empty()) {
            throw new IOException("stack is empty trying to get current");
        }
        return this.items.get(this.items.size() - 1);
    }

    public void push(XMLWriterState element) {
        this.items.add(element);
    }

    public void clear() {
        if (this.items != null) {
            this.items.clear();
        }
    }

    public void pop() throws IOException {
        if (this.empty()) {
            throw new IOException("stack is empty trying to pop");
        }
        if (this.current().isInComment()) {
            throw new IOException("Must close a comment sequence in the element in which it was started");
        }
        this.items.remove(this.items.size() - 1);
    }

    public XMLWriterState item(int index) {
        return this.items.get(index);
    }

    public boolean inComment() {
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            if (!this.items.get(i2).isInComment()) continue;
            return true;
        }
        return false;
    }
}

