/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class NamespaceContextMap {
    private final Map<String, String> prefixMap;
    private final Map<String, Set<String>> nsMap;

    public NamespaceContextMap(Map<String, String> prefixMappings) {
        this.prefixMap = this.createPrefixMap(prefixMappings);
        this.nsMap = this.createNamespaceMap(this.prefixMap);
    }

    public NamespaceContextMap(String ... mappingPairs) {
        this(NamespaceContextMap.toMap(mappingPairs));
    }

    private static Map<String, String> toMap(String ... mappingPairs) {
        HashMap<String, String> prefixMappings = new HashMap<String, String>(mappingPairs.length / 2);
        for (int i2 = 0; i2 < mappingPairs.length; ++i2) {
            prefixMappings.put(mappingPairs[i2], mappingPairs[++i2]);
        }
        return prefixMappings;
    }

    private Map<String, String> createPrefixMap(Map<String, String> prefixMappings) {
        HashMap<String, String> prefixMap = new HashMap<String, String>(prefixMappings);
        this.addConstant(prefixMap, "xml", "http://www.w3.org/XML/1998/namespace");
        this.addConstant(prefixMap, "xmlns", "http://www.w3.org/2000/xmlns/");
        return Collections.unmodifiableMap(prefixMap);
    }

    private void addConstant(Map<String, String> prefixMap, String prefix, String nsURI) {
        String previous = prefixMap.put(prefix, nsURI);
        if (previous != null && !previous.equals(nsURI)) {
            throw new IllegalArgumentException(prefix + " -> " + previous + "; see NamespaceContext contract");
        }
    }

    private Map<String, Set<String>> createNamespaceMap(Map<String, String> prefixMap) {
        HashMap<String, Set<String>> nsMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, String> entry : prefixMap.entrySet()) {
            String nsURI = entry.getValue();
            HashSet<String> prefixes = (HashSet<String>)nsMap.get(nsURI);
            if (prefixes == null) {
                prefixes = new HashSet<String>();
                nsMap.put(nsURI, prefixes);
            }
            prefixes.add(entry.getKey());
        }
        for (Map.Entry<String, String> entry : nsMap.entrySet()) {
            Set readOnly = Collections.unmodifiableSet((Set)((Object)entry.getValue()));
            entry.setValue((String)((Object)readOnly));
        }
        return nsMap;
    }

    public String getNamespaceURI(String prefix) {
        this.checkNotNull(prefix);
        String nsURI = this.prefixMap.get(prefix);
        return nsURI == null ? "" : nsURI;
    }

    public String getPrefix(String namespaceURI) {
        this.checkNotNull(namespaceURI);
        Set<String> set = this.nsMap.get(namespaceURI);
        return set == null ? null : set.iterator().next();
    }

    public Iterator<String> getPrefixes(String namespaceURI) {
        this.checkNotNull(namespaceURI);
        Set<String> set = this.nsMap.get(namespaceURI);
        return set.iterator();
    }

    private void checkNotNull(String value) {
        if (value == null) {
            throw new IllegalArgumentException("null");
        }
    }

    public Map<String, String> getMap() {
        return this.prefixMap;
    }
}

