/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xhtml;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xml.IXMLWriter;
import org.w3c.dom.Element;

public class XhtmlComposer {
    public static final String XHTML_NS = "http://www.w3.org/1999/xhtml";
    private boolean pretty;
    private boolean xml;
    public static final boolean XML = true;
    public static final boolean HTML = false;
    private Writer dst;

    public XhtmlComposer(boolean xml, boolean pretty) {
        this.pretty = pretty;
        this.xml = xml;
    }

    public XhtmlComposer(boolean xml) {
        this.pretty = false;
        this.xml = xml;
    }

    public String compose(XhtmlDocument doc) throws IOException {
        StringWriter sdst = new StringWriter();
        this.dst = sdst;
        this.composeDoc(doc);
        return sdst.toString();
    }

    public String compose(XhtmlNode node) throws IOException {
        StringWriter sdst = new StringWriter();
        this.dst = sdst;
        this.writeNode("", node, false);
        return sdst.toString();
    }

    public void compose(OutputStream stream, XhtmlDocument doc) throws IOException {
        byte[] bom = new byte[]{-17, -69, -65};
        stream.write(bom);
        this.dst = new OutputStreamWriter(stream, "UTF-8");
        this.composeDoc(doc);
        this.dst.flush();
    }

    private void composeDoc(XhtmlDocument doc) throws IOException {
        for (XhtmlNode c : doc.getChildNodes()) {
            this.writeNode("  ", c, false);
        }
    }

    private void writeNode(String indent, XhtmlNode node, boolean noPrettyOverride) throws IOException {
        if (node.getNodeType() == NodeType.Comment) {
            this.writeComment(indent, node, noPrettyOverride);
        } else if (node.getNodeType() == NodeType.DocType) {
            this.writeDocType(node);
        } else if (node.getNodeType() == NodeType.Instruction) {
            this.writeInstruction(node);
        } else if (node.getNodeType() == NodeType.Element) {
            this.writeElement(indent, node, noPrettyOverride);
        } else if (node.getNodeType() == NodeType.Document) {
            this.writeDocument(indent, node);
        } else if (node.getNodeType() == NodeType.Text) {
            this.writeText(node);
        } else {
            if (node.getNodeType() == null) {
                throw new IOException("Null node type");
            }
            throw new IOException("Unknown node type: " + node.getNodeType().toString());
        }
    }

    private void writeText(XhtmlNode node) throws IOException {
        for (char c : node.getContent().toCharArray()) {
            if (c == '&') {
                this.dst.append("&amp;");
                continue;
            }
            if (c == '<') {
                this.dst.append("&lt;");
                continue;
            }
            if (c == '>') {
                this.dst.append("&gt;");
                continue;
            }
            if (this.xml) {
                if (c == '\"') {
                    this.dst.append("&quot;");
                    continue;
                }
                this.dst.append(c);
                continue;
            }
            if (c == XhtmlNode.NBSP.charAt(0)) {
                this.dst.append("&nbsp;");
                continue;
            }
            if (c == '\u00a7') {
                this.dst.append("&sect;");
                continue;
            }
            if (c == '\u00a9') {
                this.dst.append("&copy;");
                continue;
            }
            if (c == '\u2122') {
                this.dst.append("&trade;");
                continue;
            }
            if (c == '\u03bc') {
                this.dst.append("&mu;");
                continue;
            }
            if (c == '\u00ae') {
                this.dst.append("&reg;");
                continue;
            }
            this.dst.append(c);
        }
    }

    private void writeComment(String indent, XhtmlNode node, boolean noPrettyOverride) throws IOException {
        this.dst.append(indent + "<!-- " + node.getContent().trim() + " -->" + (this.pretty && !noPrettyOverride ? "\r\n" : ""));
    }

    private void writeDocType(XhtmlNode node) throws IOException {
        this.dst.append("<!" + node.getContent() + ">\r\n");
    }

    private void writeInstruction(XhtmlNode node) throws IOException {
        this.dst.append("<?" + node.getContent() + "?>\r\n");
    }

    private String escapeHtml(String s2) {
        if (s2 == null || s2.equals("")) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (char c : s2.toCharArray()) {
            if (c == '<') {
                b.append("&lt;");
                continue;
            }
            if (c == '>') {
                b.append("&gt;");
                continue;
            }
            if (c == '\"') {
                b.append("&quot;");
                continue;
            }
            if (c == '&') {
                b.append("&amp;");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    private String attributes(XhtmlNode node) {
        StringBuilder s2 = new StringBuilder();
        for (String n : node.getAttributes().keySet()) {
            s2.append(" " + n + "=\"" + this.escapeHtml(node.getAttributes().get(n)) + "\"");
        }
        return s2.toString();
    }

    private void writeElement(String indent, XhtmlNode node, boolean noPrettyOverride) throws IOException {
        boolean concise;
        if (!this.pretty || noPrettyOverride) {
            indent = "";
        }
        boolean bl = concise = node.getChildNodes().size() == 0;
        if (node.hasEmptyExpanded() && node.getEmptyExpanded().booleanValue()) {
            concise = false;
        }
        if (!this.xml && Utilities.existsInList(node.getName(), "area", "base", "br", "col", "command", "embed", "hr", "img", "input", "keygen", "link", "menuitem", "meta", "param", "source", "track", "wbr")) {
            concise = true;
        }
        if (concise) {
            this.dst.append(indent + "<" + node.getName() + this.attributes(node) + "/>" + (this.pretty && !noPrettyOverride ? "\r\n" : ""));
        } else {
            boolean act = node.allChildrenAreText();
            if (act || !this.pretty || noPrettyOverride) {
                this.dst.append(indent + "<" + node.getName() + this.attributes(node) + ">");
            } else {
                this.dst.append(indent + "<" + node.getName() + this.attributes(node) + ">\r\n");
            }
            if (node.getName() == "head" && node.getElement("meta") == null) {
                this.dst.append(indent + "  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>" + (this.pretty && !noPrettyOverride ? "\r\n" : ""));
            }
            for (XhtmlNode c : node.getChildNodes()) {
                this.writeNode(indent + "  ", c, noPrettyOverride || node.isNoPretty());
            }
            if (act) {
                this.dst.append("</" + node.getName() + ">" + (this.pretty && !noPrettyOverride ? "\r\n" : ""));
            } else if (node.getChildNodes().get(node.getChildNodes().size() - 1).getNodeType() == NodeType.Text) {
                this.dst.append((String)(this.pretty && !noPrettyOverride ? "\r\n" + indent : "") + "</" + node.getName() + ">" + (this.pretty && !noPrettyOverride ? "\r\n" : ""));
            } else {
                this.dst.append(indent + "</" + node.getName() + ">" + (this.pretty && !noPrettyOverride ? "\r\n" : ""));
            }
        }
    }

    private void writeDocument(String indent, XhtmlNode node) throws IOException {
        indent = "";
        for (XhtmlNode c : node.getChildNodes()) {
            this.writeNode(indent, c, false);
        }
    }

    public void compose(IXMLWriter xml, XhtmlNode node) throws IOException {
        this.compose(xml, node, false);
    }

    public void compose(IXMLWriter xml, XhtmlNode node, boolean noPrettyOverride) throws IOException {
        if (node.getNodeType() == NodeType.Comment) {
            xml.comment(node.getContent(), this.pretty && !noPrettyOverride);
        } else if (node.getNodeType() == NodeType.Element) {
            this.composeElement(xml, node, noPrettyOverride);
        } else if (node.getNodeType() == NodeType.Text) {
            xml.text(node.getContent());
        } else {
            throw new Error("Unhandled node type: " + node.getNodeType().toString());
        }
    }

    private void composeElement(IXMLWriter xml, XhtmlNode node, boolean noPrettyOverride) throws IOException {
        for (String string : node.getAttributes().keySet()) {
            if (string.equals("xmlns")) {
                xml.setDefaultNamespace(node.getAttributes().get(string));
                continue;
            }
            if (string.startsWith("xmlns:")) {
                xml.namespace(string.substring(6), node.getAttributes().get(string));
                continue;
            }
            xml.attribute(string, node.getAttributes().get(string));
        }
        xml.enter(XHTML_NS, node.getName());
        for (XhtmlNode xhtmlNode : node.getChildNodes()) {
            this.compose(xml, xhtmlNode, noPrettyOverride || node.isNoPretty());
        }
        xml.exit(XHTML_NS, node.getName());
    }

    public String composePlainText(XhtmlNode x) {
        StringBuilder b = new StringBuilder();
        this.composePlainText(x, b, false);
        return b.toString().trim();
    }

    private boolean composePlainText(XhtmlNode x, StringBuilder b, boolean lastWS) {
        if (x.getNodeType() == NodeType.Text) {
            String s2;
            if (!lastWS & ((s2 = x.getContent()).startsWith(" ") || s2.startsWith("\r") || s2.startsWith("\n") || s2.endsWith("\t"))) {
                b.append(" ");
                lastWS = true;
            }
            String st = s2.trim().replace("\r", " ").replace("\n", " ").replace("\t", " ");
            while (st.contains("  ")) {
                st = st.replace("  ", " ");
            }
            if (!Utilities.noString(st)) {
                b.append(st);
                lastWS = false;
                if (!lastWS & (s2.endsWith(" ") || s2.endsWith("\r") || s2.endsWith("\n") || s2.endsWith("\t"))) {
                    b.append(" ");
                    lastWS = true;
                }
            }
            return lastWS;
        }
        if (x.getNodeType() == NodeType.Element) {
            if (x.getName().equals("li")) {
                b.append("* ");
                lastWS = true;
            }
            for (XhtmlNode n : x.getChildNodes()) {
                lastWS = this.composePlainText(n, b, lastWS);
            }
            if (x.getName().equals("p")) {
                b.append("\r\n\r\n");
                lastWS = true;
            }
            if (x.getName().equals("br") || x.getName().equals("li")) {
                b.append("\r\n");
                lastWS = true;
            }
            return lastWS;
        }
        return lastWS;
    }

    public void compose(Element div, XhtmlNode x) {
        for (XhtmlNode child : x.getChildNodes()) {
            this.appendChild(div, child);
        }
    }

    private void appendChild(Element e, XhtmlNode node) {
        if (node.getNodeType() == NodeType.Comment) {
            e.appendChild(e.getOwnerDocument().createComment(node.getContent()));
        } else {
            if (node.getNodeType() == NodeType.DocType) {
                throw new Error("not done yet");
            }
            if (node.getNodeType() == NodeType.Instruction) {
                e.appendChild(e.getOwnerDocument().createProcessingInstruction("", node.getContent()));
            } else if (node.getNodeType() == NodeType.Text) {
                e.appendChild(e.getOwnerDocument().createTextNode(node.getContent()));
            } else if (node.getNodeType() == NodeType.Element) {
                Element child = e.getOwnerDocument().createElementNS(XHTML_NS, node.getName());
                e.appendChild(child);
                for (String n : node.getAttributes().keySet()) {
                    child.setAttribute(n, node.getAttribute(n));
                }
                for (XhtmlNode c : node.getChildNodes()) {
                    this.appendChild(child, c);
                }
            } else {
                throw new Error("Unknown node type: " + node.getNodeType().toString());
            }
        }
    }

    public void compose(OutputStream stream, XhtmlNode x) throws IOException {
        byte[] bom = new byte[]{-17, -69, -65};
        stream.write(bom);
        this.dst = new OutputStreamWriter(stream, "UTF-8");
        this.dst.append("<html><head><link rel=\"stylesheet\" href=\"fhir.css\"/></head><body>\r\n");
        this.writeNode("", x, false);
        this.dst.append("</body></html>\r\n");
        this.dst.flush();
    }

    public void composeDocument(FileOutputStream f, XhtmlNode xhtml) throws IOException {
        byte[] bom = new byte[]{-17, -69, -65};
        f.write(bom);
        this.dst = new OutputStreamWriter((OutputStream)f, "UTF-8");
        this.writeNode("", xhtml, false);
        this.dst.flush();
        this.dst.close();
    }

    public String composeEx(XhtmlNode node) {
        try {
            return this.compose(node);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

