/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.tests.execution.junit5;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.utilities.tests.execution.CliTestSummary;
import org.hl7.fhir.utilities.tests.execution.ModuleTestExecutor;
import org.hl7.fhir.utilities.tests.execution.junit5.JUnit5TestSummaryAdapter;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

public class JUnit5ModuleTestExecutor
extends ModuleTestExecutor {
    private static final String SUMMARY_TEMPLATE = "Tests run: %d, Failures: %d, Errors: %d, Skipped: %d";
    private static final String MODULE_FINISHED_TEMPLATE = "%s module tests finished.";
    public static final String DEFAULT_CLASSNAME_FILTER = "^(Test.*|.+[.$]Test.*|.*Tests?)$";
    private final String moduleName;
    private final List<String> packageNames;

    public JUnit5ModuleTestExecutor(String moduleName, List<String> packageNames) {
        this.moduleName = moduleName;
        this.packageNames = Collections.unmodifiableList(packageNames);
    }

    private List<PackageSelector> getPackageSelectors() {
        List<String> packageNames = this.getPackageNames();
        return packageNames.stream().map(it -> DiscoverySelectors.selectPackage((String)it)).collect(Collectors.toList());
    }

    @Override
    public CliTestSummary executeTests(PrintStream out, String classNameFilter) {
        LauncherDiscoveryRequest request2 = LauncherDiscoveryRequestBuilder.request().selectors(this.getPackageSelectors()).filters(new Filter[]{ClassNameFilter.includeClassNamePatterns((String[])new String[]{classNameFilter == null ? DEFAULT_CLASSNAME_FILTER : classNameFilter})}).build();
        ModuleTestExecutionListener moduleTestExecutionlistener = new ModuleTestExecutionListener();
        moduleTestExecutionlistener.setOut(out);
        try (LauncherSession session = LauncherFactory.openSession();){
            Launcher launcher = session.getLauncher();
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{moduleTestExecutionlistener});
            TestPlan testPlan = launcher.discover(request2);
            launcher.execute(testPlan, new TestExecutionListener[0]);
        }
        TestExecutionSummary summary = moduleTestExecutionlistener.getSummary();
        out.println("\n" + String.format(MODULE_FINISHED_TEMPLATE, this.getModuleName()));
        out.println(String.format(SUMMARY_TEMPLATE, summary.getTestsFoundCount(), summary.getTestsFailedCount(), summary.getTestsAbortedCount(), summary.getTestsSkippedCount()));
        return new JUnit5TestSummaryAdapter(summary);
    }

    public static JUnit5ModuleTestExecutor getStandardModuleTestExecutor(String moduleName) {
        return new JUnit5ModuleTestExecutor(moduleName, Arrays.asList(moduleName));
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    public List<String> getPackageNames() {
        return this.packageNames;
    }

    class ModuleTestExecutionListener
    extends SummaryGeneratingListener {
        private PrintStream out;

        ModuleTestExecutionListener() {
        }

        public void executionStarted(TestIdentifier testIdentifier) {
            ModuleTestExecutor.printTestStarted(this.out, testIdentifier.getDisplayName());
            super.executionStarted(testIdentifier);
        }

        public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
            if (testExecutionResult.getStatus().equals((Object)TestExecutionResult.Status.FAILED)) {
                ModuleTestExecutor.printTestFailed(this.out, testIdentifier.getUniqueId(), testExecutionResult.getThrowable().isPresent() ? (Throwable)testExecutionResult.getThrowable().get() : null);
            }
            ModuleTestExecutor.printTestFinished(this.out, testIdentifier.getDisplayName(), testExecutionResult.getStatus().name());
            super.executionFinished(testIdentifier, testExecutionResult);
        }

        public void setOut(PrintStream out) {
            this.out = out;
        }
    }
}

