/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.utilities.CSFile;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.ToolGlobalSettings;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.tests.TestConfig;

public class BaseTestingUtilities {
    public static boolean silent;

    public static String loadTestResource(String ... paths) throws IOException {
        String contents;
        String dir = TestConfig.getInstance().getFhirTestCasesDirectory();
        if (dir == null && ToolGlobalSettings.hasTestsPath()) {
            dir = ToolGlobalSettings.getTestsPath();
        }
        if (dir != null && new CSFile(dir).exists()) {
            String n = Utilities.path(dir, Utilities.path(paths));
            return TextFile.fileToString(new CSFile(n));
        }
        String classpath = "/org/hl7/fhir/testcases/" + Utilities.pathURL(paths);
        try (InputStream inputStream = BaseTestingUtilities.class.getResourceAsStream(classpath);){
            if (inputStream == null) {
                throw new IOException("Can't find file on classpath: " + classpath);
            }
            contents = IOUtils.toString(inputStream, StandardCharsets.UTF_8);
        }
        return contents;
    }

    public static InputStream loadTestResourceStream(String ... paths) throws IOException {
        String dir = TestConfig.getInstance().getFhirTestCasesDirectory();
        if (dir == null && ToolGlobalSettings.hasTestsPath()) {
            dir = ToolGlobalSettings.getTestsPath();
        }
        if (dir != null && new File(dir).exists()) {
            String n = Utilities.path(dir, Utilities.path(paths));
            return new FileInputStream(n);
        }
        String classpath = "/org/hl7/fhir/testcases/" + Utilities.pathURL(paths);
        InputStream s2 = BaseTestingUtilities.class.getResourceAsStream(classpath);
        if (s2 == null) {
            throw new Error("unable to find resource " + classpath);
        }
        return s2;
    }

    public static byte[] loadTestResourceBytes(String ... paths) throws IOException {
        String dir = TestConfig.getInstance().getFhirTestCasesDirectory();
        if (dir == null && ToolGlobalSettings.hasTestsPath()) {
            dir = ToolGlobalSettings.getTestsPath();
        }
        if (dir != null && new File(dir).exists()) {
            String n = Utilities.path(dir, Utilities.path(paths));
            return TextFile.fileToBytes(n);
        }
        String classpath = "/org/hl7/fhir/testcases/" + Utilities.pathURL(paths);
        InputStream s2 = BaseTestingUtilities.class.getResourceAsStream(classpath);
        if (s2 == null) {
            throw new Error("unable to find resource " + classpath);
        }
        return TextFile.streamToBytes(s2);
    }

    public static boolean findTestResource(String ... paths) throws IOException {
        String dir = TestConfig.getInstance().getFhirTestCasesDirectory();
        if (dir == null && ToolGlobalSettings.hasTestsPath()) {
            dir = ToolGlobalSettings.getTestsPath();
        }
        if (dir != null && new File(dir).exists()) {
            String n = Utilities.path(dir, Utilities.path(paths));
            return new File(n).exists();
        }
        String classpath = "/org/hl7/fhir/testcases/" + Utilities.pathURL(paths);
        try {
            InputStream inputStream = BaseTestingUtilities.class.getResourceAsStream(classpath);
            return inputStream != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String tempFile(String folder, String name) throws IOException {
        String tmp = BaseTestingUtilities.tempFolder(folder);
        return Utilities.path(tmp, name);
    }

    public static String tempFolder(String name) throws IOException {
        String path = Utilities.path(ToolGlobalSettings.hasTempPath() ? ToolGlobalSettings.getTempPath() : "[tmp]", name);
        Utilities.createDirectory(path);
        return path;
    }

    public static void setFhirTestCasesDirectory(String s2) {
    }

    public static void createParentDirIfNotExists(Path target) {
        Path parent = target.getParent();
        if (!parent.toFile().exists()) {
            parent.toFile().mkdirs();
        }
    }
}

