/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.json.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonBoolean;
import org.hl7.fhir.utilities.json.model.JsonComment;
import org.hl7.fhir.utilities.json.model.JsonElementType;
import org.hl7.fhir.utilities.json.model.JsonLocationData;
import org.hl7.fhir.utilities.json.model.JsonNull;
import org.hl7.fhir.utilities.json.model.JsonNumber;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonPrimitive;
import org.hl7.fhir.utilities.json.model.JsonString;

public abstract class JsonElement {
    private List<JsonComment> comments;
    private JsonLocationData start;
    private JsonLocationData end;

    public abstract JsonElementType type();

    public List<JsonComment> getComments() {
        if (this.comments == null) {
            this.comments = new ArrayList<JsonComment>();
        }
        return this.comments;
    }

    public JsonLocationData getStart() {
        return this.start;
    }

    public void setStart(JsonLocationData start) {
        this.start = start;
    }

    public JsonLocationData getEnd() {
        return this.end;
    }

    public void setEnd(JsonLocationData end) {
        this.end = end;
    }

    protected void check(boolean test, String msg) throws JsonException {
        if (!test) {
            throw new JsonException(msg);
        }
    }

    public boolean hasComments() {
        return this.comments != null && !this.comments.isEmpty();
    }

    public JsonElement deepCopy() {
        return this.make().copy(this);
    }

    protected abstract JsonElement copy(JsonElement var1);

    protected abstract JsonElement make();

    public boolean isJsonObject() {
        return this.type() == JsonElementType.OBJECT;
    }

    public boolean isJsonArray() {
        return this.type() == JsonElementType.ARRAY;
    }

    public boolean isJsonPrimitive() {
        return this.isJsonBoolean() || this.isJsonString() || this.isJsonNull() || this.isJsonNumber();
    }

    public boolean isJsonBoolean() {
        return this.type() == JsonElementType.BOOLEAN;
    }

    public boolean isJsonString() {
        return this.type() == JsonElementType.STRING;
    }

    public boolean isJsonNumber() {
        return this.type() == JsonElementType.NUMBER;
    }

    public boolean isJsonNull() {
        return this.type() == JsonElementType.NULL;
    }

    public JsonObject asJsonObject() {
        return this.isJsonObject() ? (JsonObject)this : null;
    }

    public JsonArray asJsonArray() {
        return this.isJsonArray() ? (JsonArray)this : null;
    }

    public JsonPrimitive asJsonPrimitive() {
        return this.isJsonPrimitive() ? (JsonPrimitive)this : null;
    }

    public JsonBoolean asJsonBoolean() {
        return this.isJsonBoolean() ? (JsonBoolean)this : null;
    }

    public JsonString asJsonString() {
        return this.isJsonString() ? (JsonString)this : null;
    }

    public JsonNumber asJsonNumber() {
        return this.isJsonNumber() ? (JsonNumber)this : null;
    }

    public JsonNull asJsonNull() {
        return this.isJsonNull() ? (JsonNull)this : null;
    }

    public String asString() {
        return this.isJsonPrimitive() ? ((JsonPrimitive)this).getValue() : null;
    }
}

