/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPReply;
import org.hl7.fhir.exceptions.FHIRException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPClient {
    private static final Logger logger = LoggerFactory.getLogger(FTPClient.class);
    private final org.apache.commons.net.ftp.FTPClient clientImpl;
    private final String server;
    private final String path;
    private String resolvedPath = null;
    private final String user;
    private final String password;
    private final int port;
    private final String remoteSeparator;

    public FTPClient(String server, String path, String user, String password) {
        this(server, -1, path, user, password);
    }

    protected FTPClient(String server, int port, String path, String user, String password) {
        this.server = server;
        this.port = port;
        this.remoteSeparator = "/";
        this.path = this.buildPath(path);
        this.user = user;
        this.password = password;
        this.clientImpl = new org.apache.commons.net.ftp.FTPClient();
    }

    private String buildPath(String path) {
        if (path.length() == 0) {
            return "";
        }
        if (path.endsWith(this.remoteSeparator)) {
            return path;
        }
        return path + this.remoteSeparator;
    }

    public void connect() throws IOException {
        if (this.port != -1) {
            this.clientImpl.connect(this.server, this.port);
        } else {
            this.clientImpl.connect(this.server);
        }
        this.clientImpl.login(this.user, this.password);
        this.checkForPositiveCompletionAndLogErrors("FTP server could not connect.", true);
        logger.debug("Initial Working directory: " + this.clientImpl.printWorkingDirectory());
        this.clientImpl.changeWorkingDirectory(this.path);
        this.checkForPositiveCompletionAndLogErrors("FTP server could not establish default working directory", true);
        this.resolvedPath = this.clientImpl.printWorkingDirectory();
        logger.debug("Resolved working directory: " + this.resolvedPath);
    }

    public void delete(String path) throws IOException {
        String resolvedPath = this.resolveRemotePath(path);
        logger.debug("Deleting remote file: " + resolvedPath);
        this.clientImpl.deleteFile(resolvedPath);
        this.checkForPositiveCompletionAndLogErrors("Error deleting file.", false);
        logger.debug("Remote file deleted: " + resolvedPath);
    }

    protected void createRemotePathIfNotExists(String filePath) throws IOException {
        String[] subPath = filePath.split(this.remoteSeparator);
        try {
            for (int i2 = 0; i2 < subPath.length - 1; ++i2) {
                boolean exists;
                if (subPath[i2].isEmpty() || (exists = this.clientImpl.changeWorkingDirectory(subPath[i2]))) continue;
                logger.debug("Remote directory does not exist: " + this.clientImpl.printWorkingDirectory() + this.remoteSeparator + subPath[i2]);
                this.clientImpl.makeDirectory(subPath[i2]);
                this.clientImpl.changeWorkingDirectory(subPath[i2]);
                logger.debug("Made remote directory: " + this.clientImpl.printWorkingDirectory());
            }
        }
        catch (IOException e) {
            throw new IOException("Error creating remote path: " + filePath, e);
        }
        finally {
            this.clientImpl.changeWorkingDirectory(this.resolvedPath);
        }
    }

    protected boolean remotePathExists(String path) throws IOException {
        boolean output;
        try {
            output = this.clientImpl.changeWorkingDirectory(path);
        }
        finally {
            this.clientImpl.changeWorkingDirectory(this.resolvedPath);
        }
        return output;
    }

    private String resolveRemotePath(String path) {
        if (path.startsWith(this.remoteSeparator)) {
            throw new IllegalArgumentException("Absolute remote path is not permitted. Path: " + path);
        }
        return String.join((CharSequence)this.remoteSeparator, path);
    }

    public void upload(String source, String path) throws IOException {
        String resolvedPath = this.resolveRemotePath(path);
        logger.debug("Uploading file to remote path: " + resolvedPath);
        this.createRemotePathIfNotExists(path);
        FileInputStream localStream = new FileInputStream(source);
        this.clientImpl.setFileType(2);
        this.clientImpl.enterLocalPassiveMode();
        this.clientImpl.storeFile(resolvedPath, (InputStream)localStream);
        localStream.close();
        this.checkForPositiveCompletionAndLogErrors("Error uploading file.", false);
        logger.debug("Remote file uploaded: " + resolvedPath);
    }

    private void checkForPositiveCompletionAndLogErrors(String localErrorMessage, boolean disconnectOnError) throws IOException {
        int reply = this.clientImpl.getReplyCode();
        if (FTPReply.isPositiveCompletion((int)reply)) {
            return;
        }
        String remoteErrorMessage = this.clientImpl.getReplyString();
        if (disconnectOnError) {
            this.clientImpl.disconnect();
        }
        throw new IOException(localErrorMessage + " Reply code: " + reply + " Message: " + remoteErrorMessage);
    }

    public void disconnect() throws IOException {
        this.clientImpl.disconnect();
    }

    public static void main(String[] args) throws IOException, FHIRException {
        FTPClient ftp = new FTPClient(FTPClient.getNamedParam(args, "-upload-server"), FTPClient.getNamedParam(args, "-upload-path"), FTPClient.getNamedParam(args, "-upload-user"), FTPClient.getNamedParam(args, "-upload-password"));
        ftp.connect();
        ftp.upload("/Users/grahamegrieve/temp/test.xml", "testing/test.xml");
        ftp.delete("testing/test.xml");
        ftp.disconnect();
    }

    private static String getNamedParam(String[] args, String param) {
        boolean found = false;
        for (String a : args) {
            if (found) {
                return a;
            }
            if (!a.equals(param)) continue;
            found = true;
        }
        return null;
    }

    public String getServer() {
        return this.server;
    }

    public String getPath() {
        return this.path;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }
}

