/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.CSVReader;

public class CSVProcessor {
    private InputStream source;
    private DataReader data;
    private OutputStreamWriter out;
    private String start;
    private String loop;
    private int count = 0;
    private String stop;
    private StringBuilder dest;

    public void setSource(InputStream source) {
        this.source = source;
    }

    public void setData(InputStream data) throws FHIRException, IOException {
        try {
            this.data = new DataReader(data);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setOutput(OutputStream out) throws UnsupportedEncodingException {
        this.out = new OutputStreamWriter(out, "UTF-8");
    }

    public void process() throws IOException, FHIRException {
        this.buildTemplate(this.readSource());
        this.dest = new StringBuilder();
        this.dest.append(this.start);
        this.data.process();
        this.dest.append(this.stop);
        this.out.write(this.dest.toString());
        this.out.close();
    }

    private void buildTemplate(String template) throws FHIRException {
        int i2 = template.indexOf("[%loop");
        if (i2 < 0) {
            throw new FHIRException("Unable to process template - didn't find [%loop");
        }
        this.start = template.substring(0, i2);
        if ((i2 = (template = template.substring(i2 + 6)).indexOf("%]")) < 0) {
            throw new FHIRException("Unable to process template - didn't find %] matching [%loop");
        }
        String tmp = template.substring(0, i2);
        if (tmp != null && !tmp.equals("")) {
            if (!tmp.startsWith(" count=")) {
                throw new FHIRException("Unable to process template - unrecognised content on [%loop");
            }
            this.count = Integer.parseInt(tmp.substring(7));
        }
        if ((i2 = (template = template.substring(i2 + 2)).indexOf("[%endloop%]")) < 0) {
            throw new FHIRException("Unable to process template - didn't find [%endloop%]");
        }
        this.loop = template.substring(0, i2);
        this.stop = template.substring(i2 + 11);
    }

    private String readSource() throws IOException {
        StringBuilder s2 = new StringBuilder();
        InputStreamReader r = new InputStreamReader(this.source, "UTF-8");
        while (r.ready()) {
            s2.append((char)r.read());
        }
        r.close();
        return s2.toString();
    }

    public class DataReader
    extends CSVReader {
        public DataReader(InputStream data) throws FHIRException, IOException {
            super(data);
        }

        public void process() throws IOException, FHIRException {
            String[] titles = this.parseLine();
            while (this.ready()) {
                String[] values = this.parseLine();
                this.processLine(titles, values);
            }
            this.close();
        }

        private void processLine(String[] titles, String[] values) throws FHIRException {
            ++CSVProcessor.this.count;
            Object src = CSVProcessor.this.loop;
            while (((String)src).contains("[%")) {
                int i1 = ((String)src).indexOf("[%");
                int i2 = ((String)src).indexOf("%]");
                String s1 = ((String)src).substring(0, i1);
                String s2 = ((String)src).substring(i1 + 2, i2).trim();
                String s3 = ((String)src).substring(i2 + 2);
                if ("count".equals(s2)) {
                    src = s1 + Integer.toString(CSVProcessor.this.count) + s3;
                    continue;
                }
                boolean b = false;
                for (String t : titles) {
                    if (!t.equals(s2)) continue;
                    src = s1 + DataReader.getColumn(titles, values, s2) + s3;
                    b = true;
                }
                if (b) continue;
                throw new FHIRException("unknown column: '" + s2 + "'");
            }
            CSVProcessor.this.dest.append((String)src);
        }
    }
}

