/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.client.network;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.utils.client.EFhirClientException;
import org.hl7.fhir.r5.utils.client.network.ByteUtils;
import org.hl7.fhir.r5.utils.client.network.FhirLoggingInterceptor;
import org.hl7.fhir.r5.utils.client.network.FhirRequestBuilder;
import org.hl7.fhir.r5.utils.client.network.ResourceRequest;
import org.hl7.fhir.utilities.ToolingClientLogger;

public class Client {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final long DEFAULT_TIMEOUT = 5000L;
    private ToolingClientLogger logger;
    private FhirLoggingInterceptor fhirLoggingInterceptor;
    private int retryCount;
    private long timeout = 5000L;
    private byte[] payload;

    public ToolingClientLogger getLogger() {
        return this.logger;
    }

    public void setLogger(ToolingClientLogger logger) {
        this.logger = logger;
        this.fhirLoggingInterceptor = new FhirLoggingInterceptor(logger);
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public <T extends Resource> ResourceRequest<T> issueOptionsRequest(URI optionsUri, String resourceFormat, String message, long timeout) throws IOException {
        this.payload = null;
        Request.Builder request2 = new Request.Builder().method("OPTIONS", null).url(optionsUri.toURL());
        return this.executeFhirRequest(request2, resourceFormat, new Headers.Builder().build(), message, this.retryCount, timeout);
    }

    public <T extends Resource> ResourceRequest<T> issueGetResourceRequest(URI resourceUri, String resourceFormat, Headers headers, String message, long timeout) throws IOException {
        this.payload = null;
        Request.Builder request2 = new Request.Builder().url(resourceUri.toURL());
        return this.executeFhirRequest(request2, resourceFormat, headers, message, this.retryCount, timeout);
    }

    public int tester(int trytry) {
        return 5;
    }

    public <T extends Resource> ResourceRequest<T> issuePutRequest(URI resourceUri, byte[] payload, String resourceFormat, String message, long timeout) throws IOException {
        return this.issuePutRequest(resourceUri, payload, resourceFormat, new Headers.Builder().build(), message, timeout);
    }

    public <T extends Resource> ResourceRequest<T> issuePutRequest(URI resourceUri, byte[] payload, String resourceFormat, Headers headers, String message, long timeout) throws IOException {
        if (payload == null) {
            throw new EFhirClientException("PUT requests require a non-null payload");
        }
        this.payload = payload;
        RequestBody body2 = RequestBody.create((byte[])payload);
        Request.Builder request2 = new Request.Builder().url(resourceUri.toURL()).put(body2);
        return this.executeFhirRequest(request2, resourceFormat, headers, message, this.retryCount, timeout);
    }

    public <T extends Resource> ResourceRequest<T> issuePostRequest(URI resourceUri, byte[] payload, String resourceFormat, String message, long timeout) throws IOException {
        return this.issuePostRequest(resourceUri, payload, resourceFormat, new Headers.Builder().build(), message, timeout);
    }

    public <T extends Resource> ResourceRequest<T> issuePostRequest(URI resourceUri, byte[] payload, String resourceFormat, Headers headers, String message, long timeout) throws IOException {
        if (payload == null) {
            throw new EFhirClientException("POST requests require a non-null payload");
        }
        this.payload = payload;
        RequestBody body2 = RequestBody.create((MediaType)MediaType.parse((String)(resourceFormat + ";charset=UTF-8")), (byte[])payload);
        Request.Builder request2 = new Request.Builder().url(resourceUri.toURL()).post(body2);
        return this.executeFhirRequest(request2, resourceFormat, headers, message, this.retryCount, timeout);
    }

    public boolean issueDeleteRequest(URI resourceUri) throws IOException {
        Request.Builder request2 = new Request.Builder().url(resourceUri.toURL()).delete();
        return this.executeFhirRequest(request2, null, new Headers.Builder().build(), null, this.retryCount, this.timeout).isSuccessfulRequest();
    }

    public Bundle issueGetFeedRequest(URI resourceUri, String resourceFormat) throws IOException {
        Request.Builder request2 = new Request.Builder().url(resourceUri.toURL());
        return this.executeBundleRequest(request2, resourceFormat, new Headers.Builder().build(), null, this.retryCount, this.timeout);
    }

    public Bundle issuePostFeedRequest(URI resourceUri, Map<String, String> parameters, String resourceName, Resource resource, String resourceFormat) throws IOException {
        String boundary = "----WebKitFormBoundarykbMUo6H8QaUnYtRy";
        byte[] payload = ByteUtils.encodeFormSubmission(parameters, resourceName, resource, boundary);
        RequestBody body2 = RequestBody.create((MediaType)MediaType.parse((String)(resourceFormat + ";charset=UTF-8")), (byte[])payload);
        Request.Builder request2 = new Request.Builder().url(resourceUri.toURL()).post(body2);
        return this.executeBundleRequest(request2, resourceFormat, new Headers.Builder().build(), null, this.retryCount, this.timeout);
    }

    public Bundle postBatchRequest(URI resourceUri, byte[] payload, String resourceFormat, Headers headers, String message, int timeout) throws IOException {
        if (payload == null) {
            throw new EFhirClientException("POST requests require a non-null payload");
        }
        RequestBody body2 = RequestBody.create((MediaType)MediaType.parse((String)(resourceFormat + ";charset=UTF-8")), (byte[])payload);
        Request.Builder request2 = new Request.Builder().url(resourceUri.toURL()).post(body2);
        return this.executeBundleRequest(request2, resourceFormat, headers, message, this.retryCount, timeout);
    }

    public <T extends Resource> Bundle executeBundleRequest(Request.Builder request2, String resourceFormat, Headers headers, String message, int retryCount, long timeout) throws IOException {
        return new FhirRequestBuilder(request2).withLogger(this.fhirLoggingInterceptor).withResourceFormat(resourceFormat).withRetryCount(retryCount).withMessage(message).withHeaders(headers == null ? new Headers.Builder().build() : headers).withTimeout(timeout, TimeUnit.MILLISECONDS).executeAsBatch();
    }

    public <T extends Resource> ResourceRequest<T> executeFhirRequest(Request.Builder request2, String resourceFormat, Headers headers, String message, int retryCount, long timeout) throws IOException {
        return new FhirRequestBuilder(request2).withLogger(this.fhirLoggingInterceptor).withResourceFormat(resourceFormat).withRetryCount(retryCount).withMessage(message).withHeaders(headers == null ? new Headers.Builder().build() : headers).withTimeout(timeout, TimeUnit.MILLISECONDS).execute();
    }
}

