/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import java.io.IOException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.i18n.LanguageFileProducer;

public class ResourceLanguageFileBuilder {
    private LanguageFileProducer file;
    private String source;
    private String target;
    private IWorkerContext context;
    StructureDefinition profile = null;

    public void prepare(LanguageFileProducer file, IWorkerContext context, String source, String target) {
        this.file = file;
        this.source = source;
        this.target = target;
        this.context = context;
    }

    public StructureDefinition getProfile() {
        return this.profile;
    }

    public void setProfile(StructureDefinition profile) {
        this.profile = profile;
    }

    public void build(Resource res) throws IOException {
        String id = res.fhirType();
        String path = res.fhirType() + "-" + res.getIdBase();
        if (!this.source.equals(res.getLanguage())) {
            throw new FHIRException("Language mismatch: '" + this.source + "' => '" + this.target + "' but resource language is '" + res.getLanguage() + "'");
        }
        if (this.profile == null) {
            this.profile = this.context.fetchTypeDefinition(res.fhirType());
            if (this.profile == null) {
                throw new FHIRException("profile");
            }
        }
        this.file.start(path, path, res.getUserString("path"), this.source, this.target);
        for (Property p : res.children()) {
            this.process(p, id, path);
        }
        this.file.finish();
    }

    private void process(Property p, String id, String path) throws IOException {
        if (p.hasValues()) {
            int i2 = 0;
            for (Base b : p.getValues()) {
                String pid = id + "." + p.getName();
                String ppath = path + "." + p.getName() + (String)(p.isList() ? "[" + i2 + "]" : "");
                ++i2;
                if (this.isTranslatable(p, b, pid)) {
                    this.file.makeEntry(ppath, null, null, b.primitiveValue(), this.getTranslation(b, this.target));
                }
                for (Property pp : b.children()) {
                    this.process(pp, pid, ppath);
                }
            }
        }
    }

    private boolean isTranslatable(Property p, Base b, String id) {
        if (new ContextUtilities(this.context).isPrimitiveDatatype(b.fhirType())) {
            org.hl7.fhir.r5.model.Element ed = null;
            for (ElementDefinition t : this.profile.getSnapshot().getElement()) {
                if (!t.getId().equals(id)) continue;
                ed = t;
            }
            if (ed != null && ed.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-translatable")) {
                return true;
            }
        }
        return false;
    }

    private String getTranslation(Base b, String target2) {
        if (b instanceof org.hl7.fhir.r5.model.Element) {
            org.hl7.fhir.r5.model.Element e = (org.hl7.fhir.r5.model.Element)b;
            for (Extension ext : e.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/translation")) {
                String lang = ext.hasExtension("lang") ? ext.getExtensionString("lang") : null;
                if (!this.target.equals(lang)) continue;
                return ext.getExtensionString("content");
            }
        }
        return null;
    }

    public void build(Element res) {
    }
}

