/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.Utilities;

public class GraphQLSchemaGenerator {
    private static final Set<String> JSON_NUMBER_TYPES = new HashSet<String>(){
        {
            this.add("decimal");
            this.add("positiveInt");
            this.add("unsignedInt");
        }
    };
    private final ProfileUtilities profileUtilities;
    private final String version;
    IWorkerContext context;

    public GraphQLSchemaGenerator(IWorkerContext context, String version) {
        this.context = context;
        this.version = version;
        this.profileUtilities = new ProfileUtilities(context, null, null);
    }

    public void generateTypes(OutputStream stream) throws IOException, FHIRException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
        this.generateTypes(writer);
        writer.flush();
        writer.close();
    }

    public void generateTypes(Writer writer) throws IOException {
        EnumSet<FHIROperationType> operations = EnumSet.allOf(FHIROperationType.class);
        this.generateTypes(writer, operations);
    }

    public void generateTypes(Writer writer, EnumSet<FHIROperationType> operations) throws IOException {
        HashMap<String, StructureDefinition> pl = new HashMap<String, StructureDefinition>();
        HashMap<String, StructureDefinition> tl = new HashMap<String, StructureDefinition>();
        HashMap<String, String> existingTypeNames = new HashMap<String, String>();
        for (StructureDefinition sd : new ContextUtilities(this.context).allStructures()) {
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE && sd.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION) {
                pl.put(sd.getName(), sd);
            }
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.COMPLEXTYPE && sd.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION) {
                tl.put(sd.getName(), sd);
            }
            if (sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE || sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT || !sd.getAbstract()) continue;
            tl.put(sd.getName(), sd);
        }
        writer.write("# FHIR GraphQL Schema. Version " + this.version + "\r\n\r\n");
        writer.write("# FHIR Defined Primitive types\r\n");
        for (String n : this.sorted(pl.keySet())) {
            this.generatePrimitive(writer, (StructureDefinition)pl.get(n));
        }
        writer.write("\r\n");
        writer.write("# FHIR Defined Search Parameter Types\r\n");
        for (Iterator<Object> iterator : Enumerations.SearchParamType.values()) {
            if (pl.containsKey(((Enumerations.SearchParamType)((Object)iterator)).toCode()) || iterator == Enumerations.SearchParamType.NULL) continue;
            this.generateSearchParamType(writer, ((Enumerations.SearchParamType)((Object)iterator)).toCode());
        }
        writer.write("\r\n");
        this.generateElementBase(writer, operations);
        for (String n : this.sorted(tl.keySet())) {
            this.generateType(existingTypeNames, writer, (StructureDefinition)tl.get(n), operations);
        }
    }

    public void generateResource(OutputStream stream, StructureDefinition sd, List<SearchParameter> parameters, EnumSet<FHIROperationType> operations) throws IOException, FHIRException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
        this.generateResource(writer, sd, parameters, operations);
        writer.flush();
        writer.close();
    }

    public void generateResource(Writer writer, StructureDefinition sd, List<SearchParameter> parameters, EnumSet<FHIROperationType> operations) throws IOException {
        HashMap<String, String> existingTypeNames = new HashMap<String, String>();
        writer.write("# FHIR GraphQL Schema. Version " + this.version + "\r\n\r\n");
        writer.write("# import * from 'types.graphql'\r\n\r\n");
        this.generateType(existingTypeNames, writer, sd, operations);
        if (operations.contains((Object)FHIROperationType.READ)) {
            this.generateIdAccess(writer, sd.getName());
        }
        if (operations.contains((Object)FHIROperationType.SEARCH)) {
            this.generateListAccess(writer, parameters, sd.getName());
            this.generateConnectionAccess(writer, parameters, sd.getName());
        }
        if (operations.contains((Object)FHIROperationType.CREATE)) {
            this.generateCreate(writer, sd.getName());
        }
        if (operations.contains((Object)FHIROperationType.UPDATE)) {
            this.generateUpdate(writer, sd.getName());
        }
        if (operations.contains((Object)FHIROperationType.DELETE)) {
            this.generateDelete(writer, sd.getName());
        }
    }

    private void generateCreate(Writer writer, String name) throws IOException {
        writer.write("type " + name + "CreateType {\r\n");
        writer.write("  " + name + "Create(");
        this.param(writer, "resource", name + "Input", false, false);
        writer.write("): " + name + "Creation\r\n");
        writer.write("}\r\n");
        writer.write("\r\n");
        writer.write("type " + name + "Creation {\r\n");
        writer.write("  location: String\r\n");
        writer.write("  resource: " + name + "\r\n");
        writer.write("  information: OperationOutcome\r\n");
        writer.write("}\r\n");
        writer.write("\r\n");
    }

    private void generateUpdate(Writer writer, String name) throws IOException {
        writer.write("type " + name + "UpdateType {\r\n");
        writer.write("  " + name + "Update(");
        this.param(writer, "id", "ID", false, false);
        writer.write(", ");
        this.param(writer, "resource", name + "Input", false, false);
        writer.write("): " + name + "Update\r\n");
        writer.write("}\r\n");
        writer.write("\r\n");
        writer.write("type " + name + "Update {\r\n");
        writer.write("  resource: " + name + "\r\n");
        writer.write("  information: OperationOutcome\r\n");
        writer.write("}\r\n");
        writer.write("\r\n");
    }

    private void generateDelete(Writer writer, String name) throws IOException {
        writer.write("type " + name + "DeleteType {\r\n");
        writer.write("  " + name + "Delete(");
        this.param(writer, "id", "ID", false, false);
        writer.write("): " + name + "Delete\r\n");
        writer.write("}\r\n");
        writer.write("\r\n");
        writer.write("type " + name + "Delete {\r\n");
        writer.write("  information: OperationOutcome\r\n");
        writer.write("}\r\n");
        writer.write("\r\n");
    }

    private void generateListAccess(Writer writer, List<SearchParameter> parameters, String name) throws IOException {
        writer.write("type " + name + "ListType {\r\n");
        writer.write("  ");
        this.generateListAccessQuery(writer, parameters, name);
        writer.write("}\r\n");
        writer.write("\r\n");
    }

    public void generateListAccessQuery(Writer writer, List<SearchParameter> parameters, String name) throws IOException {
        writer.write(name + "List(");
        this.param(writer, "_filter", "String", false, false);
        for (SearchParameter sp : parameters) {
            this.param(writer, sp.getName().replace("-", "_"), this.getGqlname(Objects.requireNonNull(sp.getType().toCode())), true, true);
        }
        this.param(writer, "_sort", "String", false, true);
        this.param(writer, "_count", "Int", false, true);
        this.param(writer, "_cursor", "String", false, true);
        writer.write("): [" + name + "]\r\n");
    }

    private void param(Writer writer, String name, String type, boolean list, boolean line) throws IOException {
        if (line) {
            writer.write("\r\n    ");
        }
        writer.write(name);
        writer.write(": ");
        if (list) {
            writer.write("[");
        }
        writer.write(type);
        if (list) {
            writer.write("]");
        }
    }

    private void generateConnectionAccess(Writer writer, List<SearchParameter> parameters, String name) throws IOException {
        writer.write("type " + name + "ConnectionType {\r\n");
        writer.write("  ");
        this.generateConnectionAccessQuery(writer, parameters, name);
        writer.write("}\r\n");
        writer.write("\r\n");
        writer.write("type " + name + "Connection {\r\n");
        writer.write("  count: Int\r\n");
        writer.write("  offset: Int\r\n");
        writer.write("  pagesize: Int\r\n");
        writer.write("  first: ID\r\n");
        writer.write("  previous: ID\r\n");
        writer.write("  next: ID\r\n");
        writer.write("  last: ID\r\n");
        writer.write("  edges: [" + name + "Edge]\r\n");
        writer.write("}\r\n");
        writer.write("\r\n");
        writer.write("type " + name + "Edge {\r\n");
        writer.write("  mode: String\r\n");
        writer.write("  score: Float\r\n");
        writer.write("  resource: " + name + "\r\n");
        writer.write("}\r\n");
        writer.write("\r\n");
    }

    public void generateConnectionAccessQuery(Writer writer, List<SearchParameter> parameters, String name) throws IOException {
        writer.write(name + "Conection(");
        this.param(writer, "_filter", "String", false, false);
        for (SearchParameter sp : parameters) {
            this.param(writer, sp.getName().replace("-", "_"), this.getGqlname(Objects.requireNonNull(sp.getType().toCode())), true, true);
        }
        this.param(writer, "_sort", "String", false, true);
        this.param(writer, "_count", "Int", false, true);
        this.param(writer, "_cursor", "String", false, true);
        writer.write("): " + name + "Connection\r\n");
    }

    private void generateIdAccess(Writer writer, String name) throws IOException {
        writer.write("type " + name + "ReadType {\r\n");
        writer.write("  " + name + "(id: ID!): " + name + "\r\n");
        writer.write("}\r\n");
        writer.write("\r\n");
    }

    private void generateElementBase(Writer writer, EnumSet<FHIROperationType> operations) throws IOException {
        if (operations.contains((Object)FHIROperationType.READ) || operations.contains((Object)FHIROperationType.SEARCH)) {
            writer.write("interface IElement {\r\n");
            writer.write("  id: String\r\n");
            writer.write("  extension: [Extension]\r\n");
            writer.write("}\r\n");
            writer.write("\r\n");
            writer.write("type ElementBase {\r\n");
            writer.write("  id: String\r\n");
            writer.write("  extension: [Extension]\r\n");
            writer.write("}\r\n");
            writer.write("\r\n");
        }
        if (operations.contains((Object)FHIROperationType.CREATE) || operations.contains((Object)FHIROperationType.UPDATE)) {
            writer.write("input ElementBaseInput {\r\n");
            writer.write("  id : ID\r\n");
            writer.write("  extension: [ExtensionInput]\r\n");
            writer.write("}\r\n");
            writer.write("\r\n");
        }
    }

    private void generateType(Map<String, String> existingTypeNames, Writer writer, StructureDefinition sd, EnumSet<FHIROperationType> operations) throws IOException {
        ElementDefinition ed;
        StringBuilder b;
        ArrayList<StringBuilder> list;
        if (operations.contains((Object)FHIROperationType.READ) || operations.contains((Object)FHIROperationType.SEARCH)) {
            list = new ArrayList<StringBuilder>();
            b = new StringBuilder();
            list.add(b);
            b.append("interface ");
            b.append("I" + sd.getName());
            this.generateTypeSuperinterfaceDeclaration(sd, b);
            b.append(" {\r\n");
            ed = sd.getSnapshot().getElementFirstRep();
            this.generateProperties(existingTypeNames, list, b, sd.getName(), sd, ed, "type", "");
            b.append("}");
            b.append("\r\n");
            b.append("\r\n");
            b.append("type ");
            b.append(sd.getName());
            this.generateTypeSuperinterfaceDeclaration(sd, b);
            b.append(" {\r\n");
            this.generateProperties(existingTypeNames, list, b, sd.getName(), sd, ed, "type", "");
            b.append("}");
            b.append("\r\n");
            b.append("\r\n");
            for (StringBuilder bs : list) {
                writer.write(bs.toString());
            }
            list.clear();
        }
        if (operations.contains((Object)FHIROperationType.CREATE) || operations.contains((Object)FHIROperationType.UPDATE)) {
            list = new ArrayList();
            b = new StringBuilder();
            list.add(b);
            b.append("input ");
            b.append(sd.getName());
            b.append("Input {\r\n");
            ed = sd.getSnapshot().getElementFirstRep();
            this.generateProperties(existingTypeNames, list, b, sd.getName(), sd, ed, "input", "Input");
            b.append("}");
            b.append("\r\n");
            b.append("\r\n");
            for (StringBuilder bs : list) {
                writer.write(bs.toString());
            }
        }
    }

    private void generateTypeSuperinterfaceDeclaration(StructureDefinition theParentSd, StringBuilder theBuilder) {
        StructureDefinition baseSd = theParentSd;
        boolean first = true;
        while (baseSd != null && baseSd.getBaseDefinition() != null) {
            if ((baseSd = this.context.fetchResource(StructureDefinition.class, baseSd.getBaseDefinition())) == null) continue;
            if (first) {
                theBuilder.append(" implements ");
                first = false;
            } else {
                theBuilder.append(" & ");
            }
            theBuilder.append("I" + baseSd.getType());
        }
    }

    private void generateProperties(Map<String, String> existingTypeNames, List<StringBuilder> list, StringBuilder b, String typeName, StructureDefinition sd, ElementDefinition ed, String mode, String suffix) throws IOException {
        List<ElementDefinition> children = this.profileUtilities.getChildList(sd, ed);
        for (ElementDefinition child : children) {
            if (child.hasContentReference()) {
                ElementDefinition ref = this.resolveContentReference(sd, child.getContentReference());
                this.generateProperty(existingTypeNames, list, b, typeName, sd, child, ref.getType().get(0), false, ref, mode, suffix);
                continue;
            }
            if (child.getType().size() == 1) {
                this.generateProperty(existingTypeNames, list, b, typeName, sd, child, child.getType().get(0), false, null, mode, suffix);
                continue;
            }
            boolean ref = false;
            for (ElementDefinition.TypeRefComponent t : child.getType()) {
                if (!t.hasTarget()) {
                    this.generateProperty(existingTypeNames, list, b, typeName, sd, child, t, true, null, mode, suffix);
                    continue;
                }
                if (ref) continue;
                ref = true;
                this.generateProperty(existingTypeNames, list, b, typeName, sd, child, t, true, null, mode, suffix);
            }
        }
    }

    private ElementDefinition resolveContentReference(StructureDefinition sd, String contentReference) {
        String id = contentReference.substring(1);
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!id.equals(ed.getId())) continue;
            return ed;
        }
        throw new Error("Unable to find " + id);
    }

    private void generateProperty(Map<String, String> existingTypeNames, List<StringBuilder> list, StringBuilder b, String typeName, StructureDefinition sd, ElementDefinition child, ElementDefinition.TypeRefComponent typeDetails, boolean suffix, ElementDefinition cr, String mode, String suffixS) throws IOException {
        if (this.isPrimitive(typeDetails)) {
            String n = this.getGqlname(typeDetails.getWorkingCode());
            b.append("  ");
            b.append(this.tail(child.getPath(), suffix));
            if (suffix) {
                b.append(Utilities.capitalize(typeDetails.getWorkingCode()));
            }
            b.append(": ");
            if (!child.getMax().equals("1")) {
                b.append("[");
                b.append(n);
                b.append("]");
            } else {
                b.append(n);
            }
            if (!child.getPath().endsWith(".id")) {
                b.append("  _");
                b.append(this.tail(child.getPath(), suffix));
                if (suffix) {
                    b.append(Utilities.capitalize(typeDetails.getWorkingCode()));
                }
                if (!child.getMax().equals("1")) {
                    b.append(": [ElementBase");
                    b.append(suffixS);
                    b.append("]\r\n");
                } else {
                    b.append(": ElementBase");
                    b.append(suffixS);
                    b.append("\r\n");
                }
            } else {
                b.append("\r\n");
            }
        } else {
            b.append("  ");
            b.append(this.tail(child.getPath(), suffix));
            if (suffix) {
                b.append(Utilities.capitalize(typeDetails.getWorkingCode()));
            }
            b.append(": ");
            if (!child.getMax().equals("1")) {
                b.append("[");
            }
            String type = typeDetails.getWorkingCode();
            if (cr != null) {
                b.append(this.generateInnerType(existingTypeNames, list, sd, typeName, cr, mode, suffixS));
            } else if (Utilities.existsInList(type, "Element", "BackboneElement")) {
                b.append(this.generateInnerType(existingTypeNames, list, sd, typeName, child, mode, suffixS));
            } else {
                b.append(type).append(suffixS);
            }
            if (!child.getMax().equals("1")) {
                b.append("]");
            }
            if (child.getMin() != 0 && !suffix) {
                b.append("!");
            }
            b.append("\r\n");
        }
    }

    private String generateInnerType(Map<String, String> existingTypeNames, List<StringBuilder> list, StructureDefinition sd, String name, ElementDefinition child, String mode, String suffix) throws IOException {
        String key = child.getName() + "." + mode;
        if (existingTypeNames.containsKey(key)) {
            return existingTypeNames.get(key);
        }
        String typeName = name + Utilities.capitalize(this.tail(child.getPath(), false)) + suffix;
        existingTypeNames.put(key, typeName + suffix);
        StringBuilder b = new StringBuilder();
        list.add(b);
        b.append(mode);
        b.append(" ");
        b.append(typeName);
        b.append(suffix);
        b.append(" {\r\n");
        this.generateProperties(existingTypeNames, list, b, typeName, sd, child, mode, suffix);
        b.append("}");
        b.append("\r\n");
        b.append("\r\n");
        return typeName + suffix;
    }

    private String tail(String path, boolean suffix) {
        int i2;
        if (suffix) {
            path = path.substring(0, path.length() - 3);
        }
        return (i2 = path.lastIndexOf(".")) < 0 ? path : path.substring(i2 + 1);
    }

    private boolean isPrimitive(ElementDefinition.TypeRefComponent type) {
        String typeName = type.getWorkingCode();
        StructureDefinition sd = this.context.fetchTypeDefinition(typeName);
        if (sd == null) {
            return false;
        }
        return sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
    }

    private List<String> sorted(Set<String> keys) {
        ArrayList<String> sl = new ArrayList<String>(keys);
        Collections.sort(sl);
        return sl;
    }

    private void generatePrimitive(Writer writer, StructureDefinition sd) throws IOException, FHIRException {
        String gqlName = this.getGqlname(sd.getName());
        if (gqlName.equals(sd.getName())) {
            writer.write("scalar ");
            writer.write(sd.getName());
            writer.write(" # JSON Format: ");
            writer.write(this.getJsonFormat(sd));
        } else {
            writer.write("# Type ");
            writer.write(sd.getName());
            writer.write(": use GraphQL Scalar type ");
            writer.write(gqlName);
        }
        writer.write("\r\n");
    }

    private void generateSearchParamType(Writer writer, String name) throws IOException, FHIRException {
        String gqlName = this.getGqlname(name);
        if (gqlName.equals("date")) {
            writer.write("# Search Param ");
            writer.write(name);
            writer.write(": already defined as Primitive with JSON Format: string ");
        } else if (gqlName.equals(name)) {
            writer.write("scalar ");
            writer.write(name);
            writer.write(" # JSON Format: string");
        } else {
            writer.write("# Search Param ");
            writer.write(name);
            writer.write(": use GraphQL Scalar type ");
            writer.write(gqlName);
        }
        writer.write("\r\n");
    }

    private String getJsonFormat(StructureDefinition sd) throws FHIRException {
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (ed.getType().isEmpty() || !ed.getType().get(0).getCodeElement().hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-json-type")) continue;
            return ed.getType().get(0).getCodeElement().getExtensionString(" http://hl7.org/fhir/StructureDefinition/structuredefinition-json-type");
        }
        if (JSON_NUMBER_TYPES.contains(sd.getName())) {
            return "number";
        }
        return "string";
    }

    private String getGqlname(String name) {
        if (name.equals("string")) {
            return "String";
        }
        if (name.equals("integer")) {
            return "Int";
        }
        if (name.equals("boolean")) {
            return "Boolean";
        }
        if (name.equals("id")) {
            return "ID";
        }
        return name;
    }

    public static enum FHIROperationType {
        READ,
        SEARCH,
        CREATE,
        UPDATE,
        DELETE;

    }
}

