/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.test.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.hl7.fhir.utilities.CSFile;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.ToolGlobalSettings;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.tests.BaseTestingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CompareUtilities
extends BaseTestingUtilities {
    private static final boolean SHOW_DIFF = true;

    public static String createNotEqualMessage(String message, String expected, String actual) {
        return message + '\n' + "Expected :" + expected + '\n' + "Actual  :" + actual;
    }

    public static String checkXMLIsSame(InputStream expected, InputStream actual) throws Exception {
        String result = CompareUtilities.compareXml(expected, actual);
        return result;
    }

    public static String checkXMLIsSame(String expected, String actual) throws Exception {
        String result = CompareUtilities.compareXml(expected, actual);
        if (result != null) {
            String diff;
            String string = diff = ToolGlobalSettings.hasComparePath() ? ToolGlobalSettings.getComparePath() : Utilities.path(System.getenv("ProgramFiles"), "WinMerge", "WinMergeU.exe");
            if (new File(diff).exists() || Utilities.isToken(diff)) {
                Runtime.getRuntime().exec(new String[]{diff, expected, actual});
            }
        }
        return result;
    }

    private static String compareXml(InputStream expected, InputStream actual) throws Exception {
        return CompareUtilities.compareElements("", CompareUtilities.loadXml(expected).getDocumentElement(), CompareUtilities.loadXml(actual).getDocumentElement());
    }

    private static String compareXml(String expected, String actual) throws Exception {
        return CompareUtilities.compareElements("", CompareUtilities.loadXml(expected).getDocumentElement(), CompareUtilities.loadXml(actual).getDocumentElement());
    }

    private static String compareElements(String path, Element expectedElement, Element actualElement) {
        if (!CompareUtilities.namespacesMatch(expectedElement.getNamespaceURI(), actualElement.getNamespaceURI())) {
            return CompareUtilities.createNotEqualMessage("Namespaces differ at " + (String)path, expectedElement.getNamespaceURI(), actualElement.getNamespaceURI());
        }
        if (!expectedElement.getLocalName().equals(actualElement.getLocalName())) {
            return CompareUtilities.createNotEqualMessage("Names differ at " + (String)path, expectedElement.getLocalName(), actualElement.getLocalName());
        }
        String s2 = CompareUtilities.compareAttributes((String)(path = (String)path + "/" + expectedElement.getLocalName()), expectedElement.getAttributes(), actualElement.getAttributes());
        if (!Utilities.noString(s2)) {
            return s2;
        }
        s2 = CompareUtilities.compareAttributes((String)path, expectedElement.getAttributes(), actualElement.getAttributes());
        if (!Utilities.noString(s2)) {
            return s2;
        }
        Node expectedChild = expectedElement.getFirstChild();
        Node actualChild = actualElement.getFirstChild();
        expectedChild = CompareUtilities.skipBlankText(expectedChild);
        actualChild = CompareUtilities.skipBlankText(actualChild);
        while (expectedChild != null && actualChild != null) {
            if (expectedChild.getNodeType() != actualChild.getNodeType()) {
                return CompareUtilities.createNotEqualMessage("node type mismatch in children of " + (String)path, Short.toString(expectedElement.getNodeType()), Short.toString(actualElement.getNodeType()));
            }
            if (expectedChild.getNodeType() == 3) {
                if (!CompareUtilities.normalise(expectedChild.getTextContent()).equals(CompareUtilities.normalise(actualChild.getTextContent()))) {
                    return CompareUtilities.createNotEqualMessage("Text differs at " + (String)path, CompareUtilities.normalise(expectedChild.getTextContent()).toString(), CompareUtilities.normalise(actualChild.getTextContent()).toString());
                }
            } else if (expectedChild.getNodeType() == 1 && !Utilities.noString(s2 = CompareUtilities.compareElements((String)path, (Element)expectedChild, (Element)actualChild))) {
                return s2;
            }
            expectedChild = CompareUtilities.skipBlankText(expectedChild.getNextSibling());
            actualChild = CompareUtilities.skipBlankText(actualChild.getNextSibling());
        }
        if (expectedChild != null) {
            return "node mismatch - more nodes in actual in children of " + (String)path;
        }
        if (actualChild != null) {
            return "node mismatch - more nodes in expected in children of " + (String)path;
        }
        return null;
    }

    private static boolean namespacesMatch(String ns1, String ns2) {
        return ns1 == null ? ns2 == null : ns1.equals(ns2);
    }

    private static Object normalise(String text) {
        String result = text.trim().replace('\r', ' ').replace('\n', ' ').replace('\t', ' ');
        while (result.contains("  ")) {
            result = result.replace("  ", " ");
        }
        return result;
    }

    private static String compareAttributes(String path, NamedNodeMap expected, NamedNodeMap actual) {
        for (int i2 = 0; i2 < expected.getLength(); ++i2) {
            byte[] b2;
            byte[] b1;
            Node expectedNode = expected.item(i2);
            String expectedNodeName = expectedNode.getNodeName();
            if (expectedNodeName.equals("xmlns") || expectedNodeName.startsWith("xmlns:")) continue;
            Node actualNode = actual.getNamedItem(expectedNodeName);
            if (actualNode == null) {
                return "Attributes differ at " + path + ": missing attribute " + expectedNodeName;
            }
            if (CompareUtilities.normalise(expectedNode.getTextContent()).equals(CompareUtilities.normalise(actualNode.getTextContent())) || CompareUtilities.sameBytes(b1 = CompareUtilities.unBase64(expectedNode.getTextContent()), b2 = CompareUtilities.unBase64(actualNode.getTextContent()))) continue;
            return CompareUtilities.createNotEqualMessage("Attributes differ at " + path, CompareUtilities.normalise(expectedNode.getTextContent()).toString(), CompareUtilities.normalise(actualNode.getTextContent()).toString());
        }
        return null;
    }

    private static boolean sameBytes(byte[] b1, byte[] b2) {
        if (b1.length == 0 || b2.length == 0) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i2 = 0; i2 < b1.length; ++i2) {
            if (b1[i2] == b2[i2]) continue;
            return false;
        }
        return true;
    }

    private static byte[] unBase64(String text) {
        return Base64.decodeBase64(text);
    }

    private static Node skipBlankText(Node node) {
        while (node != null && (node.getNodeType() == 3 && Utilities.isWhitespace(node.getTextContent()) || node.getNodeType() == 8)) {
            node = node.getNextSibling();
        }
        return node;
    }

    private static Document loadXml(String fn) throws Exception {
        return CompareUtilities.loadXml(new FileInputStream(fn));
    }

    private static Document loadXml(InputStream fn) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(fn);
    }

    public static String checkJsonSrcIsSame(String expected, String actual) throws JsonSyntaxException, FileNotFoundException, IOException {
        return CompareUtilities.checkJsonSrcIsSame(expected, actual, true);
    }

    public static String checkJsonSrcIsSame(String expectedString, String actualString, boolean showDiff) throws JsonSyntaxException, FileNotFoundException, IOException {
        String result = CompareUtilities.compareJsonSrc(expectedString, actualString);
        if (result != null && showDiff) {
            String diff = null;
            if (System.getProperty("os.name").contains("Linux")) {
                diff = Utilities.path("/", "usr", "bin", "meld");
            } else if (Utilities.checkFile("WinMerge", Utilities.path(System.getenv("ProgramFiles(X86)"), "WinMerge"), "\\WinMergeU.exe", null)) {
                diff = Utilities.path(System.getenv("ProgramFiles(X86)"), "WinMerge", "WinMergeU.exe");
            } else if (Utilities.checkFile("WinMerge", Utilities.path(System.getenv("ProgramFiles(X86)"), "Meld"), "\\Meld.exe", null)) {
                diff = Utilities.path(System.getenv("ProgramFiles(X86)"), "Meld", "Meld.exe");
            }
            if (diff == null || diff.isEmpty()) {
                return result;
            }
            ArrayList<String> command = new ArrayList<String>();
            String expected = Utilities.path("[tmp]", "expected" + expectedString.hashCode() + ".json");
            String actual = Utilities.path("[tmp]", "actual" + actualString.hashCode() + ".json");
            TextFile.stringToFile(expectedString, expected);
            TextFile.stringToFile(actualString, actual);
            command.add(diff);
            if (diff.toLowerCase().contains("meld")) {
                command.add("--newtab");
            }
            command.add(expected);
            command.add(actual);
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory(new CSFile(Utilities.path("[tmp]")));
            builder.start();
        }
        return result;
    }

    public static String checkJsonIsSame(String expected, String actual) throws JsonSyntaxException, FileNotFoundException, IOException {
        String result = CompareUtilities.compareJson(expected, actual);
        if (result != null) {
            String diff = Utilities.path(System.getenv("ProgramFiles(X86)"), "WinMerge", "WinMergeU.exe");
            ArrayList<String> command = new ArrayList<String>();
            command.add("\"" + diff + "\" \"" + expected + "\" \"" + actual + "\"");
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory(new CSFile(Utilities.path("[tmp]")));
            builder.start();
        }
        return result;
    }

    private static String compareJsonSrc(String expected, String actual) throws JsonSyntaxException, FileNotFoundException, IOException {
        JsonObject actualJsonObject = (JsonObject)new JsonParser().parse(actual);
        JsonObject expectedJsonObject = (JsonObject)new JsonParser().parse(expected);
        return CompareUtilities.compareObjects("", expectedJsonObject, actualJsonObject);
    }

    private static String compareJson(String expected, String actual) throws JsonSyntaxException, FileNotFoundException, IOException {
        JsonObject actualJsonObject = (JsonObject)new JsonParser().parse(TextFile.fileToString(actual));
        JsonObject expectedJsonObject = (JsonObject)new JsonParser().parse(TextFile.fileToString(expected));
        return CompareUtilities.compareObjects("", expectedJsonObject, actualJsonObject);
    }

    private static String compareObjects(String path, JsonObject expectedJsonObject, JsonObject actualJsonObject) {
        String n;
        for (Map.Entry en : actualJsonObject.entrySet()) {
            n = (String)en.getKey();
            if (n.equals("fhir_comments")) continue;
            if (expectedJsonObject.has(n)) {
                String s2 = CompareUtilities.compareNodes(path + "." + n, expectedJsonObject.get(n), (JsonElement)en.getValue());
                if (Utilities.noString(s2)) continue;
                return s2;
            }
            return "properties differ at " + path + ": missing property " + n;
        }
        for (Map.Entry en : expectedJsonObject.entrySet()) {
            n = (String)en.getKey();
            if (n.equals("fhir_comments") || actualJsonObject.has(n)) continue;
            return "properties differ at " + path + ": missing property " + n;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String compareNodes(String path, JsonElement expectedJsonElement, JsonElement actualJsonElement) {
        if (actualJsonElement.getClass() != expectedJsonElement.getClass()) {
            return CompareUtilities.createNotEqualMessage("properties differ at " + path, expectedJsonElement.getClass().getName(), actualJsonElement.getClass().getName());
        }
        if (actualJsonElement instanceof JsonPrimitive) {
            JsonPrimitive actualJsonPrimitive = (JsonPrimitive)actualJsonElement;
            JsonPrimitive expectedJsonPrimitive = (JsonPrimitive)expectedJsonElement;
            if (actualJsonPrimitive.isBoolean() && expectedJsonPrimitive.isBoolean()) {
                if (actualJsonPrimitive.getAsBoolean() == expectedJsonPrimitive.getAsBoolean()) return null;
                return CompareUtilities.createNotEqualMessage("boolean property values differ at " + path, expectedJsonPrimitive.getAsString(), actualJsonPrimitive.getAsString());
            }
            if (actualJsonPrimitive.isString() && expectedJsonPrimitive.isString()) {
                String actualJsonString = actualJsonPrimitive.getAsString();
                String expectedJsonString = expectedJsonPrimitive.getAsString();
                if (actualJsonString.contains("<div") && expectedJsonString.contains("<div") || actualJsonString.equals(expectedJsonString) || CompareUtilities.sameBytes(CompareUtilities.unBase64(actualJsonString), CompareUtilities.unBase64(expectedJsonString))) return null;
                return CompareUtilities.createNotEqualMessage("string property values differ at " + path, expectedJsonString, actualJsonString);
            }
            if (!actualJsonPrimitive.isNumber() || !expectedJsonPrimitive.isNumber()) return CompareUtilities.createNotEqualMessage("property types differ at " + path, expectedJsonPrimitive.getAsString(), actualJsonPrimitive.getAsString());
            if (actualJsonPrimitive.getAsString().equals(expectedJsonPrimitive.getAsString())) return null;
            return CompareUtilities.createNotEqualMessage("number property values differ at " + path, expectedJsonPrimitive.getAsString(), actualJsonPrimitive.getAsString());
        }
        if (actualJsonElement instanceof JsonObject) {
            String s2 = CompareUtilities.compareObjects(path, (JsonObject)expectedJsonElement, (JsonObject)actualJsonElement);
            if (Utilities.noString(s2)) return null;
            return s2;
        }
        if (actualJsonElement instanceof JsonArray) {
            JsonArray actualArray = (JsonArray)actualJsonElement;
            JsonArray expectedArray = (JsonArray)expectedJsonElement;
            if (actualArray.size() != expectedArray.size()) {
                return CompareUtilities.createNotEqualMessage("array properties count differs at " + path, Integer.toString(expectedArray.size()), Integer.toString(actualArray.size()));
            }
            for (int i2 = 0; i2 < actualArray.size(); ++i2) {
                String s3 = CompareUtilities.compareNodes(path + "[" + Integer.toString(i2) + "]", expectedArray.get(i2), actualArray.get(i2));
                if (Utilities.noString(s3)) continue;
                return s3;
            }
            return null;
        } else {
            if (actualJsonElement instanceof JsonNull) return null;
            return "unhandled property " + actualJsonElement.getClass().getName();
        }
    }

    public static String checkTextIsSame(String expected, String actual) throws JsonSyntaxException, FileNotFoundException, IOException {
        return CompareUtilities.checkTextIsSame(expected, actual, true);
    }

    public static String checkTextIsSame(String expectedString, String actualString, boolean showDiff) throws JsonSyntaxException, FileNotFoundException, IOException {
        String result = CompareUtilities.compareText(expectedString, actualString);
        if (result != null && showDiff) {
            String diff = null;
            if (System.getProperty("os.name").contains("Linux")) {
                diff = Utilities.path("/", "usr", "bin", "meld");
            } else if (Utilities.checkFile("WinMerge", Utilities.path(System.getenv("ProgramFiles(X86)"), "WinMerge"), "\\WinMergeU.exe", null)) {
                diff = Utilities.path(System.getenv("ProgramFiles(X86)"), "WinMerge", "WinMergeU.exe");
            } else if (Utilities.checkFile("WinMerge", Utilities.path(System.getenv("ProgramFiles(X86)"), "Meld"), "\\Meld.exe", null)) {
                diff = Utilities.path(System.getenv("ProgramFiles(X86)"), "Meld", "Meld.exe");
            }
            if (diff == null || diff.isEmpty()) {
                return result;
            }
            ArrayList<String> command = new ArrayList<String>();
            String actual = Utilities.path("[tmp]", "actual" + actualString.hashCode() + ".json");
            String expected = Utilities.path("[tmp]", "expected" + expectedString.hashCode() + ".json");
            TextFile.stringToFile(expectedString, expected);
            TextFile.stringToFile(actualString, actual);
            command.add(diff);
            if (diff.toLowerCase().contains("meld")) {
                command.add("--newtab");
            }
            command.add(expected);
            command.add(actual);
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory(new CSFile(Utilities.path("[tmp]")));
            builder.start();
        }
        return result;
    }

    private static String compareText(String expectedString, String actualString) {
        for (int i2 = 0; i2 < Integer.min(expectedString.length(), actualString.length()); ++i2) {
            if (expectedString.charAt(i2) == actualString.charAt(i2)) continue;
            return CompareUtilities.createNotEqualMessage("Strings differ at character " + Integer.toString(i2), String.valueOf(expectedString.charAt(i2)), String.valueOf(actualString.charAt(i2)));
        }
        if (expectedString.length() != actualString.length()) {
            return CompareUtilities.createNotEqualMessage("Strings differ in length but match to the end of the shortest.", Integer.toString(expectedString.length()), Integer.toString(actualString.length()));
        }
        return null;
    }
}

