/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.NoTerminologyServiceException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Factory;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.terminologies.ValueSetUtilities;
import org.hl7.fhir.r5.terminologies.ValueSetWorker;
import org.hl7.fhir.utilities.Utilities;

public class ValueSetExpanderSimple
extends ValueSetWorker
implements ValueSetExpander {
    private List<ValueSet.ValueSetExpansionContainsComponent> codes = new ArrayList<ValueSet.ValueSetExpansionContainsComponent>();
    private List<ValueSet.ValueSetExpansionContainsComponent> roots = new ArrayList<ValueSet.ValueSetExpansionContainsComponent>();
    private Map<String, ValueSet.ValueSetExpansionContainsComponent> map = new HashMap<String, ValueSet.ValueSetExpansionContainsComponent>();
    private IWorkerContext context;
    private boolean canBeHeirarchy = true;
    private boolean includeAbstract = true;
    private Set<String> excludeKeys = new HashSet<String>();
    private Set<String> excludeSystems = new HashSet<String>();
    private ValueSet focus;
    private int maxExpansionSize = 500;
    private List<String> allErrors = new ArrayList<String>();
    private int total;
    private boolean checkCodesWhenExpanding;

    public ValueSetExpanderSimple(IWorkerContext context) {
        this.context = context;
    }

    public ValueSetExpanderSimple(IWorkerContext context, List<String> allErrors) {
        this.context = context;
        this.allErrors = allErrors;
    }

    public void setMaxExpansionSize(int theMaxExpansionSize) {
        this.maxExpansionSize = theMaxExpansionSize;
    }

    private ValueSet.ValueSetExpansionContainsComponent addCode(String system, String code, String display, ValueSet.ValueSetExpansionContainsComponent parent, List<CodeSystem.ConceptDefinitionDesignationComponent> designations, Parameters expParams, boolean isAbstract, boolean inactive, List<ValueSet> filters, boolean noInactive, boolean deprecated, List<ValueSet.ValueSetExpansionPropertyComponent> vsProp) {
        CodeSystem.ConceptDefinitionDesignationComponent t;
        if (filters != null && !filters.isEmpty() && !this.filterContainsCode(filters, system, code)) {
            return null;
        }
        if (noInactive && inactive) {
            return null;
        }
        ValueSet.ValueSetExpansionContainsComponent n = new ValueSet.ValueSetExpansionContainsComponent();
        n.setSystem(system);
        n.setCode(code);
        if (isAbstract) {
            n.setAbstract(true);
        }
        if (inactive) {
            n.setInactive(true);
        }
        if (deprecated) {
            ValueSetUtilities.setDeprecated(vsProp, n);
        }
        if (expParams.getParameterBool("includeDesignations") && designations != null) {
            for (CodeSystem.ConceptDefinitionDesignationComponent t2 : designations) {
                if (t2.getLanguage() == null && t2.getValue() == null) continue;
                ValueSet.ConceptReferenceDesignationComponent d = n.addDesignation();
                if (t2.getLanguage() != null) {
                    d.setLanguage(t2.getLanguage().trim());
                }
                if (t2.getValue() == null) continue;
                d.setValue(t2.getValue().trim());
            }
        }
        CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent = t = expParams.hasLanguage() ? this.getMatchingLang(designations, expParams.getLanguage()) : null;
        if (t == null) {
            n.setDisplay(display);
        } else {
            n.setDisplay(t.getValue());
        }
        String s2 = this.key(n);
        if (this.map.containsKey(s2) || this.excludeKeys.contains(s2)) {
            this.canBeHeirarchy = false;
        } else {
            this.codes.add(n);
            this.map.put(s2, n);
            ++this.total;
        }
        if (this.canBeHeirarchy && parent != null) {
            parent.getContains().add(n);
        } else {
            this.roots.add(n);
        }
        return n;
    }

    private boolean filterContainsCode(List<ValueSet> filters, String system, String code) {
        for (ValueSet vse : filters) {
            if (!this.expansionContainsCode(vse.getExpansion().getContains(), system, code)) continue;
            return true;
        }
        return false;
    }

    private boolean expansionContainsCode(List<ValueSet.ValueSetExpansionContainsComponent> contains, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent cc : contains) {
            if (system.equals(cc.getSystem()) && code.equals(cc.getCode())) {
                return true;
            }
            if (!this.expansionContainsCode(cc.getContains(), system, code)) continue;
            return true;
        }
        return false;
    }

    private CodeSystem.ConceptDefinitionDesignationComponent getMatchingLang(List<CodeSystem.ConceptDefinitionDesignationComponent> list, String lang) {
        for (CodeSystem.ConceptDefinitionDesignationComponent t : list) {
            if (!t.getLanguage().equals(lang)) continue;
            return t;
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent t : list) {
            if (!t.getLanguage().startsWith(lang)) continue;
            return t;
        }
        return null;
    }

    private void addCodeAndDescendents(ValueSet.ValueSetExpansionContainsComponent focus, ValueSet.ValueSetExpansionContainsComponent parent, Parameters expParams, List<ValueSet> filters, boolean noInactive, List<ValueSet.ValueSetExpansionPropertyComponent> vsProps) throws FHIRException {
        focus.checkNoModifiers("Expansion.contains", "expanding");
        ValueSet.ValueSetExpansionContainsComponent np = this.addCode(focus.getSystem(), focus.getCode(), focus.getDisplay(), parent, this.convert(focus.getDesignation()), expParams, focus.getAbstract(), focus.getInactive(), filters, noInactive, false, vsProps);
        for (ValueSet.ValueSetExpansionContainsComponent c : focus.getContains()) {
            this.addCodeAndDescendents(focus, np, expParams, filters, noInactive, vsProps);
        }
    }

    private List<CodeSystem.ConceptDefinitionDesignationComponent> convert(List<ValueSet.ConceptReferenceDesignationComponent> designations) {
        ArrayList<CodeSystem.ConceptDefinitionDesignationComponent> list = new ArrayList<CodeSystem.ConceptDefinitionDesignationComponent>();
        for (ValueSet.ConceptReferenceDesignationComponent d : designations) {
            CodeSystem.ConceptDefinitionDesignationComponent n = new CodeSystem.ConceptDefinitionDesignationComponent();
            n.setLanguage(d.getLanguage());
            n.setUse(d.getUse());
            n.setValue(d.getValue());
            list.add(n);
        }
        return list;
    }

    private void addCodeAndDescendents(CodeSystem cs, String system, CodeSystem.ConceptDefinitionComponent def, ValueSet.ValueSetExpansionContainsComponent parent, Parameters expParams, List<ValueSet> filters, CodeSystem.ConceptDefinitionComponent exclusion, IConceptFilter filterFunc, boolean noInactive, List<ValueSet.ValueSetExpansionPropertyComponent> vsProps) throws FHIRException {
        def.checkNoModifiers("Code in Code System", "expanding");
        if (exclusion != null && exclusion.getCode().equals(def.getCode())) {
            return;
        }
        ValueSet.ValueSetExpansionContainsComponent np = null;
        boolean abs = CodeSystemUtilities.isNotSelectable(cs, def);
        boolean inc = CodeSystemUtilities.isInactive(cs, def);
        boolean dep = CodeSystemUtilities.isDeprecated(cs, def, false);
        if ((this.includeAbstract || !abs) && filterFunc.includeConcept(cs, def)) {
            np = this.addCode(system, def.getCode(), def.getDisplay(), parent, def.getDesignation(), expParams, abs, inc, filters, noInactive, dep, vsProps);
        }
        for (CodeSystem.ConceptDefinitionComponent c : def.getConcept()) {
            this.addCodeAndDescendents(cs, system, c, np, expParams, filters, exclusion, filterFunc, noInactive, vsProps);
        }
        if (def.hasUserData("cs.utils.cross.link")) {
            List children = (List)def.getUserData("cs.utils.cross.link");
            for (CodeSystem.ConceptDefinitionComponent c : children) {
                this.addCodeAndDescendents(cs, system, c, np, expParams, filters, exclusion, filterFunc, noInactive, vsProps);
            }
        }
    }

    private void addCodes(ValueSet.ValueSetExpansionComponent expand, List<ValueSet.ValueSetExpansionParameterComponent> params, Parameters expParams, List<ValueSet> filters, boolean noInactive, List<ValueSet.ValueSetExpansionPropertyComponent> vsProps) throws ValueSetExpander.ETooCostly, FHIRException {
        if (expand != null) {
            if (expand.getContains().size() > this.maxExpansionSize) {
                throw this.failCostly("Too many codes to display (>" + Integer.toString(expand.getContains().size()) + ")");
            }
            for (ValueSet.ValueSetExpansionParameterComponent p : expand.getParameter()) {
                if (this.existsInParams(params, p.getName(), p.getValue())) continue;
                params.add(p);
            }
            this.copyImportContains(expand.getContains(), null, expParams, filters, noInactive, vsProps);
        }
    }

    private void excludeCode(String theSystem, String theCode) {
        ValueSet.ValueSetExpansionContainsComponent n = new ValueSet.ValueSetExpansionContainsComponent();
        n.setSystem(theSystem);
        n.setCode(theCode);
        String s2 = this.key(n);
        this.excludeKeys.add(s2);
    }

    private void excludeCodes(ValueSet.ConceptSetComponent exc, List<ValueSet.ValueSetExpansionParameterComponent> params, String ctxt) throws FHIRException {
        exc.checkNoModifiers("Compose.exclude", "expanding");
        if (exc.hasSystem() && exc.getConcept().size() == 0 && exc.getFilter().size() == 0) {
            this.excludeSystems.add(exc.getSystem());
        }
        if (exc.hasValueSet()) {
            throw this.fail("Processing Value set references in exclude is not yet done in " + ctxt);
        }
        CodeSystem cs = this.context.fetchCodeSystem(exc.getSystem());
        if ((cs == null || cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE) && this.context.supportsSystem(exc.getSystem())) {
            ValueSetExpander.ValueSetExpansionOutcome vse = this.context.expandVS(exc, false, false);
            ValueSet valueset = vse.getValueset();
            if (valueset == null) {
                throw this.failTSE("Error Expanding ValueSet: " + vse.getError());
            }
            this.excludeCodes(valueset.getExpansion(), params);
            return;
        }
        for (ValueSet.ConceptReferenceComponent c : exc.getConcept()) {
            this.excludeCode(exc.getSystem(), c.getCode());
        }
        if (exc.getFilter().size() > 0) {
            throw this.fail("not done yet - multiple filters");
        }
    }

    private void excludeCodes(ValueSet.ValueSetExpansionComponent expand, List<ValueSet.ValueSetExpansionParameterComponent> params) {
        for (ValueSet.ValueSetExpansionContainsComponent c : expand.getContains()) {
            this.excludeCode(c.getSystem(), c.getCode());
        }
    }

    private boolean existsInParams(List<ValueSet.ValueSetExpansionParameterComponent> params, String name, DataType value) {
        for (ValueSet.ValueSetExpansionParameterComponent p : params) {
            if (!p.getName().equals(name) || !PrimitiveType.compareDeep(p.getValue(), value, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expand(ValueSet source, Parameters expParams) {
        this.allErrors.clear();
        try {
            return this.expandInternal(source, expParams);
        }
        catch (NoTerminologyServiceException e) {
            return new ValueSetExpander.ValueSetExpansionOutcome(e.getMessage(), ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE, this.allErrors);
        }
        catch (Exception e) {
            return new ValueSetExpander.ValueSetExpansionOutcome(e.getMessage(), ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN, this.allErrors);
        }
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandInternal(ValueSet source, Parameters expParams) throws FHIRException, FileNotFoundException, ValueSetExpander.ETooCostly, IOException {
        return this.doExpand(source, expParams);
    }

    public ValueSetExpander.ValueSetExpansionOutcome doExpand(ValueSet source, Parameters expParams) throws FHIRException, ValueSetExpander.ETooCostly, FileNotFoundException, IOException {
        if (expParams == null) {
            expParams = this.makeDefaultExpansion();
        }
        source.checkNoModifiers("ValueSet", "expanding");
        this.focus = source.copy();
        this.focus.setExpansion(new ValueSet.ValueSetExpansionComponent());
        this.focus.getExpansion().setTimestampElement(DateTimeType.now());
        this.focus.getExpansion().setIdentifier(Factory.createUUID());
        for (Parameters.ParametersParameterComponent p : expParams.getParameter()) {
            if (!Utilities.existsInList(p.getName(), "includeDesignations", "excludeNested", "activeOnly")) continue;
            this.focus.getExpansion().addParameter().setName(p.getName()).setValue(p.getValue());
        }
        if (source.hasCompose()) {
            this.handleCompose(source.getCompose(), this.focus.getExpansion(), expParams, source.getUrl(), this.focus.getExpansion().getExtension(), source);
        }
        if (this.canBeHeirarchy) {
            for (ValueSet.ValueSetExpansionContainsComponent c : this.roots) {
                this.focus.getExpansion().getContains().add(c);
            }
        } else {
            for (ValueSet.ValueSetExpansionContainsComponent c : this.codes) {
                if (!this.map.containsKey(this.key(c)) || !this.includeAbstract && c.getAbstract()) continue;
                this.focus.getExpansion().getContains().add(c);
                c.getContains().clear();
            }
        }
        if (this.total > 0) {
            this.focus.getExpansion().setTotal(this.total);
        }
        return new ValueSetExpander.ValueSetExpansionOutcome(this.focus);
    }

    private Parameters makeDefaultExpansion() {
        Parameters res = new Parameters();
        res.addParameter("excludeNested", true);
        res.addParameter("includeDesignations", false);
        return res;
    }

    private CodeSystem.ConceptDefinitionComponent getConceptForCode(List<CodeSystem.ConceptDefinitionComponent> clist, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : clist) {
            if (code.equals(c.getCode())) {
                return c;
            }
            CodeSystem.ConceptDefinitionComponent v = this.getConceptForCode(c.getConcept(), code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private void handleCompose(ValueSet.ValueSetComposeComponent compose, ValueSet.ValueSetExpansionComponent exp, Parameters expParams, String ctxt, List<Extension> extensions, ValueSet valueSet) throws ValueSetExpander.ETooCostly, FileNotFoundException, IOException, FHIRException {
        compose.checkNoModifiers("ValueSet.compose", "expanding");
        for (ValueSet.ConceptSetComponent inc : compose.getExclude()) {
            this.excludeCodes(inc, exp.getParameter(), ctxt);
        }
        this.canBeHeirarchy = !expParams.getParameterBool("excludeNested") && this.excludeKeys.isEmpty() && this.excludeSystems.isEmpty();
        this.includeAbstract = !expParams.getParameterBool("excludeNotForUI");
        boolean first = true;
        for (ValueSet.ConceptSetComponent inc : compose.getInclude()) {
            if (first) {
                first = false;
            } else {
                this.canBeHeirarchy = false;
            }
            this.includeCodes(inc, exp, expParams, this.canBeHeirarchy, compose.hasInactive() ? !compose.getInactive() : this.checkNoInActiveFromParam(expParams), extensions, valueSet);
        }
    }

    private boolean checkNoInActiveFromParam(Parameters expParams) {
        for (Parameters.ParametersParameterComponent p : expParams.getParameter()) {
            if (!p.getName().equals("activeOnly")) continue;
            return (Boolean)p.getValueBooleanType().getValue();
        }
        return false;
    }

    private ValueSet importValueSet(String value, ValueSet.ValueSetExpansionComponent exp, Parameters expParams, boolean noInactive, ValueSet valueSet) throws ValueSetExpander.ETooCostly, TerminologyServiceException, FileNotFoundException, IOException, FHIRFormatError {
        ValueSetExpander.ValueSetExpansionOutcome vso;
        if (value == null) {
            throw this.fail("unable to find value set with no identity");
        }
        ValueSet vs = this.context.fetchResource(ValueSet.class, value, valueSet);
        if (vs == null) {
            if (this.context.fetchResource(CodeSystem.class, value, valueSet) != null) {
                throw this.fail("Cannot include value set " + value + " because it's actually a code system");
            }
            throw this.fail("Unable to find imported value set " + value);
        }
        if (noInactive) {
            expParams = expParams.copy();
            expParams.addParameter("activeOnly", true);
        }
        if ((vso = new ValueSetExpanderSimple(this.context, this.allErrors).expand(vs, expParams)).getError() != null) {
            this.addErrors(vso.getAllErrors());
            throw this.fail("Unable to expand imported value set " + vs.getUrl() + ": " + vso.getError());
        }
        if (vs.hasVersion() && !this.existsInParams(exp.getParameter(), "version", new UriType(vs.getUrl() + "|" + vs.getVersion()))) {
            exp.getParameter().add(new ValueSet.ValueSetExpansionParameterComponent().setName("version").setValue(new UriType(vs.getUrl() + "|" + vs.getVersion())));
        }
        for (Extension ex : vso.getValueset().getExpansion().getExtension()) {
            if (!ex.getUrl().equals("http://hl7.org/fhir/StructureDefinition/valueset-toocostly")) continue;
            if (ex.getValue() instanceof BooleanType) {
                exp.getExtension().add(new Extension("http://hl7.org/fhir/StructureDefinition/valueset-toocostly").setValue(new UriType(value)));
                continue;
            }
            exp.getExtension().add(ex);
        }
        for (ValueSet.ValueSetExpansionParameterComponent p : vso.getValueset().getExpansion().getParameter()) {
            if (this.existsInParams(exp.getParameter(), p.getName(), p.getValue())) continue;
            exp.getParameter().add(p);
        }
        if (this.isValueSetUnionImports(valueSet)) {
            this.copyExpansion(vso.getValueset().getExpansion().getContains());
        }
        this.canBeHeirarchy = false;
        return vso.getValueset();
    }

    protected boolean isValueSetUnionImports(ValueSet valueSet) {
        PackageInformation p = valueSet.getSourcePackage();
        if (p != null) {
            return p.getDate().before(new GregorianCalendar(2022, 2, 31).getTime());
        }
        return false;
    }

    public void copyExpansion(List<ValueSet.ValueSetExpansionContainsComponent> list) {
        for (ValueSet.ValueSetExpansionContainsComponent cc : list) {
            ValueSet.ValueSetExpansionContainsComponent n = new ValueSet.ValueSetExpansionContainsComponent();
            n.setSystem(cc.getSystem());
            n.setCode(cc.getCode());
            n.setAbstract(cc.getAbstract());
            n.setInactive(cc.getInactive());
            n.setDisplay(cc.getDisplay());
            n.getDesignation().addAll(cc.getDesignation());
            String s2 = this.key(n);
            if (!this.map.containsKey(s2) && !this.excludeKeys.contains(s2)) {
                this.codes.add(n);
                this.map.put(s2, n);
                ++this.total;
            }
            this.copyExpansion(cc.getContains());
        }
    }

    private void addErrors(List<String> errs) {
        for (String s2 : errs) {
            if (this.allErrors.contains(s2)) continue;
            this.allErrors.add(s2);
        }
    }

    private void copyImportContains(List<ValueSet.ValueSetExpansionContainsComponent> list, ValueSet.ValueSetExpansionContainsComponent parent, Parameters expParams, List<ValueSet> filter, boolean noInactive, List<ValueSet.ValueSetExpansionPropertyComponent> vsProps) throws FHIRException {
        for (ValueSet.ValueSetExpansionContainsComponent c : list) {
            c.checkNoModifiers("Imported Expansion in Code System", "expanding");
            ValueSet.ValueSetExpansionContainsComponent np = this.addCode(c.getSystem(), c.getCode(), c.getDisplay(), parent, null, expParams, c.getAbstract(), c.getInactive(), filter, noInactive, false, vsProps);
            this.copyImportContains(c.getContains(), np, expParams, filter, noInactive, vsProps);
        }
    }

    private void includeCodes(ValueSet.ConceptSetComponent inc, ValueSet.ValueSetExpansionComponent exp, Parameters expParams, boolean heirarchical, boolean noInactive, List<Extension> extensions, ValueSet valueSet) throws ValueSetExpander.ETooCostly, FileNotFoundException, IOException, FHIRException {
        inc.checkNoModifiers("Compose.include", "expanding");
        ArrayList<ValueSet> imports = new ArrayList<ValueSet>();
        for (UriType uriType : inc.getValueSet()) {
            imports.add(this.importValueSet((String)uriType.getValue(), exp, expParams, noInactive, valueSet));
        }
        if (!inc.hasSystem()) {
            if (imports.isEmpty()) {
                return;
            }
            ValueSet base = (ValueSet)imports.get(0);
            imports.remove(0);
            base.checkNoModifiers("Imported ValueSet", "expanding");
            this.copyImportContains(base.getExpansion().getContains(), null, expParams, imports, noInactive, base.getExpansion().getProperty());
        } else {
            CodeSystem cs = this.context.fetchCodeSystem(inc.getSystem());
            if (this.isServerSide(inc.getSystem()) || cs == null || cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE && cs.getContent() != CodeSystem.CodeSystemContentMode.FRAGMENT) {
                this.doServerIncludeCodes(inc, heirarchical, exp, imports, expParams, extensions, noInactive, valueSet.getExpansion().getProperty());
            } else {
                this.doInternalIncludeCodes(inc, exp, expParams, imports, cs, noInactive);
            }
        }
    }

    private void doServerIncludeCodes(ValueSet.ConceptSetComponent inc, boolean heirarchical, ValueSet.ValueSetExpansionComponent exp, List<ValueSet> imports, Parameters expParams, List<Extension> extensions, boolean noInactive, List<ValueSet.ValueSetExpansionPropertyComponent> vsProps) throws FHIRException {
        ValueSetExpander.ValueSetExpansionOutcome vso = this.context.expandVS(inc, heirarchical, noInactive);
        if (vso.getError() != null) {
            throw this.failTSE("Unable to expand imported value set: " + vso.getError());
        }
        ValueSet vs = vso.getValueset();
        if (vs.hasVersion() && !this.existsInParams(exp.getParameter(), "version", new UriType(vs.getUrl() + "|" + vs.getVersion()))) {
            exp.getParameter().add(new ValueSet.ValueSetExpansionParameterComponent().setName("version").setValue(new UriType(vs.getUrl() + "|" + vs.getVersion())));
        }
        for (ValueSet.ValueSetExpansionParameterComponent p : vso.getValueset().getExpansion().getParameter()) {
            if (this.existsInParams(exp.getParameter(), p.getName(), p.getValue())) continue;
            exp.getParameter().add(p);
        }
        for (Extension ex : vs.getExpansion().getExtension()) {
            if (!Utilities.existsInList(ex.getUrl(), "http://hl7.org/fhir/StructureDefinition/valueset-toocostly", "http://hl7.org/fhir/StructureDefinition/valueset-unclosed") || this.hasExtension(extensions, ex.getUrl())) continue;
            extensions.add(ex);
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc : vs.getExpansion().getContains()) {
            this.addCodeAndDescendents(cc, null, expParams, imports, noInactive, vsProps);
        }
    }

    private boolean hasExtension(List<Extension> extensions, String url) {
        for (Extension ex : extensions) {
            if (!ex.getUrl().equals(url)) continue;
            return true;
        }
        return false;
    }

    public void doInternalIncludeCodes(ValueSet.ConceptSetComponent inc, ValueSet.ValueSetExpansionComponent exp, Parameters expParams, List<ValueSet> imports, CodeSystem cs, boolean noInactive) throws NoTerminologyServiceException, TerminologyServiceException, FHIRException {
        if (cs == null) {
            if (this.context.isNoTerminologyServer()) {
                throw this.failTSE("Unable to find code system " + inc.getSystem().toString());
            }
            throw this.failTSE("Unable to find code system " + inc.getSystem().toString());
        }
        cs.checkNoModifiers("Code System", "expanding");
        if (cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE && cs.getContent() != CodeSystem.CodeSystemContentMode.FRAGMENT) {
            throw this.failTSE("Code system " + inc.getSystem().toString() + " is incomplete");
        }
        if (cs.hasVersion() && !this.existsInParams(exp.getParameter(), "version", new UriType(cs.getUrl() + "|" + cs.getVersion()))) {
            exp.getParameter().add(new ValueSet.ValueSetExpansionParameterComponent().setName("version").setValue(new UriType(cs.getUrl() + "|" + cs.getVersion())));
        }
        if (inc.getConcept().size() == 0 && inc.getFilter().size() == 0) {
            for (CodeSystem.ConceptDefinitionComponent def : cs.getConcept()) {
                this.addCodeAndDescendents(cs, inc.getSystem(), def, null, expParams, imports, null, new AllConceptsFilter(), noInactive, exp.getProperty());
            }
            if (cs.getContent() == CodeSystem.CodeSystemContentMode.FRAGMENT) {
                this.addFragmentWarning(exp, cs);
            }
            if (cs.getContent() == CodeSystem.CodeSystemContentMode.EXAMPLE) {
                this.addExampleWarning(exp, cs);
            }
        }
        if (!inc.getConcept().isEmpty()) {
            this.canBeHeirarchy = false;
            for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
                c.checkNoModifiers("Code in Code System", "expanding");
                CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent = CodeSystemUtilities.findCode(cs.getConcept(), c.getCode());
                Boolean inactive = false;
                if (conceptDefinitionComponent == null) {
                    if (cs.getContent() == CodeSystem.CodeSystemContentMode.FRAGMENT) {
                        this.addFragmentWarning(exp, cs);
                    } else if (cs.getContent() == CodeSystem.CodeSystemContentMode.EXAMPLE) {
                        this.addExampleWarning(exp, cs);
                    } else if (this.checkCodesWhenExpanding) {
                        throw this.failTSE("Unable to find code '" + c.getCode() + "' in code system " + cs.getUrl());
                    }
                } else {
                    inactive = CodeSystemUtilities.isInactive(cs, conceptDefinitionComponent);
                }
                this.addCode(inc.getSystem(), c.getCode(), (String)(!Utilities.noString(c.getDisplay()) ? c.getDisplay() : (conceptDefinitionComponent == null ? null : conceptDefinitionComponent.getDisplay())), null, this.convertDesignations(c.getDesignation()), expParams, false, inactive, imports, noInactive, false, exp.getProperty());
            }
        }
        if (inc.getFilter().size() > 1) {
            this.canBeHeirarchy = false;
            throw this.failTSE("Multiple filters not handled yet");
        }
        if (inc.getFilter().size() == 1) {
            ValueSet.ConceptSetFilterComponent fc;
            CodeSystem.ConceptDefinitionComponent def;
            if (cs.getContent() == CodeSystem.CodeSystemContentMode.FRAGMENT) {
                this.addFragmentWarning(exp, cs);
            }
            if ("concept".equals((fc = inc.getFilter().get(0)).getProperty()) && fc.getOp() == Enumerations.FilterOperator.ISA) {
                def = this.getConceptForCode(cs.getConcept(), fc.getValue());
                if (def == null) {
                    throw this.failTSE("Code '" + fc.getValue() + "' not found in system '" + inc.getSystem() + "'");
                }
                this.addCodeAndDescendents(cs, inc.getSystem(), def, null, expParams, imports, null, new AllConceptsFilter(), noInactive, exp.getProperty());
            } else if ("concept".equals(fc.getProperty()) && fc.getOp() == Enumerations.FilterOperator.ISNOTA) {
                CodeSystem.ConceptDefinitionComponent defEx = this.getConceptForCode(cs.getConcept(), fc.getValue());
                if (defEx == null) {
                    throw this.failTSE("Code '" + fc.getValue() + "' not found in system '" + inc.getSystem() + "'");
                }
                for (CodeSystem.ConceptDefinitionComponent def2 : cs.getConcept()) {
                    this.addCodeAndDescendents(cs, inc.getSystem(), def2, null, expParams, imports, defEx, new AllConceptsFilter(), noInactive, exp.getProperty());
                }
            } else if ("concept".equals(fc.getProperty()) && fc.getOp() == Enumerations.FilterOperator.DESCENDENTOF) {
                def = this.getConceptForCode(cs.getConcept(), fc.getValue());
                if (def == null) {
                    throw this.failTSE("Code '" + fc.getValue() + "' not found in system '" + inc.getSystem() + "'");
                }
                for (CodeSystem.ConceptDefinitionComponent c : def.getConcept()) {
                    this.addCodeAndDescendents(cs, inc.getSystem(), c, null, expParams, imports, null, new AllConceptsFilter(), noInactive, exp.getProperty());
                }
                if (def.hasUserData("cs.utils.cross.link")) {
                    List list = (List)def.getUserData("cs.utils.cross.link");
                    for (CodeSystem.ConceptDefinitionComponent c : list) {
                        this.addCodeAndDescendents(cs, inc.getSystem(), c, null, expParams, imports, null, new AllConceptsFilter(), noInactive, exp.getProperty());
                    }
                }
            } else if ("display".equals(fc.getProperty()) && fc.getOp() == Enumerations.FilterOperator.EQUAL) {
                this.canBeHeirarchy = false;
                def = this.getConceptForCode(cs.getConcept(), fc.getValue());
                if (def != null && StringUtils.isNotBlank(def.getDisplay()) && StringUtils.isNotBlank(fc.getValue()) && def.getDisplay().contains(fc.getValue())) {
                    this.addCode(inc.getSystem(), def.getCode(), def.getDisplay(), null, def.getDesignation(), expParams, CodeSystemUtilities.isNotSelectable(cs, def), CodeSystemUtilities.isInactive(cs, def), imports, noInactive, false, exp.getProperty());
                }
            } else if (this.isDefinedProperty(cs, fc.getProperty())) {
                for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : cs.getConcept()) {
                    this.addCodeAndDescendents(cs, inc.getSystem(), conceptDefinitionComponent, null, expParams, imports, null, new PropertyFilter(fc, this.getPropertyDefinition(cs, fc.getProperty())), noInactive, exp.getProperty());
                }
            } else {
                throw this.fail("Search by property[" + fc.getProperty() + "] and op[" + fc.getOp() + "] is not supported yet");
            }
        }
    }

    private CodeSystem.PropertyComponent getPropertyDefinition(CodeSystem cs, String property) {
        for (CodeSystem.PropertyComponent cp : cs.getProperty()) {
            if (!cp.getCode().equals(property)) continue;
            return cp;
        }
        return null;
    }

    private boolean isDefinedProperty(CodeSystem cs, String property) {
        for (CodeSystem.PropertyComponent cp : cs.getProperty()) {
            if (!cp.getCode().equals(property)) continue;
            return true;
        }
        return false;
    }

    private void addFragmentWarning(ValueSet.ValueSetExpansionComponent exp, CodeSystem cs) {
        String url = cs.getVersionedUrl();
        for (ValueSet.ValueSetExpansionParameterComponent p : exp.getParameter()) {
            if (!"fragment".equals(p.getName()) || !p.hasValueUriType() || !url.equals(p.getValue().primitiveValue())) continue;
            return;
        }
        exp.addParameter().setName("fragment").setValue(new UriType(url));
    }

    private void addExampleWarning(ValueSet.ValueSetExpansionComponent exp, CodeSystem cs) {
        String url = cs.getVersionedUrl();
        for (ValueSet.ValueSetExpansionParameterComponent p : exp.getParameter()) {
            if (!"example".equals(p.getName()) || !p.hasValueUriType() || !url.equals(p.getValue().primitiveValue())) continue;
            return;
        }
        exp.addParameter().setName("example").setValue(new UriType(url));
    }

    private List<CodeSystem.ConceptDefinitionDesignationComponent> convertDesignations(List<ValueSet.ConceptReferenceDesignationComponent> list) {
        ArrayList<CodeSystem.ConceptDefinitionDesignationComponent> res = new ArrayList<CodeSystem.ConceptDefinitionDesignationComponent>();
        for (ValueSet.ConceptReferenceDesignationComponent t : list) {
            CodeSystem.ConceptDefinitionDesignationComponent c = new CodeSystem.ConceptDefinitionDesignationComponent();
            c.setLanguage(t.getLanguage());
            c.setUse(t.getUse());
            c.setValue(t.getValue());
        }
        return res;
    }

    private String key(String uri, String code) {
        return "{" + uri + "}" + code;
    }

    private String key(ValueSet.ValueSetExpansionContainsComponent c) {
        return this.key(c.getSystem(), c.getCode());
    }

    private FHIRException fail(String msg) {
        this.allErrors.add(msg);
        return new FHIRException(msg);
    }

    private ValueSetExpander.ETooCostly failCostly(String msg) {
        this.allErrors.add(msg);
        return new ValueSetExpander.ETooCostly(msg);
    }

    private TerminologyServiceException failTSE(String msg) {
        this.allErrors.add(msg);
        return new TerminologyServiceException(msg);
    }

    public Collection<? extends String> getAllErrors() {
        return this.allErrors;
    }

    public boolean isCheckCodesWhenExpanding() {
        return this.checkCodesWhenExpanding;
    }

    public void setCheckCodesWhenExpanding(boolean checkCodesWhenExpanding) {
        this.checkCodesWhenExpanding = checkCodesWhenExpanding;
    }

    public static interface IConceptFilter {
        public boolean includeConcept(CodeSystem var1, CodeSystem.ConceptDefinitionComponent var2);
    }

    public class AllConceptsFilter
    implements IConceptFilter {
        @Override
        public boolean includeConcept(CodeSystem cs, CodeSystem.ConceptDefinitionComponent def) {
            return true;
        }
    }

    public class PropertyFilter
    implements IConceptFilter {
        private ValueSet.ConceptSetFilterComponent filter;
        private CodeSystem.PropertyComponent property;

        public PropertyFilter(ValueSet.ConceptSetFilterComponent fc, CodeSystem.PropertyComponent propertyDefinition) {
            this.filter = fc;
            this.property = propertyDefinition;
        }

        @Override
        public boolean includeConcept(CodeSystem cs, CodeSystem.ConceptDefinitionComponent def) {
            CodeSystem.ConceptPropertyComponent pc = this.getPropertyForConcept(def);
            if (pc != null) {
                String v = pc.getValue().isPrimitive() ? pc.getValue().primitiveValue() : null;
                switch (this.filter.getOp()) {
                    case DESCENDENTOF: {
                        throw ValueSetExpanderSimple.this.fail("not supported yet: " + this.filter.getOp().toCode());
                    }
                    case EQUAL: {
                        return this.filter.getValue().equals(v);
                    }
                    case EXISTS: {
                        throw ValueSetExpanderSimple.this.fail("not supported yet: " + this.filter.getOp().toCode());
                    }
                    case GENERALIZES: {
                        throw ValueSetExpanderSimple.this.fail("not supported yet: " + this.filter.getOp().toCode());
                    }
                    case IN: {
                        throw ValueSetExpanderSimple.this.fail("not supported yet: " + this.filter.getOp().toCode());
                    }
                    case ISA: {
                        throw ValueSetExpanderSimple.this.fail("not supported yet: " + this.filter.getOp().toCode());
                    }
                    case ISNOTA: {
                        throw ValueSetExpanderSimple.this.fail("not supported yet: " + this.filter.getOp().toCode());
                    }
                    case NOTIN: {
                        throw ValueSetExpanderSimple.this.fail("not supported yet: " + this.filter.getOp().toCode());
                    }
                    case NULL: {
                        throw ValueSetExpanderSimple.this.fail("not supported yet: " + this.filter.getOp().toCode());
                    }
                    case REGEX: {
                        throw ValueSetExpanderSimple.this.fail("not supported yet: " + this.filter.getOp().toCode());
                    }
                }
                throw ValueSetExpanderSimple.this.fail("Shouldn't get here");
            }
            if (this.property.getType() == CodeSystem.PropertyType.BOOLEAN && this.filter.getOp() == Enumerations.FilterOperator.EQUAL) {
                return "false".equals(this.filter.getValue());
            }
            return false;
        }

        private CodeSystem.ConceptPropertyComponent getPropertyForConcept(CodeSystem.ConceptDefinitionComponent def) {
            for (CodeSystem.ConceptPropertyComponent pc : def.getProperty()) {
                if (!pc.getCode().equals(this.property.getCode())) continue;
                return pc;
            }
            return null;
        }
    }
}

