/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.NoTerminologyServiceException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.SpecialCodeSystem;
import org.hl7.fhir.r5.terminologies.URICodeSystem;
import org.hl7.fhir.r5.terminologies.ValueSetChecker;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.terminologies.ValueSetWorker;
import org.hl7.fhir.r5.utils.validation.ValidationContextCarrier;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public class ValueSetCheckerSimple
extends ValueSetWorker
implements ValueSetChecker {
    private ValueSet valueset;
    private IWorkerContext context;
    private Map<String, ValueSetCheckerSimple> inner = new HashMap<String, ValueSetCheckerSimple>();
    private ValidationOptions options;
    private ValidationContextCarrier localContext;
    private List<CodeSystem> localSystems = new ArrayList<CodeSystem>();

    public ValueSetCheckerSimple(ValidationOptions options2, ValueSet source, IWorkerContext context) {
        this.valueset = source;
        this.context = context;
        this.options = options2;
    }

    public ValueSetCheckerSimple(ValidationOptions options2, ValueSet source, IWorkerContext context, ValidationContextCarrier ctxt) {
        this.valueset = source;
        this.context = context;
        this.options = options2;
        this.localContext = ctxt;
        this.analyseValueSet();
    }

    private void analyseValueSet() {
        if (this.localContext != null && this.valueset != null) {
            for (ValueSet.ConceptSetComponent i2 : this.valueset.getCompose().getInclude()) {
                this.analyseComponent(i2);
            }
            for (ValueSet.ConceptSetComponent i2 : this.valueset.getCompose().getExclude()) {
                this.analyseComponent(i2);
            }
        }
    }

    private void analyseComponent(ValueSet.ConceptSetComponent i2) {
        if (i2.getSystemElement().hasExtension("http://hl7.org/fhir/StructureDefinition/valueset-system")) {
            String ref = i2.getSystemElement().getExtensionString("http://hl7.org/fhir/StructureDefinition/valueset-system");
            if (ref.startsWith("#")) {
                String id = ref.substring(1);
                for (ValidationContextCarrier.ValidationContextResourceProxy t : this.localContext.getResources()) {
                    CodeSystem cs = (CodeSystem)t.loadContainedResource(id, CodeSystem.class);
                    if (cs == null) continue;
                    this.localSystems.add(cs);
                }
            } else {
                throw new Error("Not done yet #2: " + ref);
            }
        }
    }

    public IWorkerContext.ValidationResult validateCode(CodeableConcept code) throws FHIRException {
        ArrayList<String> errors = new ArrayList<String>();
        ValueSetChecker.ValidationProcessInfo info = new ValueSetChecker.ValidationProcessInfo();
        if (this.options.getValueSetMode() != ValidationOptions.ValueSetMode.CHECK_MEMERSHIP_ONLY) {
            for (Coding c : code.getCoding()) {
                if (!c.hasSystem()) {
                    info.getWarnings().add(this.context.formatMessage("Coding_has_no_system__cannot_validate", new Object[0]));
                }
                CodeSystem cs = this.resolveCodeSystem(c.getSystem(), c.getVersion());
                IWorkerContext.ValidationResult res = null;
                res = cs == null || cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE ? this.context.validateCode(this.options.noClient(), c, null) : this.validateCode(c, cs);
                if (!res.isOk()) {
                    errors.add(res.getMessage());
                    continue;
                }
                if (res.getMessage() == null) continue;
                info.getWarnings().add(res.getMessage());
            }
        }
        Coding foundCoding = null;
        if (this.valueset != null && this.options.getValueSetMode() != ValidationOptions.ValueSetMode.NO_MEMBERSHIP_CHECK) {
            Boolean result = false;
            for (Coding c : code.getCoding()) {
                Boolean ok = this.codeInValueSet(c.getSystem(), c.getVersion(), c.getCode(), info);
                if (ok == null && !result.booleanValue()) {
                    result = null;
                    continue;
                }
                if (!ok.booleanValue()) continue;
                result = true;
                foundCoding = c;
            }
            if (result == null) {
                info.getWarnings().add(0, this.context.formatMessage("UNABLE_TO_CHECK_IF_THE_PROVIDED_CODES_ARE_IN_THE_VALUE_SET_", this.valueset.getUrl()));
            } else if (!result.booleanValue()) {
                errors.add(0, this.context.formatMessage("None_of_the_provided_codes_are_in_the_value_set_", this.valueset.getUrl()));
            }
        }
        if (errors.size() > 0) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, ((Object)errors).toString());
        }
        if (info.getWarnings().size() > 0) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, info.getWarnings().toString());
        }
        CodeSystem.ConceptDefinitionComponent cd2 = new CodeSystem.ConceptDefinitionComponent(foundCoding.getCode());
        cd2.setDisplay(foundCoding.getDisplay());
        return new IWorkerContext.ValidationResult(foundCoding.getSystem(), cd2);
    }

    public CodeSystem resolveCodeSystem(String system, String version) {
        for (CodeSystem t : this.localSystems) {
            if (!t.getUrl().equals(system) || !this.versionsMatch(version, t.getVersion())) continue;
            return t;
        }
        CodeSystem cs = this.context.fetchCodeSystem(system, version);
        if (cs == null) {
            cs = this.findSpecialCodeSystem(system, version);
        }
        return cs;
    }

    private boolean versionsMatch(String versionTest, String versionActual) {
        return versionTest == null && VersionUtilities.versionsMatch(versionTest, versionActual);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IWorkerContext.ValidationResult validateCode(Coding code) throws FHIRException {
        Boolean ok;
        String system;
        String warningMessage = null;
        IWorkerContext.ValidationResult res = null;
        boolean inExpansion = false;
        boolean inInclude = false;
        String string = system = code.hasSystem() ? code.getSystem() : this.getValueSetSystemOrNull();
        if (this.options.getValueSetMode() != ValidationOptions.ValueSetMode.CHECK_MEMERSHIP_ONLY) {
            if (system == null && !code.hasDisplay()) {
                ArrayList<String> problems = new ArrayList<String>();
                system = this.systemForCodeInValueSet(code.getCode(), problems);
                if (system == null) {
                    if (problems.size() == 0) {
                        throw new Error("Unable to resolve systems but no reason why");
                    }
                    if (problems.size() != 1) return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, ((Object)problems).toString());
                    return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, (String)problems.get(0));
                }
            }
            if (!code.hasSystem()) {
                if (this.options.isGuessSystem() && system == null && Utilities.isAbsoluteUrl(code.getCode())) {
                    system = "urn:ietf:rfc:3986";
                }
                code.setSystem(system);
            }
            inExpansion = this.checkExpansion(code);
            inInclude = this.checkInclude(code);
            CodeSystem cs = this.resolveCodeSystem(system, code.getVersion());
            if (cs == null) {
                warningMessage = "Unable to resolve system " + system;
                if (!inExpansion) {
                    if (this.valueset == null) throw new FHIRException(warningMessage);
                    if (!this.valueset.hasExpansion()) throw new FHIRException(warningMessage);
                    return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.context.formatMessage("CODESYSTEM_CS_UNK_EXPANSION", this.valueset.getUrl(), code.getCode().toString(), code.getSystem()));
                }
            }
            if (cs != null && cs.hasSupplements()) {
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.context.formatMessage("CODESYSTEM_CS_NO_SUPPLEMENT", cs.getUrl()));
            }
            if (cs != null && cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE) {
                warningMessage = "Resolved system " + system + (String)(cs.hasVersion() ? " (v" + cs.getVersion() + ")" : "") + ", but the definition is not complete";
                if (!inExpansion && cs.getContent() != CodeSystem.CodeSystemContentMode.FRAGMENT) {
                    throw new FHIRException(warningMessage);
                }
            }
            if (cs != null) {
                if (cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE && cs.getContent() != CodeSystem.CodeSystemContentMode.FRAGMENT) {
                    if (!inInclude) throw new FHIRException("Unable to evaluate based on empty code system");
                    ValueSet.ConceptReferenceComponent cc = this.findInInclude(code);
                    if (cc == null) throw new FHIRException("Unable to evaluate based on empty code system");
                    res = new IWorkerContext.ValidationResult(system, new CodeSystem.ConceptDefinitionComponent().setCode(cc.getCode()).setDisplay(cc.getDisplay()));
                    res.setMessage("Resolved system " + system + ", but the definition is not complete, so assuming value set include is correct");
                    return res;
                }
                res = this.validateCode(code, cs);
            } else {
                if (cs != null) throw new FHIRException("No try the server");
                if (!this.valueset.hasExpansion()) throw new FHIRException("No try the server");
                if (!inExpansion) throw new FHIRException("No try the server");
                res = new IWorkerContext.ValidationResult(system, new CodeSystem.ConceptDefinitionComponent().setCode(code.getCode()).setDisplay(code.getDisplay()));
            }
        } else {
            inExpansion = this.checkExpansion(code);
            inInclude = this.checkInclude(code);
        }
        ValueSetChecker.ValidationProcessInfo info = new ValueSetChecker.ValidationProcessInfo();
        if (this.valueset == null) return res;
        if (this.options.getValueSetMode() == ValidationOptions.ValueSetMode.NO_MEMBERSHIP_CHECK) return res;
        if (res != null) {
            if (!res.isOk()) return res;
        }
        if ((ok = this.codeInValueSet(system, code.getVersion(), code.getCode(), info)) != null) {
            if (ok != false) return res;
        }
        if (res == null) {
            res = new IWorkerContext.ValidationResult((ValidationMessage.IssueSeverity)null, null);
        }
        if (info.getErr() != null) {
            res.setErrorClass(info.getErr());
        }
        if (ok == null) {
            res.setMessage("Unable to check whether code is in value set " + this.valueset.getUrl() + ": " + info.getWarnings()).setSeverity(ValidationMessage.IssueSeverity.WARNING);
            return res;
        } else if (!inExpansion && !inInclude) {
            if (!info.getWarnings().isEmpty()) {
                res.setMessage("Not in value set " + this.valueset.getUrl() + ": " + info.getWarnings()).setSeverity(ValidationMessage.IssueSeverity.ERROR);
                return res;
            } else {
                res.setMessage("Not in value set " + this.valueset.getUrl()).setSeverity(ValidationMessage.IssueSeverity.ERROR);
            }
            return res;
        } else {
            if (warningMessage != null) {
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.context.formatMessage("Code_found_in_expansion_however_", warningMessage));
            }
            if (inExpansion) {
                res.setMessage("Code found in expansion, however: " + res.getMessage());
                return res;
            } else {
                if (!inInclude) return res;
                res.setMessage("Code found in include, however: " + res.getMessage());
            }
        }
        return res;
    }

    private boolean checkInclude(Coding code) {
        if (this.valueset == null || code.getSystem() == null || code.getCode() == null) {
            return false;
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getExclude()) {
            if (!inc.hasSystem() || !inc.getSystem().equals(code.getSystem())) continue;
            for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                if (!cc.hasCode() || !cc.getCode().equals(code.getCode())) continue;
                return false;
            }
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (!inc.hasSystem() || !inc.getSystem().equals(code.getSystem())) continue;
            for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                if (!cc.hasCode() || !cc.getCode().equals(code.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    private ValueSet.ConceptReferenceComponent findInInclude(Coding code) {
        if (this.valueset == null || code.getSystem() == null || code.getCode() == null) {
            return null;
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (!inc.hasSystem() || !inc.getSystem().equals(code.getSystem())) continue;
            for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                if (!cc.hasCode() || !cc.getCode().equals(code.getCode())) continue;
                return cc;
            }
        }
        return null;
    }

    private CodeSystem findSpecialCodeSystem(String system, String version) {
        if ("urn:ietf:rfc:3986".equals(system)) {
            CodeSystem cs = new CodeSystem();
            cs.setUrl(system);
            cs.setUserData("tx.cs.special", new URICodeSystem());
            cs.setContent(CodeSystem.CodeSystemContentMode.COMPLETE);
            return cs;
        }
        return null;
    }

    private IWorkerContext.ValidationResult findCodeInExpansion(Coding code) {
        if (this.valueset == null || !this.valueset.hasExpansion()) {
            return null;
        }
        return this.findCodeInExpansion(code, this.valueset.getExpansion().getContains());
    }

    private IWorkerContext.ValidationResult findCodeInExpansion(Coding code, List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent containsComponent : contains) {
            IWorkerContext.ValidationResult res;
            if (containsComponent.getSystem().equals(code.getSystem()) && containsComponent.getCode().equals(code.getCode())) {
                CodeSystem.ConceptDefinitionComponent ccd = new CodeSystem.ConceptDefinitionComponent();
                ccd.setCode(containsComponent.getCode());
                ccd.setDisplay(containsComponent.getDisplay());
                IWorkerContext.ValidationResult res2 = new IWorkerContext.ValidationResult(code.getSystem(), ccd);
                return res2;
            }
            if (!containsComponent.hasContains() || (res = this.findCodeInExpansion(code, containsComponent.getContains())) == null) continue;
            return res;
        }
        return null;
    }

    private boolean checkExpansion(Coding code) {
        if (this.valueset == null || !this.valueset.hasExpansion()) {
            return false;
        }
        return this.checkExpansion(code, this.valueset.getExpansion().getContains());
    }

    private boolean checkExpansion(Coding code, List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent containsComponent : contains) {
            if (containsComponent.getSystem().equals(code.getSystem()) && containsComponent.getCode().equals(code.getCode())) {
                return true;
            }
            if (!containsComponent.hasContains() || !this.checkExpansion(code, containsComponent.getContains())) continue;
            return true;
        }
        return false;
    }

    private IWorkerContext.ValidationResult validateCode(Coding code, CodeSystem cs) {
        CodeSystem.ConceptDefinitionComponent cc;
        CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent = cc = cs.hasUserData("tx.cs.special") ? ((SpecialCodeSystem)cs.getUserData("tx.cs.special")).findConcept(code) : this.findCodeInConcept(cs.getConcept(), code.getCode());
        if (cc == null) {
            if (cs.getContent() == CodeSystem.CodeSystemContentMode.FRAGMENT) {
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.context.formatMessage("UNKNOWN_CODE__IN_FRAGMENT", this.gen(code), cs.getUrl()));
            }
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.context.formatMessage("Unknown_Code__in_", this.gen(code), cs.getUrl()));
        }
        if (code.getDisplay() == null) {
            return new IWorkerContext.ValidationResult(code.getSystem(), cc);
        }
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (cc.hasDisplay()) {
            b.append(cc.getDisplay());
            if (code.getDisplay().equalsIgnoreCase(cc.getDisplay())) {
                return new IWorkerContext.ValidationResult(code.getSystem(), cc);
            }
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent ds : cc.getDesignation()) {
            b.append(ds.getValue());
            if (!code.getDisplay().equalsIgnoreCase(ds.getValue())) continue;
            return new IWorkerContext.ValidationResult(code.getSystem(), cc);
        }
        ValueSet.ConceptReferenceComponent vs = this.findValueSetRef(code.getSystem(), code.getCode());
        if (vs != null && (vs.hasDisplay() || vs.hasDesignation())) {
            if (vs.hasDisplay()) {
                b.append(vs.getDisplay());
                if (code.getDisplay().equalsIgnoreCase(vs.getDisplay())) {
                    return new IWorkerContext.ValidationResult(code.getSystem(), cc);
                }
            }
            for (ValueSet.ConceptReferenceDesignationComponent ds : vs.getDesignation()) {
                b.append(ds.getValue());
                if (!code.getDisplay().equalsIgnoreCase(ds.getValue())) continue;
                return new IWorkerContext.ValidationResult(code.getSystem(), cc);
            }
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.context.formatMessagePlural(b.count(), "Display_Name_for__should_be_one_of__instead_of", code.getSystem(), code.getCode(), b.toString(), code.getDisplay()), code.getSystem(), cc);
    }

    private ValueSet.ConceptReferenceComponent findValueSetRef(String system, String code) {
        if (this.valueset == null) {
            return null;
        }
        for (ValueSet.ValueSetExpansionContainsComponent exp : this.valueset.getExpansion().getContains()) {
            if (!system.equals(exp.getSystem()) || !code.equals(exp.getCode())) continue;
            ValueSet.ConceptReferenceComponent cc = new ValueSet.ConceptReferenceComponent();
            cc.setDisplay(exp.getDisplay());
            cc.setDesignation(exp.getDesignation());
            return cc;
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (system.equals(inc.getSystem())) {
                for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                    if (!cc.getCode().equals(code)) continue;
                    return cc;
                }
            }
            for (CanonicalType url : inc.getValueSet()) {
                ValueSet.ConceptReferenceComponent cc = this.getVs(url.asStringValue()).findValueSetRef(system, code);
                if (cc == null) continue;
                return cc;
            }
        }
        return null;
    }

    private String gen(Coding code) {
        if (code.hasSystem()) {
            return code.getSystem() + "#" + code.getCode();
        }
        return null;
    }

    private String getValueSetSystemOrNull() throws FHIRException {
        if (this.valueset == null) {
            return null;
        }
        if (this.valueset.getCompose().getInclude().size() == 0) {
            if (!this.valueset.hasExpansion() || this.valueset.getExpansion().getContains().size() == 0) {
                return null;
            }
            String cs = this.valueset.getExpansion().getContains().get(0).getSystem();
            if (cs != null && this.checkSystem(this.valueset.getExpansion().getContains(), cs)) {
                return cs;
            }
            return null;
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (inc.hasValueSet()) {
                return null;
            }
            if (inc.hasSystem()) continue;
            return null;
        }
        if (this.valueset.getCompose().getInclude().size() == 1) {
            return this.valueset.getCompose().getInclude().get(0).getSystem();
        }
        return null;
    }

    private boolean checkSystem(List<ValueSet.ValueSetExpansionContainsComponent> containsList, String system) {
        for (ValueSet.ValueSetExpansionContainsComponent contains : containsList) {
            if (contains.getSystem().equals(system) && (!contains.hasContains() || this.checkSystem(contains.getContains(), system))) continue;
            return false;
        }
        return true;
    }

    private CodeSystem.ConceptDefinitionComponent findCodeInConcept(CodeSystem.ConceptDefinitionComponent concept, String code) {
        if (code.equals(concept.getCode())) {
            return concept;
        }
        CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(concept.getConcept(), code);
        if (cc != null) {
            return cc;
        }
        if (concept.hasUserData("cs.utils.cross.link")) {
            List children = (List)concept.getUserData("cs.utils.cross.link");
            for (CodeSystem.ConceptDefinitionComponent c : children) {
                cc = this.findCodeInConcept(c, code);
                if (cc == null) continue;
                return cc;
            }
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent findCodeInConcept(List<CodeSystem.ConceptDefinitionComponent> concept, String code) {
        for (CodeSystem.ConceptDefinitionComponent cc : concept) {
            if (code.equals(cc.getCode())) {
                return cc;
            }
            CodeSystem.ConceptDefinitionComponent c = this.findCodeInConcept(cc, code);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    private String systemForCodeInValueSet(String code, List<String> problems) {
        HashSet<String> sys = new HashSet<String>();
        if (!this.scanForCodeInValueSet(code, sys, problems)) {
            return null;
        }
        if (sys.size() != 1) {
            problems.add(this.context.formatMessage("Unable_to_resolve_system__value_set_has_multiple_matches", ((Object)sys).toString()));
            return null;
        }
        return (String)sys.iterator().next();
    }

    private boolean scanForCodeInValueSet(String code, Set<String> sys, List<String> problems) {
        if (this.valueset.hasCompose()) {
            if (!this.valueset.getCompose().hasInclude() && !this.valueset.getExpansion().hasContains()) {
                problems.add(this.context.formatMessage("Unable_to_resolve_system__value_set_has_no_includes_or_expansion", this.valueset.getVersionedUrl()));
            }
            int i2 = 0;
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getInclude()) {
                if (vsi.hasValueSet()) {
                    for (CanonicalType canonicalType : vsi.getValueSet()) {
                        if (this.checkForCodeInValueSet(code, (String)canonicalType.getValue(), sys, problems)) continue;
                        return false;
                    }
                } else if (!vsi.hasSystem()) {
                    problems.add(this.context.formatMessage("Unable_to_resolve_system__value_set_has_include_with_no_system", this.valueset.getVersionedUrl(), i2));
                    return false;
                }
                if (vsi.hasSystem()) {
                    boolean match;
                    if (vsi.hasFilter()) {
                        problems.add(this.context.formatMessage("Unable_to_resolve_system__value_set_has_include_with_no_system", this.valueset.getVersionedUrl(), i2, vsi.getSystem()));
                        return false;
                    }
                    CodeSystem cs = this.resolveCodeSystem(vsi.getSystem(), vsi.getVersion());
                    if (cs != null && cs.getContent() == CodeSystem.CodeSystemContentMode.COMPLETE) {
                        if (vsi.hasConcept()) {
                            for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                                match = cs.getCaseSensitive() ? cc.getCode().equals(code) : cc.getCode().equalsIgnoreCase(code);
                                if (!match) continue;
                                sys.add(vsi.getSystem());
                            }
                        } else {
                            CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent = this.findCodeInConcept(cs.getConcept(), code);
                            if (conceptDefinitionComponent != null) {
                                sys.add(vsi.getSystem());
                            }
                        }
                    } else if (vsi.hasConcept()) {
                        for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                            match = cc.getCode().equals(code);
                            if (!match) continue;
                            sys.add(vsi.getSystem());
                        }
                    } else {
                        ValueSetExpander.ValueSetExpansionOutcome valueSetExpansionOutcome = this.context.expandVS(vsi, false, false);
                        if (valueSetExpansionOutcome.isOk()) {
                            if (!this.checkSystems(valueSetExpansionOutcome.getValueset().getExpansion().getContains(), code, sys, problems)) {
                                return false;
                            }
                        } else {
                            problems.add(this.context.formatMessage("Unable_to_resolve_system__value_set_has_include_with_unknown_system", this.valueset.getVersionedUrl(), i2, vsi.getSystem(), valueSetExpansionOutcome.getAllErrors().toString()));
                            return false;
                        }
                    }
                }
                ++i2;
            }
        } else if (this.valueset.hasExpansion() && !this.checkSystems(this.valueset.getExpansion().getContains(), code, sys, problems)) {
            return false;
        }
        return true;
    }

    private boolean checkForCodeInValueSet(String code, String uri, Set<String> sys, List<String> problems) {
        ValueSetCheckerSimple vs = this.getVs(uri);
        return vs.scanForCodeInValueSet(code, sys, problems);
    }

    private boolean checkSystems(List<ValueSet.ValueSetExpansionContainsComponent> contains, String code, Set<String> systems, List<String> problems) {
        for (ValueSet.ValueSetExpansionContainsComponent c : contains) {
            if (c.getCode().equals(code)) {
                systems.add(c.getSystem());
            }
            if (!c.hasContains()) continue;
            this.checkSystems(c.getContains(), code, systems, problems);
        }
        return true;
    }

    @Override
    public Boolean codeInValueSet(String system, String version, String code, ValueSetChecker.ValidationProcessInfo info) throws FHIRException {
        if (this.valueset == null) {
            return false;
        }
        Boolean result = false;
        if (this.valueset.hasExpansion()) {
            return this.checkExpansion(new Coding(system, code, null));
        }
        if (this.valueset.hasCompose()) {
            int i2 = 0;
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getInclude()) {
                Boolean ok = this.inComponent(vsi, i2, system, version, code, this.valueset.getCompose().getInclude().size() == 1, info);
                ++i2;
                if (ok == null && !result.booleanValue()) {
                    result = null;
                    continue;
                }
                if (!ok.booleanValue()) continue;
                result = true;
                break;
            }
            i2 = this.valueset.getCompose().getInclude().size();
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getExclude()) {
                Boolean nok = this.inComponent(vsi, i2, system, version, code, this.valueset.getCompose().getInclude().size() == 1, info);
                ++i2;
                if (nok == null && !result.booleanValue()) {
                    result = null;
                    continue;
                }
                if (nok == null || !nok.booleanValue()) continue;
                result = false;
            }
        }
        return result;
    }

    private Boolean inComponent(ValueSet.ConceptSetComponent vsi, int vsiIndex, String system, String version, String code, boolean only, ValueSetChecker.ValidationProcessInfo info) throws FHIRException {
        List<CodeSystem.ConceptDefinitionComponent> list;
        boolean ok = true;
        if (vsi.hasValueSet()) {
            if (this.isValueSetUnionImports()) {
                ok = false;
                for (UriType uriType : vsi.getValueSet()) {
                    if (!this.inImport((String)uriType.getValue(), system, version, code)) continue;
                    return true;
                }
            } else {
                ok = this.inImport((String)vsi.getValueSet().get(0).getValue(), system, version, code);
                for (int i2 = 1; i2 < vsi.getValueSet().size(); ++i2) {
                    UriType uriType = vsi.getValueSet().get(i2);
                    ok = ok && this.inImport((String)uriType.getValue(), system, version, code);
                }
            }
        }
        if (!vsi.hasSystem() || !ok) {
            return ok;
        }
        if (only && system == null) {
            for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : vsi.getConcept()) {
                if (!conceptReferenceComponent.getCode().equals(code)) continue;
                return true;
            }
        }
        if (!system.equals(vsi.getSystem())) {
            return false;
        }
        CodeSystem cs = this.resolveCodeSystem(system, version);
        if (cs == null || cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE && cs.getContent() != CodeSystem.CodeSystemContentMode.FRAGMENT) {
            ValueSet valueSet = new ValueSet();
            valueSet.setStatus(Enumerations.PublicationStatus.ACTIVE);
            valueSet.setUrl(this.valueset.getUrl() + "--" + vsiIndex);
            valueSet.setVersion(this.valueset.getVersion());
            valueSet.getCompose().addInclude(vsi);
            IWorkerContext.ValidationResult res = this.context.validateCode(this.options.noClient(), new Coding(system, code, null), valueSet);
            if (res.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN || res.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED || res.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.VALUESET_UNSUPPORTED) {
                if (info != null && res.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
                    info.getWarnings().add(this.context.formatMessage("Terminology_TX_System_NotKnown", system));
                    for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                        if (!cc.getCode().equals(code)) continue;
                        return true;
                    }
                    info.setErr(ValueSetExpander.TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED);
                }
                return null;
            }
            if (res.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE) {
                throw new NoTerminologyServiceException();
            }
            return res.isOk();
        }
        if (vsi.hasFilter()) {
            ok = true;
            for (ValueSet.ConceptSetFilterComponent f : vsi.getFilter()) {
                if (this.codeInFilter(cs, system, f, code)) continue;
                return false;
            }
        }
        if ((ok = this.validateCodeInConceptList(code, cs, list = cs.getConcept())) && vsi.hasConcept()) {
            for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                if (!cc.getCode().equals(code)) continue;
                return true;
            }
            return false;
        }
        return ok;
    }

    protected boolean isValueSetUnionImports() {
        PackageInformation p = this.valueset.getSourcePackage();
        if (p != null) {
            return p.getDate().before(new GregorianCalendar(2022, 2, 31).getTime());
        }
        return false;
    }

    private boolean codeInFilter(CodeSystem cs, String system, ValueSet.ConceptSetFilterComponent f, String code) throws FHIRException {
        if ("concept".equals(f.getProperty())) {
            return this.codeInConceptFilter(cs, f, code);
        }
        System.out.println("todo: handle filters with property = " + f.getProperty());
        throw new FHIRException(this.context.formatMessage("Unable_to_handle_system__filter_with_property__", cs.getUrl(), f.getProperty()));
    }

    private boolean codeInConceptFilter(CodeSystem cs, ValueSet.ConceptSetFilterComponent f, String code) throws FHIRException {
        switch (f.getOp()) {
            case ISA: {
                return this.codeInConceptIsAFilter(cs, f, code, false);
            }
            case ISNOTA: {
                return !this.codeInConceptIsAFilter(cs, f, code, false);
            }
            case DESCENDENTOF: {
                return this.codeInConceptIsAFilter(cs, f, code, true);
            }
        }
        System.out.println("todo: handle concept filters with op = " + f.getOp());
        throw new FHIRException(this.context.formatMessage("Unable_to_handle_system__concept_filter_with_op__", new Object[]{cs.getUrl(), f.getOp()}));
    }

    private boolean codeInConceptIsAFilter(CodeSystem cs, ValueSet.ConceptSetFilterComponent f, String code, boolean rootOnly) {
        if (!rootOnly && code.equals(f.getProperty())) {
            return true;
        }
        CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(cs.getConcept(), f.getValue());
        if (cc == null) {
            return false;
        }
        return (cc = this.findCodeInConcept(cc, code)) != null;
    }

    public boolean validateCodeInConceptList(String code, CodeSystem def, List<CodeSystem.ConceptDefinitionComponent> list) {
        if (def.getCaseSensitive()) {
            for (CodeSystem.ConceptDefinitionComponent cc : list) {
                if (cc.getCode().equals(code)) {
                    return true;
                }
                if (!cc.hasConcept() || !this.validateCodeInConceptList(code, def, cc.getConcept())) continue;
                return true;
            }
        } else {
            for (CodeSystem.ConceptDefinitionComponent cc : list) {
                if (cc.getCode().equalsIgnoreCase(code)) {
                    return true;
                }
                if (!cc.hasConcept() || !this.validateCodeInConceptList(code, def, cc.getConcept())) continue;
                return true;
            }
        }
        return false;
    }

    private ValueSetCheckerSimple getVs(String url) {
        if (this.inner.containsKey(url)) {
            return this.inner.get(url);
        }
        ValueSet vs = this.context.fetchResource(ValueSet.class, url, this.valueset);
        ValueSetCheckerSimple vsc = new ValueSetCheckerSimple(this.options, vs, this.context, this.localContext);
        this.inner.put(url, vsc);
        return vsc;
    }

    private boolean inImport(String uri, String system, String version, String code) throws FHIRException {
        ValueSetCheckerSimple vs = this.getVs(uri);
        if (vs == null) {
            return false;
        }
        Boolean ok = vs.codeInValueSet(system, version, code, null);
        return ok != null && ok != false;
    }
}

