/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;

public class CodeSystemUtilities {
    public static final String USER_DATA_CROSS_LINK = "cs.utils.cross.link";

    public static boolean isNotSelectable(CodeSystem cs, CodeSystem.ConceptDefinitionComponent def) {
        for (CodeSystem.ConceptPropertyComponent p : def.getProperty()) {
            if (!"notSelectable".equals(p.getCode()) || !p.hasValue() || !(p.getValue() instanceof BooleanType)) continue;
            return (Boolean)((BooleanType)p.getValue()).getValue();
        }
        return false;
    }

    public static void setNotSelectable(CodeSystem cs, CodeSystem.ConceptDefinitionComponent concept) throws FHIRFormatError {
        CodeSystemUtilities.defineNotSelectableProperty(cs);
        CodeSystem.ConceptPropertyComponent p = CodeSystemUtilities.getProperty(concept, "notSelectable");
        if (p != null) {
            p.setValue(new BooleanType(true));
        } else {
            concept.addProperty().setCode("notSelectable").setValue(new BooleanType(true));
        }
    }

    public static void setProperty(CodeSystem cs, CodeSystem.ConceptDefinitionComponent concept, String code, DataType value) throws FHIRFormatError {
        CodeSystemUtilities.defineProperty(cs, code, CodeSystemUtilities.propertyTypeForValue(value));
        CodeSystem.ConceptPropertyComponent p = CodeSystemUtilities.getProperty(concept, code);
        if (p != null) {
            p.setValue(value);
        } else {
            concept.addProperty().setCode(code).setValue(value);
        }
    }

    private static CodeSystem.PropertyType propertyTypeForValue(DataType value) {
        if (value instanceof BooleanType) {
            return CodeSystem.PropertyType.BOOLEAN;
        }
        if (value instanceof CodeType) {
            return CodeSystem.PropertyType.CODE;
        }
        if (value instanceof Coding) {
            return CodeSystem.PropertyType.CODING;
        }
        if (value instanceof DateTimeType) {
            return CodeSystem.PropertyType.DATETIME;
        }
        if (value instanceof DecimalType) {
            return CodeSystem.PropertyType.DECIMAL;
        }
        if (value instanceof IntegerType) {
            return CodeSystem.PropertyType.INTEGER;
        }
        if (value instanceof StringType) {
            return CodeSystem.PropertyType.STRING;
        }
        throw new Error("Unknown property type " + value.getClass().getName());
    }

    private static void defineProperty(CodeSystem cs, String code, CodeSystem.PropertyType pt) {
        String url = "http://hl7.org/fhir/concept-properties#" + code;
        for (CodeSystem.PropertyComponent p : cs.getProperty()) {
            if (!p.getCode().equals(code)) continue;
            if (!p.getUri().equals(url)) {
                throw new Error("URI mismatch for code " + code + " url = " + p.getUri() + " vs " + url);
            }
            if (!p.getType().equals((Object)pt)) {
                throw new Error("Type mismatch for code " + code + " type = " + p.getType() + " vs " + pt);
            }
            return;
        }
        cs.addProperty().setCode(code).setUri(url).setType(pt).setUri(url);
    }

    public static void defineNotSelectableProperty(CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "notSelectable", "Indicates that the code is abstract - only intended to be used as a selector for other concepts", CodeSystem.PropertyType.BOOLEAN);
    }

    public static void setStatus(CodeSystem cs, CodeSystem.ConceptDefinitionComponent concept, ConceptStatus status) throws FHIRFormatError {
        CodeSystemUtilities.defineStatusProperty(cs);
        CodeSystem.ConceptPropertyComponent p = CodeSystemUtilities.getProperty(concept, "status");
        if (p != null) {
            p.setValue(new CodeType(status.toCode()));
        } else {
            concept.addProperty().setCode("status").setValue(new CodeType(status.toCode()));
        }
    }

    public static void defineStatusProperty(CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "status", "A property that indicates the status of the concept. One of active, experimental, deprecated, retired", CodeSystem.PropertyType.CODE);
    }

    private static void defineDeprecatedProperty(CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "deprecationDate", "The date at which a concept was deprecated. Concepts that are deprecated but not inactive can still be used, but their use is discouraged", CodeSystem.PropertyType.DATETIME);
    }

    public static void defineParentProperty(CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "parent", "The concept identified in this property is a parent of the concept on which it is a property. The property type will be 'code'. The meaning of parent/child relationships is defined by the hierarchyMeaning attribute", CodeSystem.PropertyType.CODE);
    }

    public static void defineChildProperty(CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "child", "The concept identified in this property is a child of the concept on which it is a property. The property type will be 'code'. The meaning of parent/child relationships is defined by the hierarchyMeaning attribute", CodeSystem.PropertyType.CODE);
    }

    public static boolean isDeprecated(CodeSystem cs, CodeSystem.ConceptDefinitionComponent def, boolean ignoreStatus) {
        try {
            for (CodeSystem.ConceptPropertyComponent p : def.getProperty()) {
                if (!ignoreStatus && "status".equals(p.getCode()) && p.hasValue() && p.hasValueCodeType() && "deprecated".equals(p.getValueCodeType().getCode())) {
                    return true;
                }
                if ("deprecationDate".equals(p.getCode()) && p.hasValue() && p.getValue() instanceof DateTimeType) {
                    return ((DateTimeType)p.getValue()).before(new DateTimeType(Calendar.getInstance()));
                }
                if (!"deprecated".equals(p.getCode()) || !p.hasValue() || !(p.getValue() instanceof BooleanType)) continue;
                return (Boolean)((BooleanType)p.getValue()).getValue();
            }
            StandardsStatus ss = ToolingExtensions.getStandardsStatus(def);
            return ss == StandardsStatus.DEPRECATED;
        }
        catch (FHIRException e) {
            return false;
        }
    }

    public static boolean isInactive(CodeSystem cs, CodeSystem.ConceptDefinitionComponent def, boolean ignoreStatus) {
        try {
            for (CodeSystem.ConceptPropertyComponent p : def.getProperty()) {
                if (!ignoreStatus && "status".equals(p.getCode()) && p.hasValue() && p.hasValueCodeType() && "inactive".equals(p.getValueCodeType().getCode())) {
                    return true;
                }
                if (!"inactive".equals(p.getCode()) || !p.hasValue() || !(p.getValue() instanceof BooleanType)) continue;
                return (Boolean)((BooleanType)p.getValue()).getValue();
            }
            return false;
        }
        catch (FHIRException e) {
            return false;
        }
    }

    public static void setDeprecated(CodeSystem cs, CodeSystem.ConceptDefinitionComponent concept, DateTimeType date) throws FHIRFormatError {
        CodeSystemUtilities.setStatus(cs, concept, ConceptStatus.Deprecated);
        CodeSystemUtilities.defineDeprecatedProperty(cs);
        concept.addProperty().setCode("deprecationDate").setValue(date);
    }

    public static void setDeprecated(CodeSystem cs, CodeSystem.ConceptDefinitionComponent concept) throws FHIRFormatError {
        CodeSystemUtilities.setStatus(cs, concept, ConceptStatus.Deprecated);
    }

    public static boolean isInactive(CodeSystem cs, CodeSystem.ConceptDefinitionComponent def) throws FHIRException {
        for (CodeSystem.ConceptPropertyComponent p : def.getProperty()) {
            if ("status".equals(p.getCode()) && p.hasValueStringType()) {
                return "inactive".equals(p.getValueStringType().primitiveValue()) || "retired".equals(p.getValueStringType().primitiveValue());
            }
            if (!"inactive".equals(p.getCode()) || !p.hasValueBooleanType()) continue;
            return (Boolean)p.getValueBooleanType().getValue();
        }
        return false;
    }

    public static boolean isInactive(CodeSystem cs, String code) throws FHIRException {
        CodeSystem.ConceptDefinitionComponent def = CodeSystemUtilities.findCode(cs.getConcept(), code);
        if (def == null) {
            return true;
        }
        return CodeSystemUtilities.isInactive(cs, def);
    }

    public static void defineCodeSystemProperty(CodeSystem cs, String code, String description, CodeSystem.PropertyType type) {
        for (CodeSystem.PropertyComponent p : cs.getProperty()) {
            if (!p.getCode().equals(code)) continue;
            return;
        }
        cs.addProperty().setCode(code).setDescription(description).setType(type).setUri("http://hl7.org/fhir/concept-properties#" + code);
    }

    public static String getCodeDefinition(CodeSystem cs, String code) {
        return CodeSystemUtilities.getCodeDefinition(cs.getConcept(), code);
    }

    private static String getCodeDefinition(List<CodeSystem.ConceptDefinitionComponent> list, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (c.hasCode() && c.getCode().equals(code)) {
                return c.getDefinition();
            }
            String s2 = CodeSystemUtilities.getCodeDefinition(c.getConcept(), code);
            if (s2 == null) continue;
            return s2;
        }
        return null;
    }

    public static CodeSystem makeShareable(CodeSystem cs) {
        if (!cs.hasExperimental()) {
            cs.setExperimental(false);
        }
        if (!cs.hasMeta()) {
            cs.setMeta(new Meta());
        }
        for (UriType uriType : cs.getMeta().getProfile()) {
            if (!"http://hl7.org/fhir/StructureDefinition/shareablecodesystem".equals(uriType.getValue())) continue;
            return cs;
        }
        cs.getMeta().getProfile().add(new CanonicalType("http://hl7.org/fhir/StructureDefinition/shareablecodesystem"));
        return cs;
    }

    public static boolean makeCSShareable(CodeSystem cs) {
        if (!cs.hasMeta()) {
            cs.setMeta(new Meta());
        }
        for (UriType uriType : cs.getMeta().getProfile()) {
            if (!"http://hl7.org/fhir/StructureDefinition/shareablecodesystem".equals(uriType.getValue())) continue;
            return false;
        }
        cs.getMeta().getProfile().add(new CanonicalType("http://hl7.org/fhir/StructureDefinition/shareablecodesystem"));
        return true;
    }

    public static void setOID(CodeSystem cs, String oid) {
        if (!((String)oid).startsWith("urn:oid:")) {
            oid = "urn:oid:" + (String)oid;
        }
        if (!cs.hasIdentifier()) {
            cs.addIdentifier(new Identifier().setSystem("urn:ietf:rfc:3986").setValue((String)oid));
        } else if ("urn:ietf:rfc:3986".equals(cs.getIdentifierFirstRep().getSystem()) && cs.getIdentifierFirstRep().hasValue() && cs.getIdentifierFirstRep().getValue().startsWith("urn:oid:")) {
            cs.getIdentifierFirstRep().setValue((String)oid);
        } else {
            throw new Error("unable to set OID on code system");
        }
    }

    public static boolean hasOID(CanonicalResource cs) {
        return CodeSystemUtilities.getOID(cs) != null;
    }

    public static String getOID(CanonicalResource cs) {
        if (cs.hasIdentifier() && "urn:ietf:rfc:3986".equals(cs.getIdentifierFirstRep().getSystem()) && cs.getIdentifierFirstRep().hasValue() && cs.getIdentifierFirstRep().getValue().startsWith("urn:oid:")) {
            return cs.getIdentifierFirstRep().getValue().substring(8);
        }
        return null;
    }

    public static CodeSystem.ConceptDefinitionComponent findCode(List<CodeSystem.ConceptDefinitionComponent> list, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (c.getCode().equals(code)) {
                return c;
            }
            CodeSystem.ConceptDefinitionComponent s2 = CodeSystemUtilities.findCode(c.getConcept(), code);
            if (s2 == null) continue;
            return s2;
        }
        return null;
    }

    public static void markStatus(CodeSystem cs, String wg, StandardsStatus status, String pckage, String fmm, String normativeVersion) throws FHIRException {
        if (wg != null && (!ToolingExtensions.hasExtension(cs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg") || Utilities.existsInList(ToolingExtensions.readStringExtension(cs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg"), "fhir", "vocab") && !Utilities.existsInList(wg, "fhir", "vocab"))) {
            ToolingExtensions.setCodeExtension(cs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg", wg);
        }
        if (status != null) {
            StandardsStatus ss = ToolingExtensions.getStandardsStatus(cs);
            if (ss == null || ss.isLowerThan(status)) {
                ToolingExtensions.setStandardsStatus(cs, status, normativeVersion);
            }
            if (pckage != null) {
                if (!cs.hasUserData("ballot.package")) {
                    cs.setUserData("ballot.package", pckage);
                } else if (!pckage.equals(cs.getUserString("ballot.package")) && !"infrastructure".equals(cs.getUserString("ballot.package"))) {
                    System.out.println("Code System " + cs.getUrl() + ": ownership clash " + pckage + " vs " + cs.getUserString("ballot.package"));
                }
            }
            if (status == StandardsStatus.NORMATIVE) {
                cs.setExperimental(false);
                cs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            }
        }
        if (fmm != null) {
            String sfmm = ToolingExtensions.readStringExtension(cs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm");
            if (Utilities.noString(sfmm) || Integer.parseInt(sfmm) < Integer.parseInt(fmm)) {
                ToolingExtensions.setIntegerExtension(cs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm", Integer.parseInt(fmm));
            }
            if (Integer.parseInt(fmm) <= 1) {
                cs.setExperimental(true);
            }
        }
    }

    public static DataType readProperty(CodeSystem.ConceptDefinitionComponent concept, String code) {
        for (CodeSystem.ConceptPropertyComponent p : concept.getProperty()) {
            if (!p.getCode().equals(code)) continue;
            return p.getValue();
        }
        return null;
    }

    public static CodeSystem.ConceptPropertyComponent getProperty(CodeSystem.ConceptDefinitionComponent concept, String code) {
        for (CodeSystem.ConceptPropertyComponent p : concept.getProperty()) {
            if (!p.getCode().equals(code)) continue;
            return p;
        }
        return null;
    }

    public static List<CodeSystem.ConceptPropertyComponent> getPropertyValues(CodeSystem.ConceptDefinitionComponent concept, String code) {
        ArrayList<CodeSystem.ConceptPropertyComponent> res = new ArrayList<CodeSystem.ConceptPropertyComponent>();
        for (CodeSystem.ConceptPropertyComponent p : concept.getProperty()) {
            if (!p.getCode().equals(code)) continue;
            res.add(p);
        }
        return res;
    }

    public static List<String> getOtherChildren(CodeSystem cs, CodeSystem.ConceptDefinitionComponent c) {
        ArrayList<String> res = new ArrayList<String>();
        for (CodeSystem.ConceptPropertyComponent p : c.getProperty()) {
            if (!"parent".equals(p.getCode())) continue;
            res.add(p.getValue().primitiveValue());
        }
        return res;
    }

    public static void addOtherChild(CodeSystem cs, CodeSystem.ConceptDefinitionComponent owner, String code) {
        CodeSystemUtilities.defineChildProperty(cs);
        owner.addProperty().setCode("child").setValue(new CodeType(code));
    }

    public static boolean hasProperty(CodeSystem.ConceptDefinitionComponent c, String code) {
        for (CodeSystem.ConceptPropertyComponent cp : c.getProperty()) {
            if (!code.equals(cp.getCode())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCode(CodeSystem cs, String code) {
        for (CodeSystem.ConceptDefinitionComponent cc : cs.getConcept()) {
            if (!CodeSystemUtilities.hasCode(cc, code)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCode(CodeSystem.ConceptDefinitionComponent cc, String code) {
        if (code.equals(cc.getCode())) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent c : cc.getConcept()) {
            if (!CodeSystemUtilities.hasCode(c, code)) continue;
            return true;
        }
        return false;
    }

    public static CodeSystem.ConceptDefinitionComponent getCode(CodeSystem cs, String code) {
        if (code == null) {
            return null;
        }
        for (CodeSystem.ConceptDefinitionComponent cc : cs.getConcept()) {
            CodeSystem.ConceptDefinitionComponent cd2 = CodeSystemUtilities.getCode(cc, code);
            if (cd2 == null) continue;
            return cd2;
        }
        return null;
    }

    private static CodeSystem.ConceptDefinitionComponent getCode(CodeSystem.ConceptDefinitionComponent cc, String code) {
        if (code.equals(cc.getCode())) {
            return cc;
        }
        for (CodeSystem.ConceptDefinitionComponent c : cc.getConcept()) {
            CodeSystem.ConceptDefinitionComponent cd2 = CodeSystemUtilities.getCode(c, code);
            if (cd2 == null) continue;
            return cd2;
        }
        return null;
    }

    public static void crossLinkCodeSystem(CodeSystem cs) {
        String parent = CodeSystemUtilities.getPropertyByUrl(cs, "http://hl7.org/fhir/concept-properties#parent");
        if (parent != null) {
            CodeSystemUtilities.crossLinkConcepts(cs.getConcept(), cs.getConcept(), parent);
        }
    }

    private static String getPropertyByUrl(CodeSystem cs, String url) {
        for (CodeSystem.PropertyComponent pc : cs.getProperty()) {
            if (!url.equals(pc.getUri())) continue;
            return pc.getCode();
        }
        return null;
    }

    private static void crossLinkConcepts(List<CodeSystem.ConceptDefinitionComponent> root, List<CodeSystem.ConceptDefinitionComponent> focus, String parent) {
        for (CodeSystem.ConceptDefinitionComponent def : focus) {
            List<CodeSystem.ConceptPropertyComponent> pcl = CodeSystemUtilities.getPropertyValues(def, parent);
            for (CodeSystem.ConceptPropertyComponent pc : pcl) {
                String code = pc.getValue().primitiveValue();
                CodeSystem.ConceptDefinitionComponent tgt = CodeSystemUtilities.findCode(root, code);
                if (!tgt.hasUserData(USER_DATA_CROSS_LINK)) {
                    tgt.setUserData(USER_DATA_CROSS_LINK, new ArrayList());
                }
                List children = (List)tgt.getUserData(USER_DATA_CROSS_LINK);
                children.add(def);
            }
            if (!def.hasConcept()) continue;
            CodeSystemUtilities.crossLinkConcepts(root, def.getConcept(), parent);
        }
    }

    public static boolean hasHierarchy(CodeSystem cs) {
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            if (!c.hasConcept()) continue;
            return true;
        }
        return false;
    }

    public static void sortAllCodes(CodeSystem cs) {
        CodeSystemUtilities.sortAllCodes(cs.getConcept());
    }

    private static void sortAllCodes(List<CodeSystem.ConceptDefinitionComponent> list) {
        Collections.sort(list, new ConceptDefinitionComponentSorter());
        for (CodeSystem.ConceptDefinitionComponent cd2 : list) {
            if (!cd2.hasConcept()) continue;
            CodeSystemUtilities.sortAllCodes(cd2.getConcept());
        }
    }

    public static Coding readCoding(String jurisdiction) {
        return jurisdiction == null || !jurisdiction.contains("#") ? null : new Coding().setCode(jurisdiction.substring(jurisdiction.indexOf("#") + 1)).setSystem(jurisdiction.substring(0, jurisdiction.indexOf("#")));
    }

    public static SystemReference getSystemReference(String system, IWorkerContext ctxt) {
        if (system == null) {
            return null;
        }
        if ("http://snomed.info/sct".equals(system)) {
            return new SystemReference("SNOMED CT", "https://browser.ihtsdotools.org/");
        }
        if ("http://loinc.org".equals(system)) {
            return new SystemReference("LOINC", "https://loinc.org/");
        }
        if ("http://unitsofmeasure.org".equals(system)) {
            return new SystemReference("UCUM", "http://ucum.org");
        }
        if (system.equals("http://www.nlm.nih.gov/research/umls/rxnorm")) {
            return new SystemReference("RxNorm", "http://www.nlm.nih.gov/research/umls/rxnorm");
        }
        if (ctxt != null) {
            CodeSystem cs = ctxt.fetchCodeSystem(system);
            if (cs != null && cs.hasUserData("path")) {
                return new SystemReference(cs.present(), cs.getUserString("path"), Utilities.isAbsoluteUrl(cs.getUserString("path")));
            }
            if (cs != null) {
                return new SystemReference(cs.present(), null);
            }
        }
        return null;
    }

    public static boolean isNotCurrent(CodeSystem cs, CodeSystem.ConceptDefinitionComponent c) {
        return CodeSystemUtilities.isInactive(cs, c) || CodeSystemUtilities.isDeprecated(cs, c, false);
    }

    public static enum ConceptStatus {
        Active,
        Experimental,
        Deprecated,
        Retired;


        public String toCode() {
            switch (this) {
                case Active: {
                    return "active";
                }
                case Experimental: {
                    return "experimental";
                }
                case Deprecated: {
                    return "deprecated";
                }
                case Retired: {
                    return "retired";
                }
            }
            return null;
        }
    }

    public static class CodeSystemNavigator {
        private CodeSystem cs;
        private boolean restructure;
        private Set<String> processed = new HashSet<String>();

        public CodeSystemNavigator(CodeSystem cs) {
            this.cs = cs;
            this.restructure = this.hasExtraRelationships(cs.getConcept());
        }

        public boolean isRestructure() {
            return this.restructure;
        }

        private boolean hasExtraRelationships(List<CodeSystem.ConceptDefinitionComponent> concept) {
            for (CodeSystem.ConceptDefinitionComponent cd2 : concept) {
                if (!this.getSubsumedBy(cd2).isEmpty()) {
                    return true;
                }
                for (CodeSystem.ConceptDefinitionComponent cdc : cd2.getConcept()) {
                    if (!this.hasExtraRelationships(cdc.getConcept())) continue;
                    return true;
                }
            }
            return false;
        }

        public List<CodeSystem.ConceptDefinitionComponent> getConcepts(CodeSystem.ConceptDefinitionComponent context) {
            if (context == null) {
                if (this.restructure) {
                    ArrayList<CodeSystem.ConceptDefinitionComponent> res = new ArrayList<CodeSystem.ConceptDefinitionComponent>();
                    for (CodeSystem.ConceptDefinitionComponent cd2 : this.cs.getConcept()) {
                        if (!this.getSubsumedBy(cd2).isEmpty()) continue;
                        res.add(cd2);
                        this.processed.add(cd2.getCode());
                    }
                    return res;
                }
                return this.cs.getConcept();
            }
            if (this.restructure) {
                ArrayList<CodeSystem.ConceptDefinitionComponent> res = new ArrayList<CodeSystem.ConceptDefinitionComponent>();
                for (CodeSystem.ConceptDefinitionComponent cd3 : context.getConcept()) {
                    res.add(cd3);
                    this.processed.add(cd3.getCode());
                }
                for (CodeSystem.ConceptDefinitionComponent cd3 : this.cs.getConcept()) {
                    if (!this.getSubsumedBy(cd3).contains(context.getCode()) || this.processed.contains(cd3.getCode())) continue;
                    res.add(cd3);
                    this.processed.add(cd3.getCode());
                }
                return res;
            }
            return context.getConcept();
        }

        private List<String> getSubsumedBy(CodeSystem.ConceptDefinitionComponent cd2) {
            ArrayList<String> codes = new ArrayList<String>();
            for (CodeSystem.ConceptPropertyComponent cp : cd2.getProperty()) {
                if (!"subsumedBy".equals(cp.getCode())) continue;
                codes.add(cp.getValue().primitiveValue());
            }
            return codes;
        }

        public List<CodeSystem.ConceptDefinitionComponent> getOtherChildren(CodeSystem.ConceptDefinitionComponent context) {
            ArrayList<CodeSystem.ConceptDefinitionComponent> res = new ArrayList<CodeSystem.ConceptDefinitionComponent>();
            for (CodeSystem.ConceptDefinitionComponent cd2 : this.cs.getConcept()) {
                if (!this.getSubsumedBy(cd2).contains(context.getCode()) || !this.processed.contains(cd2.getCode())) continue;
                res.add(cd2);
            }
            return res;
        }
    }

    public static class ConceptDefinitionComponentSorter
    implements Comparator<CodeSystem.ConceptDefinitionComponent> {
        @Override
        public int compare(CodeSystem.ConceptDefinitionComponent o1, CodeSystem.ConceptDefinitionComponent o2) {
            return o1.getCode().compareToIgnoreCase(o2.getCode());
        }
    }

    public static class SystemReference {
        private String link;
        private String text;
        private boolean local;

        public SystemReference(String text, String link) {
            this.link = link;
            this.text = text;
        }

        public SystemReference(String text, String link, boolean local) {
            this.link = link;
            this.text = text;
            this.local = local;
        }

        public String getLink() {
            return this.link;
        }

        public String getText() {
            return this.text;
        }

        public boolean isLocal() {
            return this.local;
        }
    }
}

