/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.spreadsheets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.FontFormatting;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PatternFormatting;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.renderers.spreadsheets.CanonicalSpreadsheetGenerator;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTAutoFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCustomFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCustomFilters;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFilterColumn;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFilters;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STFilterOperator;

public class StructureDefinitionSpreadsheetGenerator
extends CanonicalSpreadsheetGenerator {
    private XmlParser xml = new XmlParser();
    private JsonParser json = new JsonParser();
    private boolean asXml;
    private boolean hideMustSupportFalse;
    private List<StructureDefinition.StructureDefinitionMappingComponent> mapKeys = new ArrayList<StructureDefinition.StructureDefinitionMappingComponent>();
    private static String[] titles = new String[]{"ID", "Path", "Slice Name", "Alias(s)", "Label", "Min", "Max", "Must Support?", "Is Modifier?", "Is Summary?", "Type(s)", "Short", "Definition", "Comments", "Requirements", "Default Value", "Meaning When Missing", "Fixed Value", "Pattern", "Example", "Minimum Value", "Maximum Value", "Maximum Length", "Binding Strength", "Binding Description", "Binding Value Set", "Code", "Slicing Discriminator", "Slicing Description", "Slicing Ordered", "Slicing Rules", "Base Path", "Base Min", "Base Max", "Condition(s)", "Constraint(s)"};

    public StructureDefinitionSpreadsheetGenerator(IWorkerContext context, boolean valuesAsXml, boolean hideMustSupportFalse) {
        super(context);
        this.asXml = valuesAsXml;
        this.hideMustSupportFalse = hideMustSupportFalse;
    }

    public StructureDefinitionSpreadsheetGenerator renderStructureDefinition(StructureDefinition sd, boolean forMultiple) throws Exception {
        Sheet sheet;
        if (sd == null) {
            System.out.println("no structure!");
        }
        if (!sd.hasSnapshot()) {
            throw new DefinitionException(this.context.formatMessage("needs_a_snapshot", new Object[0]));
        }
        this.addStructureDefinitionMetadata(this.renderCanonicalResource(sd, forMultiple), sd);
        Sheet sheet2 = sheet = forMultiple && this.hasSheet("Elements") ? this.getSheet("Elements") : this.makeSheet("Elements");
        if (sheet.getLastRowNum() == 0) {
            int i2;
            Row headerRow = sheet.createRow(0);
            int coffset = forMultiple ? 1 : 0;
            for (i2 = 0; i2 < titles.length; ++i2) {
                if (forMultiple) {
                    this.addCell(headerRow, 0, "Structure.ID", (CellStyle)this.styles.get("header"));
                }
                this.addCell(headerRow, i2 + coffset, titles[i2], (CellStyle)this.styles.get("header"));
            }
            if (!forMultiple) {
                i2 = titles.length - 1;
                for (StructureDefinition.StructureDefinitionMappingComponent map : sd.getMapping()) {
                    this.addCell(headerRow, ++i2 + coffset, "Mapping: " + map.getName(), (CellStyle)this.styles.get("header"));
                }
            }
        }
        for (ElementDefinition child : sd.getSnapshot().getElement()) {
            this.processElement(sheet, sd, child, forMultiple);
        }
        if (!forMultiple) {
            this.configureSheet(sheet, sd);
        }
        return this;
    }

    public StructureDefinitionSpreadsheetGenerator configure() throws Exception {
        Sheet sheet = this.hasSheet("Elements") ? this.getSheet("Elements") : this.makeSheet("Elements");
        this.configureSheet(sheet, null);
        return this;
    }

    private void addStructureDefinitionMetadata(Sheet sheet, StructureDefinition sd) {
        for (Coding coding : sd.getKeyword()) {
            this.addMetadataRow(sheet, "Keyword", this.dr.display(coding));
        }
        this.addMetadataRow(sheet, "FHIR Version", sd.getFhirVersionElement().asStringValue());
        this.addMetadataRow(sheet, "Kind", sd.getKindElement().asStringValue());
        this.addMetadataRow(sheet, "Type", sd.getType());
        this.addMetadataRow(sheet, "Base Definition", sd.getBaseDefinition());
        this.addMetadataRow(sheet, "Abstract", sd.getAbstractElement().asStringValue());
        this.addMetadataRow(sheet, "Derivation", sd.getDerivationElement().asStringValue());
        for (StructureDefinition.StructureDefinitionContextComponent structureDefinitionContextComponent : sd.getContext()) {
            this.addMetadataRow(sheet, "Context", structureDefinitionContextComponent.getTypeElement().asStringValue() + ":" + structureDefinitionContextComponent.getExpression());
        }
        for (StringType stringType : sd.getContextInvariant()) {
            this.addMetadataRow(sheet, "Context Inv.", (String)stringType.getValue());
        }
    }

    public void processElement(Sheet sheet, StructureDefinition sd, ElementDefinition ed, boolean forMultiple) throws Exception {
        Row row = sheet.createRow(sheet.getLastRowNum() + 1);
        int i2 = 0;
        if (forMultiple) {
            this.addCell(row, i2++, sd.getId(), (CellStyle)this.styles.get("body"));
        }
        this.addCell(row, i2++, ed.getId(), (CellStyle)this.styles.get("body"));
        this.addCell(row, i2++, ed.getPath());
        this.addCell(row, i2++, ed.getSliceName());
        this.addCell(row, i2++, this.itemList(ed.getAlias()));
        this.addCell(row, i2++, ed.getLabel());
        this.addCell(row, i2++, ed.getMin());
        this.addCell(row, i2++, ed.getMax());
        this.addCell(row, i2++, ed.getMustSupport() ? "Y" : "");
        this.addCell(row, i2++, ed.getIsModifier() ? "Y" : "");
        this.addCell(row, i2++, ed.getIsSummary() ? "Y" : "");
        this.addCell(row, i2++, this.itemList(ed.getType()));
        this.addCell(row, i2++, ed.getShort());
        this.addCell(row, i2++, ed.getDefinition());
        this.addCell(row, i2++, ed.getComment());
        this.addCell(row, i2++, ed.getRequirements());
        this.addCell(row, i2++, ed.getDefaultValue() != null ? this.renderType(ed.getDefaultValue()) : "");
        this.addCell(row, i2++, ed.getMeaningWhenMissing());
        this.addCell(row, i2++, ed.hasFixed() ? this.renderType(ed.getFixed()) : "");
        this.addCell(row, i2++, ed.hasPattern() ? this.renderType(ed.getPattern()) : "");
        this.addCell(row, i2++, ed.hasExample() ? this.renderType(ed.getExample().get(0).getValue()) : "");
        this.addCell(row, i2++, ed.hasMinValue() ? this.renderType(ed.getMinValue()) : "");
        this.addCell(row, i2++, ed.hasMaxValue() ? this.renderType(ed.getMaxValue()) : "");
        this.addCell(row, i2++, ed.hasMaxLength() ? Integer.toString(ed.getMaxLength()) : "");
        if (ed.hasBinding()) {
            this.addCell(row, i2++, ed.getBinding().getStrength() != null ? ed.getBinding().getStrength().toCode() : "");
            this.addCell(row, i2++, ed.getBinding().getDescription());
            if (ed.getBinding().getValueSet() == null) {
                this.addCell(row, i2++, "");
            } else {
                this.addCell(row, i2++, ed.getBinding().getValueSet());
            }
        } else {
            this.addCell(row, i2++, "");
            this.addCell(row, i2++, "");
            this.addCell(row, i2++, "");
        }
        this.addCell(row, i2++, this.itemList(ed.getCode()));
        if (ed.hasSlicing()) {
            this.addCell(row, i2++, this.itemList(ed.getSlicing().getDiscriminator()));
            this.addCell(row, i2++, ed.getSlicing().getDescription());
            this.addCell(row, i2++, ed.getSlicing().getOrdered());
            this.addCell(row, i2++, ed.getSlicing().getRules() != null ? ed.getSlicing().getRules().toCode() : "");
        } else {
            this.addCell(row, i2++, "");
            this.addCell(row, i2++, "");
            this.addCell(row, i2++, "");
            this.addCell(row, i2++, "");
        }
        if (ed.getBase() != null) {
            this.addCell(row, i2++, ed.getBase().getPath());
            this.addCell(row, i2++, ed.getBase().getMin());
            this.addCell(row, i2++, ed.getBase().getMax());
        } else {
            this.addCell(row, i2++, "");
            this.addCell(row, i2++, "");
            this.addCell(row, i2++, "");
        }
        this.addCell(row, i2++, this.itemList(ed.getCondition()));
        this.addCell(row, i2++, this.itemList(ed.getConstraint()));
        if (!forMultiple) {
            for (StructureDefinition.StructureDefinitionMappingComponent mapKey : sd.getMapping()) {
                String mapString = "";
                for (ElementDefinition.ElementDefinitionMappingComponent map : ed.getMapping()) {
                    if (!map.getIdentity().equals(mapKey.getIdentity())) continue;
                    mapString = map.getMap();
                }
                this.addCell(row, i2++, mapString);
            }
        }
    }

    private String itemList(List l) {
        StringBuilder s2 = new StringBuilder();
        for (int i2 = 0; i2 < l.size(); ++i2) {
            Element c;
            Element t;
            Object o = l.get(i2);
            Object val = "";
            if (o instanceof StringType) {
                val = (String)((StringType)o).getValue();
            } else if (o instanceof UriType) {
                val = (String)((UriType)o).getValue();
            } else if (o instanceof IdType) {
                val = ((IdType)o).getValue();
            } else if (o instanceof java.util.Enumeration) {
                val = o.toString();
            } else if (o instanceof ElementDefinition.TypeRefComponent) {
                t = (ElementDefinition.TypeRefComponent)o;
                val = ((ElementDefinition.TypeRefComponent)t).getWorkingCode();
                if (val == null) {
                    val = "";
                }
                if (((String)val).startsWith("http://hl7.org/fhir/StructureDefinition/")) {
                    val = ((String)val).substring(40);
                }
                if (((ElementDefinition.TypeRefComponent)t).hasTargetProfile()) {
                    val = (String)val + "(" + this.canonicalList(((ElementDefinition.TypeRefComponent)t).getTargetProfile()) + ")";
                }
                if (((ElementDefinition.TypeRefComponent)t).hasProfile()) {
                    val = (String)val + " {" + this.canonicalList(((ElementDefinition.TypeRefComponent)t).getProfile()) + "}";
                }
                if (((ElementDefinition.TypeRefComponent)t).hasAggregation()) {
                    val = (String)val + " <<" + this.aggList(((ElementDefinition.TypeRefComponent)t).getAggregation()) + ">>";
                }
            } else if (o instanceof Coding) {
                t = (Coding)o;
                val = (((Coding)t).getSystem() == null ? "" : ((Coding)t).getSystem()) + (String)(((Coding)t).getCode() == null ? "" : "#" + ((Coding)t).getCode()) + (String)(((Coding)t).getDisplay() == null ? "" : " (" + ((Coding)t).getDisplay() + ")");
            } else if (o instanceof ElementDefinition.ElementDefinitionConstraintComponent) {
                c = (ElementDefinition.ElementDefinitionConstraintComponent)o;
                val = ((ElementDefinition.ElementDefinitionConstraintComponent)c).getKey() + ":" + ((ElementDefinition.ElementDefinitionConstraintComponent)c).getHuman() + " {" + ((ElementDefinition.ElementDefinitionConstraintComponent)c).getExpression() + "}";
            } else if (o instanceof ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent) {
                c = (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent)o;
                val = ((ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent)c).getType().toCode() + ":" + ((ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent)c).getPath() + "}";
            } else {
                val = o.toString();
                val = ((String)val).substring(((String)val).indexOf("[") + 1);
                val = ((String)val).substring(0, ((String)val).indexOf("]"));
            }
            s2 = s2.append((String)val);
            if (i2 != 0) continue;
            s2.append("\n");
        }
        return s2.toString();
    }

    private String aggList(List<Enumeration<ElementDefinition.AggregationMode>> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (Enumeration<ElementDefinition.AggregationMode> c : list) {
            b.append(((ElementDefinition.AggregationMode)((Object)c.getValue())).toCode());
        }
        return b.toString();
    }

    private String canonicalList(List<CanonicalType> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder("|");
        for (CanonicalType c : list) {
            String v = (String)c.getValue();
            if (v.startsWith("http://hl7.org/fhir/StructureDefinition/")) {
                v = v.substring(40);
            }
            b.append(v);
        }
        return b.toString();
    }

    private String renderType(DataType value) throws Exception {
        if (value == null) {
            return "";
        }
        if (value.isPrimitive()) {
            return value.primitiveValue();
        }
        String s2 = null;
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        if (this.asXml) {
            this.xml.setOutputStyle(IParser.OutputStyle.PRETTY);
            this.xml.compose((OutputStream)bs, "", value);
            bs.close();
            s2 = bs.toString();
            s2 = s2.substring(s2.indexOf("\n") + 2);
        } else {
            this.json.setOutputStyle(IParser.OutputStyle.PRETTY);
            this.json.compose(bs, value, "");
            bs.close();
            s2 = bs.toString();
        }
        return s2;
    }

    public void configureSheet(Sheet sheet, StructureDefinition sd) throws IOException {
        int i2;
        for (i2 = 0; i2 < 34; ++i2) {
            sheet.autoSizeColumn(i2);
        }
        sheet.setColumnHidden(2, true);
        sheet.setColumnHidden(3, true);
        sheet.setColumnHidden(30, true);
        sheet.setColumnHidden(31, true);
        sheet.setColumnHidden(32, true);
        sheet.setColumnWidth(9, this.columnPixels(20.0));
        sheet.setColumnWidth(11, this.columnPixels(100.0));
        sheet.setColumnWidth(12, this.columnPixels(100.0));
        sheet.setColumnWidth(13, this.columnPixels(100.0));
        sheet.setColumnWidth(15, this.columnPixels(20.0));
        sheet.setColumnWidth(16, this.columnPixels(20.0));
        sheet.setColumnWidth(17, this.columnPixels(20.0));
        sheet.setColumnWidth(18, this.columnPixels(20.0));
        sheet.setColumnWidth(34, this.columnPixels(100.0));
        if (sd != null) {
            i2 = titles.length - 1;
            for (StructureDefinition.StructureDefinitionMappingComponent map : sd.getMapping()) {
                sheet.setColumnWidth(++i2, this.columnPixels(50.0));
                sheet.autoSizeColumn(i2);
            }
        }
        sheet.createFreezePane(2, 1);
        if (this.hideMustSupportFalse) {
            SheetConditionalFormatting sheetCF = sheet.getSheetConditionalFormatting();
            String address = "A2:AI" + Math.max(sheet.getLastRowNum(), 2);
            CellRangeAddress[] regions = new CellRangeAddress[]{CellRangeAddress.valueOf((String)address)};
            ConditionalFormattingRule rule1 = sheetCF.createConditionalFormattingRule("$G2<>\"Y\"");
            PatternFormatting fill1 = rule1.createPatternFormatting();
            fill1.setFillBackgroundColor(IndexedColors.GREY_25_PERCENT.index);
            fill1.setFillPattern((short)1);
            ConditionalFormattingRule rule2 = sheetCF.createConditionalFormattingRule("$Q2<>\"\"");
            FontFormatting font = rule2.createFontFormatting();
            font.setFontColorIndex(IndexedColors.GREY_25_PERCENT.index);
            font.setFontStyle(true, false);
            sheetCF.addConditionalFormatting(regions, rule1, rule2);
            sheet.setAutoFilter(new CellRangeAddress(0, sheet.getLastRowNum(), 0, titles.length + (sd == null ? 0 : sd.getMapping().size() - 1)));
            XSSFSheet xSheet = (XSSFSheet)sheet;
            CTAutoFilter sheetFilter = xSheet.getCTWorksheet().getAutoFilter();
            CTFilterColumn filterColumn1 = sheetFilter.addNewFilterColumn();
            filterColumn1.setColId(6L);
            CTCustomFilters filters = filterColumn1.addNewCustomFilters();
            CTCustomFilter filter1 = filters.addNewCustomFilter();
            filter1.setOperator(STFilterOperator.NOT_EQUAL);
            filter1.setVal(" ");
            CTFilterColumn filterColumn2 = sheetFilter.addNewFilterColumn();
            filterColumn2.setColId(26L);
            CTFilters filters2 = filterColumn2.addNewFilters();
            filters2.setBlank(true);
            for (Row row : sheet) {
                if (row.getRowNum() <= 0 || row.getCell(6).getStringCellValue().equals("Y") && row.getCell(26).getStringCellValue().isEmpty()) continue;
                ((XSSFRow)row).getCTRow().setHidden(true);
            }
        }
        sheet.setActiveCell(new CellAddress(sheet.getRow(1).getCell(0)));
    }
}

