/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.spreadsheets;

import java.io.IOException;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.spreadsheets.CanonicalSpreadsheetGenerator;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;

public class CodeSystemSpreadsheetGenerator
extends CanonicalSpreadsheetGenerator {
    public CodeSystemSpreadsheetGenerator(IWorkerContext context) {
        super(context);
    }

    public boolean canGenerate(CodeSystem cs) {
        return true;
    }

    public CodeSystemSpreadsheetGenerator renderCodeSystem(CodeSystem cs) throws IOException {
        if (cs == null) {
            System.out.println("no code system!");
        }
        this.addCodeSystemMetadata(this.renderCanonicalResource(cs, false), cs);
        if (cs.hasProperty()) {
            this.addProperties(cs.getProperty());
        }
        if (cs.hasFilter()) {
            this.addFilters(cs.getFilter());
        }
        if (cs.hasConcept()) {
            this.addConcepts(cs.getConcept());
        }
        return this;
    }

    private void addCodeSystemMetadata(Sheet sheet, CodeSystem cs) {
        this.addMetadataRow(sheet, "Case Sensitive", cs.getCaseSensitiveElement().asStringValue());
        this.addMetadataRow(sheet, "Value Set (all codes)", cs.getValueSet());
        this.addMetadataRow(sheet, "Hierarchy", cs.getHierarchyMeaningElement().asStringValue());
        this.addMetadataRow(sheet, "Compositional", cs.getCompositionalElement().asStringValue());
        this.addMetadataRow(sheet, "Version Needed?", cs.getVersionNeededElement().asStringValue());
        this.addMetadataRow(sheet, "Content", cs.getContentElement().asStringValue());
        this.addMetadataRow(sheet, "Supplements", cs.getSupplements());
        this.addMetadataRow(sheet, "Count", cs.getCountElement().asStringValue());
    }

    private void addFilters(List<CodeSystem.CodeSystemFilterComponent> filters) {
        Sheet sheet = this.makeSheet("Filters");
        this.addHeaders(sheet, "Code", "Description", "Operators", "Value");
        for (CodeSystem.CodeSystemFilterComponent f : filters) {
            CommaSeparatedStringBuilder cs = new CommaSeparatedStringBuilder();
            for (Enumeration<Enumerations.FilterOperator> op : f.getOperator()) {
                cs.append(op.asStringValue());
            }
            this.addRow(sheet, f.getCode(), f.getDescription(), cs.toString(), f.getValue());
        }
    }

    private void addProperties(List<CodeSystem.PropertyComponent> properties) {
        Sheet sheet = this.makeSheet("Properties");
        this.addHeaders(sheet, "Code", "Uri", "Description", "Type");
        for (CodeSystem.PropertyComponent p : properties) {
            this.addRow(sheet, p.getCode(), p.getUri(), p.getDescription(), p.getTypeElement().asStringValue());
        }
    }

    private void addConcepts(List<CodeSystem.ConceptDefinitionComponent> concepts) {
        Sheet sheet = this.makeSheet("Concepts");
        this.addHeaders(sheet, "Level", "Code", "Display", "Definition");
        this.addConcepts(sheet, 1, concepts);
    }

    private void addConcepts(Sheet sheet, int i2, List<CodeSystem.ConceptDefinitionComponent> concepts) {
        for (CodeSystem.ConceptDefinitionComponent c : concepts) {
            this.addRow(sheet, Integer.toString(i2), c.getCode(), c.getDisplay(), c.getDefinition());
            if (!c.hasConcept()) continue;
            this.addConcepts(sheet, i2 + 1, c.getConcept());
        }
    }

    private void genExpansionParams(List<ValueSet.ValueSetExpansionParameterComponent> params) {
        Sheet sheet = this.makeSheet("Expansion Parameters");
        this.addHeaders(sheet, "Parameter", "Value");
        for (ValueSet.ValueSetExpansionParameterComponent p : params) {
            this.addRow(sheet, p.getName(), this.dr.display(p.getValue()));
        }
    }

    private void genExpansion(List<ValueSet.ValueSetExpansionContainsComponent> list) {
        Sheet sheet = this.makeSheet("Expansion");
        this.addHeaders(sheet, "Level", "System", "version", "Code", "Display", "Abstract", "Inactive");
        this.genExpansionEntry(1, list, sheet);
    }

    public void genExpansionEntry(int level, List<ValueSet.ValueSetExpansionContainsComponent> list, Sheet sheet) {
        for (ValueSet.ValueSetExpansionContainsComponent p : list) {
            this.addRow(sheet, Integer.toString(level), p.getSystem(), p.getVersion(), p.getCode(), p.getDisplay(), this.bool(p.getAbstract()), this.bool(p.getInactive()));
            if (!p.hasContains()) continue;
            this.genExpansionEntry(level + 1, p.getContains(), sheet);
        }
    }

    private String bool(boolean value) {
        return value ? "" : "false";
    }

    private void addAllCodes(Sheet sheet) {
        this.addHeaders(sheet, "Codes");
        this.addRow(sheet, "All codes");
    }

    private void addValueSets(Sheet sheet, List<CanonicalType> valueSets) {
        this.addHeaders(sheet, "ValueSet URL");
        for (CanonicalType u : valueSets) {
            this.addRow(sheet, (String)u.getValue());
        }
    }

    private void configureSheet(Sheet sheet) {
        sheet.setColumnWidth(0, this.columnPixels(30.0));
        sheet.setColumnWidth(1, this.columnPixels(40.0));
        sheet.setColumnWidth(1, this.columnPixels(50.0));
    }

    private void addConcepts(Sheet sheet, List<ValueSet.ConceptReferenceComponent> concepts) {
        this.addHeaders(sheet, "Concept", "Description");
        for (ValueSet.ConceptReferenceComponent cd2 : concepts) {
            this.addRow(sheet, cd2.getCode(), cd2.getDisplay());
        }
    }

    private void addFilters(Sheet sheet, List<ValueSet.ConceptSetFilterComponent> filters) {
        this.addHeaders(sheet, "Property", "Operation", "Value");
        for (ValueSet.ConceptSetFilterComponent f : filters) {
            this.addRow(sheet, f.getProperty(), f.getOpElement().asStringValue(), f.getValue());
        }
    }
}

