/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class QuestionnaireResponseRenderer
extends ResourceRenderer {
    public QuestionnaireResponseRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public boolean render(XhtmlNode x, Resource q) throws UnsupportedEncodingException, IOException {
        return this.render(x, (QuestionnaireResponse)q);
    }

    public boolean render(XhtmlNode x, QuestionnaireResponse q) throws UnsupportedEncodingException, IOException {
        switch (this.context.getQuestionnaireMode()) {
            case FORM: {
                return this.renderForm(x, q);
            }
            case LINKS: {
                return this.renderLinks(x, q);
            }
            case TREE: {
                return this.renderTree(x, q);
            }
        }
        throw new Error("Unknown QuestionnaireResponse Renderer Mode");
    }

    @Override
    public boolean render(XhtmlNode x, BaseWrappers.ResourceWrapper qr) throws UnsupportedEncodingException, IOException {
        switch (this.context.getQuestionnaireMode()) {
            case FORM: {
                return this.renderTree(x, qr);
            }
            case LINKS: {
                return this.renderLinks(x, qr);
            }
            case TREE: {
                return this.renderTree(x, qr);
            }
        }
        throw new Error("Unknown QuestionnaireResponse Renderer Mode");
    }

    public boolean renderTree(XhtmlNode x, BaseWrappers.ResourceWrapper qr) throws UnsupportedEncodingException, IOException {
        HierarchicalTableGenerator gen;
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator(this.context.getDestDir(), this.context.isInlineGraphics(), true);
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = hierarchicalTableGenerator.new HierarchicalTableGenerator.TableModel("qtree=" + qr.getId(), false);
        model.setAlternating(true);
        model.setDocoImg(this.context.getLink(RenderingContext.KnownLinkType.SPEC) + "help16.png");
        model.setDocoRef(this.context.getLink(RenderingContext.KnownLinkType.SPEC) + "formats.html#table");
        List<HierarchicalTableGenerator.Title> list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(hierarchicalTableGenerator2.new HierarchicalTableGenerator.Title(null, model.getDocoRef(), this.translate("sd.head", "LinkId"), this.translate("sd.hint", "The linkId for the item"), null, 0));
        List<HierarchicalTableGenerator.Title> list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(hierarchicalTableGenerator3.new HierarchicalTableGenerator.Title(null, model.getDocoRef(), this.translate("sd.head", "Text"), this.translate("sd.hint", "Text for the item"), null, 0));
        List<HierarchicalTableGenerator.Title> list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list3.add(hierarchicalTableGenerator4.new HierarchicalTableGenerator.Title(null, model.getDocoRef(), this.translate("sd.head", "Definition"), this.translate("sd.hint", "Minimum and Maximum # of times the the itemcan appear in the instance"), null, 0));
        List<HierarchicalTableGenerator.Title> list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list4.add(hierarchicalTableGenerator5.new HierarchicalTableGenerator.Title(null, model.getDocoRef(), this.translate("sd.head", "Answer"), this.translate("sd.hint", "The type of the item"), null, 0));
        boolean hasExt = false;
        HierarchicalTableGenerator.Row row = this.addTreeRoot(gen, model.getRows(), qr);
        List<BaseWrappers.BaseWrapper> items = qr.children("item");
        for (BaseWrappers.BaseWrapper i2 : items) {
            hasExt = this.renderTreeItem(gen, row.getSubRows(), qr, i2) || hasExt;
        }
        XhtmlNode xn = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.getChildNodes().add(xn);
        return hasExt;
    }

    public boolean renderTree(XhtmlNode x, QuestionnaireResponse q) throws UnsupportedEncodingException, IOException {
        HierarchicalTableGenerator gen;
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator(this.context.getDestDir(), this.context.isInlineGraphics(), true);
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = hierarchicalTableGenerator.new HierarchicalTableGenerator.TableModel("qtree=" + q.getId(), true);
        model.setAlternating(true);
        model.setDocoImg(this.context.getLink(RenderingContext.KnownLinkType.SPEC) + "help16.png");
        model.setDocoRef(this.context.getLink(RenderingContext.KnownLinkType.SPEC) + "formats.html#table");
        List<HierarchicalTableGenerator.Title> list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(hierarchicalTableGenerator2.new HierarchicalTableGenerator.Title(null, model.getDocoRef(), this.translate("sd.head", "LinkId"), this.translate("sd.hint", "The linkId for the item"), null, 0));
        List<HierarchicalTableGenerator.Title> list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(hierarchicalTableGenerator3.new HierarchicalTableGenerator.Title(null, model.getDocoRef(), this.translate("sd.head", "Text"), this.translate("sd.hint", "Text for the item"), null, 0));
        List<HierarchicalTableGenerator.Title> list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list3.add(hierarchicalTableGenerator4.new HierarchicalTableGenerator.Title(null, model.getDocoRef(), this.translate("sd.head", "Definition"), this.translate("sd.hint", "Minimum and Maximum # of times the the itemcan appear in the instance"), null, 0));
        List<HierarchicalTableGenerator.Title> list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list4.add(hierarchicalTableGenerator5.new HierarchicalTableGenerator.Title(null, model.getDocoRef(), this.translate("sd.head", "Answer"), this.translate("sd.hint", "The type of the item"), null, 0));
        boolean hasExt = false;
        HierarchicalTableGenerator.Row row = this.addTreeRoot(gen, model.getRows(), q);
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent i2 : q.getItem()) {
            hasExt = this.renderTreeItem(gen, row.getSubRows(), q, i2) || hasExt;
        }
        XhtmlNode xn = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.getChildNodes().add(xn);
        return hasExt;
    }

    private HierarchicalTableGenerator.Row addTreeRoot(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, QuestionnaireResponse q) throws IOException {
        HierarchicalTableGenerator.Row r = gen.new HierarchicalTableGenerator.Row();
        rows.add(r);
        r.setIcon("icon_q_root.gif", "QuestionnaireResponseRoot");
        List<HierarchicalTableGenerator.Cell> list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(hierarchicalTableGenerator.new HierarchicalTableGenerator.Cell(null, null, q.getId(), null, null));
        List<HierarchicalTableGenerator.Cell> list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(hierarchicalTableGenerator2.new HierarchicalTableGenerator.Cell(null, null, "", null, null));
        List<HierarchicalTableGenerator.Cell> list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(hierarchicalTableGenerator3.new HierarchicalTableGenerator.Cell(null, null, "QuestionnaireResponse", null, null));
        List<HierarchicalTableGenerator.Cell> list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(hierarchicalTableGenerator4.new HierarchicalTableGenerator.Cell(null, null, "", null, null));
        return r;
    }

    private HierarchicalTableGenerator.Row addTreeRoot(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, BaseWrappers.ResourceWrapper q) throws IOException {
        HierarchicalTableGenerator.Row r = gen.new HierarchicalTableGenerator.Row();
        rows.add(r);
        r.setIcon("icon_q_root.gif", "QuestionnaireResponseRoot");
        List<HierarchicalTableGenerator.Cell> list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(hierarchicalTableGenerator.new HierarchicalTableGenerator.Cell(null, null, q.getId(), null, null));
        List<HierarchicalTableGenerator.Cell> list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(hierarchicalTableGenerator2.new HierarchicalTableGenerator.Cell(null, null, "", null, null));
        List<HierarchicalTableGenerator.Cell> list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(hierarchicalTableGenerator3.new HierarchicalTableGenerator.Cell(null, null, "QuestionnaireResponse", null, null));
        List<HierarchicalTableGenerator.Cell> list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(hierarchicalTableGenerator4.new HierarchicalTableGenerator.Cell(null, null, "", null, null));
        return r;
    }

    private boolean renderTreeItem(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, BaseWrappers.ResourceWrapper q, BaseWrappers.BaseWrapper i2) throws IOException {
        boolean hasExt;
        block9: {
            String text;
            List<BaseWrappers.BaseWrapper> answers;
            HierarchicalTableGenerator.Row r;
            block8: {
                boolean hasItem;
                r = gen.new HierarchicalTableGenerator.Row();
                rows.add(r);
                hasExt = false;
                List<BaseWrappers.BaseWrapper> items = i2.children("item");
                answers = i2.children("answer");
                boolean bl = hasItem = items != null && !items.isEmpty();
                if (answers != null) {
                    for (BaseWrappers.BaseWrapper a : answers) {
                        hasItem = a.has("item");
                    }
                }
                if (hasItem) {
                    r.setIcon("icon-q-group.png", "Group");
                } else {
                    r.setIcon("icon-q-string.png", "Item");
                }
                String linkId = i2.has("linkId") ? i2.get("linkId").primitiveValue() : "??";
                text = i2.has("text") ? i2.get("text").primitiveValue() : "";
                List<HierarchicalTableGenerator.Cell> list = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(hierarchicalTableGenerator.new HierarchicalTableGenerator.Cell(null, (String)(this.context.getDefinitionsTarget() == null ? "" : this.context.getDefinitionsTarget() + "#item." + linkId), linkId, null, null));
                List<HierarchicalTableGenerator.Cell> list2 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator2);
                list2.add(hierarchicalTableGenerator2.new HierarchicalTableGenerator.Cell(null, null, text, null, null));
                List<HierarchicalTableGenerator.Cell> list3 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator3);
                list3.add(hierarchicalTableGenerator3.new HierarchicalTableGenerator.Cell(null, null, null, null, null));
                if (answers != null && answers.size() != 0) break block8;
                List<HierarchicalTableGenerator.Cell> list4 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator4);
                list4.add(hierarchicalTableGenerator4.new HierarchicalTableGenerator.Cell(null, null, null, null, null));
                if (items == null) break block9;
                for (BaseWrappers.BaseWrapper si : items) {
                    this.renderTreeItem(gen, r.getSubRows(), q, si);
                }
                break block9;
            }
            if (answers.size() == 1) {
                BaseWrappers.BaseWrapper ans = answers.get(0);
                this.renderAnswer(gen, q, r, ans);
            } else {
                List<HierarchicalTableGenerator.Cell> list = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(hierarchicalTableGenerator.new HierarchicalTableGenerator.Cell(null, null, null, null, null));
                for (BaseWrappers.BaseWrapper ans : answers) {
                    HierarchicalTableGenerator.Row ar = gen.new HierarchicalTableGenerator.Row();
                    ar.setIcon("icon-q-string.png", "Item");
                    ar.getSubRows().add(ar);
                    List<HierarchicalTableGenerator.Cell> list5 = ar.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator5);
                    list5.add(hierarchicalTableGenerator5.new HierarchicalTableGenerator.Cell(null, null, null, null, null));
                    List<HierarchicalTableGenerator.Cell> list6 = ar.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator6);
                    list6.add(hierarchicalTableGenerator6.new HierarchicalTableGenerator.Cell(null, null, text, null, null));
                    List<HierarchicalTableGenerator.Cell> list7 = ar.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator7);
                    list7.add(hierarchicalTableGenerator7.new HierarchicalTableGenerator.Cell(null, null, null, null, null));
                    this.renderAnswer(gen, q, ar, ans);
                }
            }
        }
        return hasExt;
    }

    public void renderAnswer(HierarchicalTableGenerator gen, BaseWrappers.ResourceWrapper q, HierarchicalTableGenerator.Row r, BaseWrappers.BaseWrapper ans) throws UnsupportedEncodingException, IOException {
        Base b = ans.get("value[x]");
        if (b == null) {
            List<HierarchicalTableGenerator.Cell> list = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(hierarchicalTableGenerator.new HierarchicalTableGenerator.Cell(null, null, "null!", null, null));
        } else if (b.isPrimitive()) {
            List<HierarchicalTableGenerator.Cell> list = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(hierarchicalTableGenerator.new HierarchicalTableGenerator.Cell(null, null, b.primitiveValue(), null, null));
        } else {
            XhtmlNode x = new XhtmlNode(NodeType.Element, "span");
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            HierarchicalTableGenerator.Cell cell = hierarchicalTableGenerator.new HierarchicalTableGenerator.Cell(null, null, null, null, null);
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            HierarchicalTableGenerator.Piece p = hierarchicalTableGenerator2.new HierarchicalTableGenerator.Piece("span");
            p.getChildren().add(x);
            cell.addPiece(p);
            this.render(x, (DataType)b);
            r.getCells().add(cell);
        }
        List<BaseWrappers.BaseWrapper> items = ans.children("item");
        for (BaseWrappers.BaseWrapper si : items) {
            this.renderTreeItem(gen, r.getSubRows(), q, si);
        }
    }

    private boolean renderTreeItem(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, QuestionnaireResponse q, QuestionnaireResponse.QuestionnaireResponseItemComponent i2) throws IOException {
        HierarchicalTableGenerator.Row r = gen.new HierarchicalTableGenerator.Row();
        rows.add(r);
        boolean hasExt = false;
        boolean hasItem = i2.hasItem();
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent a : i2.getAnswer()) {
            hasItem = a.hasItem();
        }
        if (hasItem) {
            r.setIcon("icon-q-group.png", "Group");
        } else {
            r.setIcon("icon-q-string.png", "Item");
        }
        List<HierarchicalTableGenerator.Cell> list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(hierarchicalTableGenerator.new HierarchicalTableGenerator.Cell(null, (String)(this.context.getDefinitionsTarget() == null ? "" : this.context.getDefinitionsTarget() + "#item." + i2.getLinkId()), i2.getLinkId(), null, null));
        List<HierarchicalTableGenerator.Cell> list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(hierarchicalTableGenerator2.new HierarchicalTableGenerator.Cell(null, null, i2.getText(), null, null));
        List<HierarchicalTableGenerator.Cell> list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(hierarchicalTableGenerator3.new HierarchicalTableGenerator.Cell(null, null, null, null, null));
        List<HierarchicalTableGenerator.Cell> list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(hierarchicalTableGenerator4.new HierarchicalTableGenerator.Cell(null, null, null, null, null));
        return hasExt;
    }

    public void genDefinitionLink(HierarchicalTableGenerator gen, QuestionnaireResponse.QuestionnaireResponseItemComponent i2, HierarchicalTableGenerator.Cell defn, Resource src) {
        StructureDefinition sd;
        String path = null;
        String d = i2.getDefinition();
        if (d.contains("#")) {
            path = d.substring(d.indexOf("#") + 1);
            d = d.substring(0, d.indexOf("#"));
        }
        if ((sd = this.context.getWorker().fetchResource(StructureDefinition.class, d, src)) != null) {
            String url = sd.getUserString("path");
            if (url != null) {
                List<HierarchicalTableGenerator.Piece> list = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(hierarchicalTableGenerator.new HierarchicalTableGenerator.Piece(url + "#" + path, path, null));
            } else {
                List<HierarchicalTableGenerator.Piece> list = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(hierarchicalTableGenerator.new HierarchicalTableGenerator.Piece(null, i2.getDefinition(), null));
            }
        } else {
            List<HierarchicalTableGenerator.Piece> list = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(hierarchicalTableGenerator.new HierarchicalTableGenerator.Piece(null, i2.getDefinition(), null));
        }
    }

    public void genDefinitionLink(XhtmlNode x, QuestionnaireResponse.QuestionnaireResponseItemComponent i2, Resource src) {
        StructureDefinition sd;
        String path = null;
        String d = i2.getDefinition();
        if (d.contains("#")) {
            path = d.substring(d.indexOf("#") + 1);
            d = d.substring(0, d.indexOf("#"));
        }
        if ((sd = this.context.getWorker().fetchResource(StructureDefinition.class, d, src)) != null) {
            String url = sd.getUserString("path");
            if (url != null) {
                x.ah(url + "#" + path).tx(path);
            } else {
                x.tx(i2.getDefinition());
            }
        } else {
            x.tx(i2.getDefinition());
        }
    }

    private void addExpression(HierarchicalTableGenerator.Piece p, Expression exp, String label, String url) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "li").style("font-size: 11px");
        p.addHtml(x);
        x.ah(url).tx(label);
        x.tx(": ");
        x.code(exp.getExpression());
    }

    public boolean renderForm(XhtmlNode x, QuestionnaireResponse q) throws UnsupportedEncodingException, IOException {
        boolean hasExt = false;
        return false;
    }

    public boolean renderForm(XhtmlNode x, BaseWrappers.ResourceWrapper q) throws UnsupportedEncodingException, IOException {
        boolean hasExt = false;
        XhtmlNode d = x.div();
        d.tx("todo");
        return hasExt;
    }

    private boolean renderLinks(XhtmlNode x, QuestionnaireResponse q) {
        x.para().tx("Try this QuestionnaireResponse out:");
        XhtmlNode ul = x.ul();
        ul.li().ah("http://todo.nlm.gov/path?mode=ig&src=" + Utilities.pathURL(this.context.getLink(RenderingContext.KnownLinkType.SELF), "package.tgz") + "&q=" + q.getId() + ".json").tx("NLM Forms Library");
        return false;
    }

    private boolean renderLinks(XhtmlNode x, BaseWrappers.ResourceWrapper q) {
        x.para().tx("Try this QuestionnaireResponse out:");
        XhtmlNode ul = x.ul();
        ul.li().ah("http://todo.nlm.gov/path?mode=ig&src=" + Utilities.pathURL(this.context.getLink(RenderingContext.KnownLinkType.SELF), "package.tgz") + "&q=" + q.getId() + ".json").tx("NLM Forms Library");
        return false;
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return "todo";
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return "Not done yet";
    }
}

