/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class PatientRenderer
extends ResourceRenderer {
    private static final int MAX_IMAGE_LENGTH = 0x200000;

    public PatientRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws UnsupportedEncodingException, IOException {
        this.describe(x, dr);
        return false;
    }

    @Override
    public String display(Resource dr) {
        Patient pat = (Patient)dr;
        Identifier id = null;
        for (Identifier t : pat.getIdentifier()) {
            id = this.chooseId(id, t);
        }
        HumanName n = null;
        for (HumanName t : pat.getName()) {
            n = this.chooseName(n, t);
        }
        return this.display(n, pat.hasGender() ? pat.getGender().getDisplay() : null, pat.getBirthDateElement(), id);
    }

    private Identifier chooseId(Identifier oldId, Identifier newId) {
        if (oldId == null) {
            return newId;
        }
        if (newId == null) {
            return oldId;
        }
        return this.isPreferred(newId.getUse(), oldId.getUse()) ? newId : oldId;
    }

    private boolean isPreferred(Identifier.IdentifierUse newUse, Identifier.IdentifierUse oldUse) {
        if (newUse == null && oldUse == null || newUse == oldUse) {
            return false;
        }
        if (newUse == null) {
            return true;
        }
        switch (newUse) {
            case NULL: {
                return !this.existsInList(oldUse, Identifier.IdentifierUse.OFFICIAL, Identifier.IdentifierUse.USUAL);
            }
            case OFFICIAL: {
                return !this.existsInList(oldUse, Identifier.IdentifierUse.USUAL);
            }
            case OLD: {
                return !this.existsInList(oldUse, Identifier.IdentifierUse.OFFICIAL, Identifier.IdentifierUse.SECONDARY, Identifier.IdentifierUse.USUAL);
            }
            case SECONDARY: {
                return !this.existsInList(oldUse, Identifier.IdentifierUse.OFFICIAL, Identifier.IdentifierUse.USUAL);
            }
            case TEMP: {
                return !this.existsInList(oldUse, Identifier.IdentifierUse.OFFICIAL, Identifier.IdentifierUse.SECONDARY, Identifier.IdentifierUse.USUAL);
            }
            case USUAL: {
                return true;
            }
        }
        return false;
    }

    private boolean existsInList(Identifier.IdentifierUse oldUse, Identifier.IdentifierUse ... values) {
        for (Identifier.IdentifierUse value : values) {
            if (value != oldUse) continue;
            return true;
        }
        return false;
    }

    private HumanName chooseName(HumanName oldName, HumanName newName) {
        if (oldName == null) {
            return newName;
        }
        if (newName == null) {
            return oldName;
        }
        return this.isPreferred(newName.getUse(), oldName.getUse()) ? newName : oldName;
    }

    private boolean isPreferred(HumanName.NameUse newUse, HumanName.NameUse oldUse) {
        if (newUse == null && oldUse == null || newUse == oldUse) {
            return false;
        }
        if (newUse == null) {
            return true;
        }
        if (oldUse == null) {
            return this.existsInList(newUse, HumanName.NameUse.OFFICIAL, HumanName.NameUse.USUAL);
        }
        switch (oldUse) {
            case ANONYMOUS: {
                return this.existsInList(newUse, HumanName.NameUse.OFFICIAL, HumanName.NameUse.USUAL);
            }
            case MAIDEN: {
                return this.existsInList(newUse, HumanName.NameUse.OFFICIAL, HumanName.NameUse.USUAL);
            }
            case NICKNAME: {
                return this.existsInList(newUse, HumanName.NameUse.OFFICIAL, HumanName.NameUse.USUAL);
            }
            case NULL: {
                return this.existsInList(newUse, HumanName.NameUse.OFFICIAL, HumanName.NameUse.USUAL);
            }
            case OFFICIAL: {
                return this.existsInList(newUse, HumanName.NameUse.USUAL);
            }
            case OLD: {
                return this.existsInList(newUse, HumanName.NameUse.OFFICIAL, HumanName.NameUse.USUAL);
            }
            case TEMP: {
                return this.existsInList(newUse, HumanName.NameUse.OFFICIAL, HumanName.NameUse.USUAL);
            }
            case USUAL: {
                return false;
            }
        }
        return false;
    }

    private boolean existsInList(HumanName.NameUse oldUse, HumanName.NameUse ... values) {
        for (HumanName.NameUse value : values) {
            if (value != oldUse) continue;
            return true;
        }
        return false;
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper pat) throws UnsupportedEncodingException, IOException {
        Identifier id = null;
        BaseWrappers.PropertyWrapper pw = this.getProperty(pat, "identifier");
        for (BaseWrappers.BaseWrapper baseWrapper : pw.getValues()) {
            id = this.chooseId(id, (Identifier)baseWrapper.getBase());
        }
        pw = this.getProperty(pat, "name");
        HumanName n = null;
        for (BaseWrappers.BaseWrapper t : pw.getValues()) {
            n = this.chooseName(n, (HumanName)((Object)t));
        }
        String string = null;
        pw = this.getProperty(pat, "gender");
        if (this.valued(pw)) {
            pw.value().getBase().primitiveValue();
        }
        DateType dt = null;
        pw = this.getProperty(pat, "birthDate");
        if (this.valued(pw)) {
            dt = (DateType)pw.value().getBase();
        }
        return this.display(n, string, dt, id);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void describe(XhtmlNode x, BaseWrappers.ResourceWrapper pat) throws UnsupportedEncodingException, IOException {
        void var6_10;
        Identifier id = null;
        BaseWrappers.PropertyWrapper pw = this.getProperty(pat, "identifier");
        for (BaseWrappers.BaseWrapper baseWrapper : pw.getValues()) {
            id = this.chooseId(id, (Identifier)baseWrapper.getBase());
        }
        pw = this.getProperty(pat, "name");
        HumanName n = null;
        for (BaseWrappers.BaseWrapper t : pw.getValues()) {
            n = this.chooseName(n, (HumanName)t.getBase());
        }
        Object var6_8 = null;
        pw = this.getProperty(pat, "gender");
        if (this.valued(pw)) {
            String string = pw.value().getBase().primitiveValue();
        }
        DateType dt = null;
        pw = this.getProperty(pat, "birthDate");
        if (this.valued(pw)) {
            dt = (DateType)pw.value().getBase();
        }
        this.describe(x, n, (String)var6_10, dt, id);
    }

    private String display(HumanName name, String gender, DateType dob, Identifier id) {
        StringBuilder b = new StringBuilder();
        b.append(this.display(name));
        b.append(" ");
        if (dob == null) {
            b.append("(no stated gender)");
        } else {
            b.append(gender);
        }
        b.append(", ");
        if (dob == null) {
            b.append("DoB Unknown");
        } else {
            b.append("DoB: " + this.display(dob));
        }
        if (id != null) {
            b.append(" ( ");
            b.append(this.display(id));
            b.append(")");
        }
        return b.toString();
    }

    public void describe(XhtmlNode x, HumanName name, String gender, DateType dob, Identifier id) throws UnsupportedEncodingException, IOException {
        if (name == null) {
            x.b().tx("Anonymous Patient");
        } else {
            this.render(x.b(), name);
        }
        x.tx(" ");
        if (gender == null) {
            x.tx("(no stated gender)");
        } else {
            x.tx(gender);
        }
        x.tx(", ");
        if (dob == null) {
            x.tx("DoB Unknown");
        } else {
            x.tx("DoB: ");
            this.render(x, dob);
        }
        if (id != null) {
            x.tx(" ( ");
            this.render(x, id);
            x.tx(")");
        }
    }

    @Override
    public boolean render(XhtmlNode x, BaseWrappers.ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode tbl;
        this.describe(this.makeBanner(x.para()), r);
        x.hr();
        if (this.hasRenderablePhoto(r)) {
            tbl = x.table("none");
            XhtmlNode tr = tbl.tr();
            tbl = tr.td().table("grid");
            this.renderPhoto(tr.td(), r);
        } else {
            tbl = x.table("grid");
        }
        this.addStatus(tbl, r);
        this.addIdentifiers(tbl, r);
        this.addNames(tbl, r);
        this.addComms(tbl, r);
        this.addLangs(tbl, r);
        this.addNOKs(tbl, r);
        this.addLinks(tbl, r);
        this.addExtensions(tbl, r);
        if (tbl.isEmpty()) {
            x.remove(tbl);
        }
        return false;
    }

    private void addExtensions(XhtmlNode tbl, BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, FHIRException, IOException {
        HashMap extensions = new HashMap();
        BaseWrappers.PropertyWrapper pw = this.getProperty(r, "extension");
        for (BaseWrappers.BaseWrapper t : pw.getValues()) {
            Extension ext = (Extension)t.getBase();
            if (!extensions.containsKey(ext.getUrl())) {
                extensions.put(ext.getUrl(), new ArrayList());
            }
            ((List)extensions.get(ext.getUrl())).add(ext);
        }
        for (String url : extensions.keySet()) {
            StructureDefinition sd = this.context.getWorker().fetchResource(StructureDefinition.class, url);
            if (sd == null) continue;
            List list = (List)extensions.get(url);
            boolean anyComplex = false;
            for (Extension ext : list) {
                anyComplex = anyComplex || ext.hasExtension();
            }
            if (!anyComplex) {
                XhtmlNode tr = tbl.tr();
                this.nameCell(tr, sd.getTitle() + ":", sd.getDescription(), sd.getUserString("path"));
                XhtmlNode td = tr.td();
                td.colspan("3");
                if (list.size() == 1) {
                    XhtmlNode ul = td.ul();
                    for (Extension s2 : list) {
                        XhtmlNode li = ul.li();
                        this.render(r, li, s2.getValue());
                    }
                    continue;
                }
                this.render(r, td, ((Extension)list.get(0)).getValue());
                continue;
            }
            for (Extension ext : list) {
                XhtmlNode tr = tbl.tr();
                this.nameCell(tr, sd.getTitle() + ":", sd.getDescription());
                XhtmlNode td = tr.td();
                td.colspan("3");
                if (ext.hasExtension()) {
                    XhtmlNode ul = td.ul();
                    for (Extension s3 : ext.getExtension()) {
                        XhtmlNode li = ul.li();
                        li.tx(s3.getUrl() + ": ");
                        if (s3.hasExtension()) {
                            boolean first = true;
                            for (Extension t : s3.getExtension()) {
                                if (first) {
                                    first = false;
                                } else {
                                    li.tx("; ");
                                }
                                li.tx(t.getUrl() + "=");
                                this.render(r, li, t.getValue());
                            }
                            continue;
                        }
                        this.render(r, li, s3.getValue());
                    }
                    continue;
                }
                this.render(r, td, ext.getValue());
            }
        }
    }

    private void addIdentifiers(XhtmlNode tbl, BaseWrappers.ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode td;
        ArrayList<Identifier> ids = new ArrayList<Identifier>();
        BaseWrappers.PropertyWrapper pw = this.getProperty(r, "identifier");
        for (BaseWrappers.BaseWrapper baseWrapper : pw.getValues()) {
            ids.add((Identifier)baseWrapper.getBase());
        }
        Identifier id = null;
        for (Identifier i2 : ids) {
            id = this.chooseId(id, i2);
        }
        if (id != null) {
            ids.remove(id);
        }
        if (ids.size() == 1) {
            XhtmlNode xhtmlNode = tbl.tr();
            this.nameCell(xhtmlNode, "Other Id:", "Other Ids (see the one above)");
            td = xhtmlNode.td();
            td.colspan("3");
            this.render(r, td, (DataType)ids.get(0));
        } else if (ids.size() > 1) {
            XhtmlNode xhtmlNode = tbl.tr();
            this.nameCell(xhtmlNode, "Other Ids:", "Other Ids (see the one above)");
            td = xhtmlNode.td();
            td.colspan("3");
            XhtmlNode ul = td.ul();
            for (Identifier i3 : ids) {
                this.render(r, ul.li(), (DataType)i3);
            }
        }
    }

    private void addLangs(XhtmlNode tbl, BaseWrappers.ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode td;
        XhtmlNode tr;
        ArrayList<CodeableConcept> langs = new ArrayList<CodeableConcept>();
        BaseWrappers.PropertyWrapper pw = this.getProperty(r, "communication");
        CodeableConcept prefLang = null;
        for (BaseWrappers.BaseWrapper t : pw.getValues()) {
            BaseWrappers.PropertyWrapper l = this.getProperty(t, "language");
            if (l == null || !l.hasValues()) continue;
            CodeableConcept lang = (CodeableConcept)l.getValues().get(0).getBase();
            langs.add(lang);
            l = this.getProperty(t, "preferred");
            if (l == null || !l.hasValues() || !"true".equals(l.getValues().get(0).getBase().primitiveValue())) continue;
            prefLang = lang;
        }
        if (langs.size() == 1) {
            tr = tbl.tr();
            this.nameCell(tr, "Language:", "Languages spoken");
            td = tr.td();
            td.colspan("3");
            this.render(r, td, (DataType)langs.get(0));
            if (prefLang != null) {
                td.tx(" (preferred)");
            }
        } else if (langs.size() > 1) {
            tr = tbl.tr();
            this.nameCell(tr, "Languages:", "Languages spoken");
            td = tr.td();
            td.colspan("3");
            XhtmlNode ul = td.ul();
            for (CodeableConcept i2 : langs) {
                XhtmlNode li = ul.li();
                this.render(r, li, (DataType)i2);
                if (i2 != prefLang) continue;
                li.tx(" (preferred)");
            }
        }
    }

    private void addLinks(XhtmlNode tbl, BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, FHIRException, IOException {
        ArrayList<NamedReferance> refs = new ArrayList<NamedReferance>();
        BaseWrappers.PropertyWrapper pw = this.getProperty(r, "generalPractitioner");
        if (pw != null) {
            for (BaseWrappers.BaseWrapper t : pw.getValues()) {
                refs.add(new NamedReferance("General Practitioner", (Reference)t.getBase(), t));
            }
        }
        if ((pw = this.getProperty(r, "managingOrganization")) != null) {
            for (BaseWrappers.BaseWrapper t : pw.getValues()) {
                refs.add(new NamedReferance("Managing Organization", (Reference)t.getBase(), t));
            }
        }
        pw = this.getProperty(r, "link");
        for (BaseWrappers.BaseWrapper t : pw.getValues()) {
            BaseWrappers.PropertyWrapper l = this.getProperty(t, "other");
            Reference ref = null;
            BaseWrappers.BaseWrapper refw = null;
            for (BaseWrappers.BaseWrapper v : l.getValues()) {
                ref = (Reference)v.getBase();
                refw = v;
            }
            String type = null;
            l = this.getProperty(t, "type");
            for (BaseWrappers.BaseWrapper v : l.getValues()) {
                type = v.getBase().primitiveValue();
            }
            if (type == null || ref == null) continue;
            refs.add(new NamedReferance(this.describeLinkedRecord(type), ref, refw));
        }
        if (refs.size() > 0) {
            XhtmlNode tr = tbl.tr();
            this.nameCell(tr, "Links:", "Patient Links");
            XhtmlNode td = tr.td();
            td.colspan("3");
            XhtmlNode ul = td.ul();
            for (NamedReferance ref : refs) {
                XhtmlNode li = ul.li();
                li.tx(ref.getName());
                li.tx(": ");
                this.renderReference(r, li, ref.getReference());
            }
        }
    }

    private String describeLinkedRecord(String type) {
        switch (type) {
            case "replaced-by": {
                return "This record replaced by";
            }
            case "replaces": {
                return "This record replaces";
            }
            case "refer": {
                return "Please refer to";
            }
            case "seealso": {
                return "Also see";
            }
        }
        return "Unknown";
    }

    private void addNOKs(XhtmlNode tbl, BaseWrappers.ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException {
        BaseWrappers.PropertyWrapper pw = this.getProperty(r, "contact");
        for (BaseWrappers.BaseWrapper t : pw.getValues()) {
            this.addNOK(tbl, r, t);
        }
    }

    private void addNOK(XhtmlNode tbl, BaseWrappers.ResourceWrapper r, BaseWrappers.BaseWrapper bw) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode li;
        DataType v;
        ArrayList<CodeableConcept> rels = new ArrayList<CodeableConcept>();
        HumanName name = null;
        Address add = null;
        String gender = null;
        Period period = null;
        Reference organization = null;
        ArrayList<CodeableConcept> tels = new ArrayList<CodeableConcept>();
        BaseWrappers.PropertyWrapper pw = this.getProperty(bw, "relationship");
        for (BaseWrappers.BaseWrapper t : pw.getValues()) {
            v = (CodeableConcept)t.getBase();
            rels.add((CodeableConcept)v);
        }
        pw = this.getProperty(bw, "name");
        if (pw.hasValues()) {
            name = (HumanName)pw.getValues().get(0).getBase();
        }
        pw = this.getProperty(bw, "telecom");
        for (BaseWrappers.BaseWrapper t : pw.getValues()) {
            v = (ContactPoint)t.getBase();
            tels.add((CodeableConcept)v);
        }
        pw = this.getProperty(bw, "address");
        if (pw.hasValues()) {
            add = (Address)pw.getValues().get(0).getBase();
        }
        if ((pw = this.getProperty(bw, "gender")).hasValues()) {
            gender = pw.getValues().get(0).getBase().primitiveValue();
        }
        if ((pw = this.getProperty(bw, "organization")).hasValues()) {
            organization = (Reference)pw.getValues().get(0).getBase();
        }
        if ((pw = this.getProperty(bw, "period")).hasValues()) {
            period = (Period)pw.getValues().get(0).getBase();
        }
        if (rels.size() < 2 && name == null && add == null && gender == null && period == null && organization == null && tels.size() == 0) {
            return;
        }
        XhtmlNode tr = tbl.tr();
        if (rels.size() == 1) {
            this.nameCell(tr, (((CodeableConcept)rels.get(0)).getCodingFirstRep().hasDisplay() ? ((CodeableConcept)rels.get(0)).getCodingFirstRep().getDisplay() : this.display((DataType)rels.get(0))) + ":", "Nominated Contact: " + this.display((DataType)rels.get(0)));
        } else {
            this.nameCell(tr, "Contact", "Patient contact");
        }
        XhtmlNode td = tr.td();
        td.colspan("3");
        XhtmlNode ul = td.ul();
        if (name != null) {
            li = ul.li();
            this.render(r, li, (DataType)name);
            if (gender != null) {
                li.tx(" (" + gender + ")");
            }
        } else if (gender != null) {
            li = ul.li();
            li.tx("Gender: " + gender);
        }
        if (rels.size() > 1) {
            li = ul.li();
            li.tx("Relationships: ");
            boolean first = true;
            for (CodeableConcept rel : rels) {
                if (first) {
                    first = false;
                } else {
                    li.tx(", ");
                }
                this.render(r, li, (DataType)rel);
            }
        }
        if (add != null) {
            this.render(r, ul.li(), (DataType)add);
        }
        for (ContactPoint contactPoint : tels) {
            this.render(r, ul.li(), (DataType)contactPoint);
        }
        if (organization != null) {
            li = ul.li();
            li.tx("Organization: ");
            this.render(r, li, (DataType)organization);
        }
        if (period != null) {
            li = ul.li();
            li.tx("Valid Period: ");
            this.render(r, li, (DataType)period);
        }
    }

    private void addNames(XhtmlNode tbl, BaseWrappers.ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode td;
        ArrayList<HumanName> names = new ArrayList<HumanName>();
        BaseWrappers.PropertyWrapper pw = this.getProperty(r, "name");
        for (BaseWrappers.BaseWrapper baseWrapper : pw.getValues()) {
            names.add((HumanName)baseWrapper.getBase());
        }
        HumanName name = null;
        for (HumanName n : names) {
            name = this.chooseName(name, n);
        }
        if (name != null) {
            names.remove(name);
        }
        if (names.size() == 1) {
            XhtmlNode xhtmlNode = tbl.tr();
            this.nameCell(xhtmlNode, "Alt. Name:", "Alternate names (see the one above)");
            td = xhtmlNode.td();
            td.colspan("3");
            this.render(r, td, (DataType)names.get(0));
        } else if (names.size() > 1) {
            XhtmlNode xhtmlNode = tbl.tr();
            this.nameCell(xhtmlNode, "Alt Names:", "Alternate names (see the one above)");
            td = xhtmlNode.td();
            td.colspan("3");
            XhtmlNode ul = td.ul();
            for (HumanName n : names) {
                this.render(r, ul.li(), (DataType)n);
            }
        }
    }

    private void addComms(XhtmlNode tbl, BaseWrappers.ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode td;
        ArrayList<ContactPoint> tels = new ArrayList<ContactPoint>();
        BaseWrappers.PropertyWrapper pw = this.getProperty(r, "telecom");
        for (BaseWrappers.BaseWrapper baseWrapper : pw.getValues()) {
            tels.add((ContactPoint)baseWrapper.getBase());
        }
        ArrayList<Address> adds = new ArrayList<Address>();
        pw = this.getProperty(r, "address");
        for (BaseWrappers.BaseWrapper t : pw.getValues()) {
            adds.add((Address)t.getBase());
        }
        if (tels.size() + adds.size() == 1) {
            XhtmlNode xhtmlNode = tbl.tr();
            this.nameCell(xhtmlNode, "Contact Detail:", "Ways to contact the Patient");
            td = xhtmlNode.td();
            td.colspan("3");
            if (adds.isEmpty()) {
                this.render(r, td, (DataType)tels.get(0));
            } else {
                this.render(r, td, (DataType)adds.get(0));
            }
        } else if (tels.size() + adds.size() > 1) {
            XhtmlNode xhtmlNode = tbl.tr();
            this.nameCell(xhtmlNode, "Contact Details:", "Ways to contact the Patient");
            td = xhtmlNode.td();
            td.colspan("3");
            XhtmlNode ul = td.ul();
            for (ContactPoint contactPoint : tels) {
                this.render(r, ul.li(), (DataType)contactPoint);
            }
            for (Address address : adds) {
                this.render(r, ul.li(), (DataType)address);
            }
        }
    }

    private void addStatus(XhtmlNode tbl, BaseWrappers.ResourceWrapper r) throws FHIRFormatError, DefinitionException, UnsupportedEncodingException, FHIRException, IOException {
        int count = 0;
        if (r.has("active")) {
            ++count;
        }
        if (r.has("deceased")) {
            ++count;
        }
        if (r.has("maritalStatus")) {
            ++count;
        }
        if (r.has("multipleBirth")) {
            ++count;
        }
        if (count > 0) {
            XhtmlNode td;
            BaseWrappers.PropertyWrapper a;
            XhtmlNode tr = tbl.tr();
            int pos = 0;
            if (r.has("active") && (a = r.getChildByName("active")).hasValues()) {
                this.nameCell(tr, "Active:", "Record is active");
                td = tr.td();
                if (++pos == count) {
                    td.colspan("3");
                }
                this.render(r, td, (DataType)a.value().getBase());
            }
            if (r.has("deceased[x]") && (a = r.getChildByName("deceased[x]")).hasValues()) {
                this.nameCell(tr, "Deceased:", "Known status of Patient");
                td = tr.td();
                if (++pos == count) {
                    td.colspan("3");
                }
                this.render(r, td, (DataType)a.value().getBase());
            }
            if (r.has("maritalStatus") && (a = r.getChildByName("maritalStatus")).hasValues()) {
                if (++pos == 3) {
                    tr = tbl.tr();
                }
                this.nameCell(tr, "Marital Status:", "Known Marital status of Patient");
                td = tr.td();
                if (pos == count) {
                    td.colspan("3");
                }
                this.render(r, td, (DataType)a.value().getBase());
            }
            if (r.has("multipleBirth[x]") && (a = r.getChildByName("multipleBirth[x]")).hasValues()) {
                if (++pos == 3) {
                    tr = tbl.tr();
                }
                this.nameCell(tr, "Multiple Birth:", "Known multipleBirth status of Patient");
                td = tr.td();
                if (pos == count) {
                    td.colspan("3");
                }
                this.render(r, td, (DataType)a.value().getBase());
            }
        }
    }

    private void nameCell(XhtmlNode tr, String text, String title) {
        XhtmlNode td = tr.td();
        td.setAttribute("title", title);
        td.tx(text);
        td.style("background-color: #f3f5da");
    }

    private void nameCell(XhtmlNode tr, String text, String title, String link) {
        XhtmlNode td = tr.td();
        td.setAttribute("title", title);
        if (link != null) {
            td.ah(link).tx(text);
        } else {
            td.tx(text);
        }
        td.style("background-color: #f3f5da");
    }

    private void renderPhoto(XhtmlNode td, BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, FHIRException, IOException {
        if (r.has("photo")) {
            BaseWrappers.PropertyWrapper a = r.getChildByName("photo");
            for (BaseWrappers.BaseWrapper v : a.getValues()) {
                Attachment att = (Attachment)v.getBase();
                if (!att.getContentType().startsWith("image/") || att.getData() == null || this.context.isInlineGraphics() && (att.getData().length <= 0 || att.getData().length >= 0x200000)) continue;
                String ext = this.extensionForType(att.getContentType());
                if (this.context.isInlineGraphics() || Utilities.noString(this.context.getDestDir()) || ext == null) {
                    td.img("data:" + att.getContentType() + ";base64," + att.getDataElement().asStringValue(), "patient photo");
                } else {
                    String n = UUID.randomUUID().toString().toLowerCase() + ext;
                    TextFile.bytesToFile(att.getData(), new File(Utilities.path(this.context.getDestDir(), n)));
                    td.img(n, "patient photo");
                }
                return;
            }
        }
    }

    private String extensionForType(String contentType) {
        if (contentType.equals("image/gif")) {
            return ".gif";
        }
        if (contentType.equals("image/png")) {
            return ".png";
        }
        if (contentType.equals("image/jpeg")) {
            return ".jpg";
        }
        return null;
    }

    private boolean hasRenderablePhoto(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, FHIRException, IOException {
        if (r.has("photo")) {
            BaseWrappers.PropertyWrapper a = r.getChildByName("photo");
            for (BaseWrappers.BaseWrapper v : a.getValues()) {
                Attachment att = (Attachment)v.getBase();
                if (!att.hasContentType() || !att.getContentType().startsWith("image/") || att.getData() == null || this.context.isInlineGraphics() && (att.getData().length <= 0 || att.getData().length >= 0x200000)) continue;
                return true;
            }
        }
        return false;
    }

    private XhtmlNode makeBanner(XhtmlNode para) {
        para.style("border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;");
        return para;
    }

    public class NamedReferance {
        private String name;
        private Reference reference;
        private BaseWrappers.BaseWrapper wrapper;

        public NamedReferance(String name, Reference ref, BaseWrappers.BaseWrapper refw) {
            this.name = name;
            this.reference = ref;
            this.wrapper = refw;
        }

        public String getName() {
            return this.name;
        }

        public Reference getReference() {
            return this.reference;
        }

        public BaseWrappers.BaseWrapper getWrapper() {
            return this.wrapper;
        }
    }
}

