/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ParametersRenderer
extends ResourceRenderer {
    public ParametersRenderer(RenderingContext context) {
        super(context);
    }

    public ParametersRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        x.h2().tx("Parameters");
        XhtmlNode tbl = x.table("grid");
        this.params(tbl, ((Parameters)r).getParameter(), 0);
        return false;
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return null;
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return null;
    }

    @Override
    public boolean render(XhtmlNode x, BaseWrappers.ResourceWrapper params) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        x.h2().tx("Parameters");
        XhtmlNode tbl = x.table("grid");
        BaseWrappers.PropertyWrapper pw = this.getProperty(params, "parameter");
        if (this.valued(pw)) {
            this.paramsW(tbl, pw.getValues(), 0);
        }
        return false;
    }

    private void paramsW(XhtmlNode tbl, List<BaseWrappers.BaseWrapper> list, int indent) throws FHIRFormatError, DefinitionException, FHIRException, IOException, EOperationOutcome {
        for (BaseWrappers.BaseWrapper p : list) {
            XhtmlNode tr = tbl.tr();
            XhtmlNode td = tr.td();
            for (int i2 = 0; i2 < indent; ++i2) {
                td.tx(XhtmlNode.NBSP);
            }
            if (p.has("name")) {
                td.tx(p.get("name").primitiveValue());
            } else {
                td.tx("???");
            }
            if (p.has("value")) {
                this.renderBase(tr.td(), p.get("value"));
                continue;
            }
            if (p.has("resource")) {
                BaseWrappers.ResourceWrapper rw = p.getChildByName("resource").getAsResource();
                td = tr.td();
                XhtmlNode para = td.para();
                para.tx(rw.fhirType() + "/" + rw.getId());
                para.an(rw.fhirType() + "_" + rw.getId()).tx(" ");
                XhtmlNode x = rw.getNarrative();
                if (x != null) {
                    td.addChildren(x);
                    continue;
                }
                ResourceRenderer rr = RendererFactory.factory(rw, this.context, this.rcontext);
                rr.render(td, rw);
                continue;
            }
            if (!p.has("part")) continue;
            tr.td();
            BaseWrappers.PropertyWrapper pw = this.getProperty(p, "part");
            this.paramsW(tbl, pw.getValues(), 1);
        }
    }

    public XhtmlNode render(Parameters params) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        XhtmlNode div = new XhtmlNode(NodeType.Element, "div");
        div.h2().tx("Parameters");
        XhtmlNode tbl = div.table("grid");
        this.params(tbl, params.getParameter(), 0);
        return div;
    }

    private void params(XhtmlNode tbl, List<Parameters.ParametersParameterComponent> list, int indent) throws FHIRFormatError, DefinitionException, FHIRException, IOException, EOperationOutcome {
        for (Parameters.ParametersParameterComponent p : list) {
            XhtmlNode tr = tbl.tr();
            XhtmlNode td = tr.td();
            for (int i2 = 0; i2 < indent; ++i2) {
                td.tx(XhtmlNode.NBSP);
            }
            td.tx(p.getName());
            if (p.hasValue()) {
                this.render(tr.td(), p.getValue());
                continue;
            }
            if (p.hasResource()) {
                Resource r = p.getResource();
                td = tr.td();
                XhtmlNode para = td.para();
                para.tx(r.fhirType() + "/" + r.getId());
                para.an(r.fhirType() + "_" + r.getId()).tx(" ");
                ResourceRenderer rr = RendererFactory.factory(r, this.context);
                rr.render(td, r);
                continue;
            }
            if (!p.hasPart()) continue;
            tr.td();
            this.params(tbl, p.getPart(), 1);
        }
    }
}

