/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.profilemodel;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceFactory;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.profilemodel.PEDefinition;
import org.hl7.fhir.r5.profilemodel.PEDefinitionElement;
import org.hl7.fhir.r5.profilemodel.PEDefinitionExtension;
import org.hl7.fhir.r5.profilemodel.PEDefinitionResource;
import org.hl7.fhir.r5.profilemodel.PEDefinitionSlice;
import org.hl7.fhir.r5.profilemodel.PEDefinitionSubExtension;
import org.hl7.fhir.r5.profilemodel.PEDefinitionTypeSlice;
import org.hl7.fhir.r5.profilemodel.PEInstance;
import org.hl7.fhir.r5.profilemodel.PEType;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;

public class PEBuilder {
    private IWorkerContext context;
    private ProfileUtilities pu;
    private ContextUtilities cu;
    private PEElementPropertiesPolicy elementProps;
    private boolean fixedPropsDefault;
    private FHIRPathEngine fpe;

    public PEBuilder(IWorkerContext context, PEElementPropertiesPolicy elementProps, boolean fixedPropsDefault) {
        this.context = context;
        this.elementProps = elementProps;
        this.fixedPropsDefault = fixedPropsDefault;
        this.pu = new ProfileUtilities(context, null, null);
        this.cu = new ContextUtilities(context);
        this.fpe = new FHIRPathEngine(context, this.pu);
    }

    public PEDefinition buildPEDefinition(StructureDefinition profile) {
        if (!profile.hasSnapshot()) {
            throw new DefinitionException("Profile '" + profile.getVersionedUrl() + "' does not have a snapshot");
        }
        return new PEDefinitionResource(this, profile, profile.getName());
    }

    public PEDefinition buildPEDefinition(String url) {
        StructureDefinition profile = this.getProfile(url);
        if (profile == null) {
            throw new DefinitionException("Unable to find profile for URL '" + url + "'");
        }
        if (!profile.hasSnapshot()) {
            throw new DefinitionException("Profile '" + url + "' does not have a snapshot");
        }
        return new PEDefinitionResource(this, profile, profile.getName());
    }

    public PEDefinition buildPEDefinition(String url, String version) {
        StructureDefinition profile = this.getProfile(url, version);
        if (profile == null) {
            throw new DefinitionException("Unable to find profile for URL '" + url + "'");
        }
        if (!profile.hasSnapshot()) {
            throw new DefinitionException("Profile '" + url + "' does not have a snapshot");
        }
        return new PEDefinitionResource(this, profile, profile.getName());
    }

    public PEInstance buildPEInstance(String url, Resource resource) {
        PEDefinition defn = this.buildPEDefinition(url);
        return this.loadInstance(defn, resource);
    }

    public PEInstance buildPEInstance(StructureDefinition profile, Resource resource) {
        PEDefinition defn = this.buildPEDefinition(profile);
        return this.loadInstance(defn, resource);
    }

    public PEInstance buildPEInstance(String url, String version, Resource resource) {
        PEDefinition defn = this.buildPEDefinition(url, version);
        return this.loadInstance(defn, resource);
    }

    public Resource createResource(String url, String version, boolean meta) {
        PEDefinition definition = this.buildPEDefinition(url, version);
        Resource res = ResourceFactory.createResource(definition.types().get(0).getType());
        this.populateByProfile(res, definition);
        if (meta) {
            res.getMeta().addProfile(definition.profile.getUrl());
        }
        return res;
    }

    public Resource createResource(StructureDefinition profile, boolean meta) {
        PEDefinition definition = this.buildPEDefinition(profile);
        Resource res = ResourceFactory.createResource(definition.types().get(0).getType());
        this.populateByProfile(res, definition);
        if (meta) {
            res.getMeta().addProfile(definition.profile.getUrl());
        }
        return res;
    }

    public Resource createResource(String url, boolean meta) {
        PEDefinition definition = this.buildPEDefinition(url);
        Resource res = ResourceFactory.createResource(definition.types().get(0).getType());
        this.populateByProfile(res, definition);
        if (meta) {
            res.getMeta().addProfile(definition.profile.getUrl());
        }
        return res;
    }

    private StructureDefinition getProfile(String url) {
        return this.context.fetchResource(StructureDefinition.class, url);
    }

    private StructureDefinition getProfile(String url, String version) {
        return this.context.fetchResource(StructureDefinition.class, url, version);
    }

    protected List<PEDefinition> listChildren(boolean allFixed, PEDefinition parent, StructureDefinition profileStructure, ElementDefinition definition, String url, String ... omitList) {
        StructureDefinition profile = profileStructure;
        List<ElementDefinition> list = this.pu.getChildList(profile, definition);
        if (definition.getType().size() == 1 || !definition.getPath().contains(".") || list.isEmpty()) {
            assert (url == null || this.checkType(definition, url));
            ArrayList<PEDefinition> res = new ArrayList<PEDefinition>();
            if (list.size() == 0) {
                profile = this.context.fetchResource(StructureDefinition.class, url);
                list = this.pu.getChildList(profile, profile.getSnapshot().getElementFirstRep());
            }
            if (list.size() > 0) {
                int i2 = 0;
                while (i2 < list.size()) {
                    ElementDefinition defn = list.get(i2);
                    if (!defn.getMax().equals("0") && (allFixed || this.include(defn))) {
                        if (this.passElementPropsCheck(defn) && !Utilities.existsInList(defn.getName(), omitList)) {
                            PEDefinitionElement pe = new PEDefinitionElement(this, profile, defn, parent.path());
                            pe.setRecursing(definition == defn || profile.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION && profile.getType().equals("Extension"));
                            if (this.cu.isPrimitiveDatatype(definition.getTypeFirstRep().getWorkingCode()) && "value".equals(pe.name())) {
                                pe.setMustHaveValue(definition.getMustHaveValue());
                            }
                            pe.setInFixedValue(definition.hasFixed() || definition.hasPattern() || parent.isInFixedValue());
                            if (defn.hasSlicing()) {
                                if (defn.getSlicing().getRules() != ElementDefinition.SlicingRules.CLOSED) {
                                    res.add(pe);
                                }
                                ++i2;
                                while (i2 < list.size() && list.get(i2).getPath().equals(defn.getPath())) {
                                    StructureDefinition ext = this.getExtensionDefinition(list.get(i2));
                                    if (ext != null) {
                                        res.add(new PEDefinitionExtension(this, list.get(i2).getSliceName(), profile, list.get(i2), defn, ext, parent.path()));
                                    } else if (this.isTypeSlicing(defn)) {
                                        res.add(new PEDefinitionTypeSlice(this, list.get(i2).getSliceName(), profile, list.get(i2), defn, parent.path()));
                                    } else {
                                        res.add(new PEDefinitionSlice(this, list.get(i2).getSliceName(), profile, list.get(i2), defn, parent.path()));
                                    }
                                    ++i2;
                                }
                                continue;
                            }
                            res.add(pe);
                            ++i2;
                            continue;
                        }
                        ++i2;
                        continue;
                    }
                    ++i2;
                }
            }
            return res;
        }
        if (list.isEmpty()) {
            throw new DefinitionException("not done yet!");
        }
        throw new DefinitionException("not done yet");
    }

    private boolean passElementPropsCheck(ElementDefinition bdefn) {
        switch (this.elementProps) {
            case EXTENSION: {
                return !Utilities.existsInList(bdefn.getBase().getPath(), "Element.id");
            }
            case NONE: {
                return !Utilities.existsInList(bdefn.getBase().getPath(), "Element.id", "Element.extension");
            }
        }
        return true;
    }

    private boolean isTypeSlicing(ElementDefinition defn) {
        ElementDefinition.ElementDefinitionSlicingComponent sl = defn.getSlicing();
        return sl.getRules() == ElementDefinition.SlicingRules.CLOSED && sl.getDiscriminator().size() == 1 && sl.getDiscriminatorFirstRep().getType() == ElementDefinition.DiscriminatorType.TYPE && "$this".equals(sl.getDiscriminatorFirstRep().getPath());
    }

    private boolean include(ElementDefinition defn) {
        if (this.fixedPropsDefault) {
            return true;
        }
        return !defn.hasFixed() && !defn.hasPattern();
    }

    protected List<PEDefinition> listSlices(StructureDefinition profileStructure, ElementDefinition definition, PEDefinition parent) {
        List<ElementDefinition> list = this.pu.getSliceList(profileStructure, definition);
        ArrayList<PEDefinition> res = new ArrayList<PEDefinition>();
        for (ElementDefinition ed : list) {
            if (profileStructure.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT && profileStructure.getType().equals("Extension")) {
                res.add(new PEDefinitionSubExtension(this, profileStructure, ed, parent.path()));
                continue;
            }
            PEDefinitionElement pe = new PEDefinitionElement(this, profileStructure, ed, parent.path());
            pe.setRecursing(definition == ed || profileStructure.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION && profileStructure.getType().equals("Extension"));
            res.add(pe);
        }
        return res;
    }

    private boolean checkType(ElementDefinition defn, String url) {
        for (ElementDefinition.TypeRefComponent t : defn.getType()) {
            if (("http://hl7.org/fhir/StructureDefinition/" + t.getWorkingCode()).equals(url)) {
                return true;
            }
            for (CanonicalType u : t.getProfile()) {
                if (!url.equals(u.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private StructureDefinition getExtensionDefinition(ElementDefinition ed) {
        if ("Extension".equals(ed.getTypeFirstRep().getWorkingCode()) && ed.getTypeFirstRep().getProfile().size() == 1) {
            return this.context.fetchResource(StructureDefinition.class, ed.getTypeFirstRep().getProfile().get(0).asStringValue());
        }
        return null;
    }

    private ElementDefinition getByName(List<ElementDefinition> blist, String name) {
        for (ElementDefinition ed : blist) {
            if (!name.equals(ed.getName())) continue;
            return ed;
        }
        return null;
    }

    protected PEType makeType(ElementDefinition.TypeRefComponent t) {
        if (t.hasProfile()) {
            StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, (String)t.getProfile().get(0).getValue());
            if (sd == null) {
                return new PEType(this.tail((String)t.getProfile().get(0).getValue()), t.getWorkingCode(), (String)t.getProfile().get(0).getValue());
            }
            return new PEType(sd.getName(), t.getWorkingCode(), (String)t.getProfile().get(0).getValue());
        }
        return this.makeType(t.getWorkingCode());
    }

    protected PEType makeType(ElementDefinition.TypeRefComponent t, CanonicalType u) {
        StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, (String)u.getValue());
        if (sd == null) {
            return new PEType(this.tail((String)u.getValue()), t.getWorkingCode(), (String)u.getValue());
        }
        return new PEType(sd.getName(), t.getWorkingCode(), (String)u.getValue());
    }

    protected PEType makeType(String tn) {
        return new PEType(tn, tn, "http://hl7.org/fhir/StructureDefinition/" + tn);
    }

    private String tail(String value) {
        return value.contains("/") ? value.substring(value.lastIndexOf("/") + 1) : value;
    }

    protected List<ElementDefinition> getChildren(StructureDefinition profileStructure, ElementDefinition definition) {
        return this.pu.getChildList(profileStructure, definition);
    }

    private PEInstance loadInstance(PEDefinition defn, Resource resource) {
        return new PEInstance(this, defn, resource, resource, defn.name());
    }

    public IWorkerContext getContext() {
        return this.context;
    }

    protected void populateByProfile(Base base, PEDefinition definition) {
        for (PEDefinition pe : definition.children(true)) {
            if (pe.fixedValue()) {
                if (pe.definition().hasPattern()) {
                    base.setProperty(pe.schemaName(), pe.definition().getPattern());
                    continue;
                }
                base.setProperty(pe.schemaName(), pe.definition().getFixed());
                continue;
            }
            for (int i2 = 0; i2 < pe.min(); ++i2) {
                Base b = null;
                if (pe.schemaName().endsWith("[x]")) {
                    if (pe.types().size() == 1) {
                        b = base.addChild(pe.schemaName().replace("[x]", Utilities.capitalize(pe.types().get(0).getType())));
                    }
                } else {
                    b = base.addChild(pe.schemaName());
                }
                if (b == null) continue;
                this.populateByProfile(b, pe);
            }
        }
    }

    public String makeSliceExpression(StructureDefinition profile, ElementDefinition.ElementDefinitionSlicingComponent slicing, ElementDefinition definition) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(" and ");
        block9: for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d : slicing.getDiscriminator()) {
            switch (d.getType()) {
                case EXISTS: {
                    throw new DefinitionException("The discriminator type 'exists' is not supported by the PEBuilder");
                }
                case PATTERN: {
                    throw new DefinitionException("The discriminator type 'pattern' is not supported by the PEBuilder");
                }
                case POSITION: {
                    throw new DefinitionException("The discriminator type 'position' is not supported by the PEBuilder");
                }
                case PROFILE: {
                    throw new DefinitionException("The discriminator type 'profile' is not supported by the PEBuilder");
                }
                case TYPE: {
                    throw new DefinitionException("The discriminator type 'type' is not supported by the PEBuilder");
                }
                case VALUE: {
                    String path = d.getPath();
                    if (path.contains(".")) {
                        throw new DefinitionException("The discriminator path '" + path + "' is not supported by the PEBuilder");
                    }
                    ElementDefinition ed = this.getChildElement(profile, definition, path);
                    if (ed == null) {
                        throw new DefinitionException("The discriminator path '" + path + "' could not be resolved by the PEBuilder");
                    }
                    if (!ed.hasFixed()) {
                        throw new DefinitionException("The discriminator path '" + path + "' has no fixed value - this is not supported by the PEBuilder");
                    }
                    if (!ed.getFixed().isPrimitive()) {
                        throw new DefinitionException("The discriminator path '" + path + "' has a fixed value that is not a primitive (" + ed.getFixed().fhirType() + ") - this is not supported by the PEBuilder");
                    }
                    b.append(path + " = '" + ed.getFixed().primitiveValue() + "'");
                    continue block9;
                }
                case NULL: {
                    throw new DefinitionException("The discriminator type 'null' is not supported by the PEBuilder");
                }
            }
            throw new DefinitionException("The discriminator type '??' is not supported by the PEBuilder");
        }
        return b.toString();
    }

    private ElementDefinition getChildElement(StructureDefinition profile, ElementDefinition definition, String path) {
        List<ElementDefinition> elements = this.pu.getChildList(profile, definition);
        if (elements.size() == 0) {
            profile = definition.getTypeFirstRep().hasProfile() ? this.context.fetchResource(StructureDefinition.class, definition.getTypeFirstRep().getProfile().get(0).asStringValue()) : this.context.fetchTypeDefinition(definition.getTypeFirstRep().getWorkingCode());
            elements = this.pu.getChildList(profile, profile.getSnapshot().getElementFirstRep());
        }
        return this.getByName(elements, path);
    }

    public List<Base> exec(Resource resource, Base data, String fhirpath) {
        return this.fpe.evaluate((Object)this, resource, resource, data, fhirpath);
    }

    public boolean isResource(String name) {
        return this.cu.isResource(name);
    }

    public static enum PEElementPropertiesPolicy {
        NONE,
        EXTENSION,
        EXTENSION_ID;

    }
}

