/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openapi;

import java.util.HashSet;
import java.util.List;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.openapi.ComponentsWriter;
import org.hl7.fhir.r5.openapi.OperationWriter;
import org.hl7.fhir.r5.openapi.ParameterWriter;
import org.hl7.fhir.r5.openapi.PathItemWriter;
import org.hl7.fhir.r5.openapi.RequestBodyWriter;
import org.hl7.fhir.r5.openapi.ResponseObjectWriter;
import org.hl7.fhir.r5.openapi.SchemaWriter;
import org.hl7.fhir.r5.openapi.Writer;
import org.hl7.fhir.utilities.Utilities;

public class OpenApiGenerator {
    private IWorkerContext context;
    private CapabilityStatement source;
    private Writer dest;

    public OpenApiGenerator(IWorkerContext context, CapabilityStatement cs, Writer oa) {
        this.context = context;
        this.source = cs;
        this.dest = oa;
    }

    public void generate(String license, String url) {
        this.dest.info().title(this.source.present()).description(this.source.getDescription()).license(license, url).version(this.source.getVersion());
        for (ContactDetail cd2 : this.source.getContact()) {
            this.dest.info().contact(cd2.getName(), this.email(cd2.getTelecom()), this.url(cd2.getTelecom()));
        }
        if (this.source.hasPublisher()) {
            this.dest.info().contact(this.source.getPublisher(), null, null);
        }
        if (this.source.hasImplementation()) {
            this.dest.server(this.source.getImplementation().getUrl()).description(this.source.getImplementation().getDescription());
        }
        this.dest.externalDocs().url(this.source.getUrl()).description("FHIR CapabilityStatement");
        for (CapabilityStatement.CapabilityStatementRestComponent csr : this.source.getRest()) {
            if (csr.getMode() != CapabilityStatement.RestfulCapabilityMode.SERVER) continue;
            this.generatePaths(csr, this.source);
        }
        this.writeBaseParameters(this.dest.components());
    }

    private void writeBaseParameters(ComponentsWriter components) {
        components.parameter("rid").name("rid").in(ParameterWriter.ParameterLocation.path).description("id of the resource (=Resource.id)").required(true).allowEmptyValue(false).style(ParameterWriter.ParameterStyle.simple).schema().type(SchemaWriter.SchemaType.string);
        components.parameter("hid").name("hid").in(ParameterWriter.ParameterLocation.path).description("id of the history entry (=Resource.meta.versionId)").required(true).allowEmptyValue(false).style(ParameterWriter.ParameterStyle.simple).schema().type(SchemaWriter.SchemaType.string);
        components.parameter("summary").name("_summary").in(ParameterWriter.ParameterLocation.query).description("Requests the server to return a designated subset of the resource").allowEmptyValue().style(ParameterWriter.ParameterStyle.form).schema().type(SchemaWriter.SchemaType.string).enums("true", "text", "data", "count", "false");
        components.parameter("format").name("_format").in(ParameterWriter.ParameterLocation.query).description("Specify alternative response formats by their MIME-types (when a client is unable acccess accept: header)").allowEmptyValue().style(ParameterWriter.ParameterStyle.form).schema().type(SchemaWriter.SchemaType.string).format("mime-type");
        components.parameter("pretty").name("_pretty").in(ParameterWriter.ParameterLocation.query).description("Ask for a pretty printed response for human convenience").allowEmptyValue().style(ParameterWriter.ParameterStyle.form).schema().type(SchemaWriter.SchemaType.bool);
        SchemaWriter p = components.parameter("elements").name("_elements").in(ParameterWriter.ParameterLocation.query).description("Requests the server to return a collection of elements from the resource").allowEmptyValue().style(ParameterWriter.ParameterStyle.form).explode(false).schema();
        p.type(SchemaWriter.SchemaType.array).format("string");
        p.items().format("string");
        components.parameter("count").name("_count").in(ParameterWriter.ParameterLocation.query).description("The maximum number of search results on a page. The server is not bound to return the number requested, but cannot return more").schema().type(SchemaWriter.SchemaType.number);
    }

    private void generatePaths(CapabilityStatement.CapabilityStatementRestComponent csr, Resource cs) {
        this.generateMetadata();
        for (CapabilityStatement.CapabilityStatementRestResourceComponent r : csr.getResource()) {
            this.generateResource(r, cs);
        }
        if (this.hasOp(csr, CapabilityStatement.SystemRestfulInteraction.HISTORYSYSTEM)) {
            this.generateHistorySystem(csr);
        }
        if (this.hasOp(csr, CapabilityStatement.SystemRestfulInteraction.SEARCHSYSTEM)) {
            this.generateSearchSystem(csr, cs);
        }
        if (this.hasOp(csr, CapabilityStatement.SystemRestfulInteraction.BATCH) || this.hasOp(csr, CapabilityStatement.SystemRestfulInteraction.TRANSACTION)) {
            this.generateBatchTransaction(csr);
        }
    }

    private void generateResource(CapabilityStatement.CapabilityStatementRestResourceComponent r, Resource cs) {
        if (this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.SEARCHTYPE)) {
            this.generateSearch(r, cs);
        }
        if (this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.READ)) {
            this.generateRead(r);
        }
        if (this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.CREATE)) {
            this.generateCreate(r);
        }
        if (this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.UPDATE)) {
            this.generateUpdate(r);
        }
        if (this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.PATCH)) {
            this.generatePatch(r);
        }
        if (this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.DELETE)) {
            this.generateDelete(r);
        }
        if (this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE)) {
            this.generateHistoryInstance(r);
        }
        if (this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.VREAD)) {
            this.generateVRead(r);
        }
        if (this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE)) {
            this.generateHistoryType(r);
        }
    }

    private void generateMetadata() {
        OperationWriter op = this.makePathMetadata().operation("get");
        op.summary("Return the server's capability statement");
        op.operationId("metadata");
        this.opOutcome(op.responses().defaultResponse());
        ResponseObjectWriter resp = op.responses().httpResponse("200");
        resp.description("the capbility statement");
        if (this.isJson()) {
            resp.content("application/fhir+json").schemaRef(this.specRef() + "/fhir.schema.json#/definitions/CapabilityStatement");
        }
        if (this.isXml()) {
            resp.content("application/fhir+xml").schemaRef(this.specRef() + "/CapabilityStatement.xsd");
        }
        op.paramRef("#/components/parameters/format");
        op.paramRef("#/components/parameters/pretty");
        op.paramRef("#/components/parameters/summary");
        op.paramRef("#/components/parameters/elements");
    }

    private void generateRead(CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        OperationWriter op = this.makePathResId(r).operation("get");
        op.summary("Read the current state of the resource");
        op.operationId("read" + r.getType());
        this.opOutcome(op.responses().defaultResponse());
        ResponseObjectWriter resp = op.responses().httpResponse("200");
        resp.description("the resource being returned");
        if (r.getVersioning() != CapabilityStatement.ResourceVersionPolicy.NOVERSION) {
            resp.header("ETag").description("Version from Resource.meta.version as a weak ETag").schema().type(SchemaWriter.SchemaType.string);
        }
        if (this.isJson()) {
            resp.content("application/fhir+json").schemaRef(this.specRef() + "/fhir.schema.json#/definitions/" + r.getType());
        }
        if (this.isXml()) {
            resp.content("application/fhir+xml").schemaRef(this.specRef() + "/" + r.getType() + ".xsd");
        }
        op.paramRef("#/components/parameters/rid");
        op.paramRef("#/components/parameters/summary");
        op.paramRef("#/components/parameters/format");
        op.paramRef("#/components/parameters/pretty");
        op.paramRef("#/components/parameters/elements");
    }

    private void generateSearch(CapabilityStatement.CapabilityStatementRestResourceComponent r, Resource cs) {
        OperationWriter op = this.makePathResType(r).operation("get");
        op.summary("Search all resources of type " + r.getType() + " based on a set of criteria");
        op.operationId("search" + r.getType());
        this.opOutcome(op.responses().defaultResponse());
        ResponseObjectWriter resp = op.responses().httpResponse("200");
        resp.description("the resource being returned");
        if (this.isJson()) {
            resp.content("application/fhir+json").schemaRef(this.specRef() + "/fhir.schema.json#/definitions/Bundle");
        }
        if (this.isXml()) {
            resp.content("application/fhir+xml").schemaRef(this.specRef() + "/Bundle.xsd");
        }
        op.paramRef("#/components/parameters/format");
        op.paramRef("#/components/parameters/pretty");
        op.paramRef("#/components/parameters/summary");
        op.paramRef("#/components/parameters/elements");
        HashSet<String> set = new HashSet<String>();
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent spc : r.getSearchParam()) {
            SearchParameter sp;
            if (set.contains(spc.getName())) continue;
            set.add(spc.getName());
            ParameterWriter p = op.parameter(spc.getName());
            p.in(ParameterWriter.ParameterLocation.query).description(spc.getDocumentation());
            p.schema().type(this.getSchemaType(spc.getType()));
            if (!spc.hasDefinition() || (sp = this.context.fetchResource(SearchParameter.class, spc.getDefinition(), cs)) == null) continue;
            p.description(sp.getDescription());
        }
    }

    private void generateSearchSystem(CapabilityStatement.CapabilityStatementRestComponent csr, Resource cs) {
        OperationWriter op = this.makePathSystem().operation("get");
        op.summary("Search all resources of all types based on a set of criteria");
        op.operationId("searchAll");
        this.opOutcome(op.responses().defaultResponse());
        ResponseObjectWriter resp = op.responses().httpResponse("200");
        resp.description("the resource being returned");
        if (this.isJson()) {
            resp.content("application/fhir+json").schemaRef(this.specRef() + "/fhir.schema.json#/definitions/Bundle");
        }
        if (this.isXml()) {
            resp.content("application/fhir+xml").schemaRef(this.specRef() + "/Bundle.xsd");
        }
        op.paramRef("#/components/parameters/format");
        op.paramRef("#/components/parameters/pretty");
        op.paramRef("#/components/parameters/summary");
        op.paramRef("#/components/parameters/elements");
        HashSet<String> set = new HashSet<String>();
        set.add("_summary");
        set.add("_format");
        set.add("_pretty");
        set.add("_elements");
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent spc : csr.getSearchParam()) {
            SearchParameter sp;
            if (set.contains(spc.getName())) continue;
            set.add(spc.getName());
            ParameterWriter p = op.parameter(spc.getName());
            p.in(ParameterWriter.ParameterLocation.query).description(spc.getDocumentation());
            p.schema().type(this.getSchemaType(spc.getType()));
            if (!spc.hasDefinition() || (sp = this.context.fetchResource(SearchParameter.class, spc.getDefinition(), cs)) == null) continue;
            p.description(sp.getDescription());
        }
    }

    private SchemaWriter.SchemaType getSchemaType(Enumerations.SearchParamType type) {
        switch (type) {
            case DATE: {
                return SchemaWriter.SchemaType.dateTime;
            }
            case NUMBER: {
                return SchemaWriter.SchemaType.number;
            }
            case QUANTITY: {
                return SchemaWriter.SchemaType.string;
            }
            case REFERENCE: {
                return SchemaWriter.SchemaType.string;
            }
            case STRING: {
                return SchemaWriter.SchemaType.string;
            }
            case TOKEN: {
                return SchemaWriter.SchemaType.string;
            }
            case URI: {
                return SchemaWriter.SchemaType.string;
            }
        }
        return null;
    }

    private void generateHistoryType(CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        OperationWriter op = this.makePathResHistListType(r).operation("get");
        op.summary("Read the past states of the resource");
        op.operationId("histtype" + r.getType());
        this.opOutcome(op.responses().defaultResponse());
        ResponseObjectWriter resp = op.responses().httpResponse("200");
        resp.description("the resources being returned");
        if (this.isJson()) {
            resp.content("application/fhir+json").schemaRef(this.specRef() + "/fhir.schema.json#/definitions/Bundle");
        }
        if (this.isXml()) {
            resp.content("application/fhir+xml").schemaRef(this.specRef() + "/Bundle.xsd");
        }
        op.paramRef("#/components/parameters/summary");
        op.paramRef("#/components/parameters/format");
        op.paramRef("#/components/parameters/pretty");
        op.paramRef("#/components/parameters/elements");
        op.paramRef("#/components/parameters/count");
        op.parameter("_since").in(ParameterWriter.ParameterLocation.query).description("Only include resource versions that were created at or after the given instant in time").schema().type(SchemaWriter.SchemaType.dateTime);
        op.parameter("_at").in(ParameterWriter.ParameterLocation.query).description("Only include resource versions that were current at some point during the time period specified in the date time value (see Search notes on date searching)").schema().type(SchemaWriter.SchemaType.dateTime);
        op.parameter("_list").in(ParameterWriter.ParameterLocation.query).description("Only include resource versions that are referenced in the specified list (current list references are allowed)").schema().type(SchemaWriter.SchemaType.string);
    }

    private void generateHistoryInstance(CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        OperationWriter op = this.makePathResHistListId(r).operation("get");
        op.summary("Read the past states of the resource");
        op.operationId("histinst" + r.getType());
        this.opOutcome(op.responses().defaultResponse());
        ResponseObjectWriter resp = op.responses().httpResponse("200");
        resp.description("the resources being returned");
        if (this.isJson()) {
            resp.content("application/fhir+json").schemaRef(this.specRef() + "/fhir.schema.json#/definitions/Bundle");
        }
        if (this.isXml()) {
            resp.content("application/fhir+xml").schemaRef(this.specRef() + "/Bundle.xsd");
        }
        op.paramRef("#/components/parameters/rid");
        op.paramRef("#/components/parameters/summary");
        op.paramRef("#/components/parameters/format");
        op.paramRef("#/components/parameters/pretty");
        op.paramRef("#/components/parameters/elements");
        op.paramRef("#/components/parameters/count");
        op.parameter("_since").in(ParameterWriter.ParameterLocation.query).description("Only include resource versions that were created at or after the given instant in time").schema().type(SchemaWriter.SchemaType.dateTime);
        op.parameter("_at").in(ParameterWriter.ParameterLocation.query).description("Only include resource versions that were current at some point during the time period specified in the date time value (see Search notes on date searching)").schema().type(SchemaWriter.SchemaType.dateTime);
        op.parameter("_list").in(ParameterWriter.ParameterLocation.query).description("Only include resource versions that are referenced in the specified list (current list references are allowed)").schema().type(SchemaWriter.SchemaType.string);
    }

    private void generateHistorySystem(CapabilityStatement.CapabilityStatementRestComponent csr) {
        OperationWriter op = this.makePathHistListSystem().operation("get");
        op.summary("Read the past states of all resources");
        op.operationId("histAll");
        this.opOutcome(op.responses().defaultResponse());
        ResponseObjectWriter resp = op.responses().httpResponse("200");
        resp.description("the resources being returned");
        if (this.isJson()) {
            resp.content("application/fhir+json").schemaRef(this.specRef() + "/fhir.schema.json#/definitions/Bundle");
        }
        if (this.isXml()) {
            resp.content("application/fhir+xml").schemaRef(this.specRef() + "/Bundle.xsd");
        }
        op.paramRef("#/components/parameters/summary");
        op.paramRef("#/components/parameters/format");
        op.paramRef("#/components/parameters/pretty");
        op.paramRef("#/components/parameters/elements");
        op.paramRef("#/components/parameters/count");
        op.parameter("_since").in(ParameterWriter.ParameterLocation.query).description("Only include resource versions that were created at or after the given instant in time").schema().type(SchemaWriter.SchemaType.dateTime);
        op.parameter("_at").in(ParameterWriter.ParameterLocation.query).description("Only include resource versions that were current at some point during the time period specified in the date time value (see Search notes on date searching)").schema().type(SchemaWriter.SchemaType.dateTime);
        op.parameter("_list").in(ParameterWriter.ParameterLocation.query).description("Only include resource versions that are referenced in the specified list (current list references are allowed)").schema().type(SchemaWriter.SchemaType.string);
    }

    private void generateVRead(CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        OperationWriter op = this.makePathResHistId(r).operation("get");
        op.summary("Read a past state of the resource");
        op.operationId("vread" + r.getType());
        this.opOutcome(op.responses().defaultResponse());
        ResponseObjectWriter resp = op.responses().httpResponse("200");
        resp.description("the resource being returned");
        if (r.getVersioning() != CapabilityStatement.ResourceVersionPolicy.NOVERSION) {
            resp.header("ETag").description("Version from Resource.meta.version as a weak ETag for that version").schema().type(SchemaWriter.SchemaType.string);
        }
        if (this.isJson()) {
            resp.content("application/fhir+json").schemaRef(this.specRef() + "/fhir.schema.json#/definitions/" + r.getType());
        }
        if (this.isXml()) {
            resp.content("application/fhir+xml").schemaRef(this.specRef() + "/" + r.getType() + ".xsd");
        }
        op.paramRef("#/components/parameters/rid");
        op.paramRef("#/components/parameters/hid");
        op.paramRef("#/components/parameters/summary");
        op.paramRef("#/components/parameters/format");
        op.paramRef("#/components/parameters/pretty");
        op.paramRef("#/components/parameters/elements");
    }

    private void generateUpdate(CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        OperationWriter op = this.makePathResId(r).operation("put");
        if (r.getUpdateCreate()) {
            op.summary("Update the current state of the resource (can create a new resource if it does not exist)");
        } else {
            op.summary("Update the current state of the resource");
        }
        op.operationId("update" + r.getType());
        RequestBodyWriter req = op.request();
        req.description("The new state of the resource").required(true);
        if (this.isJson()) {
            req.content("application/fhir+json").schemaRef(this.specRef() + "/fhir.schema.json#/definitions/" + r.getType());
        }
        if (this.isXml()) {
            req.content("application/fhir+xml").schemaRef(this.specRef() + "/" + r.getType() + ".xsd");
        }
        this.opOutcome(op.responses().defaultResponse());
        ResponseObjectWriter resp = op.responses().httpResponse("200");
        resp.description("the resource being returned after being updated");
        if (r.getVersioning() != CapabilityStatement.ResourceVersionPolicy.NOVERSION) {
            resp.header("ETag").description("Version from Resource.meta.version as a weak ETag").schema().type(SchemaWriter.SchemaType.string);
        }
        if (this.isJson()) {
            resp.content("application/fhir+json").schemaRef(this.specRef() + "/fhir.schema.json#/definitions/" + r.getType());
        }
        if (this.isXml()) {
            resp.content("application/fhir+xml").schemaRef(this.specRef() + "/" + r.getType() + ".xsd");
        }
        op.paramRef("#/components/parameters/rid");
        op.paramRef("#/components/parameters/summary");
        op.paramRef("#/components/parameters/format");
        op.paramRef("#/components/parameters/pretty");
        op.paramRef("#/components/parameters/elements");
    }

    private void generatePatch(CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        OperationWriter op = this.makePathResId(r).operation("patch");
        op.summary("Change the current state of the resource by providing a patch - a series of change commands");
        op.operationId("patch" + r.getType());
        RequestBodyWriter req = op.request();
        req.description("The new state of the resource").required(true);
        if (this.isJson()) {
            req.content("application/json-patch+json").schemaRef(this.specRef() + "/fhir.schema.json#/definitions/" + r.getType());
            req.content("application/fhir+json").schemaRef(this.specRef() + "/fhir.schema.json#/definitions/Parameters");
        }
        if (this.isXml()) {
            req.content("application/xml-patch+xml").schemaRef(this.specRef() + "/" + r.getType() + ".xsd");
            req.content("application/fhir+xml").schemaRef(this.specRef() + "/Parameters.xsd");
        }
        this.opOutcome(op.responses().defaultResponse());
        ResponseObjectWriter resp = op.responses().httpResponse("200");
        resp.description("the resource being returned after being patched");
        if (r.getVersioning() != CapabilityStatement.ResourceVersionPolicy.NOVERSION) {
            resp.header("ETag").description("Version from Resource.meta.version as a weak ETag").schema().type(SchemaWriter.SchemaType.string);
        }
        if (this.isJson()) {
            resp.content("application/fhir+json").schemaRef(this.specRef() + "/fhir.schema.json#/definitions/" + r.getType());
        }
        if (this.isXml()) {
            resp.content("application/fhir+xml").schemaRef(this.specRef() + "/" + r.getType() + ".xsd");
        }
        op.paramRef("#/components/parameters/rid");
        op.paramRef("#/components/parameters/summary");
        op.paramRef("#/components/parameters/format");
        op.paramRef("#/components/parameters/pretty");
        op.paramRef("#/components/parameters/elements");
    }

    private void generateDelete(CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        OperationWriter op = this.makePathResId(r).operation("delete");
        op.summary("Delete the resource so that it no exists (no read, search etc)");
        op.operationId("delete" + r.getType());
        this.opOutcome(op.responses().defaultResponse());
        ResponseObjectWriter resp = op.responses().httpResponse("204");
        resp.description("If the resource is deleted - no content is returned");
        if (r.getVersioning() != CapabilityStatement.ResourceVersionPolicy.NOVERSION) {
            resp.header("ETag").description("Version from Resource.meta.version as a weak ETag").schema().type(SchemaWriter.SchemaType.string);
        }
        op.paramRef("#/components/parameters/rid");
    }

    private void generateCreate(CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        OperationWriter op = this.makePathRes(r).operation("post");
        op.summary("Create a new resource");
        op.operationId("create" + r.getType());
        RequestBodyWriter req = op.request();
        req.description("The new state of the resource").required(true);
        if (this.isJson()) {
            req.content("application/fhir+json").schemaRef(this.specRef() + "/fhir.schema.json#/definitions/" + r.getType());
        }
        if (this.isXml()) {
            req.content("application/fhir+xml").schemaRef(this.specRef() + "/" + r.getType() + ".xsd");
        }
        this.opOutcome(op.responses().defaultResponse());
        ResponseObjectWriter resp = op.responses().httpResponse("200");
        resp.description("the resource being returned after being updated");
        if (r.getVersioning() != CapabilityStatement.ResourceVersionPolicy.NOVERSION) {
            resp.header("ETag").description("Version from Resource.meta.version as a weak ETag").schema().type(SchemaWriter.SchemaType.string);
        }
        if (this.isJson()) {
            resp.content("application/fhir+json").schemaRef(this.specRef() + "/fhir.schema.json#/definitions/" + r.getType());
        }
        if (this.isXml()) {
            resp.content("application/fhir+xml").schemaRef(this.specRef() + "/" + r.getType() + ".xsd");
        }
        op.paramRef("#/components/parameters/summary");
        op.paramRef("#/components/parameters/format");
        op.paramRef("#/components/parameters/pretty");
        op.paramRef("#/components/parameters/elements");
    }

    private void generateBatchTransaction(CapabilityStatement.CapabilityStatementRestComponent csr) {
        OperationWriter op = this.makePathSystem().operation("put");
        op.summary("Batch or Transaction");
        op.operationId("transaction");
        RequestBodyWriter req = op.request();
        req.description("The batch or transaction").required(true);
        if (this.isJson()) {
            req.content("application/fhir+json").schemaRef(this.specRef() + "/fhir.schema.json#/definitions/Bundle");
        }
        if (this.isXml()) {
            req.content("application/fhir+xml").schemaRef(this.specRef() + "/Bundle.xsd");
        }
        this.opOutcome(op.responses().defaultResponse());
        ResponseObjectWriter resp = op.responses().httpResponse("200");
        resp.description("Batch or Transaction response");
        if (this.isJson()) {
            resp.content("application/fhir+json").schemaRef(this.specRef() + "/fhir.schema.json#/definitions/Bundle");
        }
        if (this.isXml()) {
            resp.content("application/fhir+xml").schemaRef(this.specRef() + "/Bundle.xsd");
        }
        op.paramRef("#/components/parameters/format");
        op.paramRef("#/components/parameters/pretty");
    }

    private void opOutcome(ResponseObjectWriter resp) {
        resp.description("Error, with details");
        if (this.isJson()) {
            resp.content("application/fhir+json").schemaRef(this.specRef() + "/fhir.schema.json#/definitions/OperationOutcome");
        }
        if (this.isXml()) {
            resp.content("application/fhir+xml").schemaRef(this.specRef() + "/OperationOutcome.xsd");
        }
    }

    private String specRef() {
        String ver = this.context.getVersion();
        if (Utilities.noString(ver)) {
            return "https://hl7.org/fhir/STU3";
        }
        if (ver.startsWith("4.0")) {
            return "https://hl7.org/fhir/R4";
        }
        if (ver.startsWith("3.0")) {
            return "https://hl7.org/fhir/STU3";
        }
        if (ver.startsWith("1.0")) {
            return "https://hl7.org/fhir/DSTU2";
        }
        if (ver.startsWith("1.4")) {
            return "https://hl7.org/fhir/2016May";
        }
        return "https://build.fhir.org";
    }

    private boolean isJson() {
        for (CodeType f : this.source.getFormat()) {
            if (!f.getCode().contains("json")) continue;
            return true;
        }
        return false;
    }

    private boolean isXml() {
        for (CodeType f : this.source.getFormat()) {
            if (!f.getCode().contains("xml")) continue;
            return true;
        }
        return false;
    }

    public PathItemWriter makePathSystem() {
        PathItemWriter p = this.dest.path("/");
        p.summary("System level operations");
        p.description("System level operations");
        return p;
    }

    public PathItemWriter makePathMetadata() {
        PathItemWriter p = this.dest.path("/metadata");
        p.summary("Access to the Server's Capability Statement");
        p.description("All FHIR Servers return a CapabilityStatement that describes what services they perform");
        return p;
    }

    public PathItemWriter makePathRes(CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        PathItemWriter p = this.dest.path("/" + r.getType());
        p.summary("Manager for resources of type " + r.getType());
        p.description("The Manager for resources of type " + r.getType() + ": provides services to manage the collection of all the " + r.getType() + " instances");
        return p;
    }

    public PathItemWriter makePathResId(CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        PathItemWriter p = this.dest.path("/" + r.getType() + "/{rid}");
        p.summary("Read/Write/etc resource instance of type " + r.getType());
        p.description("Access to services to manage the state of a single resource of type " + r.getType());
        return p;
    }

    public PathItemWriter makePathResType(CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        PathItemWriter p = this.dest.path("/" + r.getType());
        p.summary("manage the collection of resources of type " + r.getType());
        p.description("Access to services to manage the collection of all resources of type " + r.getType());
        return p;
    }

    public PathItemWriter makePathResHistListType(CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        PathItemWriter p = this.dest.path("/" + r.getType() + "/_history");
        p.summary("Read past versions of resources of type " + r.getType());
        p.description("Access to previous versions of resourcez of type " + r.getType());
        return p;
    }

    public PathItemWriter makePathResHistListId(CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        PathItemWriter p = this.dest.path("/" + r.getType() + "/{rid}/_history");
        p.summary("Read past versions of resource instance of type " + r.getType());
        p.description("Access to previous versions of a single resource of type " + r.getType());
        return p;
    }

    public PathItemWriter makePathResHistId(CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        PathItemWriter p = this.dest.path("/" + r.getType() + "/{rid}/_history/{hid}");
        p.summary("Read a past version of resource instance of type " + r.getType());
        p.description("Access a to specified previous version of a single resource of type " + r.getType());
        return p;
    }

    public PathItemWriter makePathHistListSystem() {
        PathItemWriter p = this.dest.path("/_history");
        p.summary("Read a past version of resource instance of all types");
        p.description("Access a previous versions of all types");
        return p;
    }

    private boolean hasOp(CapabilityStatement.CapabilityStatementRestComponent r, CapabilityStatement.SystemRestfulInteraction opCode) {
        for (CapabilityStatement.SystemInteractionComponent op : r.getInteraction()) {
            if (op.getCode() != opCode) continue;
            return true;
        }
        return false;
    }

    private boolean hasOp(CapabilityStatement.CapabilityStatementRestResourceComponent r, CapabilityStatement.TypeRestfulInteraction opCode) {
        for (CapabilityStatement.ResourceInteractionComponent op : r.getInteraction()) {
            if (op.getCode() != opCode) continue;
            return true;
        }
        return false;
    }

    private String url(List<ContactPoint> telecom) {
        for (ContactPoint cp : telecom) {
            if (cp.getSystem() != ContactPoint.ContactPointSystem.URL) continue;
            return cp.getValue();
        }
        return null;
    }

    private String email(List<ContactPoint> telecom) {
        for (ContactPoint cp : telecom) {
            if (cp.getSystem() != ContactPoint.ContactPointSystem.EMAIL) continue;
            return cp.getValue();
        }
        return null;
    }
}

