/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="time")
public class TimeType
extends PrimitiveType<String> {
    private static final long serialVersionUID = 3L;

    public TimeType() {
    }

    public TimeType(String theValue) {
        this.setValue(theValue);
    }

    @Override
    protected String parse(String theValue) {
        return theValue;
    }

    @Override
    protected String encode(String theValue) {
        return theValue;
    }

    @Override
    public TimeType copy() {
        TimeType ret = new TimeType((String)this.getValue());
        this.copyValues(ret);
        return ret;
    }

    @Override
    public String fhirType() {
        return "time";
    }

    public int getHour() {
        String v = (String)this.getValue();
        if (v.length() < 2) {
            return 0;
        }
        if (!Utilities.isInteger(v = v.substring(0, 2))) {
            return 0;
        }
        return Integer.parseInt(v);
    }

    public int getMinute() {
        String v = (String)this.getValue();
        if (v.length() < 5) {
            return 0;
        }
        if (!Utilities.isInteger(v = v.substring(3, 5))) {
            return 0;
        }
        return Integer.parseInt(v);
    }

    public float getSecond() {
        String v = (String)this.getValue();
        if (v.length() < 8) {
            return 0.0f;
        }
        if (!Utilities.isDecimal(v = v.substring(6), false, true)) {
            return 0.0f;
        }
        return Float.parseFloat(v);
    }

    public TemporalPrecisionEnum getPrecision() {
        String v = (String)this.getValue();
        if (v.length() == 5) {
            return TemporalPrecisionEnum.MINUTE;
        }
        if (v.length() == 8) {
            return TemporalPrecisionEnum.SECOND;
        }
        if (v.length() > 9) {
            return TemporalPrecisionEnum.MILLI;
        }
        return null;
    }

    public void setPrecision(TemporalPrecisionEnum temp) {
        if (temp == TemporalPrecisionEnum.MINUTE) {
            this.setValue(((String)this.getValue()).substring(0, 5));
        }
        if (temp == TemporalPrecisionEnum.SECOND) {
            this.setValue(((String)this.getValue()).substring(0, 8));
        }
    }

    @Override
    public String fpValue() {
        return "@T" + this.primitiveValue();
    }
}

