/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.Age;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.Availability;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Count;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.Distance;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.ExtendedContactDetail;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.FormularyItem;
import org.hl7.fhir.r5.model.GenomicStudy;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.ParameterDefinition;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.RatioRange;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Signature;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.Transport;
import org.hl7.fhir.r5.model.TriggerDefinition;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.UuidType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Task", profile="http://hl7.org/fhir/StructureDefinition/Task")
public class Task
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Task Instance Identifier", formalDefinition="The business identifier for this task.")
    protected List<Identifier> identifier;
    @Child(name="instantiatesCanonical", type={CanonicalType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Formal definition of task", formalDefinition="The URL pointing to a *FHIR*-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Task.")
    protected CanonicalType instantiatesCanonical;
    @Child(name="instantiatesUri", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Formal definition of task", formalDefinition="The URL pointing to an *externally* maintained  protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Task.")
    protected UriType instantiatesUri;
    @Child(name="basedOn", type={Reference.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Request fulfilled by this task", formalDefinition="BasedOn refers to a higher-level authorization that triggered the creation of the task.  It references a \"request\" resource such as a ServiceRequest, MedicationRequest, CarePlan, etc. which is distinct from the \"request\" resource the task is seeking to fulfill.  This latter resource is referenced by focus.  For example, based on a CarePlan (= basedOn), a task is created to fulfill a ServiceRequest ( = focus ) to collect a specimen from a patient.")
    protected List<Reference> basedOn;
    @Child(name="groupIdentifier", type={Identifier.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Requisition or grouper id", formalDefinition="An identifier that links together multiple tasks and other requests that were created in the same context.")
    protected Identifier groupIdentifier;
    @Child(name="partOf", type={Task.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Composite task", formalDefinition="Task that this particular task is part of.")
    protected List<Reference> partOf;
    @Child(name="status", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | requested | received | accepted | +", formalDefinition="The current status of the task.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/task-status")
    protected Enumeration<TaskStatus> status;
    @Child(name="statusReason", type={CodeableReference.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reason for current status", formalDefinition="An explanation as to why this task is held, failed, was refused, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/task-status-reason")
    protected CodeableReference statusReason;
    @Child(name="businessStatus", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="E.g. \"Specimen collected\", \"IV prepped\"", formalDefinition="Contains business-specific nuances of the business state.")
    protected CodeableConcept businessStatus;
    @Child(name="intent", type={CodeType.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="unknown | proposal | plan | order | original-order | reflex-order | filler-order | instance-order | option", formalDefinition="Indicates the \"level\" of actionability associated with the Task, i.e. i+R[9]Cs this a proposed task, a planned task, an actionable task, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/task-intent")
    protected Enumeration<TaskIntent> intent;
    @Child(name="priority", type={CodeType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="routine | urgent | asap | stat", formalDefinition="Indicates how quickly the Task should be addressed with respect to other requests.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-priority")
    protected Enumeration<Enumerations.RequestPriority> priority;
    @Child(name="doNotPerform", type={BooleanType.class}, order=11, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="True if Task is prohibiting action", formalDefinition="If true indicates that the Task is asking for the specified action to *not* occur.")
    protected BooleanType doNotPerform;
    @Child(name="code", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Task Type", formalDefinition="A name or code (or both) briefly describing what the task involves.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/task-code")
    protected CodeableConcept code;
    @Child(name="description", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human-readable explanation of task", formalDefinition="A free-text description of what is to be performed.")
    protected StringType description;
    @Child(name="focus", type={Reference.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What task is acting on", formalDefinition="The request being fulfilled or the resource being manipulated (changed, suspended, etc.) by this task.")
    protected Reference focus;
    @Child(name="for", type={Reference.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Beneficiary of the Task", formalDefinition="The entity who benefits from the performance of the service specified in the task (e.g., the patient).")
    protected Reference for_;
    @Child(name="encounter", type={Encounter.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Healthcare event during which this task originated", formalDefinition="The healthcare event  (e.g. a patient and healthcare provider interaction) during which this task was created.")
    protected Reference encounter;
    @Child(name="requestedPeriod", type={Period.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the task should be performed", formalDefinition="Indicates the start and/or end of the period of time when completion of the task is desired to take place.")
    protected Period requestedPeriod;
    @Child(name="executionPeriod", type={Period.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Start and end time of execution", formalDefinition="Identifies the time action was first taken against the task (start) and/or the time final action was taken against the task prior to marking it as completed (end).")
    protected Period executionPeriod;
    @Child(name="authoredOn", type={DateTimeType.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Task Creation Date", formalDefinition="The date and time this task was created.")
    protected DateTimeType authoredOn;
    @Child(name="lastModified", type={DateTimeType.class}, order=20, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Task Last Modified Date", formalDefinition="The date and time of last modification to this task.")
    protected DateTimeType lastModified;
    @Child(name="requester", type={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class}, order=21, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who is asking for task to be done", formalDefinition="The creator of the task.")
    protected Reference requester;
    @Child(name="requestedPerformer", type={CodeableReference.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who should perform Task", formalDefinition="The kind of participant or specific participant that should perform the task.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/performer-role")
    protected List<CodeableReference> requestedPerformer;
    @Child(name="owner", type={Practitioner.class, PractitionerRole.class, Organization.class, CareTeam.class, HealthcareService.class, Patient.class, Device.class, RelatedPerson.class}, order=23, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible individual", formalDefinition="Individual organization or Device currently responsible for task execution.")
    protected Reference owner;
    @Child(name="location", type={Location.class}, order=24, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where task occurs", formalDefinition="Principal physical location where the this task is performed.")
    protected Reference location;
    @Child(name="reason", type={CodeableReference.class}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Why task is needed", formalDefinition="A description, code, or reference indicating why this task needs to be performed.")
    protected List<CodeableReference> reason;
    @Child(name="insurance", type={Coverage.class, ClaimResponse.class}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Associated insurance coverage", formalDefinition="Insurance plans, coverage extensions, pre-authorizations and/or pre-determinations that may be relevant to the Task.")
    protected List<Reference> insurance;
    @Child(name="note", type={Annotation.class}, order=27, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about the task", formalDefinition="Free-text information captured about the task as it progresses.")
    protected List<Annotation> note;
    @Child(name="relevantHistory", type={Provenance.class}, order=28, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Key events in history of the Task", formalDefinition="Links to Provenance records for past versions of this Task that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the task.")
    protected List<Reference> relevantHistory;
    @Child(name="restriction", type={}, order=29, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Constraints on fulfillment tasks", formalDefinition="If the Task.focus is a request resource and the task is seeking fulfillment (i.e. is asking for the request to be actioned), this element identifies any limitations on what parts of the referenced request should be actioned.")
    protected TaskRestrictionComponent restriction;
    @Child(name="input", type={}, order=30, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information used to perform task", formalDefinition="Additional information that may be needed in the execution of the task.")
    protected List<TaskInputComponent> input;
    @Child(name="output", type={}, order=31, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information produced as part of task", formalDefinition="Outputs produced by the Task.")
    protected List<TaskOutputComponent> output;
    private static final long serialVersionUID = -15240003L;
    @SearchParamDefinition(name="authored-on", path="Task.authoredOn", description="Search by creation date", type="date")
    public static final String SP_AUTHORED_ON = "authored-on";
    public static final DateClientParam AUTHORED_ON = new DateClientParam("authored-on");
    @SearchParamDefinition(name="based-on", path="Task.basedOn", description="Search by requests this task is based on", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("Task:based-on").toLocked();
    @SearchParamDefinition(name="business-status", path="Task.businessStatus", description="Search by business status", type="token")
    public static final String SP_BUSINESS_STATUS = "business-status";
    public static final TokenClientParam BUSINESS_STATUS = new TokenClientParam("business-status");
    @SearchParamDefinition(name="code", path="Task.code", description="Search by task code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="encounter", path="Task.encounter", description="Search by encounter", type="reference", target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Task:encounter").toLocked();
    @SearchParamDefinition(name="focus", path="Task.focus", description="Search by task focus", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_FOCUS = "focus";
    public static final ReferenceClientParam FOCUS = new ReferenceClientParam("focus");
    public static final Include INCLUDE_FOCUS = new Include("Task:focus").toLocked();
    @SearchParamDefinition(name="group-identifier", path="Task.groupIdentifier", description="Search by group identifier", type="token")
    public static final String SP_GROUP_IDENTIFIER = "group-identifier";
    public static final TokenClientParam GROUP_IDENTIFIER = new TokenClientParam("group-identifier");
    @SearchParamDefinition(name="identifier", path="Task.identifier", description="Search for a task instance by its business identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="intent", path="Task.intent", description="Search by task intent", type="token")
    public static final String SP_INTENT = "intent";
    public static final TokenClientParam INTENT = new TokenClientParam("intent");
    @SearchParamDefinition(name="modified", path="Task.lastModified", description="Search by last modification date", type="date")
    public static final String SP_MODIFIED = "modified";
    public static final DateClientParam MODIFIED = new DateClientParam("modified");
    @SearchParamDefinition(name="output", path="Task.output", description="Search by task output", type="reference")
    public static final String SP_OUTPUT = "output";
    public static final ReferenceClientParam OUTPUT = new ReferenceClientParam("output");
    public static final Include INCLUDE_OUTPUT = new Include("Task:output").toLocked();
    @SearchParamDefinition(name="owner", path="Task.owner", description="Search by task owner", type="reference", target={CareTeam.class, Device.class, HealthcareService.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_OWNER = "owner";
    public static final ReferenceClientParam OWNER = new ReferenceClientParam("owner");
    public static final Include INCLUDE_OWNER = new Include("Task:owner").toLocked();
    @SearchParamDefinition(name="part-of", path="Task.partOf", description="Search by task this task is part of", type="reference", target={Task.class})
    public static final String SP_PART_OF = "part-of";
    public static final ReferenceClientParam PART_OF = new ReferenceClientParam("part-of");
    public static final Include INCLUDE_PART_OF = new Include("Task:part-of").toLocked();
    @SearchParamDefinition(name="patient", path="Task.for.where(resolve() is Patient)", description="Search by patient", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Task:patient").toLocked();
    @SearchParamDefinition(name="performer", path="Task.requestedPerformer.reference", description="Search by specific requested performer.", type="reference")
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("Task:performer").toLocked();
    @SearchParamDefinition(name="period", path="Task.executionPeriod", description="Search by period Task is/was underway", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="priority", path="Task.priority", description="Search by task priority", type="token")
    public static final String SP_PRIORITY = "priority";
    public static final TokenClientParam PRIORITY = new TokenClientParam("priority");
    @SearchParamDefinition(name="requester", path="Task.requester", description="Search by task requester", type="reference", target={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_REQUESTER = "requester";
    public static final ReferenceClientParam REQUESTER = new ReferenceClientParam("requester");
    public static final Include INCLUDE_REQUESTER = new Include("Task:requester").toLocked();
    @SearchParamDefinition(name="status", path="Task.status", description="Search by task status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="Task.for", description="Search by subject", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Task:subject").toLocked();

    public Task() {
    }

    public Task(TaskStatus status, TaskIntent intent) {
        this.setStatus(status);
        this.setIntent(intent);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Task setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Task addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CanonicalType getInstantiatesCanonicalElement() {
        if (this.instantiatesCanonical == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.instantiatesCanonical");
            }
            if (Configuration.doAutoCreate()) {
                this.instantiatesCanonical = new CanonicalType();
            }
        }
        return this.instantiatesCanonical;
    }

    public boolean hasInstantiatesCanonicalElement() {
        return this.instantiatesCanonical != null && !this.instantiatesCanonical.isEmpty();
    }

    public boolean hasInstantiatesCanonical() {
        return this.instantiatesCanonical != null && !this.instantiatesCanonical.isEmpty();
    }

    public Task setInstantiatesCanonicalElement(CanonicalType value) {
        this.instantiatesCanonical = value;
        return this;
    }

    public String getInstantiatesCanonical() {
        return this.instantiatesCanonical == null ? null : (String)this.instantiatesCanonical.getValue();
    }

    public Task setInstantiatesCanonical(String value) {
        if (Utilities.noString(value)) {
            this.instantiatesCanonical = null;
        } else {
            if (this.instantiatesCanonical == null) {
                this.instantiatesCanonical = new CanonicalType();
            }
            this.instantiatesCanonical.setValue(value);
        }
        return this;
    }

    public UriType getInstantiatesUriElement() {
        if (this.instantiatesUri == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.instantiatesUri");
            }
            if (Configuration.doAutoCreate()) {
                this.instantiatesUri = new UriType();
            }
        }
        return this.instantiatesUri;
    }

    public boolean hasInstantiatesUriElement() {
        return this.instantiatesUri != null && !this.instantiatesUri.isEmpty();
    }

    public boolean hasInstantiatesUri() {
        return this.instantiatesUri != null && !this.instantiatesUri.isEmpty();
    }

    public Task setInstantiatesUriElement(UriType value) {
        this.instantiatesUri = value;
        return this;
    }

    public String getInstantiatesUri() {
        return this.instantiatesUri == null ? null : (String)this.instantiatesUri.getValue();
    }

    public Task setInstantiatesUri(String value) {
        if (Utilities.noString(value)) {
            this.instantiatesUri = null;
        } else {
            if (this.instantiatesUri == null) {
                this.instantiatesUri = new UriType();
            }
            this.instantiatesUri.setValue(value);
        }
        return this;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public Task setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public Task addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public Identifier getGroupIdentifier() {
        if (this.groupIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.groupIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.groupIdentifier = new Identifier();
            }
        }
        return this.groupIdentifier;
    }

    public boolean hasGroupIdentifier() {
        return this.groupIdentifier != null && !this.groupIdentifier.isEmpty();
    }

    public Task setGroupIdentifier(Identifier value) {
        this.groupIdentifier = value;
        return this;
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public Task setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public Task addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public Enumeration<TaskStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<TaskStatus>(new TaskStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Task setStatusElement(Enumeration<TaskStatus> value) {
        this.status = value;
        return this;
    }

    public TaskStatus getStatus() {
        return this.status == null ? null : (TaskStatus)((Object)this.status.getValue());
    }

    public Task setStatus(TaskStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<TaskStatus>(new TaskStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableReference getStatusReason() {
        if (this.statusReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.statusReason");
            }
            if (Configuration.doAutoCreate()) {
                this.statusReason = new CodeableReference();
            }
        }
        return this.statusReason;
    }

    public boolean hasStatusReason() {
        return this.statusReason != null && !this.statusReason.isEmpty();
    }

    public Task setStatusReason(CodeableReference value) {
        this.statusReason = value;
        return this;
    }

    public CodeableConcept getBusinessStatus() {
        if (this.businessStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.businessStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.businessStatus = new CodeableConcept();
            }
        }
        return this.businessStatus;
    }

    public boolean hasBusinessStatus() {
        return this.businessStatus != null && !this.businessStatus.isEmpty();
    }

    public Task setBusinessStatus(CodeableConcept value) {
        this.businessStatus = value;
        return this;
    }

    public Enumeration<TaskIntent> getIntentElement() {
        if (this.intent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.intent");
            }
            if (Configuration.doAutoCreate()) {
                this.intent = new Enumeration<TaskIntent>(new TaskIntentEnumFactory());
            }
        }
        return this.intent;
    }

    public boolean hasIntentElement() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public boolean hasIntent() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public Task setIntentElement(Enumeration<TaskIntent> value) {
        this.intent = value;
        return this;
    }

    public TaskIntent getIntent() {
        return this.intent == null ? null : (TaskIntent)((Object)this.intent.getValue());
    }

    public Task setIntent(TaskIntent value) {
        if (this.intent == null) {
            this.intent = new Enumeration<TaskIntent>(new TaskIntentEnumFactory());
        }
        this.intent.setValue((Object)value);
        return this;
    }

    public Enumeration<Enumerations.RequestPriority> getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public Task setPriorityElement(Enumeration<Enumerations.RequestPriority> value) {
        this.priority = value;
        return this;
    }

    public Enumerations.RequestPriority getPriority() {
        return this.priority == null ? null : (Enumerations.RequestPriority)((Object)this.priority.getValue());
    }

    public Task setPriority(Enumerations.RequestPriority value) {
        if (value == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
            }
            this.priority.setValue((Object)value);
        }
        return this;
    }

    public BooleanType getDoNotPerformElement() {
        if (this.doNotPerform == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.doNotPerform");
            }
            if (Configuration.doAutoCreate()) {
                this.doNotPerform = new BooleanType();
            }
        }
        return this.doNotPerform;
    }

    public boolean hasDoNotPerformElement() {
        return this.doNotPerform != null && !this.doNotPerform.isEmpty();
    }

    public boolean hasDoNotPerform() {
        return this.doNotPerform != null && !this.doNotPerform.isEmpty();
    }

    public Task setDoNotPerformElement(BooleanType value) {
        this.doNotPerform = value;
        return this;
    }

    public boolean getDoNotPerform() {
        return this.doNotPerform == null || this.doNotPerform.isEmpty() ? false : (Boolean)this.doNotPerform.getValue();
    }

    public Task setDoNotPerform(boolean value) {
        if (this.doNotPerform == null) {
            this.doNotPerform = new BooleanType();
        }
        this.doNotPerform.setValue((Object)value);
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Task setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Task setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Task setDescription(String value) {
        if (Utilities.noString(value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public Reference getFocus() {
        if (this.focus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.focus");
            }
            if (Configuration.doAutoCreate()) {
                this.focus = new Reference();
            }
        }
        return this.focus;
    }

    public boolean hasFocus() {
        return this.focus != null && !this.focus.isEmpty();
    }

    public Task setFocus(Reference value) {
        this.focus = value;
        return this;
    }

    public Reference getFor() {
        if (this.for_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.for_");
            }
            if (Configuration.doAutoCreate()) {
                this.for_ = new Reference();
            }
        }
        return this.for_;
    }

    public boolean hasFor() {
        return this.for_ != null && !this.for_.isEmpty();
    }

    public Task setFor(Reference value) {
        this.for_ = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public Task setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Period getRequestedPeriod() {
        if (this.requestedPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.requestedPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.requestedPeriod = new Period();
            }
        }
        return this.requestedPeriod;
    }

    public boolean hasRequestedPeriod() {
        return this.requestedPeriod != null && !this.requestedPeriod.isEmpty();
    }

    public Task setRequestedPeriod(Period value) {
        this.requestedPeriod = value;
        return this;
    }

    public Period getExecutionPeriod() {
        if (this.executionPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.executionPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.executionPeriod = new Period();
            }
        }
        return this.executionPeriod;
    }

    public boolean hasExecutionPeriod() {
        return this.executionPeriod != null && !this.executionPeriod.isEmpty();
    }

    public Task setExecutionPeriod(Period value) {
        this.executionPeriod = value;
        return this;
    }

    public DateTimeType getAuthoredOnElement() {
        if (this.authoredOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.authoredOn");
            }
            if (Configuration.doAutoCreate()) {
                this.authoredOn = new DateTimeType();
            }
        }
        return this.authoredOn;
    }

    public boolean hasAuthoredOnElement() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public boolean hasAuthoredOn() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public Task setAuthoredOnElement(DateTimeType value) {
        this.authoredOn = value;
        return this;
    }

    public Date getAuthoredOn() {
        return this.authoredOn == null ? null : (Date)this.authoredOn.getValue();
    }

    public Task setAuthoredOn(Date value) {
        if (value == null) {
            this.authoredOn = null;
        } else {
            if (this.authoredOn == null) {
                this.authoredOn = new DateTimeType();
            }
            this.authoredOn.setValue(value);
        }
        return this;
    }

    public DateTimeType getLastModifiedElement() {
        if (this.lastModified == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.lastModified");
            }
            if (Configuration.doAutoCreate()) {
                this.lastModified = new DateTimeType();
            }
        }
        return this.lastModified;
    }

    public boolean hasLastModifiedElement() {
        return this.lastModified != null && !this.lastModified.isEmpty();
    }

    public boolean hasLastModified() {
        return this.lastModified != null && !this.lastModified.isEmpty();
    }

    public Task setLastModifiedElement(DateTimeType value) {
        this.lastModified = value;
        return this;
    }

    public Date getLastModified() {
        return this.lastModified == null ? null : (Date)this.lastModified.getValue();
    }

    public Task setLastModified(Date value) {
        if (value == null) {
            this.lastModified = null;
        } else {
            if (this.lastModified == null) {
                this.lastModified = new DateTimeType();
            }
            this.lastModified.setValue(value);
        }
        return this;
    }

    public Reference getRequester() {
        if (this.requester == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.requester");
            }
            if (Configuration.doAutoCreate()) {
                this.requester = new Reference();
            }
        }
        return this.requester;
    }

    public boolean hasRequester() {
        return this.requester != null && !this.requester.isEmpty();
    }

    public Task setRequester(Reference value) {
        this.requester = value;
        return this;
    }

    public List<CodeableReference> getRequestedPerformer() {
        if (this.requestedPerformer == null) {
            this.requestedPerformer = new ArrayList<CodeableReference>();
        }
        return this.requestedPerformer;
    }

    public Task setRequestedPerformer(List<CodeableReference> theRequestedPerformer) {
        this.requestedPerformer = theRequestedPerformer;
        return this;
    }

    public boolean hasRequestedPerformer() {
        if (this.requestedPerformer == null) {
            return false;
        }
        for (CodeableReference item : this.requestedPerformer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addRequestedPerformer() {
        CodeableReference t = new CodeableReference();
        if (this.requestedPerformer == null) {
            this.requestedPerformer = new ArrayList<CodeableReference>();
        }
        this.requestedPerformer.add(t);
        return t;
    }

    public Task addRequestedPerformer(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.requestedPerformer == null) {
            this.requestedPerformer = new ArrayList<CodeableReference>();
        }
        this.requestedPerformer.add(t);
        return this;
    }

    public CodeableReference getRequestedPerformerFirstRep() {
        if (this.getRequestedPerformer().isEmpty()) {
            this.addRequestedPerformer();
        }
        return this.getRequestedPerformer().get(0);
    }

    public Reference getOwner() {
        if (this.owner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.owner = new Reference();
            }
        }
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public Task setOwner(Reference value) {
        this.owner = value;
        return this;
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public Task setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public Task setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public Task addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<Reference> getInsurance() {
        if (this.insurance == null) {
            this.insurance = new ArrayList<Reference>();
        }
        return this.insurance;
    }

    public Task setInsurance(List<Reference> theInsurance) {
        this.insurance = theInsurance;
        return this;
    }

    public boolean hasInsurance() {
        if (this.insurance == null) {
            return false;
        }
        for (Reference item : this.insurance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addInsurance() {
        Reference t = new Reference();
        if (this.insurance == null) {
            this.insurance = new ArrayList<Reference>();
        }
        this.insurance.add(t);
        return t;
    }

    public Task addInsurance(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.insurance == null) {
            this.insurance = new ArrayList<Reference>();
        }
        this.insurance.add(t);
        return this;
    }

    public Reference getInsuranceFirstRep() {
        if (this.getInsurance().isEmpty()) {
            this.addInsurance();
        }
        return this.getInsurance().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Task setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Task addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<Reference> getRelevantHistory() {
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        return this.relevantHistory;
    }

    public Task setRelevantHistory(List<Reference> theRelevantHistory) {
        this.relevantHistory = theRelevantHistory;
        return this;
    }

    public boolean hasRelevantHistory() {
        if (this.relevantHistory == null) {
            return false;
        }
        for (Reference item : this.relevantHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRelevantHistory() {
        Reference t = new Reference();
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        this.relevantHistory.add(t);
        return t;
    }

    public Task addRelevantHistory(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        this.relevantHistory.add(t);
        return this;
    }

    public Reference getRelevantHistoryFirstRep() {
        if (this.getRelevantHistory().isEmpty()) {
            this.addRelevantHistory();
        }
        return this.getRelevantHistory().get(0);
    }

    public TaskRestrictionComponent getRestriction() {
        if (this.restriction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.restriction");
            }
            if (Configuration.doAutoCreate()) {
                this.restriction = new TaskRestrictionComponent();
            }
        }
        return this.restriction;
    }

    public boolean hasRestriction() {
        return this.restriction != null && !this.restriction.isEmpty();
    }

    public Task setRestriction(TaskRestrictionComponent value) {
        this.restriction = value;
        return this;
    }

    public List<TaskInputComponent> getInput() {
        if (this.input == null) {
            this.input = new ArrayList<TaskInputComponent>();
        }
        return this.input;
    }

    public Task setInput(List<TaskInputComponent> theInput) {
        this.input = theInput;
        return this;
    }

    public boolean hasInput() {
        if (this.input == null) {
            return false;
        }
        for (TaskInputComponent item : this.input) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TaskInputComponent addInput() {
        TaskInputComponent t = new TaskInputComponent();
        if (this.input == null) {
            this.input = new ArrayList<TaskInputComponent>();
        }
        this.input.add(t);
        return t;
    }

    public Task addInput(TaskInputComponent t) {
        if (t == null) {
            return this;
        }
        if (this.input == null) {
            this.input = new ArrayList<TaskInputComponent>();
        }
        this.input.add(t);
        return this;
    }

    public TaskInputComponent getInputFirstRep() {
        if (this.getInput().isEmpty()) {
            this.addInput();
        }
        return this.getInput().get(0);
    }

    public List<TaskOutputComponent> getOutput() {
        if (this.output == null) {
            this.output = new ArrayList<TaskOutputComponent>();
        }
        return this.output;
    }

    public Task setOutput(List<TaskOutputComponent> theOutput) {
        this.output = theOutput;
        return this;
    }

    public boolean hasOutput() {
        if (this.output == null) {
            return false;
        }
        for (TaskOutputComponent item : this.output) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TaskOutputComponent addOutput() {
        TaskOutputComponent t = new TaskOutputComponent();
        if (this.output == null) {
            this.output = new ArrayList<TaskOutputComponent>();
        }
        this.output.add(t);
        return t;
    }

    public Task addOutput(TaskOutputComponent t) {
        if (t == null) {
            return this;
        }
        if (this.output == null) {
            this.output = new ArrayList<TaskOutputComponent>();
        }
        this.output.add(t);
        return this;
    }

    public TaskOutputComponent getOutputFirstRep() {
        if (this.getOutput().isEmpty()) {
            this.addOutput();
        }
        return this.getOutput().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The business identifier for this task.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("instantiatesCanonical", "canonical(ActivityDefinition)", "The URL pointing to a *FHIR*-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Task.", 0, 1, this.instantiatesCanonical));
        children.add(new Property("instantiatesUri", "uri", "The URL pointing to an *externally* maintained  protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Task.", 0, 1, this.instantiatesUri));
        children.add(new Property("basedOn", "Reference(Any)", "BasedOn refers to a higher-level authorization that triggered the creation of the task.  It references a \"request\" resource such as a ServiceRequest, MedicationRequest, CarePlan, etc. which is distinct from the \"request\" resource the task is seeking to fulfill.  This latter resource is referenced by focus.  For example, based on a CarePlan (= basedOn), a task is created to fulfill a ServiceRequest ( = focus ) to collect a specimen from a patient.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("groupIdentifier", "Identifier", "An identifier that links together multiple tasks and other requests that were created in the same context.", 0, 1, this.groupIdentifier));
        children.add(new Property("partOf", "Reference(Task)", "Task that this particular task is part of.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, SP_CODE, "The current status of the task.", 0, 1, this.status));
        children.add(new Property("statusReason", "CodeableReference", "An explanation as to why this task is held, failed, was refused, etc.", 0, 1, this.statusReason));
        children.add(new Property("businessStatus", "CodeableConcept", "Contains business-specific nuances of the business state.", 0, 1, this.businessStatus));
        children.add(new Property(SP_INTENT, SP_CODE, "Indicates the \"level\" of actionability associated with the Task, i.e. i+R[9]Cs this a proposed task, a planned task, an actionable task, etc.", 0, 1, this.intent));
        children.add(new Property(SP_PRIORITY, SP_CODE, "Indicates how quickly the Task should be addressed with respect to other requests.", 0, 1, this.priority));
        children.add(new Property("doNotPerform", "boolean", "If true indicates that the Task is asking for the specified action to *not* occur.", 0, 1, this.doNotPerform));
        children.add(new Property(SP_CODE, "CodeableConcept", "A name or code (or both) briefly describing what the task involves.", 0, 1, this.code));
        children.add(new Property("description", "string", "A free-text description of what is to be performed.", 0, 1, this.description));
        children.add(new Property(SP_FOCUS, "Reference(Any)", "The request being fulfilled or the resource being manipulated (changed, suspended, etc.) by this task.", 0, 1, this.focus));
        children.add(new Property("for", "Reference(Any)", "The entity who benefits from the performance of the service specified in the task (e.g., the patient).", 0, 1, this.for_));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The healthcare event  (e.g. a patient and healthcare provider interaction) during which this task was created.", 0, 1, this.encounter));
        children.add(new Property("requestedPeriod", "Period", "Indicates the start and/or end of the period of time when completion of the task is desired to take place.", 0, 1, this.requestedPeriod));
        children.add(new Property("executionPeriod", "Period", "Identifies the time action was first taken against the task (start) and/or the time final action was taken against the task prior to marking it as completed (end).", 0, 1, this.executionPeriod));
        children.add(new Property("authoredOn", "dateTime", "The date and time this task was created.", 0, 1, this.authoredOn));
        children.add(new Property("lastModified", "dateTime", "The date and time of last modification to this task.", 0, 1, this.lastModified));
        children.add(new Property(SP_REQUESTER, "Reference(Device|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "The creator of the task.", 0, 1, this.requester));
        children.add(new Property("requestedPerformer", "CodeableReference(Practitioner|PractitionerRole|Organization|CareTeam|HealthcareService|Patient|Device|RelatedPerson)", "The kind of participant or specific participant that should perform the task.", 0, Integer.MAX_VALUE, this.requestedPerformer));
        children.add(new Property(SP_OWNER, "Reference(Practitioner|PractitionerRole|Organization|CareTeam|HealthcareService|Patient|Device|RelatedPerson)", "Individual organization or Device currently responsible for task execution.", 0, 1, this.owner));
        children.add(new Property("location", "Reference(Location)", "Principal physical location where the this task is performed.", 0, 1, this.location));
        children.add(new Property("reason", "CodeableReference", "A description, code, or reference indicating why this task needs to be performed.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("insurance", "Reference(Coverage|ClaimResponse)", "Insurance plans, coverage extensions, pre-authorizations and/or pre-determinations that may be relevant to the Task.", 0, Integer.MAX_VALUE, this.insurance));
        children.add(new Property("note", "Annotation", "Free-text information captured about the task as it progresses.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("relevantHistory", "Reference(Provenance)", "Links to Provenance records for past versions of this Task that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the task.", 0, Integer.MAX_VALUE, this.relevantHistory));
        children.add(new Property("restriction", "", "If the Task.focus is a request resource and the task is seeking fulfillment (i.e. is asking for the request to be actioned), this element identifies any limitations on what parts of the referenced request should be actioned.", 0, 1, this.restriction));
        children.add(new Property("input", "", "Additional information that may be needed in the execution of the task.", 0, Integer.MAX_VALUE, this.input));
        children.add(new Property(SP_OUTPUT, "", "Outputs produced by the Task.", 0, Integer.MAX_VALUE, this.output));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The business identifier for this task.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 8911915: {
                return new Property("instantiatesCanonical", "canonical(ActivityDefinition)", "The URL pointing to a *FHIR*-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Task.", 0, 1, this.instantiatesCanonical);
            }
            case -1926393373: {
                return new Property("instantiatesUri", "uri", "The URL pointing to an *externally* maintained  protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Task.", 0, 1, this.instantiatesUri);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(Any)", "BasedOn refers to a higher-level authorization that triggered the creation of the task.  It references a \"request\" resource such as a ServiceRequest, MedicationRequest, CarePlan, etc. which is distinct from the \"request\" resource the task is seeking to fulfill.  This latter resource is referenced by focus.  For example, based on a CarePlan (= basedOn), a task is created to fulfill a ServiceRequest ( = focus ) to collect a specimen from a patient.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -445338488: {
                return new Property("groupIdentifier", "Identifier", "An identifier that links together multiple tasks and other requests that were created in the same context.", 0, 1, this.groupIdentifier);
            }
            case -995410646: {
                return new Property("partOf", "Reference(Task)", "Task that this particular task is part of.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The current status of the task.", 0, 1, this.status);
            }
            case 2051346646: {
                return new Property("statusReason", "CodeableReference", "An explanation as to why this task is held, failed, was refused, etc.", 0, 1, this.statusReason);
            }
            case 2008591314: {
                return new Property("businessStatus", "CodeableConcept", "Contains business-specific nuances of the business state.", 0, 1, this.businessStatus);
            }
            case -1183762788: {
                return new Property(SP_INTENT, SP_CODE, "Indicates the \"level\" of actionability associated with the Task, i.e. i+R[9]Cs this a proposed task, a planned task, an actionable task, etc.", 0, 1, this.intent);
            }
            case -1165461084: {
                return new Property(SP_PRIORITY, SP_CODE, "Indicates how quickly the Task should be addressed with respect to other requests.", 0, 1, this.priority);
            }
            case -1788508167: {
                return new Property("doNotPerform", "boolean", "If true indicates that the Task is asking for the specified action to *not* occur.", 0, 1, this.doNotPerform);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "A name or code (or both) briefly describing what the task involves.", 0, 1, this.code);
            }
            case -1724546052: {
                return new Property("description", "string", "A free-text description of what is to be performed.", 0, 1, this.description);
            }
            case 97604824: {
                return new Property(SP_FOCUS, "Reference(Any)", "The request being fulfilled or the resource being manipulated (changed, suspended, etc.) by this task.", 0, 1, this.focus);
            }
            case 101577: {
                return new Property("for", "Reference(Any)", "The entity who benefits from the performance of the service specified in the task (e.g., the patient).", 0, 1, this.for_);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The healthcare event  (e.g. a patient and healthcare provider interaction) during which this task was created.", 0, 1, this.encounter);
            }
            case -897241393: {
                return new Property("requestedPeriod", "Period", "Indicates the start and/or end of the period of time when completion of the task is desired to take place.", 0, 1, this.requestedPeriod);
            }
            case 1218624249: {
                return new Property("executionPeriod", "Period", "Identifies the time action was first taken against the task (start) and/or the time final action was taken against the task prior to marking it as completed (end).", 0, 1, this.executionPeriod);
            }
            case -1500852503: {
                return new Property("authoredOn", "dateTime", "The date and time this task was created.", 0, 1, this.authoredOn);
            }
            case 1959003007: {
                return new Property("lastModified", "dateTime", "The date and time of last modification to this task.", 0, 1, this.lastModified);
            }
            case 693933948: {
                return new Property(SP_REQUESTER, "Reference(Device|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "The creator of the task.", 0, 1, this.requester);
            }
            case 2072749056: {
                return new Property("requestedPerformer", "CodeableReference(Practitioner|PractitionerRole|Organization|CareTeam|HealthcareService|Patient|Device|RelatedPerson)", "The kind of participant or specific participant that should perform the task.", 0, Integer.MAX_VALUE, this.requestedPerformer);
            }
            case 106164915: {
                return new Property(SP_OWNER, "Reference(Practitioner|PractitionerRole|Organization|CareTeam|HealthcareService|Patient|Device|RelatedPerson)", "Individual organization or Device currently responsible for task execution.", 0, 1, this.owner);
            }
            case 1901043637: {
                return new Property("location", "Reference(Location)", "Principal physical location where the this task is performed.", 0, 1, this.location);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference", "A description, code, or reference indicating why this task needs to be performed.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 73049818: {
                return new Property("insurance", "Reference(Coverage|ClaimResponse)", "Insurance plans, coverage extensions, pre-authorizations and/or pre-determinations that may be relevant to the Task.", 0, Integer.MAX_VALUE, this.insurance);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Free-text information captured about the task as it progresses.", 0, Integer.MAX_VALUE, this.note);
            }
            case 1538891575: {
                return new Property("relevantHistory", "Reference(Provenance)", "Links to Provenance records for past versions of this Task that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the task.", 0, Integer.MAX_VALUE, this.relevantHistory);
            }
            case -1561062452: {
                return new Property("restriction", "", "If the Task.focus is a request resource and the task is seeking fulfillment (i.e. is asking for the request to be actioned), this element identifies any limitations on what parts of the referenced request should be actioned.", 0, 1, this.restriction);
            }
            case 100358090: {
                return new Property("input", "", "Additional information that may be needed in the execution of the task.", 0, Integer.MAX_VALUE, this.input);
            }
            case -1005512447: {
                return new Property(SP_OUTPUT, "", "Outputs produced by the Task.", 0, Integer.MAX_VALUE, this.output);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 8911915: {
                Base[] baseArray;
                if (this.instantiatesCanonical == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.instantiatesCanonical;
                }
                return baseArray;
            }
            case -1926393373: {
                Base[] baseArray;
                if (this.instantiatesUri == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.instantiatesUri;
                }
                return baseArray;
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -445338488: {
                Base[] baseArray;
                if (this.groupIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.groupIdentifier;
                }
                return baseArray;
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case 2051346646: {
                Base[] baseArray;
                if (this.statusReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.statusReason;
                }
                return baseArray;
            }
            case 2008591314: {
                Base[] baseArray;
                if (this.businessStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.businessStatus;
                }
                return baseArray;
            }
            case -1183762788: {
                Base[] baseArray;
                if (this.intent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.intent;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.priority;
                }
                return baseArray;
            }
            case -1788508167: {
                Base[] baseArray;
                if (this.doNotPerform == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.doNotPerform;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.code;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.description;
                }
                return baseArray;
            }
            case 97604824: {
                Base[] baseArray;
                if (this.focus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.focus;
                }
                return baseArray;
            }
            case 101577: {
                Base[] baseArray;
                if (this.for_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.for_;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.encounter;
                }
                return baseArray;
            }
            case -897241393: {
                Base[] baseArray;
                if (this.requestedPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.requestedPeriod;
                }
                return baseArray;
            }
            case 1218624249: {
                Base[] baseArray;
                if (this.executionPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.executionPeriod;
                }
                return baseArray;
            }
            case -1500852503: {
                Base[] baseArray;
                if (this.authoredOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.authoredOn;
                }
                return baseArray;
            }
            case 1959003007: {
                Base[] baseArray;
                if (this.lastModified == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.lastModified;
                }
                return baseArray;
            }
            case 693933948: {
                Base[] baseArray;
                if (this.requester == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.requester;
                }
                return baseArray;
            }
            case 2072749056: {
                return this.requestedPerformer == null ? new Base[]{} : this.requestedPerformer.toArray(new Base[this.requestedPerformer.size()]);
            }
            case 106164915: {
                Base[] baseArray;
                if (this.owner == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.owner;
                }
                return baseArray;
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray22 = new Base[1];
                    baseArray = baseArray22;
                    baseArray22[0] = this.location;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 73049818: {
                return this.insurance == null ? new Base[]{} : this.insurance.toArray(new Base[this.insurance.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 1538891575: {
                return this.relevantHistory == null ? new Base[]{} : this.relevantHistory.toArray(new Base[this.relevantHistory.size()]);
            }
            case -1561062452: {
                Base[] baseArray;
                if (this.restriction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray23 = new Base[1];
                    baseArray = baseArray23;
                    baseArray23[0] = this.restriction;
                }
                return baseArray;
            }
            case 100358090: {
                return this.input == null ? new Base[]{} : this.input.toArray(new Base[this.input.size()]);
            }
            case -1005512447: {
                return this.output == null ? new Base[]{} : this.output.toArray(new Base[this.output.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 8911915: {
                this.instantiatesCanonical = TypeConvertor.castToCanonical(value);
                return value;
            }
            case -1926393373: {
                this.instantiatesUri = TypeConvertor.castToUri(value);
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -445338488: {
                this.groupIdentifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case -995410646: {
                this.getPartOf().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new TaskStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 2051346646: {
                this.statusReason = TypeConvertor.castToCodeableReference(value);
                return value;
            }
            case 2008591314: {
                this.businessStatus = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1183762788: {
                value = new TaskIntentEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.intent = value;
                return value;
            }
            case -1165461084: {
                value = new Enumerations.RequestPriorityEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.priority = value;
                return value;
            }
            case -1788508167: {
                this.doNotPerform = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToString(value);
                return value;
            }
            case 97604824: {
                this.focus = TypeConvertor.castToReference(value);
                return value;
            }
            case 101577: {
                this.for_ = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -897241393: {
                this.requestedPeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 1218624249: {
                this.executionPeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -1500852503: {
                this.authoredOn = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1959003007: {
                this.lastModified = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 693933948: {
                this.requester = TypeConvertor.castToReference(value);
                return value;
            }
            case 2072749056: {
                this.getRequestedPerformer().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 106164915: {
                this.owner = TypeConvertor.castToReference(value);
                return value;
            }
            case 1901043637: {
                this.location = TypeConvertor.castToReference(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 73049818: {
                this.getInsurance().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 1538891575: {
                this.getRelevantHistory().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1561062452: {
                this.restriction = (TaskRestrictionComponent)((Object)value);
                return value;
            }
            case 100358090: {
                this.getInput().add((TaskInputComponent)((Object)value));
                return value;
            }
            case -1005512447: {
                this.getOutput().add((TaskOutputComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("instantiatesCanonical")) {
            this.instantiatesCanonical = TypeConvertor.castToCanonical(value);
        } else if (name.equals("instantiatesUri")) {
            this.instantiatesUri = TypeConvertor.castToUri(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("groupIdentifier")) {
            this.groupIdentifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals("partOf")) {
            this.getPartOf().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new TaskStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("statusReason")) {
            this.statusReason = TypeConvertor.castToCodeableReference(value);
        } else if (name.equals("businessStatus")) {
            this.businessStatus = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_INTENT)) {
            value = new TaskIntentEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.intent = value;
        } else if (name.equals(SP_PRIORITY)) {
            value = new Enumerations.RequestPriorityEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.priority = value;
        } else if (name.equals("doNotPerform")) {
            this.doNotPerform = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToString(value);
        } else if (name.equals(SP_FOCUS)) {
            this.focus = TypeConvertor.castToReference(value);
        } else if (name.equals("for")) {
            this.for_ = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("requestedPeriod")) {
            this.requestedPeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals("executionPeriod")) {
            this.executionPeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals("authoredOn")) {
            this.authoredOn = TypeConvertor.castToDateTime(value);
        } else if (name.equals("lastModified")) {
            this.lastModified = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_REQUESTER)) {
            this.requester = TypeConvertor.castToReference(value);
        } else if (name.equals("requestedPerformer")) {
            this.getRequestedPerformer().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals(SP_OWNER)) {
            this.owner = TypeConvertor.castToReference(value);
        } else if (name.equals("location")) {
            this.location = TypeConvertor.castToReference(value);
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("insurance")) {
            this.getInsurance().add(TypeConvertor.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("relevantHistory")) {
            this.getRelevantHistory().add(TypeConvertor.castToReference(value));
        } else if (name.equals("restriction")) {
            this.restriction = (TaskRestrictionComponent)((Object)value);
        } else if (name.equals("input")) {
            this.getInput().add((TaskInputComponent)((Object)value));
        } else if (name.equals(SP_OUTPUT)) {
            this.getOutput().add((TaskOutputComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 8911915: {
                return this.getInstantiatesCanonicalElement();
            }
            case -1926393373: {
                return this.getInstantiatesUriElement();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -445338488: {
                return this.getGroupIdentifier();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2051346646: {
                return this.getStatusReason();
            }
            case 2008591314: {
                return this.getBusinessStatus();
            }
            case -1183762788: {
                return this.getIntentElement();
            }
            case -1165461084: {
                return this.getPriorityElement();
            }
            case -1788508167: {
                return this.getDoNotPerformElement();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 97604824: {
                return this.getFocus();
            }
            case 101577: {
                return this.getFor();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -897241393: {
                return this.getRequestedPeriod();
            }
            case 1218624249: {
                return this.getExecutionPeriod();
            }
            case -1500852503: {
                return this.getAuthoredOnElement();
            }
            case 1959003007: {
                return this.getLastModifiedElement();
            }
            case 693933948: {
                return this.getRequester();
            }
            case 2072749056: {
                return this.addRequestedPerformer();
            }
            case 106164915: {
                return this.getOwner();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case -934964668: {
                return this.addReason();
            }
            case 73049818: {
                return this.addInsurance();
            }
            case 3387378: {
                return this.addNote();
            }
            case 1538891575: {
                return this.addRelevantHistory();
            }
            case -1561062452: {
                return this.getRestriction();
            }
            case 100358090: {
                return this.addInput();
            }
            case -1005512447: {
                return this.addOutput();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 8911915: {
                return new String[]{"canonical"};
            }
            case -1926393373: {
                return new String[]{"uri"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -445338488: {
                return new String[]{"Identifier"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 2051346646: {
                return new String[]{"CodeableReference"};
            }
            case 2008591314: {
                return new String[]{"CodeableConcept"};
            }
            case -1183762788: {
                return new String[]{SP_CODE};
            }
            case -1165461084: {
                return new String[]{SP_CODE};
            }
            case -1788508167: {
                return new String[]{"boolean"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case 97604824: {
                return new String[]{"Reference"};
            }
            case 101577: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -897241393: {
                return new String[]{"Period"};
            }
            case 1218624249: {
                return new String[]{"Period"};
            }
            case -1500852503: {
                return new String[]{"dateTime"};
            }
            case 1959003007: {
                return new String[]{"dateTime"};
            }
            case 693933948: {
                return new String[]{"Reference"};
            }
            case 2072749056: {
                return new String[]{"CodeableReference"};
            }
            case 106164915: {
                return new String[]{"Reference"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case 73049818: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 1538891575: {
                return new String[]{"Reference"};
            }
            case -1561062452: {
                return new String[0];
            }
            case 100358090: {
                return new String[0];
            }
            case -1005512447: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("instantiatesCanonical")) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.instantiatesCanonical");
        }
        if (name.equals("instantiatesUri")) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.instantiatesUri");
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("groupIdentifier")) {
            this.groupIdentifier = new Identifier();
            return this.groupIdentifier;
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.status");
        }
        if (name.equals("statusReason")) {
            this.statusReason = new CodeableReference();
            return this.statusReason;
        }
        if (name.equals("businessStatus")) {
            this.businessStatus = new CodeableConcept();
            return this.businessStatus;
        }
        if (name.equals(SP_INTENT)) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.intent");
        }
        if (name.equals(SP_PRIORITY)) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.priority");
        }
        if (name.equals("doNotPerform")) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.doNotPerform");
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.description");
        }
        if (name.equals(SP_FOCUS)) {
            this.focus = new Reference();
            return this.focus;
        }
        if (name.equals("for")) {
            this.for_ = new Reference();
            return this.for_;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("requestedPeriod")) {
            this.requestedPeriod = new Period();
            return this.requestedPeriod;
        }
        if (name.equals("executionPeriod")) {
            this.executionPeriod = new Period();
            return this.executionPeriod;
        }
        if (name.equals("authoredOn")) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.authoredOn");
        }
        if (name.equals("lastModified")) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.lastModified");
        }
        if (name.equals(SP_REQUESTER)) {
            this.requester = new Reference();
            return this.requester;
        }
        if (name.equals("requestedPerformer")) {
            return this.addRequestedPerformer();
        }
        if (name.equals(SP_OWNER)) {
            this.owner = new Reference();
            return this.owner;
        }
        if (name.equals("location")) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("insurance")) {
            return this.addInsurance();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("relevantHistory")) {
            return this.addRelevantHistory();
        }
        if (name.equals("restriction")) {
            this.restriction = new TaskRestrictionComponent();
            return this.restriction;
        }
        if (name.equals("input")) {
            return this.addInput();
        }
        if (name.equals(SP_OUTPUT)) {
            return this.addOutput();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Task";
    }

    @Override
    public Task copy() {
        Task dst = new Task();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Task dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.instantiatesCanonical = this.instantiatesCanonical == null ? null : this.instantiatesCanonical.copy();
        UriType uriType = dst.instantiatesUri = this.instantiatesUri == null ? null : this.instantiatesUri.copy();
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        Identifier identifier = dst.groupIdentifier = this.groupIdentifier == null ? null : this.groupIdentifier.copy();
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.statusReason = this.statusReason == null ? null : this.statusReason.copy();
        dst.businessStatus = this.businessStatus == null ? null : this.businessStatus.copy();
        dst.intent = this.intent == null ? null : this.intent.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.doNotPerform = this.doNotPerform == null ? null : this.doNotPerform.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.focus = this.focus == null ? null : this.focus.copy();
        dst.for_ = this.for_ == null ? null : this.for_.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.requestedPeriod = this.requestedPeriod == null ? null : this.requestedPeriod.copy();
        dst.executionPeriod = this.executionPeriod == null ? null : this.executionPeriod.copy();
        dst.authoredOn = this.authoredOn == null ? null : this.authoredOn.copy();
        dst.lastModified = this.lastModified == null ? null : this.lastModified.copy();
        Reference reference = dst.requester = this.requester == null ? null : this.requester.copy();
        if (this.requestedPerformer != null) {
            dst.requestedPerformer = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.requestedPerformer) {
                dst.requestedPerformer.add(codeableReference.copy());
            }
        }
        dst.owner = this.owner == null ? null : this.owner.copy();
        Reference reference2 = dst.location = this.location == null ? null : this.location.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        if (this.insurance != null) {
            dst.insurance = new ArrayList<Reference>();
            for (Reference reference3 : this.insurance) {
                dst.insurance.add(reference3.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.relevantHistory != null) {
            dst.relevantHistory = new ArrayList<Reference>();
            for (Reference reference4 : this.relevantHistory) {
                dst.relevantHistory.add(reference4.copy());
            }
        }
        TaskRestrictionComponent taskRestrictionComponent = dst.restriction = this.restriction == null ? null : this.restriction.copy();
        if (this.input != null) {
            dst.input = new ArrayList<TaskInputComponent>();
            for (TaskInputComponent taskInputComponent : this.input) {
                dst.input.add(taskInputComponent.copy());
            }
        }
        if (this.output != null) {
            dst.output = new ArrayList<TaskOutputComponent>();
            for (TaskOutputComponent taskOutputComponent : this.output) {
                dst.output.add(taskOutputComponent.copy());
            }
        }
    }

    protected Task typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Task)) {
            return false;
        }
        Task o = (Task)other_;
        return Task.compareDeep(this.identifier, o.identifier, true) && Task.compareDeep(this.instantiatesCanonical, o.instantiatesCanonical, true) && Task.compareDeep(this.instantiatesUri, o.instantiatesUri, true) && Task.compareDeep(this.basedOn, o.basedOn, true) && Task.compareDeep(this.groupIdentifier, o.groupIdentifier, true) && Task.compareDeep(this.partOf, o.partOf, true) && Task.compareDeep(this.status, o.status, true) && Task.compareDeep(this.statusReason, o.statusReason, true) && Task.compareDeep(this.businessStatus, o.businessStatus, true) && Task.compareDeep(this.intent, o.intent, true) && Task.compareDeep(this.priority, o.priority, true) && Task.compareDeep(this.doNotPerform, o.doNotPerform, true) && Task.compareDeep(this.code, o.code, true) && Task.compareDeep(this.description, o.description, true) && Task.compareDeep(this.focus, o.focus, true) && Task.compareDeep(this.for_, o.for_, true) && Task.compareDeep(this.encounter, o.encounter, true) && Task.compareDeep(this.requestedPeriod, o.requestedPeriod, true) && Task.compareDeep(this.executionPeriod, o.executionPeriod, true) && Task.compareDeep(this.authoredOn, o.authoredOn, true) && Task.compareDeep(this.lastModified, o.lastModified, true) && Task.compareDeep(this.requester, o.requester, true) && Task.compareDeep(this.requestedPerformer, o.requestedPerformer, true) && Task.compareDeep(this.owner, o.owner, true) && Task.compareDeep(this.location, o.location, true) && Task.compareDeep(this.reason, o.reason, true) && Task.compareDeep(this.insurance, o.insurance, true) && Task.compareDeep(this.note, o.note, true) && Task.compareDeep(this.relevantHistory, o.relevantHistory, true) && Task.compareDeep(this.restriction, o.restriction, true) && Task.compareDeep(this.input, o.input, true) && Task.compareDeep(this.output, o.output, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Task)) {
            return false;
        }
        Task o = (Task)other_;
        return Task.compareValues(this.instantiatesCanonical, o.instantiatesCanonical, true) && Task.compareValues(this.instantiatesUri, o.instantiatesUri, true) && Task.compareValues(this.status, o.status, true) && Task.compareValues(this.intent, o.intent, true) && Task.compareValues(this.priority, o.priority, true) && Task.compareValues(this.doNotPerform, o.doNotPerform, true) && Task.compareValues(this.description, o.description, true) && Task.compareValues(this.authoredOn, o.authoredOn, true) && Task.compareValues(this.lastModified, o.lastModified, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.basedOn, this.groupIdentifier, this.partOf, this.status, this.statusReason, this.businessStatus, this.intent, this.priority, this.doNotPerform, this.code, this.description, this.focus, this.for_, this.encounter, this.requestedPeriod, this.executionPeriod, this.authoredOn, this.lastModified, this.requester, this.requestedPerformer, this.owner, this.location, this.reason, this.insurance, this.note, this.relevantHistory, this.restriction, this.input, this.output);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Task;
    }

    @Block
    public static class TaskOutputComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for output", formalDefinition="The name of the Output parameter.")
        protected CodeableConcept type;
        @Child(name="value", type={Base64BinaryType.class, BooleanType.class, CanonicalType.class, CodeType.class, DateType.class, DateTimeType.class, DecimalType.class, IdType.class, InstantType.class, IntegerType.class, Integer64Type.class, MarkdownType.class, OidType.class, PositiveIntType.class, StringType.class, TimeType.class, UnsignedIntType.class, UriType.class, UrlType.class, UuidType.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, CodeableReference.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, RatioRange.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Availability.class, ExtendedContactDetail.class, Dosage.class, Meta.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Result of output", formalDefinition="The value of the Output parameter as a basic type.")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public TaskOutputComponent() {
        }

        public TaskOutputComponent(CodeableConcept type, DataType value) {
            this.setType(type);
            this.setValue(value);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TaskOutputComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public TaskOutputComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public Base64BinaryType getValueBase64BinaryType() throws FHIRException {
            if (this.value == null) {
                this.value = new Base64BinaryType();
            }
            if (!(this.value instanceof Base64BinaryType)) {
                throw new FHIRException("Type mismatch: the type Base64BinaryType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Base64BinaryType)this.value;
        }

        public boolean hasValueBase64BinaryType() {
            return this != null && this.value instanceof Base64BinaryType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public CanonicalType getValueCanonicalType() throws FHIRException {
            if (this.value == null) {
                this.value = new CanonicalType();
            }
            if (!(this.value instanceof CanonicalType)) {
                throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CanonicalType)this.value;
        }

        public boolean hasValueCanonicalType() {
            return this != null && this.value instanceof CanonicalType;
        }

        public CodeType getValueCodeType() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeType();
            }
            if (!(this.value instanceof CodeType)) {
                throw new FHIRException("Type mismatch: the type CodeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeType)this.value;
        }

        public boolean hasValueCodeType() {
            return this != null && this.value instanceof CodeType;
        }

        public DateType getValueDateType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateType();
            }
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this != null && this.value instanceof DateType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this != null && this.value instanceof DecimalType;
        }

        public IdType getValueIdType() throws FHIRException {
            if (this.value == null) {
                this.value = new IdType();
            }
            if (!(this.value instanceof IdType)) {
                throw new FHIRException("Type mismatch: the type IdType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IdType)this.value;
        }

        public boolean hasValueIdType() {
            return this != null && this.value instanceof IdType;
        }

        public InstantType getValueInstantType() throws FHIRException {
            if (this.value == null) {
                this.value = new InstantType();
            }
            if (!(this.value instanceof InstantType)) {
                throw new FHIRException("Type mismatch: the type InstantType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (InstantType)this.value;
        }

        public boolean hasValueInstantType() {
            return this != null && this.value instanceof InstantType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public Integer64Type getValueInteger64Type() throws FHIRException {
            if (this.value == null) {
                this.value = new Integer64Type();
            }
            if (!(this.value instanceof Integer64Type)) {
                throw new FHIRException("Type mismatch: the type Integer64Type was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Integer64Type)this.value;
        }

        public boolean hasValueInteger64Type() {
            return this != null && this.value instanceof Integer64Type;
        }

        public MarkdownType getValueMarkdownType() throws FHIRException {
            if (this.value == null) {
                this.value = new MarkdownType();
            }
            if (!(this.value instanceof MarkdownType)) {
                throw new FHIRException("Type mismatch: the type MarkdownType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (MarkdownType)this.value;
        }

        public boolean hasValueMarkdownType() {
            return this != null && this.value instanceof MarkdownType;
        }

        public OidType getValueOidType() throws FHIRException {
            if (this.value == null) {
                this.value = new OidType();
            }
            if (!(this.value instanceof OidType)) {
                throw new FHIRException("Type mismatch: the type OidType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (OidType)this.value;
        }

        public boolean hasValueOidType() {
            return this != null && this.value instanceof OidType;
        }

        public PositiveIntType getValuePositiveIntType() throws FHIRException {
            if (this.value == null) {
                this.value = new PositiveIntType();
            }
            if (!(this.value instanceof PositiveIntType)) {
                throw new FHIRException("Type mismatch: the type PositiveIntType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (PositiveIntType)this.value;
        }

        public boolean hasValuePositiveIntType() {
            return this != null && this.value instanceof PositiveIntType;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public TimeType getValueTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new TimeType();
            }
            if (!(this.value instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TimeType)this.value;
        }

        public boolean hasValueTimeType() {
            return this != null && this.value instanceof TimeType;
        }

        public UnsignedIntType getValueUnsignedIntType() throws FHIRException {
            if (this.value == null) {
                this.value = new UnsignedIntType();
            }
            if (!(this.value instanceof UnsignedIntType)) {
                throw new FHIRException("Type mismatch: the type UnsignedIntType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UnsignedIntType)this.value;
        }

        public boolean hasValueUnsignedIntType() {
            return this != null && this.value instanceof UnsignedIntType;
        }

        public UriType getValueUriType() throws FHIRException {
            if (this.value == null) {
                this.value = new UriType();
            }
            if (!(this.value instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UriType)this.value;
        }

        public boolean hasValueUriType() {
            return this != null && this.value instanceof UriType;
        }

        public UrlType getValueUrlType() throws FHIRException {
            if (this.value == null) {
                this.value = new UrlType();
            }
            if (!(this.value instanceof UrlType)) {
                throw new FHIRException("Type mismatch: the type UrlType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UrlType)this.value;
        }

        public boolean hasValueUrlType() {
            return this != null && this.value instanceof UrlType;
        }

        public UuidType getValueUuidType() throws FHIRException {
            if (this.value == null) {
                this.value = new UuidType();
            }
            if (!(this.value instanceof UuidType)) {
                throw new FHIRException("Type mismatch: the type UuidType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UuidType)this.value;
        }

        public boolean hasValueUuidType() {
            return this != null && this.value instanceof UuidType;
        }

        public Address getValueAddress() throws FHIRException {
            if (this.value == null) {
                this.value = new Address();
            }
            if (!(this.value instanceof Address)) {
                throw new FHIRException("Type mismatch: the type Address was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Address)this.value;
        }

        public boolean hasValueAddress() {
            return this != null && this.value instanceof Address;
        }

        public Age getValueAge() throws FHIRException {
            if (this.value == null) {
                this.value = new Age();
            }
            if (!(this.value instanceof Age)) {
                throw new FHIRException("Type mismatch: the type Age was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Age)this.value;
        }

        public boolean hasValueAge() {
            return this != null && this.value instanceof Age;
        }

        public Annotation getValueAnnotation() throws FHIRException {
            if (this.value == null) {
                this.value = new Annotation();
            }
            if (!(this.value instanceof Annotation)) {
                throw new FHIRException("Type mismatch: the type Annotation was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Annotation)this.value;
        }

        public boolean hasValueAnnotation() {
            return this != null && this.value instanceof Annotation;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public CodeableReference getValueCodeableReference() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableReference();
            }
            if (!(this.value instanceof CodeableReference)) {
                throw new FHIRException("Type mismatch: the type CodeableReference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableReference)this.value;
        }

        public boolean hasValueCodeableReference() {
            return this != null && this.value instanceof CodeableReference;
        }

        public Coding getValueCoding() throws FHIRException {
            if (this.value == null) {
                this.value = new Coding();
            }
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this != null && this.value instanceof Coding;
        }

        public ContactPoint getValueContactPoint() throws FHIRException {
            if (this.value == null) {
                this.value = new ContactPoint();
            }
            if (!(this.value instanceof ContactPoint)) {
                throw new FHIRException("Type mismatch: the type ContactPoint was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ContactPoint)this.value;
        }

        public boolean hasValueContactPoint() {
            return this != null && this.value instanceof ContactPoint;
        }

        public Count getValueCount() throws FHIRException {
            if (this.value == null) {
                this.value = new Count();
            }
            if (!(this.value instanceof Count)) {
                throw new FHIRException("Type mismatch: the type Count was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Count)this.value;
        }

        public boolean hasValueCount() {
            return this != null && this.value instanceof Count;
        }

        public Distance getValueDistance() throws FHIRException {
            if (this.value == null) {
                this.value = new Distance();
            }
            if (!(this.value instanceof Distance)) {
                throw new FHIRException("Type mismatch: the type Distance was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Distance)this.value;
        }

        public boolean hasValueDistance() {
            return this != null && this.value instanceof Distance;
        }

        public Duration getValueDuration() throws FHIRException {
            if (this.value == null) {
                this.value = new Duration();
            }
            if (!(this.value instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Duration)this.value;
        }

        public boolean hasValueDuration() {
            return this != null && this.value instanceof Duration;
        }

        public HumanName getValueHumanName() throws FHIRException {
            if (this.value == null) {
                this.value = new HumanName();
            }
            if (!(this.value instanceof HumanName)) {
                throw new FHIRException("Type mismatch: the type HumanName was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (HumanName)this.value;
        }

        public boolean hasValueHumanName() {
            return this != null && this.value instanceof HumanName;
        }

        public Identifier getValueIdentifier() throws FHIRException {
            if (this.value == null) {
                this.value = new Identifier();
            }
            if (!(this.value instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Identifier)this.value;
        }

        public boolean hasValueIdentifier() {
            return this != null && this.value instanceof Identifier;
        }

        public Money getValueMoney() throws FHIRException {
            if (this.value == null) {
                this.value = new Money();
            }
            if (!(this.value instanceof Money)) {
                throw new FHIRException("Type mismatch: the type Money was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Money)this.value;
        }

        public boolean hasValueMoney() {
            return this != null && this.value instanceof Money;
        }

        public Period getValuePeriod() throws FHIRException {
            if (this.value == null) {
                this.value = new Period();
            }
            if (!(this.value instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Period)this.value;
        }

        public boolean hasValuePeriod() {
            return this != null && this.value instanceof Period;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public Ratio getValueRatio() throws FHIRException {
            if (this.value == null) {
                this.value = new Ratio();
            }
            if (!(this.value instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Ratio)this.value;
        }

        public boolean hasValueRatio() {
            return this != null && this.value instanceof Ratio;
        }

        public RatioRange getValueRatioRange() throws FHIRException {
            if (this.value == null) {
                this.value = new RatioRange();
            }
            if (!(this.value instanceof RatioRange)) {
                throw new FHIRException("Type mismatch: the type RatioRange was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (RatioRange)this.value;
        }

        public boolean hasValueRatioRange() {
            return this != null && this.value instanceof RatioRange;
        }

        public Reference getValueReference() throws FHIRException {
            if (this.value == null) {
                this.value = new Reference();
            }
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this != null && this.value instanceof Reference;
        }

        public SampledData getValueSampledData() throws FHIRException {
            if (this.value == null) {
                this.value = new SampledData();
            }
            if (!(this.value instanceof SampledData)) {
                throw new FHIRException("Type mismatch: the type SampledData was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (SampledData)this.value;
        }

        public boolean hasValueSampledData() {
            return this != null && this.value instanceof SampledData;
        }

        public Signature getValueSignature() throws FHIRException {
            if (this.value == null) {
                this.value = new Signature();
            }
            if (!(this.value instanceof Signature)) {
                throw new FHIRException("Type mismatch: the type Signature was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Signature)this.value;
        }

        public boolean hasValueSignature() {
            return this != null && this.value instanceof Signature;
        }

        public Timing getValueTiming() throws FHIRException {
            if (this.value == null) {
                this.value = new Timing();
            }
            if (!(this.value instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Timing)this.value;
        }

        public boolean hasValueTiming() {
            return this != null && this.value instanceof Timing;
        }

        public ContactDetail getValueContactDetail() throws FHIRException {
            if (this.value == null) {
                this.value = new ContactDetail();
            }
            if (!(this.value instanceof ContactDetail)) {
                throw new FHIRException("Type mismatch: the type ContactDetail was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ContactDetail)this.value;
        }

        public boolean hasValueContactDetail() {
            return this != null && this.value instanceof ContactDetail;
        }

        public DataRequirement getValueDataRequirement() throws FHIRException {
            if (this.value == null) {
                this.value = new DataRequirement();
            }
            if (!(this.value instanceof DataRequirement)) {
                throw new FHIRException("Type mismatch: the type DataRequirement was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DataRequirement)this.value;
        }

        public boolean hasValueDataRequirement() {
            return this != null && this.value instanceof DataRequirement;
        }

        public Expression getValueExpression() throws FHIRException {
            if (this.value == null) {
                this.value = new Expression();
            }
            if (!(this.value instanceof Expression)) {
                throw new FHIRException("Type mismatch: the type Expression was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Expression)this.value;
        }

        public boolean hasValueExpression() {
            return this != null && this.value instanceof Expression;
        }

        public ParameterDefinition getValueParameterDefinition() throws FHIRException {
            if (this.value == null) {
                this.value = new ParameterDefinition();
            }
            if (!(this.value instanceof ParameterDefinition)) {
                throw new FHIRException("Type mismatch: the type ParameterDefinition was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ParameterDefinition)this.value;
        }

        public boolean hasValueParameterDefinition() {
            return this != null && this.value instanceof ParameterDefinition;
        }

        public RelatedArtifact getValueRelatedArtifact() throws FHIRException {
            if (this.value == null) {
                this.value = new RelatedArtifact();
            }
            if (!(this.value instanceof RelatedArtifact)) {
                throw new FHIRException("Type mismatch: the type RelatedArtifact was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (RelatedArtifact)this.value;
        }

        public boolean hasValueRelatedArtifact() {
            return this != null && this.value instanceof RelatedArtifact;
        }

        public TriggerDefinition getValueTriggerDefinition() throws FHIRException {
            if (this.value == null) {
                this.value = new TriggerDefinition();
            }
            if (!(this.value instanceof TriggerDefinition)) {
                throw new FHIRException("Type mismatch: the type TriggerDefinition was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TriggerDefinition)this.value;
        }

        public boolean hasValueTriggerDefinition() {
            return this != null && this.value instanceof TriggerDefinition;
        }

        public UsageContext getValueUsageContext() throws FHIRException {
            if (this.value == null) {
                this.value = new UsageContext();
            }
            if (!(this.value instanceof UsageContext)) {
                throw new FHIRException("Type mismatch: the type UsageContext was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UsageContext)this.value;
        }

        public boolean hasValueUsageContext() {
            return this != null && this.value instanceof UsageContext;
        }

        public Availability getValueAvailability() throws FHIRException {
            if (this.value == null) {
                this.value = new Availability();
            }
            if (!(this.value instanceof Availability)) {
                throw new FHIRException("Type mismatch: the type Availability was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Availability)this.value;
        }

        public boolean hasValueAvailability() {
            return this != null && this.value instanceof Availability;
        }

        public ExtendedContactDetail getValueExtendedContactDetail() throws FHIRException {
            if (this.value == null) {
                this.value = new ExtendedContactDetail();
            }
            if (!(this.value instanceof ExtendedContactDetail)) {
                throw new FHIRException("Type mismatch: the type ExtendedContactDetail was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ExtendedContactDetail)this.value;
        }

        public boolean hasValueExtendedContactDetail() {
            return this != null && this.value instanceof ExtendedContactDetail;
        }

        public Dosage getValueDosage() throws FHIRException {
            if (this.value == null) {
                this.value = new Dosage();
            }
            if (!(this.value instanceof Dosage)) {
                throw new FHIRException("Type mismatch: the type Dosage was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Dosage)this.value;
        }

        public boolean hasValueDosage() {
            return this != null && this.value instanceof Dosage;
        }

        public Meta getValueMeta() throws FHIRException {
            if (this.value == null) {
                this.value = new Meta();
            }
            if (!(this.value instanceof Meta)) {
                throw new FHIRException("Type mismatch: the type Meta was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Meta)this.value;
        }

        public boolean hasValueMeta() {
            return this != null && this.value instanceof Meta;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public TaskOutputComponent setValue(DataType value) {
            if (!(value == null || value instanceof Base64BinaryType || value instanceof BooleanType || value instanceof CanonicalType || value instanceof CodeType || value instanceof DateType || value instanceof DateTimeType || value instanceof DecimalType || value instanceof IdType || value instanceof InstantType || value instanceof IntegerType || value instanceof Integer64Type || value instanceof MarkdownType || value instanceof OidType || value instanceof PositiveIntType || value instanceof StringType || value instanceof TimeType || value instanceof UnsignedIntType || value instanceof UriType || value instanceof UrlType || value instanceof UuidType || value instanceof Address || value instanceof Age || value instanceof Annotation || value instanceof Attachment || value instanceof CodeableConcept || value instanceof CodeableReference || value instanceof Coding || value instanceof ContactPoint || value instanceof Count || value instanceof Distance || value instanceof Duration || value instanceof HumanName || value instanceof Identifier || value instanceof Money || value instanceof Period || value instanceof Quantity || value instanceof Range || value instanceof Ratio || value instanceof RatioRange || value instanceof Reference || value instanceof SampledData || value instanceof Signature || value instanceof Timing || value instanceof ContactDetail || value instanceof DataRequirement || value instanceof Expression || value instanceof ParameterDefinition || value instanceof RelatedArtifact || value instanceof TriggerDefinition || value instanceof UsageContext || value instanceof Availability || value instanceof ExtendedContactDetail || value instanceof Dosage || value instanceof Meta)) {
                throw new Error("Not the right type for Task.output.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The name of the Output parameter.", 0, 1, this.type));
            children.add(new Property("value[x]", "base64Binary|boolean|canonical|code|date|dateTime|decimal|id|instant|integer|integer64|markdown|oid|positiveInt|string|time|unsignedInt|uri|url|uuid|Address|Age|Annotation|Attachment|CodeableConcept|CodeableReference|Coding|ContactPoint|Count|Distance|Duration|HumanName|Identifier|Money|Period|Quantity|Range|Ratio|RatioRange|Reference|SampledData|Signature|Timing|ContactDetail|DataRequirement|Expression|ParameterDefinition|RelatedArtifact|TriggerDefinition|UsageContext|Availability|ExtendedContactDetail|Dosage|Meta", "The value of the Output parameter as a basic type.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The name of the Output parameter.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "base64Binary|boolean|canonical|code|date|dateTime|decimal|id|instant|integer|integer64|markdown|oid|positiveInt|string|time|unsignedInt|uri|url|uuid|Address|Age|Annotation|Attachment|CodeableConcept|CodeableReference|Coding|ContactPoint|Count|Distance|Duration|HumanName|Identifier|Money|Period|Quantity|Range|Ratio|RatioRange|Reference|SampledData|Signature|Timing|ContactDetail|DataRequirement|Expression|ParameterDefinition|RelatedArtifact|TriggerDefinition|UsageContext|Availability|ExtendedContactDetail|Dosage|Meta", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "base64Binary|boolean|canonical|code|date|dateTime|decimal|id|instant|integer|integer64|markdown|oid|positiveInt|string|time|unsignedInt|uri|url|uuid|Address|Age|Annotation|Attachment|CodeableConcept|CodeableReference|Coding|ContactPoint|Count|Distance|Duration|HumanName|Identifier|Money|Period|Quantity|Range|Ratio|RatioRange|Reference|SampledData|Signature|Timing|ContactDetail|DataRequirement|Expression|ParameterDefinition|RelatedArtifact|TriggerDefinition|UsageContext|Availability|ExtendedContactDetail|Dosage|Meta", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1535024575: {
                    return new Property("value[x]", "base64Binary", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -786218365: {
                    return new Property("value[x]", "canonical", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -766209282: {
                    return new Property("value[x]", Task.SP_CODE, "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "date", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "decimal", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 231604844: {
                    return new Property("value[x]", "id", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1668687056: {
                    return new Property("value[x]", "instant", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1122120181: {
                    return new Property("value[x]", "integer64", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -497880704: {
                    return new Property("value[x]", "markdown", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1410178407: {
                    return new Property("value[x]", "oid", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1249932027: {
                    return new Property("value[x]", "positiveInt", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -765708322: {
                    return new Property("value[x]", "time", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 26529417: {
                    return new Property("value[x]", "unsignedInt", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1410172357: {
                    return new Property("value[x]", "uri", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1410172354: {
                    return new Property("value[x]", "url", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -765667124: {
                    return new Property("value[x]", "uuid", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -478981821: {
                    return new Property("value[x]", "Address", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1410191922: {
                    return new Property("value[x]", "Age", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -67108992: {
                    return new Property("value[x]", "Annotation", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -257955629: {
                    return new Property("value[x]", "CodeableReference", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "Coding", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 944904545: {
                    return new Property("value[x]", "ContactPoint", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 2017332766: {
                    return new Property("value[x]", "Count", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -456359802: {
                    return new Property("value[x]", "Distance", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 1558135333: {
                    return new Property("value[x]", "Duration", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -2026205465: {
                    return new Property("value[x]", "HumanName", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -130498310: {
                    return new Property("value[x]", "Identifier", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 2026560975: {
                    return new Property("value[x]", "Money", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1524344174: {
                    return new Property("value[x]", "Period", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "Range", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 2030767386: {
                    return new Property("value[x]", "Ratio", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -706454461: {
                    return new Property("value[x]", "RatioRange", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "Reference", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -962229101: {
                    return new Property("value[x]", "SampledData", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -540985785: {
                    return new Property("value[x]", "Signature", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1406282469: {
                    return new Property("value[x]", "Timing", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1125200224: {
                    return new Property("value[x]", "ContactDetail", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 1710554248: {
                    return new Property("value[x]", "DataRequirement", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -307517719: {
                    return new Property("value[x]", "Expression", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 1387478187: {
                    return new Property("value[x]", "ParameterDefinition", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 1748214124: {
                    return new Property("value[x]", "RelatedArtifact", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 976830394: {
                    return new Property("value[x]", "TriggerDefinition", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 588000479: {
                    return new Property("value[x]", "UsageContext", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 1678530924: {
                    return new Property("value[x]", "Availability", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1567222041: {
                    return new Property("value[x]", "ExtendedContactDetail", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1858636920: {
                    return new Property("value[x]", "Dosage", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -765920490: {
                    return new Property("value[x]", "Meta", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"base64Binary", "boolean", "canonical", Task.SP_CODE, "date", "dateTime", "decimal", "id", "instant", "integer", "integer64", "markdown", "oid", "positiveInt", "string", "time", "unsignedInt", "uri", "url", "uuid", "Address", "Age", "Annotation", "Attachment", "CodeableConcept", "CodeableReference", "Coding", "ContactPoint", "Count", "Distance", "Duration", "HumanName", "Identifier", "Money", "Period", "Quantity", "Range", "Ratio", "RatioRange", "Reference", "SampledData", "Signature", "Timing", "ContactDetail", "DataRequirement", "Expression", "ParameterDefinition", "RelatedArtifact", "TriggerDefinition", "UsageContext", "Availability", "ExtendedContactDetail", "Dosage", "Meta"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueCanonical")) {
                this.value = new CanonicalType();
                return this.value;
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueId")) {
                this.value = new IdType();
                return this.value;
            }
            if (name.equals("valueInstant")) {
                this.value = new InstantType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueInteger64")) {
                this.value = new Integer64Type();
                return this.value;
            }
            if (name.equals("valueMarkdown")) {
                this.value = new MarkdownType();
                return this.value;
            }
            if (name.equals("valueOid")) {
                this.value = new OidType();
                return this.value;
            }
            if (name.equals("valuePositiveInt")) {
                this.value = new PositiveIntType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueUnsignedInt")) {
                this.value = new UnsignedIntType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueUrl")) {
                this.value = new UrlType();
                return this.value;
            }
            if (name.equals("valueUuid")) {
                this.value = new UuidType();
                return this.value;
            }
            if (name.equals("valueAddress")) {
                this.value = new Address();
                return this.value;
            }
            if (name.equals("valueAge")) {
                this.value = new Age();
                return this.value;
            }
            if (name.equals("valueAnnotation")) {
                this.value = new Annotation();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueCodeableReference")) {
                this.value = new CodeableReference();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueContactPoint")) {
                this.value = new ContactPoint();
                return this.value;
            }
            if (name.equals("valueCount")) {
                this.value = new Count();
                return this.value;
            }
            if (name.equals("valueDistance")) {
                this.value = new Distance();
                return this.value;
            }
            if (name.equals("valueDuration")) {
                this.value = new Duration();
                return this.value;
            }
            if (name.equals("valueHumanName")) {
                this.value = new HumanName();
                return this.value;
            }
            if (name.equals("valueIdentifier")) {
                this.value = new Identifier();
                return this.value;
            }
            if (name.equals("valueMoney")) {
                this.value = new Money();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valueRatio")) {
                this.value = new Ratio();
                return this.value;
            }
            if (name.equals("valueRatioRange")) {
                this.value = new RatioRange();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("valueSampledData")) {
                this.value = new SampledData();
                return this.value;
            }
            if (name.equals("valueSignature")) {
                this.value = new Signature();
                return this.value;
            }
            if (name.equals("valueTiming")) {
                this.value = new Timing();
                return this.value;
            }
            if (name.equals("valueContactDetail")) {
                this.value = new ContactDetail();
                return this.value;
            }
            if (name.equals("valueDataRequirement")) {
                this.value = new DataRequirement();
                return this.value;
            }
            if (name.equals("valueExpression")) {
                this.value = new Expression();
                return this.value;
            }
            if (name.equals("valueParameterDefinition")) {
                this.value = new ParameterDefinition();
                return this.value;
            }
            if (name.equals("valueRelatedArtifact")) {
                this.value = new RelatedArtifact();
                return this.value;
            }
            if (name.equals("valueTriggerDefinition")) {
                this.value = new TriggerDefinition();
                return this.value;
            }
            if (name.equals("valueUsageContext")) {
                this.value = new UsageContext();
                return this.value;
            }
            if (name.equals("valueAvailability")) {
                this.value = new Availability();
                return this.value;
            }
            if (name.equals("valueExtendedContactDetail")) {
                this.value = new ExtendedContactDetail();
                return this.value;
            }
            if (name.equals("valueDosage")) {
                this.value = new Dosage();
                return this.value;
            }
            if (name.equals("valueMeta")) {
                this.value = new Meta();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public TaskOutputComponent copy() {
            TaskOutputComponent dst = new TaskOutputComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TaskOutputComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TaskOutputComponent)) {
                return false;
            }
            TaskOutputComponent o = (TaskOutputComponent)other_;
            return TaskOutputComponent.compareDeep(this.type, o.type, true) && TaskOutputComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TaskOutputComponent)) {
                return false;
            }
            TaskOutputComponent o = (TaskOutputComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.value);
        }

        @Override
        public String fhirType() {
            return "Task.output";
        }
    }

    @Block
    public static class TaskInputComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for the input", formalDefinition="A code or description indicating how the input is intended to be used as part of the task execution.")
        protected CodeableConcept type;
        @Child(name="value", type={Base64BinaryType.class, BooleanType.class, CanonicalType.class, CodeType.class, DateType.class, DateTimeType.class, DecimalType.class, IdType.class, InstantType.class, IntegerType.class, Integer64Type.class, MarkdownType.class, OidType.class, PositiveIntType.class, StringType.class, TimeType.class, UnsignedIntType.class, UriType.class, UrlType.class, UuidType.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, CodeableReference.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, RatioRange.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Availability.class, ExtendedContactDetail.class, Dosage.class, Meta.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Content to use in performing the task", formalDefinition="The value of the input parameter as a basic type.")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public TaskInputComponent() {
        }

        public TaskInputComponent(CodeableConcept type, DataType value) {
            this.setType(type);
            this.setValue(value);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TaskInputComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public TaskInputComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public Base64BinaryType getValueBase64BinaryType() throws FHIRException {
            if (this.value == null) {
                this.value = new Base64BinaryType();
            }
            if (!(this.value instanceof Base64BinaryType)) {
                throw new FHIRException("Type mismatch: the type Base64BinaryType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Base64BinaryType)this.value;
        }

        public boolean hasValueBase64BinaryType() {
            return this != null && this.value instanceof Base64BinaryType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public CanonicalType getValueCanonicalType() throws FHIRException {
            if (this.value == null) {
                this.value = new CanonicalType();
            }
            if (!(this.value instanceof CanonicalType)) {
                throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CanonicalType)this.value;
        }

        public boolean hasValueCanonicalType() {
            return this != null && this.value instanceof CanonicalType;
        }

        public CodeType getValueCodeType() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeType();
            }
            if (!(this.value instanceof CodeType)) {
                throw new FHIRException("Type mismatch: the type CodeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeType)this.value;
        }

        public boolean hasValueCodeType() {
            return this != null && this.value instanceof CodeType;
        }

        public DateType getValueDateType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateType();
            }
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this != null && this.value instanceof DateType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this != null && this.value instanceof DecimalType;
        }

        public IdType getValueIdType() throws FHIRException {
            if (this.value == null) {
                this.value = new IdType();
            }
            if (!(this.value instanceof IdType)) {
                throw new FHIRException("Type mismatch: the type IdType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IdType)this.value;
        }

        public boolean hasValueIdType() {
            return this != null && this.value instanceof IdType;
        }

        public InstantType getValueInstantType() throws FHIRException {
            if (this.value == null) {
                this.value = new InstantType();
            }
            if (!(this.value instanceof InstantType)) {
                throw new FHIRException("Type mismatch: the type InstantType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (InstantType)this.value;
        }

        public boolean hasValueInstantType() {
            return this != null && this.value instanceof InstantType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public Integer64Type getValueInteger64Type() throws FHIRException {
            if (this.value == null) {
                this.value = new Integer64Type();
            }
            if (!(this.value instanceof Integer64Type)) {
                throw new FHIRException("Type mismatch: the type Integer64Type was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Integer64Type)this.value;
        }

        public boolean hasValueInteger64Type() {
            return this != null && this.value instanceof Integer64Type;
        }

        public MarkdownType getValueMarkdownType() throws FHIRException {
            if (this.value == null) {
                this.value = new MarkdownType();
            }
            if (!(this.value instanceof MarkdownType)) {
                throw new FHIRException("Type mismatch: the type MarkdownType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (MarkdownType)this.value;
        }

        public boolean hasValueMarkdownType() {
            return this != null && this.value instanceof MarkdownType;
        }

        public OidType getValueOidType() throws FHIRException {
            if (this.value == null) {
                this.value = new OidType();
            }
            if (!(this.value instanceof OidType)) {
                throw new FHIRException("Type mismatch: the type OidType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (OidType)this.value;
        }

        public boolean hasValueOidType() {
            return this != null && this.value instanceof OidType;
        }

        public PositiveIntType getValuePositiveIntType() throws FHIRException {
            if (this.value == null) {
                this.value = new PositiveIntType();
            }
            if (!(this.value instanceof PositiveIntType)) {
                throw new FHIRException("Type mismatch: the type PositiveIntType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (PositiveIntType)this.value;
        }

        public boolean hasValuePositiveIntType() {
            return this != null && this.value instanceof PositiveIntType;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public TimeType getValueTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new TimeType();
            }
            if (!(this.value instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TimeType)this.value;
        }

        public boolean hasValueTimeType() {
            return this != null && this.value instanceof TimeType;
        }

        public UnsignedIntType getValueUnsignedIntType() throws FHIRException {
            if (this.value == null) {
                this.value = new UnsignedIntType();
            }
            if (!(this.value instanceof UnsignedIntType)) {
                throw new FHIRException("Type mismatch: the type UnsignedIntType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UnsignedIntType)this.value;
        }

        public boolean hasValueUnsignedIntType() {
            return this != null && this.value instanceof UnsignedIntType;
        }

        public UriType getValueUriType() throws FHIRException {
            if (this.value == null) {
                this.value = new UriType();
            }
            if (!(this.value instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UriType)this.value;
        }

        public boolean hasValueUriType() {
            return this != null && this.value instanceof UriType;
        }

        public UrlType getValueUrlType() throws FHIRException {
            if (this.value == null) {
                this.value = new UrlType();
            }
            if (!(this.value instanceof UrlType)) {
                throw new FHIRException("Type mismatch: the type UrlType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UrlType)this.value;
        }

        public boolean hasValueUrlType() {
            return this != null && this.value instanceof UrlType;
        }

        public UuidType getValueUuidType() throws FHIRException {
            if (this.value == null) {
                this.value = new UuidType();
            }
            if (!(this.value instanceof UuidType)) {
                throw new FHIRException("Type mismatch: the type UuidType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UuidType)this.value;
        }

        public boolean hasValueUuidType() {
            return this != null && this.value instanceof UuidType;
        }

        public Address getValueAddress() throws FHIRException {
            if (this.value == null) {
                this.value = new Address();
            }
            if (!(this.value instanceof Address)) {
                throw new FHIRException("Type mismatch: the type Address was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Address)this.value;
        }

        public boolean hasValueAddress() {
            return this != null && this.value instanceof Address;
        }

        public Age getValueAge() throws FHIRException {
            if (this.value == null) {
                this.value = new Age();
            }
            if (!(this.value instanceof Age)) {
                throw new FHIRException("Type mismatch: the type Age was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Age)this.value;
        }

        public boolean hasValueAge() {
            return this != null && this.value instanceof Age;
        }

        public Annotation getValueAnnotation() throws FHIRException {
            if (this.value == null) {
                this.value = new Annotation();
            }
            if (!(this.value instanceof Annotation)) {
                throw new FHIRException("Type mismatch: the type Annotation was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Annotation)this.value;
        }

        public boolean hasValueAnnotation() {
            return this != null && this.value instanceof Annotation;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public CodeableReference getValueCodeableReference() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableReference();
            }
            if (!(this.value instanceof CodeableReference)) {
                throw new FHIRException("Type mismatch: the type CodeableReference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableReference)this.value;
        }

        public boolean hasValueCodeableReference() {
            return this != null && this.value instanceof CodeableReference;
        }

        public Coding getValueCoding() throws FHIRException {
            if (this.value == null) {
                this.value = new Coding();
            }
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this != null && this.value instanceof Coding;
        }

        public ContactPoint getValueContactPoint() throws FHIRException {
            if (this.value == null) {
                this.value = new ContactPoint();
            }
            if (!(this.value instanceof ContactPoint)) {
                throw new FHIRException("Type mismatch: the type ContactPoint was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ContactPoint)this.value;
        }

        public boolean hasValueContactPoint() {
            return this != null && this.value instanceof ContactPoint;
        }

        public Count getValueCount() throws FHIRException {
            if (this.value == null) {
                this.value = new Count();
            }
            if (!(this.value instanceof Count)) {
                throw new FHIRException("Type mismatch: the type Count was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Count)this.value;
        }

        public boolean hasValueCount() {
            return this != null && this.value instanceof Count;
        }

        public Distance getValueDistance() throws FHIRException {
            if (this.value == null) {
                this.value = new Distance();
            }
            if (!(this.value instanceof Distance)) {
                throw new FHIRException("Type mismatch: the type Distance was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Distance)this.value;
        }

        public boolean hasValueDistance() {
            return this != null && this.value instanceof Distance;
        }

        public Duration getValueDuration() throws FHIRException {
            if (this.value == null) {
                this.value = new Duration();
            }
            if (!(this.value instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Duration)this.value;
        }

        public boolean hasValueDuration() {
            return this != null && this.value instanceof Duration;
        }

        public HumanName getValueHumanName() throws FHIRException {
            if (this.value == null) {
                this.value = new HumanName();
            }
            if (!(this.value instanceof HumanName)) {
                throw new FHIRException("Type mismatch: the type HumanName was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (HumanName)this.value;
        }

        public boolean hasValueHumanName() {
            return this != null && this.value instanceof HumanName;
        }

        public Identifier getValueIdentifier() throws FHIRException {
            if (this.value == null) {
                this.value = new Identifier();
            }
            if (!(this.value instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Identifier)this.value;
        }

        public boolean hasValueIdentifier() {
            return this != null && this.value instanceof Identifier;
        }

        public Money getValueMoney() throws FHIRException {
            if (this.value == null) {
                this.value = new Money();
            }
            if (!(this.value instanceof Money)) {
                throw new FHIRException("Type mismatch: the type Money was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Money)this.value;
        }

        public boolean hasValueMoney() {
            return this != null && this.value instanceof Money;
        }

        public Period getValuePeriod() throws FHIRException {
            if (this.value == null) {
                this.value = new Period();
            }
            if (!(this.value instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Period)this.value;
        }

        public boolean hasValuePeriod() {
            return this != null && this.value instanceof Period;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public Ratio getValueRatio() throws FHIRException {
            if (this.value == null) {
                this.value = new Ratio();
            }
            if (!(this.value instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Ratio)this.value;
        }

        public boolean hasValueRatio() {
            return this != null && this.value instanceof Ratio;
        }

        public RatioRange getValueRatioRange() throws FHIRException {
            if (this.value == null) {
                this.value = new RatioRange();
            }
            if (!(this.value instanceof RatioRange)) {
                throw new FHIRException("Type mismatch: the type RatioRange was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (RatioRange)this.value;
        }

        public boolean hasValueRatioRange() {
            return this != null && this.value instanceof RatioRange;
        }

        public Reference getValueReference() throws FHIRException {
            if (this.value == null) {
                this.value = new Reference();
            }
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this != null && this.value instanceof Reference;
        }

        public SampledData getValueSampledData() throws FHIRException {
            if (this.value == null) {
                this.value = new SampledData();
            }
            if (!(this.value instanceof SampledData)) {
                throw new FHIRException("Type mismatch: the type SampledData was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (SampledData)this.value;
        }

        public boolean hasValueSampledData() {
            return this != null && this.value instanceof SampledData;
        }

        public Signature getValueSignature() throws FHIRException {
            if (this.value == null) {
                this.value = new Signature();
            }
            if (!(this.value instanceof Signature)) {
                throw new FHIRException("Type mismatch: the type Signature was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Signature)this.value;
        }

        public boolean hasValueSignature() {
            return this != null && this.value instanceof Signature;
        }

        public Timing getValueTiming() throws FHIRException {
            if (this.value == null) {
                this.value = new Timing();
            }
            if (!(this.value instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Timing)this.value;
        }

        public boolean hasValueTiming() {
            return this != null && this.value instanceof Timing;
        }

        public ContactDetail getValueContactDetail() throws FHIRException {
            if (this.value == null) {
                this.value = new ContactDetail();
            }
            if (!(this.value instanceof ContactDetail)) {
                throw new FHIRException("Type mismatch: the type ContactDetail was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ContactDetail)this.value;
        }

        public boolean hasValueContactDetail() {
            return this != null && this.value instanceof ContactDetail;
        }

        public DataRequirement getValueDataRequirement() throws FHIRException {
            if (this.value == null) {
                this.value = new DataRequirement();
            }
            if (!(this.value instanceof DataRequirement)) {
                throw new FHIRException("Type mismatch: the type DataRequirement was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DataRequirement)this.value;
        }

        public boolean hasValueDataRequirement() {
            return this != null && this.value instanceof DataRequirement;
        }

        public Expression getValueExpression() throws FHIRException {
            if (this.value == null) {
                this.value = new Expression();
            }
            if (!(this.value instanceof Expression)) {
                throw new FHIRException("Type mismatch: the type Expression was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Expression)this.value;
        }

        public boolean hasValueExpression() {
            return this != null && this.value instanceof Expression;
        }

        public ParameterDefinition getValueParameterDefinition() throws FHIRException {
            if (this.value == null) {
                this.value = new ParameterDefinition();
            }
            if (!(this.value instanceof ParameterDefinition)) {
                throw new FHIRException("Type mismatch: the type ParameterDefinition was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ParameterDefinition)this.value;
        }

        public boolean hasValueParameterDefinition() {
            return this != null && this.value instanceof ParameterDefinition;
        }

        public RelatedArtifact getValueRelatedArtifact() throws FHIRException {
            if (this.value == null) {
                this.value = new RelatedArtifact();
            }
            if (!(this.value instanceof RelatedArtifact)) {
                throw new FHIRException("Type mismatch: the type RelatedArtifact was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (RelatedArtifact)this.value;
        }

        public boolean hasValueRelatedArtifact() {
            return this != null && this.value instanceof RelatedArtifact;
        }

        public TriggerDefinition getValueTriggerDefinition() throws FHIRException {
            if (this.value == null) {
                this.value = new TriggerDefinition();
            }
            if (!(this.value instanceof TriggerDefinition)) {
                throw new FHIRException("Type mismatch: the type TriggerDefinition was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TriggerDefinition)this.value;
        }

        public boolean hasValueTriggerDefinition() {
            return this != null && this.value instanceof TriggerDefinition;
        }

        public UsageContext getValueUsageContext() throws FHIRException {
            if (this.value == null) {
                this.value = new UsageContext();
            }
            if (!(this.value instanceof UsageContext)) {
                throw new FHIRException("Type mismatch: the type UsageContext was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UsageContext)this.value;
        }

        public boolean hasValueUsageContext() {
            return this != null && this.value instanceof UsageContext;
        }

        public Availability getValueAvailability() throws FHIRException {
            if (this.value == null) {
                this.value = new Availability();
            }
            if (!(this.value instanceof Availability)) {
                throw new FHIRException("Type mismatch: the type Availability was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Availability)this.value;
        }

        public boolean hasValueAvailability() {
            return this != null && this.value instanceof Availability;
        }

        public ExtendedContactDetail getValueExtendedContactDetail() throws FHIRException {
            if (this.value == null) {
                this.value = new ExtendedContactDetail();
            }
            if (!(this.value instanceof ExtendedContactDetail)) {
                throw new FHIRException("Type mismatch: the type ExtendedContactDetail was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ExtendedContactDetail)this.value;
        }

        public boolean hasValueExtendedContactDetail() {
            return this != null && this.value instanceof ExtendedContactDetail;
        }

        public Dosage getValueDosage() throws FHIRException {
            if (this.value == null) {
                this.value = new Dosage();
            }
            if (!(this.value instanceof Dosage)) {
                throw new FHIRException("Type mismatch: the type Dosage was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Dosage)this.value;
        }

        public boolean hasValueDosage() {
            return this != null && this.value instanceof Dosage;
        }

        public Meta getValueMeta() throws FHIRException {
            if (this.value == null) {
                this.value = new Meta();
            }
            if (!(this.value instanceof Meta)) {
                throw new FHIRException("Type mismatch: the type Meta was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Meta)this.value;
        }

        public boolean hasValueMeta() {
            return this != null && this.value instanceof Meta;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public TaskInputComponent setValue(DataType value) {
            if (!(value == null || value instanceof Base64BinaryType || value instanceof BooleanType || value instanceof CanonicalType || value instanceof CodeType || value instanceof DateType || value instanceof DateTimeType || value instanceof DecimalType || value instanceof IdType || value instanceof InstantType || value instanceof IntegerType || value instanceof Integer64Type || value instanceof MarkdownType || value instanceof OidType || value instanceof PositiveIntType || value instanceof StringType || value instanceof TimeType || value instanceof UnsignedIntType || value instanceof UriType || value instanceof UrlType || value instanceof UuidType || value instanceof Address || value instanceof Age || value instanceof Annotation || value instanceof Attachment || value instanceof CodeableConcept || value instanceof CodeableReference || value instanceof Coding || value instanceof ContactPoint || value instanceof Count || value instanceof Distance || value instanceof Duration || value instanceof HumanName || value instanceof Identifier || value instanceof Money || value instanceof Period || value instanceof Quantity || value instanceof Range || value instanceof Ratio || value instanceof RatioRange || value instanceof Reference || value instanceof SampledData || value instanceof Signature || value instanceof Timing || value instanceof ContactDetail || value instanceof DataRequirement || value instanceof Expression || value instanceof ParameterDefinition || value instanceof RelatedArtifact || value instanceof TriggerDefinition || value instanceof UsageContext || value instanceof Availability || value instanceof ExtendedContactDetail || value instanceof Dosage || value instanceof Meta)) {
                throw new Error("Not the right type for Task.input.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "A code or description indicating how the input is intended to be used as part of the task execution.", 0, 1, this.type));
            children.add(new Property("value[x]", "base64Binary|boolean|canonical|code|date|dateTime|decimal|id|instant|integer|integer64|markdown|oid|positiveInt|string|time|unsignedInt|uri|url|uuid|Address|Age|Annotation|Attachment|CodeableConcept|CodeableReference|Coding|ContactPoint|Count|Distance|Duration|HumanName|Identifier|Money|Period|Quantity|Range|Ratio|RatioRange|Reference|SampledData|Signature|Timing|ContactDetail|DataRequirement|Expression|ParameterDefinition|RelatedArtifact|TriggerDefinition|UsageContext|Availability|ExtendedContactDetail|Dosage|Meta", "The value of the input parameter as a basic type.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A code or description indicating how the input is intended to be used as part of the task execution.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "base64Binary|boolean|canonical|code|date|dateTime|decimal|id|instant|integer|integer64|markdown|oid|positiveInt|string|time|unsignedInt|uri|url|uuid|Address|Age|Annotation|Attachment|CodeableConcept|CodeableReference|Coding|ContactPoint|Count|Distance|Duration|HumanName|Identifier|Money|Period|Quantity|Range|Ratio|RatioRange|Reference|SampledData|Signature|Timing|ContactDetail|DataRequirement|Expression|ParameterDefinition|RelatedArtifact|TriggerDefinition|UsageContext|Availability|ExtendedContactDetail|Dosage|Meta", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "base64Binary|boolean|canonical|code|date|dateTime|decimal|id|instant|integer|integer64|markdown|oid|positiveInt|string|time|unsignedInt|uri|url|uuid|Address|Age|Annotation|Attachment|CodeableConcept|CodeableReference|Coding|ContactPoint|Count|Distance|Duration|HumanName|Identifier|Money|Period|Quantity|Range|Ratio|RatioRange|Reference|SampledData|Signature|Timing|ContactDetail|DataRequirement|Expression|ParameterDefinition|RelatedArtifact|TriggerDefinition|UsageContext|Availability|ExtendedContactDetail|Dosage|Meta", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1535024575: {
                    return new Property("value[x]", "base64Binary", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -786218365: {
                    return new Property("value[x]", "canonical", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -766209282: {
                    return new Property("value[x]", Task.SP_CODE, "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "date", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "decimal", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 231604844: {
                    return new Property("value[x]", "id", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1668687056: {
                    return new Property("value[x]", "instant", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1122120181: {
                    return new Property("value[x]", "integer64", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -497880704: {
                    return new Property("value[x]", "markdown", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1410178407: {
                    return new Property("value[x]", "oid", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1249932027: {
                    return new Property("value[x]", "positiveInt", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -765708322: {
                    return new Property("value[x]", "time", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 26529417: {
                    return new Property("value[x]", "unsignedInt", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1410172357: {
                    return new Property("value[x]", "uri", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1410172354: {
                    return new Property("value[x]", "url", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -765667124: {
                    return new Property("value[x]", "uuid", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -478981821: {
                    return new Property("value[x]", "Address", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1410191922: {
                    return new Property("value[x]", "Age", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -67108992: {
                    return new Property("value[x]", "Annotation", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -257955629: {
                    return new Property("value[x]", "CodeableReference", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "Coding", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 944904545: {
                    return new Property("value[x]", "ContactPoint", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 2017332766: {
                    return new Property("value[x]", "Count", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -456359802: {
                    return new Property("value[x]", "Distance", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 1558135333: {
                    return new Property("value[x]", "Duration", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -2026205465: {
                    return new Property("value[x]", "HumanName", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -130498310: {
                    return new Property("value[x]", "Identifier", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 2026560975: {
                    return new Property("value[x]", "Money", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1524344174: {
                    return new Property("value[x]", "Period", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "Range", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 2030767386: {
                    return new Property("value[x]", "Ratio", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -706454461: {
                    return new Property("value[x]", "RatioRange", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "Reference", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -962229101: {
                    return new Property("value[x]", "SampledData", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -540985785: {
                    return new Property("value[x]", "Signature", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1406282469: {
                    return new Property("value[x]", "Timing", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1125200224: {
                    return new Property("value[x]", "ContactDetail", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 1710554248: {
                    return new Property("value[x]", "DataRequirement", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -307517719: {
                    return new Property("value[x]", "Expression", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 1387478187: {
                    return new Property("value[x]", "ParameterDefinition", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 1748214124: {
                    return new Property("value[x]", "RelatedArtifact", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 976830394: {
                    return new Property("value[x]", "TriggerDefinition", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 588000479: {
                    return new Property("value[x]", "UsageContext", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 1678530924: {
                    return new Property("value[x]", "Availability", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1567222041: {
                    return new Property("value[x]", "ExtendedContactDetail", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1858636920: {
                    return new Property("value[x]", "Dosage", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -765920490: {
                    return new Property("value[x]", "Meta", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"base64Binary", "boolean", "canonical", Task.SP_CODE, "date", "dateTime", "decimal", "id", "instant", "integer", "integer64", "markdown", "oid", "positiveInt", "string", "time", "unsignedInt", "uri", "url", "uuid", "Address", "Age", "Annotation", "Attachment", "CodeableConcept", "CodeableReference", "Coding", "ContactPoint", "Count", "Distance", "Duration", "HumanName", "Identifier", "Money", "Period", "Quantity", "Range", "Ratio", "RatioRange", "Reference", "SampledData", "Signature", "Timing", "ContactDetail", "DataRequirement", "Expression", "ParameterDefinition", "RelatedArtifact", "TriggerDefinition", "UsageContext", "Availability", "ExtendedContactDetail", "Dosage", "Meta"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueCanonical")) {
                this.value = new CanonicalType();
                return this.value;
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueId")) {
                this.value = new IdType();
                return this.value;
            }
            if (name.equals("valueInstant")) {
                this.value = new InstantType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueInteger64")) {
                this.value = new Integer64Type();
                return this.value;
            }
            if (name.equals("valueMarkdown")) {
                this.value = new MarkdownType();
                return this.value;
            }
            if (name.equals("valueOid")) {
                this.value = new OidType();
                return this.value;
            }
            if (name.equals("valuePositiveInt")) {
                this.value = new PositiveIntType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueUnsignedInt")) {
                this.value = new UnsignedIntType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueUrl")) {
                this.value = new UrlType();
                return this.value;
            }
            if (name.equals("valueUuid")) {
                this.value = new UuidType();
                return this.value;
            }
            if (name.equals("valueAddress")) {
                this.value = new Address();
                return this.value;
            }
            if (name.equals("valueAge")) {
                this.value = new Age();
                return this.value;
            }
            if (name.equals("valueAnnotation")) {
                this.value = new Annotation();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueCodeableReference")) {
                this.value = new CodeableReference();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueContactPoint")) {
                this.value = new ContactPoint();
                return this.value;
            }
            if (name.equals("valueCount")) {
                this.value = new Count();
                return this.value;
            }
            if (name.equals("valueDistance")) {
                this.value = new Distance();
                return this.value;
            }
            if (name.equals("valueDuration")) {
                this.value = new Duration();
                return this.value;
            }
            if (name.equals("valueHumanName")) {
                this.value = new HumanName();
                return this.value;
            }
            if (name.equals("valueIdentifier")) {
                this.value = new Identifier();
                return this.value;
            }
            if (name.equals("valueMoney")) {
                this.value = new Money();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valueRatio")) {
                this.value = new Ratio();
                return this.value;
            }
            if (name.equals("valueRatioRange")) {
                this.value = new RatioRange();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("valueSampledData")) {
                this.value = new SampledData();
                return this.value;
            }
            if (name.equals("valueSignature")) {
                this.value = new Signature();
                return this.value;
            }
            if (name.equals("valueTiming")) {
                this.value = new Timing();
                return this.value;
            }
            if (name.equals("valueContactDetail")) {
                this.value = new ContactDetail();
                return this.value;
            }
            if (name.equals("valueDataRequirement")) {
                this.value = new DataRequirement();
                return this.value;
            }
            if (name.equals("valueExpression")) {
                this.value = new Expression();
                return this.value;
            }
            if (name.equals("valueParameterDefinition")) {
                this.value = new ParameterDefinition();
                return this.value;
            }
            if (name.equals("valueRelatedArtifact")) {
                this.value = new RelatedArtifact();
                return this.value;
            }
            if (name.equals("valueTriggerDefinition")) {
                this.value = new TriggerDefinition();
                return this.value;
            }
            if (name.equals("valueUsageContext")) {
                this.value = new UsageContext();
                return this.value;
            }
            if (name.equals("valueAvailability")) {
                this.value = new Availability();
                return this.value;
            }
            if (name.equals("valueExtendedContactDetail")) {
                this.value = new ExtendedContactDetail();
                return this.value;
            }
            if (name.equals("valueDosage")) {
                this.value = new Dosage();
                return this.value;
            }
            if (name.equals("valueMeta")) {
                this.value = new Meta();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public TaskInputComponent copy() {
            TaskInputComponent dst = new TaskInputComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TaskInputComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TaskInputComponent)) {
                return false;
            }
            TaskInputComponent o = (TaskInputComponent)other_;
            return TaskInputComponent.compareDeep(this.type, o.type, true) && TaskInputComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TaskInputComponent)) {
                return false;
            }
            TaskInputComponent o = (TaskInputComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.value);
        }

        @Override
        public String fhirType() {
            return "Task.input";
        }
    }

    @Block
    public static class TaskRestrictionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="repetitions", type={PositiveIntType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How many times to repeat", formalDefinition="Indicates the number of times the requested action should occur.")
        protected PositiveIntType repetitions;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When fulfillment is sought", formalDefinition="The time-period for which fulfillment is sought. This must fall within the overall time period authorized in the referenced request.  E.g. ServiceRequest.occurance[x].")
        protected Period period;
        @Child(name="recipient", type={Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, Group.class, Organization.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="For whom is fulfillment sought?", formalDefinition="For requests that are targeted to more than one potential recipient/target, to identify who is fulfillment is sought for.")
        protected List<Reference> recipient;
        private static final long serialVersionUID = 1673996066L;

        public PositiveIntType getRepetitionsElement() {
            if (this.repetitions == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TaskRestrictionComponent.repetitions");
                }
                if (Configuration.doAutoCreate()) {
                    this.repetitions = new PositiveIntType();
                }
            }
            return this.repetitions;
        }

        public boolean hasRepetitionsElement() {
            return this.repetitions != null && !this.repetitions.isEmpty();
        }

        public boolean hasRepetitions() {
            return this.repetitions != null && !this.repetitions.isEmpty();
        }

        public TaskRestrictionComponent setRepetitionsElement(PositiveIntType value) {
            this.repetitions = value;
            return this;
        }

        public int getRepetitions() {
            return this.repetitions == null || this.repetitions.isEmpty() ? 0 : (Integer)this.repetitions.getValue();
        }

        public TaskRestrictionComponent setRepetitions(int value) {
            if (this.repetitions == null) {
                this.repetitions = new PositiveIntType();
            }
            this.repetitions.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TaskRestrictionComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public TaskRestrictionComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public List<Reference> getRecipient() {
            if (this.recipient == null) {
                this.recipient = new ArrayList<Reference>();
            }
            return this.recipient;
        }

        public TaskRestrictionComponent setRecipient(List<Reference> theRecipient) {
            this.recipient = theRecipient;
            return this;
        }

        public boolean hasRecipient() {
            if (this.recipient == null) {
                return false;
            }
            for (Reference item : this.recipient) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addRecipient() {
            Reference t = new Reference();
            if (this.recipient == null) {
                this.recipient = new ArrayList<Reference>();
            }
            this.recipient.add(t);
            return t;
        }

        public TaskRestrictionComponent addRecipient(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.recipient == null) {
                this.recipient = new ArrayList<Reference>();
            }
            this.recipient.add(t);
            return this;
        }

        public Reference getRecipientFirstRep() {
            if (this.getRecipient().isEmpty()) {
                this.addRecipient();
            }
            return this.getRecipient().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("repetitions", "positiveInt", "Indicates the number of times the requested action should occur.", 0, 1, this.repetitions));
            children.add(new Property(Task.SP_PERIOD, "Period", "The time-period for which fulfillment is sought. This must fall within the overall time period authorized in the referenced request.  E.g. ServiceRequest.occurance[x].", 0, 1, this.period));
            children.add(new Property("recipient", "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Group|Organization)", "For requests that are targeted to more than one potential recipient/target, to identify who is fulfillment is sought for.", 0, Integer.MAX_VALUE, this.recipient));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 984367650: {
                    return new Property("repetitions", "positiveInt", "Indicates the number of times the requested action should occur.", 0, 1, this.repetitions);
                }
                case -991726143: {
                    return new Property(Task.SP_PERIOD, "Period", "The time-period for which fulfillment is sought. This must fall within the overall time period authorized in the referenced request.  E.g. ServiceRequest.occurance[x].", 0, 1, this.period);
                }
                case 820081177: {
                    return new Property("recipient", "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Group|Organization)", "For requests that are targeted to more than one potential recipient/target, to identify who is fulfillment is sought for.", 0, Integer.MAX_VALUE, this.recipient);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 984367650: {
                    Base[] baseArray;
                    if (this.repetitions == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.repetitions;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
                case 820081177: {
                    return this.recipient == null ? new Base[]{} : this.recipient.toArray(new Base[this.recipient.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 984367650: {
                    this.repetitions = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case 820081177: {
                    this.getRecipient().add(TypeConvertor.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("repetitions")) {
                this.repetitions = TypeConvertor.castToPositiveInt(value);
            } else if (name.equals(Task.SP_PERIOD)) {
                this.period = TypeConvertor.castToPeriod(value);
            } else if (name.equals("recipient")) {
                this.getRecipient().add(TypeConvertor.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 984367650: {
                    return this.getRepetitionsElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case 820081177: {
                    return this.addRecipient();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 984367650: {
                    return new String[]{"positiveInt"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case 820081177: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("repetitions")) {
                throw new FHIRException("Cannot call addChild on a primitive type Task.restriction.repetitions");
            }
            if (name.equals(Task.SP_PERIOD)) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals("recipient")) {
                return this.addRecipient();
            }
            return super.addChild(name);
        }

        @Override
        public TaskRestrictionComponent copy() {
            TaskRestrictionComponent dst = new TaskRestrictionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TaskRestrictionComponent dst) {
            super.copyValues(dst);
            dst.repetitions = this.repetitions == null ? null : this.repetitions.copy();
            Period period = dst.period = this.period == null ? null : this.period.copy();
            if (this.recipient != null) {
                dst.recipient = new ArrayList<Reference>();
                for (Reference i2 : this.recipient) {
                    dst.recipient.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TaskRestrictionComponent)) {
                return false;
            }
            TaskRestrictionComponent o = (TaskRestrictionComponent)other_;
            return TaskRestrictionComponent.compareDeep(this.repetitions, o.repetitions, true) && TaskRestrictionComponent.compareDeep(this.period, o.period, true) && TaskRestrictionComponent.compareDeep(this.recipient, o.recipient, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TaskRestrictionComponent)) {
                return false;
            }
            TaskRestrictionComponent o = (TaskRestrictionComponent)other_;
            return TaskRestrictionComponent.compareValues(this.repetitions, o.repetitions, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.repetitions, this.period, this.recipient);
        }

        @Override
        public String fhirType() {
            return "Task.restriction";
        }
    }

    public static class TaskStatusEnumFactory
    implements EnumFactory<TaskStatus> {
        @Override
        public TaskStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return TaskStatus.DRAFT;
            }
            if ("requested".equals(codeString)) {
                return TaskStatus.REQUESTED;
            }
            if ("received".equals(codeString)) {
                return TaskStatus.RECEIVED;
            }
            if ("accepted".equals(codeString)) {
                return TaskStatus.ACCEPTED;
            }
            if ("rejected".equals(codeString)) {
                return TaskStatus.REJECTED;
            }
            if ("ready".equals(codeString)) {
                return TaskStatus.READY;
            }
            if ("cancelled".equals(codeString)) {
                return TaskStatus.CANCELLED;
            }
            if ("in-progress".equals(codeString)) {
                return TaskStatus.INPROGRESS;
            }
            if ("on-hold".equals(codeString)) {
                return TaskStatus.ONHOLD;
            }
            if ("failed".equals(codeString)) {
                return TaskStatus.FAILED;
            }
            if ("completed".equals(codeString)) {
                return TaskStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return TaskStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown TaskStatus code '" + codeString + "'");
        }

        public Enumeration<TaskStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<TaskStatus>(this, TaskStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.NULL, code);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.DRAFT, code);
            }
            if ("requested".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.REQUESTED, code);
            }
            if ("received".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.RECEIVED, code);
            }
            if ("accepted".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.ACCEPTED, code);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.REJECTED, code);
            }
            if ("ready".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.READY, code);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.CANCELLED, code);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.INPROGRESS, code);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.ONHOLD, code);
            }
            if ("failed".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.FAILED, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.COMPLETED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown TaskStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(TaskStatus code) {
            if (code == TaskStatus.DRAFT) {
                return "draft";
            }
            if (code == TaskStatus.REQUESTED) {
                return "requested";
            }
            if (code == TaskStatus.RECEIVED) {
                return "received";
            }
            if (code == TaskStatus.ACCEPTED) {
                return "accepted";
            }
            if (code == TaskStatus.REJECTED) {
                return "rejected";
            }
            if (code == TaskStatus.READY) {
                return "ready";
            }
            if (code == TaskStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == TaskStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == TaskStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == TaskStatus.FAILED) {
                return "failed";
            }
            if (code == TaskStatus.COMPLETED) {
                return "completed";
            }
            if (code == TaskStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(TaskStatus code) {
            return code.getSystem();
        }
    }

    public static enum TaskStatus {
        DRAFT,
        REQUESTED,
        RECEIVED,
        ACCEPTED,
        REJECTED,
        READY,
        CANCELLED,
        INPROGRESS,
        ONHOLD,
        FAILED,
        COMPLETED,
        ENTEREDINERROR,
        NULL;


        public static TaskStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("requested".equals(codeString)) {
                return REQUESTED;
            }
            if ("received".equals(codeString)) {
                return RECEIVED;
            }
            if ("accepted".equals(codeString)) {
                return ACCEPTED;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if ("ready".equals(codeString)) {
                return READY;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("failed".equals(codeString)) {
                return FAILED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown TaskStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case REQUESTED: {
                    return "requested";
                }
                case RECEIVED: {
                    return "received";
                }
                case ACCEPTED: {
                    return "accepted";
                }
                case REJECTED: {
                    return "rejected";
                }
                case READY: {
                    return "ready";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case FAILED: {
                    return "failed";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/task-status";
                }
                case REQUESTED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case RECEIVED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case ACCEPTED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case READY: {
                    return "http://hl7.org/fhir/task-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/task-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/task-status";
                }
                case FAILED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/task-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "The task is not yet ready to be acted upon.";
                }
                case REQUESTED: {
                    return "The task is ready to be acted upon and action is sought.";
                }
                case RECEIVED: {
                    return "A potential performer has claimed ownership of the task and is evaluating whether to perform it.";
                }
                case ACCEPTED: {
                    return "The potential performer has agreed to execute the task but has not yet started work.";
                }
                case REJECTED: {
                    return "The potential performer who claimed ownership of the task has decided not to execute it prior to performing any action.";
                }
                case READY: {
                    return "The task is ready to be performed, but no action has yet been taken.  Used in place of requested/received/accepted/rejected when request assignment and acceptance is a given.";
                }
                case CANCELLED: {
                    return "The task was not completed.";
                }
                case INPROGRESS: {
                    return "The task has been started but is not yet complete.";
                }
                case ONHOLD: {
                    return "The task has been started but work has been paused.";
                }
                case FAILED: {
                    return "The task was attempted but could not be completed due to some error.";
                }
                case COMPLETED: {
                    return "The task has been completed.";
                }
                case ENTEREDINERROR: {
                    return "The task should never have existed and is retained only because of the possibility it may have used.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case REQUESTED: {
                    return "Requested";
                }
                case RECEIVED: {
                    return "Received";
                }
                case ACCEPTED: {
                    return "Accepted";
                }
                case REJECTED: {
                    return "Rejected";
                }
                case READY: {
                    return "Ready";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case FAILED: {
                    return "Failed";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class TaskIntentEnumFactory
    implements EnumFactory<TaskIntent> {
        @Override
        public TaskIntent fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("unknown".equals(codeString)) {
                return TaskIntent.UNKNOWN;
            }
            if ("proposal".equals(codeString)) {
                return TaskIntent.PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return TaskIntent.PLAN;
            }
            if ("order".equals(codeString)) {
                return TaskIntent.ORDER;
            }
            if ("original-order".equals(codeString)) {
                return TaskIntent.ORIGINALORDER;
            }
            if ("reflex-order".equals(codeString)) {
                return TaskIntent.REFLEXORDER;
            }
            if ("filler-order".equals(codeString)) {
                return TaskIntent.FILLERORDER;
            }
            if ("instance-order".equals(codeString)) {
                return TaskIntent.INSTANCEORDER;
            }
            if ("option".equals(codeString)) {
                return TaskIntent.OPTION;
            }
            throw new IllegalArgumentException("Unknown TaskIntent code '" + codeString + "'");
        }

        public Enumeration<TaskIntent> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<TaskIntent>(this, TaskIntent.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<TaskIntent>(this, TaskIntent.NULL, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<TaskIntent>(this, TaskIntent.UNKNOWN, code);
            }
            if ("proposal".equals(codeString)) {
                return new Enumeration<TaskIntent>(this, TaskIntent.PROPOSAL, code);
            }
            if ("plan".equals(codeString)) {
                return new Enumeration<TaskIntent>(this, TaskIntent.PLAN, code);
            }
            if ("order".equals(codeString)) {
                return new Enumeration<TaskIntent>(this, TaskIntent.ORDER, code);
            }
            if ("original-order".equals(codeString)) {
                return new Enumeration<TaskIntent>(this, TaskIntent.ORIGINALORDER, code);
            }
            if ("reflex-order".equals(codeString)) {
                return new Enumeration<TaskIntent>(this, TaskIntent.REFLEXORDER, code);
            }
            if ("filler-order".equals(codeString)) {
                return new Enumeration<TaskIntent>(this, TaskIntent.FILLERORDER, code);
            }
            if ("instance-order".equals(codeString)) {
                return new Enumeration<TaskIntent>(this, TaskIntent.INSTANCEORDER, code);
            }
            if ("option".equals(codeString)) {
                return new Enumeration<TaskIntent>(this, TaskIntent.OPTION, code);
            }
            throw new FHIRException("Unknown TaskIntent code '" + codeString + "'");
        }

        @Override
        public String toCode(TaskIntent code) {
            if (code == TaskIntent.UNKNOWN) {
                return "unknown";
            }
            if (code == TaskIntent.PROPOSAL) {
                return "proposal";
            }
            if (code == TaskIntent.PLAN) {
                return "plan";
            }
            if (code == TaskIntent.ORDER) {
                return "order";
            }
            if (code == TaskIntent.ORIGINALORDER) {
                return "original-order";
            }
            if (code == TaskIntent.REFLEXORDER) {
                return "reflex-order";
            }
            if (code == TaskIntent.FILLERORDER) {
                return "filler-order";
            }
            if (code == TaskIntent.INSTANCEORDER) {
                return "instance-order";
            }
            if (code == TaskIntent.OPTION) {
                return "option";
            }
            return "?";
        }

        @Override
        public String toSystem(TaskIntent code) {
            return code.getSystem();
        }
    }

    public static enum TaskIntent {
        UNKNOWN,
        PROPOSAL,
        PLAN,
        ORDER,
        ORIGINALORDER,
        REFLEXORDER,
        FILLERORDER,
        INSTANCEORDER,
        OPTION,
        NULL;


        public static TaskIntent fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if ("proposal".equals(codeString)) {
                return PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return PLAN;
            }
            if ("order".equals(codeString)) {
                return ORDER;
            }
            if ("original-order".equals(codeString)) {
                return ORIGINALORDER;
            }
            if ("reflex-order".equals(codeString)) {
                return REFLEXORDER;
            }
            if ("filler-order".equals(codeString)) {
                return FILLERORDER;
            }
            if ("instance-order".equals(codeString)) {
                return INSTANCEORDER;
            }
            if ("option".equals(codeString)) {
                return OPTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown TaskIntent code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case UNKNOWN: {
                    return "unknown";
                }
                case PROPOSAL: {
                    return "proposal";
                }
                case PLAN: {
                    return "plan";
                }
                case ORDER: {
                    return "order";
                }
                case ORIGINALORDER: {
                    return "original-order";
                }
                case REFLEXORDER: {
                    return "reflex-order";
                }
                case FILLERORDER: {
                    return "filler-order";
                }
                case INSTANCEORDER: {
                    return "instance-order";
                }
                case OPTION: {
                    return "option";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case UNKNOWN: {
                    return "http://hl7.org/fhir/task-intent";
                }
                case PROPOSAL: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case PLAN: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case ORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case ORIGINALORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case REFLEXORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case FILLERORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case INSTANCEORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case OPTION: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case UNKNOWN: {
                    return "The intent is not known.  When dealing with Task, it's not always known (or relevant) how the task was initiated - i.e. whether it was proposed, planned, ordered or just done spontaneously.";
                }
                case PROPOSAL: {
                    return "The request is a suggestion made by someone/something that does not have an intention to ensure it occurs and without providing an authorization to act.";
                }
                case PLAN: {
                    return "The request represents an intention to ensure something occurs without providing an authorization for others to act.";
                }
                case ORDER: {
                    return "The request represents a request/demand and authorization for action by the requestor.";
                }
                case ORIGINALORDER: {
                    return "The request represents an original authorization for action.";
                }
                case REFLEXORDER: {
                    return "The request represents an automatically generated supplemental authorization for action based on a parent authorization together with initial results of the action taken against that parent authorization.";
                }
                case FILLERORDER: {
                    return "The request represents the view of an authorization instantiated by a fulfilling system representing the details of the fulfiller's intention to act upon a submitted order.";
                }
                case INSTANCEORDER: {
                    return "An order created in fulfillment of a broader order that represents the authorization for a single activity occurrence.  E.g. The administration of a single dose of a drug.";
                }
                case OPTION: {
                    return "The request represents a component or option for a RequestOrchestration that establishes timing, conditionality and/or other constraints among a set of requests.  Refer to [[[RequestOrchestration]]] for additional information on how this status is used.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case UNKNOWN: {
                    return "Unknown";
                }
                case PROPOSAL: {
                    return "Proposal";
                }
                case PLAN: {
                    return "Plan";
                }
                case ORDER: {
                    return "Order";
                }
                case ORIGINALORDER: {
                    return "Original Order";
                }
                case REFLEXORDER: {
                    return "Reflex Order";
                }
                case FILLERORDER: {
                    return "Filler Order";
                }
                case INSTANCEORDER: {
                    return "Instance Order";
                }
                case OPTION: {
                    return "Option";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

