/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="SubscriptionStatus", profile="http://hl7.org/fhir/StructureDefinition/SubscriptionStatus")
public class SubscriptionStatus
extends DomainResource {
    @Child(name="status", type={CodeType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="requested | active | error | off | entered-in-error", formalDefinition="The status of the subscription, which marks the server state for managing the subscription.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscription-status")
    protected Enumeration<Enumerations.SubscriptionStatusCodes> status;
    @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="handshake | heartbeat | event-notification | query-status | query-event", formalDefinition="The type of event being conveyed with this notificaiton.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscription-notification-type")
    protected Enumeration<SubscriptionNotificationType> type;
    @Child(name="eventsSinceSubscriptionStart", type={Integer64Type.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Events since the Subscription was created", formalDefinition="The total number of actual events which have been generated since the Subscription was created (inclusive of this notification) - regardless of how many have been successfully communicated.  This number is NOT incremented for handshake and heartbeat notifications.")
    protected Integer64Type eventsSinceSubscriptionStart;
    @Child(name="notificationEvent", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Detailed information about any events relevant to this notification", formalDefinition="Detailed information about events relevant to this subscription notification.")
    protected List<SubscriptionStatusNotificationEventComponent> notificationEvent;
    @Child(name="subscription", type={Subscription.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reference to the Subscription responsible for this notification", formalDefinition="The reference to the Subscription which generated this notification.")
    protected Reference subscription;
    @Child(name="topic", type={CanonicalType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reference to the SubscriptionTopic this notification relates to", formalDefinition="The reference to the SubscriptionTopic for the Subscription which generated this notification.")
    protected CanonicalType topic;
    @Child(name="error", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="List of errors on the subscription", formalDefinition="A record of errors that occurred when the server processed a notification.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscription-error")
    protected List<CodeableConcept> error;
    private static final long serialVersionUID = -285503955L;

    public SubscriptionStatus() {
    }

    public SubscriptionStatus(SubscriptionNotificationType type, Reference subscription) {
        this.setType(type);
        this.setSubscription(subscription);
    }

    public Enumeration<Enumerations.SubscriptionStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionStatus.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.SubscriptionStatusCodes>(new Enumerations.SubscriptionStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public SubscriptionStatus setStatusElement(Enumeration<Enumerations.SubscriptionStatusCodes> value) {
        this.status = value;
        return this;
    }

    public Enumerations.SubscriptionStatusCodes getStatus() {
        return this.status == null ? null : (Enumerations.SubscriptionStatusCodes)((Object)this.status.getValue());
    }

    public SubscriptionStatus setStatus(Enumerations.SubscriptionStatusCodes value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<Enumerations.SubscriptionStatusCodes>(new Enumerations.SubscriptionStatusCodesEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Enumeration<SubscriptionNotificationType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionStatus.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<SubscriptionNotificationType>(new SubscriptionNotificationTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public SubscriptionStatus setTypeElement(Enumeration<SubscriptionNotificationType> value) {
        this.type = value;
        return this;
    }

    public SubscriptionNotificationType getType() {
        return this.type == null ? null : (SubscriptionNotificationType)((Object)this.type.getValue());
    }

    public SubscriptionStatus setType(SubscriptionNotificationType value) {
        if (this.type == null) {
            this.type = new Enumeration<SubscriptionNotificationType>(new SubscriptionNotificationTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public Integer64Type getEventsSinceSubscriptionStartElement() {
        if (this.eventsSinceSubscriptionStart == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionStatus.eventsSinceSubscriptionStart");
            }
            if (Configuration.doAutoCreate()) {
                this.eventsSinceSubscriptionStart = new Integer64Type();
            }
        }
        return this.eventsSinceSubscriptionStart;
    }

    public boolean hasEventsSinceSubscriptionStartElement() {
        return this.eventsSinceSubscriptionStart != null && !this.eventsSinceSubscriptionStart.isEmpty();
    }

    public boolean hasEventsSinceSubscriptionStart() {
        return this.eventsSinceSubscriptionStart != null && !this.eventsSinceSubscriptionStart.isEmpty();
    }

    public SubscriptionStatus setEventsSinceSubscriptionStartElement(Integer64Type value) {
        this.eventsSinceSubscriptionStart = value;
        return this;
    }

    public long getEventsSinceSubscriptionStart() {
        return this.eventsSinceSubscriptionStart == null || this.eventsSinceSubscriptionStart.isEmpty() ? 0L : (Long)this.eventsSinceSubscriptionStart.getValue();
    }

    public SubscriptionStatus setEventsSinceSubscriptionStart(long value) {
        this.eventsSinceSubscriptionStart = new Integer64Type();
        this.eventsSinceSubscriptionStart.setValue((Object)value);
        return this;
    }

    public List<SubscriptionStatusNotificationEventComponent> getNotificationEvent() {
        if (this.notificationEvent == null) {
            this.notificationEvent = new ArrayList<SubscriptionStatusNotificationEventComponent>();
        }
        return this.notificationEvent;
    }

    public SubscriptionStatus setNotificationEvent(List<SubscriptionStatusNotificationEventComponent> theNotificationEvent) {
        this.notificationEvent = theNotificationEvent;
        return this;
    }

    public boolean hasNotificationEvent() {
        if (this.notificationEvent == null) {
            return false;
        }
        for (SubscriptionStatusNotificationEventComponent item : this.notificationEvent) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubscriptionStatusNotificationEventComponent addNotificationEvent() {
        SubscriptionStatusNotificationEventComponent t = new SubscriptionStatusNotificationEventComponent();
        if (this.notificationEvent == null) {
            this.notificationEvent = new ArrayList<SubscriptionStatusNotificationEventComponent>();
        }
        this.notificationEvent.add(t);
        return t;
    }

    public SubscriptionStatus addNotificationEvent(SubscriptionStatusNotificationEventComponent t) {
        if (t == null) {
            return this;
        }
        if (this.notificationEvent == null) {
            this.notificationEvent = new ArrayList<SubscriptionStatusNotificationEventComponent>();
        }
        this.notificationEvent.add(t);
        return this;
    }

    public SubscriptionStatusNotificationEventComponent getNotificationEventFirstRep() {
        if (this.getNotificationEvent().isEmpty()) {
            this.addNotificationEvent();
        }
        return this.getNotificationEvent().get(0);
    }

    public Reference getSubscription() {
        if (this.subscription == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionStatus.subscription");
            }
            if (Configuration.doAutoCreate()) {
                this.subscription = new Reference();
            }
        }
        return this.subscription;
    }

    public boolean hasSubscription() {
        return this.subscription != null && !this.subscription.isEmpty();
    }

    public SubscriptionStatus setSubscription(Reference value) {
        this.subscription = value;
        return this;
    }

    public CanonicalType getTopicElement() {
        if (this.topic == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionStatus.topic");
            }
            if (Configuration.doAutoCreate()) {
                this.topic = new CanonicalType();
            }
        }
        return this.topic;
    }

    public boolean hasTopicElement() {
        return this.topic != null && !this.topic.isEmpty();
    }

    public boolean hasTopic() {
        return this.topic != null && !this.topic.isEmpty();
    }

    public SubscriptionStatus setTopicElement(CanonicalType value) {
        this.topic = value;
        return this;
    }

    public String getTopic() {
        return this.topic == null ? null : (String)this.topic.getValue();
    }

    public SubscriptionStatus setTopic(String value) {
        if (Utilities.noString(value)) {
            this.topic = null;
        } else {
            if (this.topic == null) {
                this.topic = new CanonicalType();
            }
            this.topic.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getError() {
        if (this.error == null) {
            this.error = new ArrayList<CodeableConcept>();
        }
        return this.error;
    }

    public SubscriptionStatus setError(List<CodeableConcept> theError) {
        this.error = theError;
        return this;
    }

    public boolean hasError() {
        if (this.error == null) {
            return false;
        }
        for (CodeableConcept item : this.error) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addError() {
        CodeableConcept t = new CodeableConcept();
        if (this.error == null) {
            this.error = new ArrayList<CodeableConcept>();
        }
        this.error.add(t);
        return t;
    }

    public SubscriptionStatus addError(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.error == null) {
            this.error = new ArrayList<CodeableConcept>();
        }
        this.error.add(t);
        return this;
    }

    public CodeableConcept getErrorFirstRep() {
        if (this.getError().isEmpty()) {
            this.addError();
        }
        return this.getError().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("status", "code", "The status of the subscription, which marks the server state for managing the subscription.", 0, 1, this.status));
        children.add(new Property("type", "code", "The type of event being conveyed with this notificaiton.", 0, 1, this.type));
        children.add(new Property("eventsSinceSubscriptionStart", "integer64", "The total number of actual events which have been generated since the Subscription was created (inclusive of this notification) - regardless of how many have been successfully communicated.  This number is NOT incremented for handshake and heartbeat notifications.", 0, 1, this.eventsSinceSubscriptionStart));
        children.add(new Property("notificationEvent", "", "Detailed information about events relevant to this subscription notification.", 0, Integer.MAX_VALUE, this.notificationEvent));
        children.add(new Property("subscription", "Reference(Subscription)", "The reference to the Subscription which generated this notification.", 0, 1, this.subscription));
        children.add(new Property("topic", "canonical(SubscriptionTopic)", "The reference to the SubscriptionTopic for the Subscription which generated this notification.", 0, 1, this.topic));
        children.add(new Property("error", "CodeableConcept", "A record of errors that occurred when the server processed a notification.", 0, Integer.MAX_VALUE, this.error));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -892481550: {
                return new Property("status", "code", "The status of the subscription, which marks the server state for managing the subscription.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property("type", "code", "The type of event being conveyed with this notificaiton.", 0, 1, this.type);
            }
            case 304566692: {
                return new Property("eventsSinceSubscriptionStart", "integer64", "The total number of actual events which have been generated since the Subscription was created (inclusive of this notification) - regardless of how many have been successfully communicated.  This number is NOT incremented for handshake and heartbeat notifications.", 0, 1, this.eventsSinceSubscriptionStart);
            }
            case -1595878289: {
                return new Property("notificationEvent", "", "Detailed information about events relevant to this subscription notification.", 0, Integer.MAX_VALUE, this.notificationEvent);
            }
            case 341203229: {
                return new Property("subscription", "Reference(Subscription)", "The reference to the Subscription which generated this notification.", 0, 1, this.subscription);
            }
            case 110546223: {
                return new Property("topic", "canonical(SubscriptionTopic)", "The reference to the SubscriptionTopic for the Subscription which generated this notification.", 0, 1, this.topic);
            }
            case 96784904: {
                return new Property("error", "CodeableConcept", "A record of errors that occurred when the server processed a notification.", 0, Integer.MAX_VALUE, this.error);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case 304566692: {
                Base[] baseArray;
                if (this.eventsSinceSubscriptionStart == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.eventsSinceSubscriptionStart;
                }
                return baseArray;
            }
            case -1595878289: {
                return this.notificationEvent == null ? new Base[]{} : this.notificationEvent.toArray(new Base[this.notificationEvent.size()]);
            }
            case 341203229: {
                Base[] baseArray;
                if (this.subscription == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subscription;
                }
                return baseArray;
            }
            case 110546223: {
                Base[] baseArray;
                if (this.topic == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.topic;
                }
                return baseArray;
            }
            case 96784904: {
                return this.error == null ? new Base[]{} : this.error.toArray(new Base[this.error.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -892481550: {
                value = new Enumerations.SubscriptionStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 3575610: {
                value = new SubscriptionNotificationTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
                return value;
            }
            case 304566692: {
                this.eventsSinceSubscriptionStart = TypeConvertor.castToInteger64(value);
                return value;
            }
            case -1595878289: {
                this.getNotificationEvent().add((SubscriptionStatusNotificationEventComponent)((Object)value));
                return value;
            }
            case 341203229: {
                this.subscription = TypeConvertor.castToReference(value);
                return value;
            }
            case 110546223: {
                this.topic = TypeConvertor.castToCanonical(value);
                return value;
            }
            case 96784904: {
                this.getError().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("status")) {
            value = new Enumerations.SubscriptionStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("type")) {
            value = new SubscriptionNotificationTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.type = value;
        } else if (name.equals("eventsSinceSubscriptionStart")) {
            this.eventsSinceSubscriptionStart = TypeConvertor.castToInteger64(value);
        } else if (name.equals("notificationEvent")) {
            this.getNotificationEvent().add((SubscriptionStatusNotificationEventComponent)((Object)value));
        } else if (name.equals("subscription")) {
            this.subscription = TypeConvertor.castToReference(value);
        } else if (name.equals("topic")) {
            this.topic = TypeConvertor.castToCanonical(value);
        } else if (name.equals("error")) {
            this.getError().add(TypeConvertor.castToCodeableConcept(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -892481550: {
                return this.getStatusElement();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case 304566692: {
                return this.getEventsSinceSubscriptionStartElement();
            }
            case -1595878289: {
                return this.addNotificationEvent();
            }
            case 341203229: {
                return this.getSubscription();
            }
            case 110546223: {
                return this.getTopicElement();
            }
            case 96784904: {
                return this.addError();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -892481550: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"code"};
            }
            case 304566692: {
                return new String[]{"integer64"};
            }
            case -1595878289: {
                return new String[0];
            }
            case 341203229: {
                return new String[]{"Reference"};
            }
            case 110546223: {
                return new String[]{"canonical"};
            }
            case 96784904: {
                return new String[]{"CodeableConcept"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionStatus.status");
        }
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionStatus.type");
        }
        if (name.equals("eventsSinceSubscriptionStart")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionStatus.eventsSinceSubscriptionStart");
        }
        if (name.equals("notificationEvent")) {
            return this.addNotificationEvent();
        }
        if (name.equals("subscription")) {
            this.subscription = new Reference();
            return this.subscription;
        }
        if (name.equals("topic")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionStatus.topic");
        }
        if (name.equals("error")) {
            return this.addError();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SubscriptionStatus";
    }

    @Override
    public SubscriptionStatus copy() {
        SubscriptionStatus dst = new SubscriptionStatus();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SubscriptionStatus dst) {
        super.copyValues(dst);
        dst.status = this.status == null ? null : this.status.copy();
        dst.type = this.type == null ? null : this.type.copy();
        Integer64Type integer64Type = dst.eventsSinceSubscriptionStart = this.eventsSinceSubscriptionStart == null ? null : this.eventsSinceSubscriptionStart.copy();
        if (this.notificationEvent != null) {
            dst.notificationEvent = new ArrayList<SubscriptionStatusNotificationEventComponent>();
            for (SubscriptionStatusNotificationEventComponent subscriptionStatusNotificationEventComponent : this.notificationEvent) {
                dst.notificationEvent.add(subscriptionStatusNotificationEventComponent.copy());
            }
        }
        dst.subscription = this.subscription == null ? null : this.subscription.copy();
        CanonicalType canonicalType = dst.topic = this.topic == null ? null : this.topic.copy();
        if (this.error != null) {
            dst.error = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.error) {
                dst.error.add(codeableConcept.copy());
            }
        }
    }

    protected SubscriptionStatus typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SubscriptionStatus)) {
            return false;
        }
        SubscriptionStatus o = (SubscriptionStatus)other_;
        return SubscriptionStatus.compareDeep(this.status, o.status, true) && SubscriptionStatus.compareDeep(this.type, o.type, true) && SubscriptionStatus.compareDeep(this.eventsSinceSubscriptionStart, o.eventsSinceSubscriptionStart, true) && SubscriptionStatus.compareDeep(this.notificationEvent, o.notificationEvent, true) && SubscriptionStatus.compareDeep(this.subscription, o.subscription, true) && SubscriptionStatus.compareDeep(this.topic, o.topic, true) && SubscriptionStatus.compareDeep(this.error, o.error, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SubscriptionStatus)) {
            return false;
        }
        SubscriptionStatus o = (SubscriptionStatus)other_;
        return SubscriptionStatus.compareValues(this.status, o.status, true) && SubscriptionStatus.compareValues(this.type, o.type, true) && SubscriptionStatus.compareValues(this.eventsSinceSubscriptionStart, o.eventsSinceSubscriptionStart, true) && SubscriptionStatus.compareValues(this.topic, o.topic, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.status, this.type, this.eventsSinceSubscriptionStart, this.notificationEvent, this.subscription, this.topic, this.error);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SubscriptionStatus;
    }

    @Block
    public static class SubscriptionStatusNotificationEventComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="eventNumber", type={Integer64Type.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Event number", formalDefinition="The sequential number of this event in this subscription context.")
        protected Integer64Type eventNumber;
        @Child(name="timestamp", type={InstantType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The instant this event occurred", formalDefinition="The actual time this event occured on the server.")
        protected InstantType timestamp;
        @Child(name="focus", type={Reference.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The focus of this event", formalDefinition="The focus of this event. While this will usually be a reference to the focus resource of the event, it MAY contain a reference to a non-FHIR object.")
        protected Reference focus;
        @Child(name="additionalContext", type={Reference.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional context for this event", formalDefinition="Additional context information for this event. Generally, this will contain references to additional resources included with the event (e.g., the Patient relevant to an Encounter), however it MAY refer to non-FHIR objects.")
        protected List<Reference> additionalContext;
        private static final long serialVersionUID = 855121922L;

        public SubscriptionStatusNotificationEventComponent() {
        }

        public SubscriptionStatusNotificationEventComponent(long eventNumber) {
            this.setEventNumber(eventNumber);
        }

        public Integer64Type getEventNumberElement() {
            if (this.eventNumber == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionStatusNotificationEventComponent.eventNumber");
                }
                if (Configuration.doAutoCreate()) {
                    this.eventNumber = new Integer64Type();
                }
            }
            return this.eventNumber;
        }

        public boolean hasEventNumberElement() {
            return this.eventNumber != null && !this.eventNumber.isEmpty();
        }

        public boolean hasEventNumber() {
            return this.eventNumber != null && !this.eventNumber.isEmpty();
        }

        public SubscriptionStatusNotificationEventComponent setEventNumberElement(Integer64Type value) {
            this.eventNumber = value;
            return this;
        }

        public long getEventNumber() {
            return this.eventNumber == null || this.eventNumber.isEmpty() ? 0L : (Long)this.eventNumber.getValue();
        }

        public SubscriptionStatusNotificationEventComponent setEventNumber(long value) {
            this.eventNumber = new Integer64Type();
            this.eventNumber.setValue((Object)value);
            return this;
        }

        public InstantType getTimestampElement() {
            if (this.timestamp == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionStatusNotificationEventComponent.timestamp");
                }
                if (Configuration.doAutoCreate()) {
                    this.timestamp = new InstantType();
                }
            }
            return this.timestamp;
        }

        public boolean hasTimestampElement() {
            return this.timestamp != null && !this.timestamp.isEmpty();
        }

        public boolean hasTimestamp() {
            return this.timestamp != null && !this.timestamp.isEmpty();
        }

        public SubscriptionStatusNotificationEventComponent setTimestampElement(InstantType value) {
            this.timestamp = value;
            return this;
        }

        public Date getTimestamp() {
            return this.timestamp == null ? null : (Date)this.timestamp.getValue();
        }

        public SubscriptionStatusNotificationEventComponent setTimestamp(Date value) {
            if (value == null) {
                this.timestamp = null;
            } else {
                if (this.timestamp == null) {
                    this.timestamp = new InstantType();
                }
                this.timestamp.setValue(value);
            }
            return this;
        }

        public Reference getFocus() {
            if (this.focus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionStatusNotificationEventComponent.focus");
                }
                if (Configuration.doAutoCreate()) {
                    this.focus = new Reference();
                }
            }
            return this.focus;
        }

        public boolean hasFocus() {
            return this.focus != null && !this.focus.isEmpty();
        }

        public SubscriptionStatusNotificationEventComponent setFocus(Reference value) {
            this.focus = value;
            return this;
        }

        public List<Reference> getAdditionalContext() {
            if (this.additionalContext == null) {
                this.additionalContext = new ArrayList<Reference>();
            }
            return this.additionalContext;
        }

        public SubscriptionStatusNotificationEventComponent setAdditionalContext(List<Reference> theAdditionalContext) {
            this.additionalContext = theAdditionalContext;
            return this;
        }

        public boolean hasAdditionalContext() {
            if (this.additionalContext == null) {
                return false;
            }
            for (Reference item : this.additionalContext) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addAdditionalContext() {
            Reference t = new Reference();
            if (this.additionalContext == null) {
                this.additionalContext = new ArrayList<Reference>();
            }
            this.additionalContext.add(t);
            return t;
        }

        public SubscriptionStatusNotificationEventComponent addAdditionalContext(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.additionalContext == null) {
                this.additionalContext = new ArrayList<Reference>();
            }
            this.additionalContext.add(t);
            return this;
        }

        public Reference getAdditionalContextFirstRep() {
            if (this.getAdditionalContext().isEmpty()) {
                this.addAdditionalContext();
            }
            return this.getAdditionalContext().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("eventNumber", "integer64", "The sequential number of this event in this subscription context.", 0, 1, this.eventNumber));
            children.add(new Property("timestamp", "instant", "The actual time this event occured on the server.", 0, 1, this.timestamp));
            children.add(new Property("focus", "Reference(Any)", "The focus of this event. While this will usually be a reference to the focus resource of the event, it MAY contain a reference to a non-FHIR object.", 0, 1, this.focus));
            children.add(new Property("additionalContext", "Reference(Any)", "Additional context information for this event. Generally, this will contain references to additional resources included with the event (e.g., the Patient relevant to an Encounter), however it MAY refer to non-FHIR objects.", 0, Integer.MAX_VALUE, this.additionalContext));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -35234173: {
                    return new Property("eventNumber", "integer64", "The sequential number of this event in this subscription context.", 0, 1, this.eventNumber);
                }
                case 55126294: {
                    return new Property("timestamp", "instant", "The actual time this event occured on the server.", 0, 1, this.timestamp);
                }
                case 97604824: {
                    return new Property("focus", "Reference(Any)", "The focus of this event. While this will usually be a reference to the focus resource of the event, it MAY contain a reference to a non-FHIR object.", 0, 1, this.focus);
                }
                case -908743800: {
                    return new Property("additionalContext", "Reference(Any)", "Additional context information for this event. Generally, this will contain references to additional resources included with the event (e.g., the Patient relevant to an Encounter), however it MAY refer to non-FHIR objects.", 0, Integer.MAX_VALUE, this.additionalContext);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -35234173: {
                    Base[] baseArray;
                    if (this.eventNumber == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.eventNumber;
                    }
                    return baseArray;
                }
                case 55126294: {
                    Base[] baseArray;
                    if (this.timestamp == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.timestamp;
                    }
                    return baseArray;
                }
                case 97604824: {
                    Base[] baseArray;
                    if (this.focus == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.focus;
                    }
                    return baseArray;
                }
                case -908743800: {
                    return this.additionalContext == null ? new Base[]{} : this.additionalContext.toArray(new Base[this.additionalContext.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -35234173: {
                    this.eventNumber = TypeConvertor.castToInteger64(value);
                    return value;
                }
                case 55126294: {
                    this.timestamp = TypeConvertor.castToInstant(value);
                    return value;
                }
                case 97604824: {
                    this.focus = TypeConvertor.castToReference(value);
                    return value;
                }
                case -908743800: {
                    this.getAdditionalContext().add(TypeConvertor.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("eventNumber")) {
                this.eventNumber = TypeConvertor.castToInteger64(value);
            } else if (name.equals("timestamp")) {
                this.timestamp = TypeConvertor.castToInstant(value);
            } else if (name.equals("focus")) {
                this.focus = TypeConvertor.castToReference(value);
            } else if (name.equals("additionalContext")) {
                this.getAdditionalContext().add(TypeConvertor.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -35234173: {
                    return this.getEventNumberElement();
                }
                case 55126294: {
                    return this.getTimestampElement();
                }
                case 97604824: {
                    return this.getFocus();
                }
                case -908743800: {
                    return this.addAdditionalContext();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -35234173: {
                    return new String[]{"integer64"};
                }
                case 55126294: {
                    return new String[]{"instant"};
                }
                case 97604824: {
                    return new String[]{"Reference"};
                }
                case -908743800: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("eventNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionStatus.notificationEvent.eventNumber");
            }
            if (name.equals("timestamp")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionStatus.notificationEvent.timestamp");
            }
            if (name.equals("focus")) {
                this.focus = new Reference();
                return this.focus;
            }
            if (name.equals("additionalContext")) {
                return this.addAdditionalContext();
            }
            return super.addChild(name);
        }

        @Override
        public SubscriptionStatusNotificationEventComponent copy() {
            SubscriptionStatusNotificationEventComponent dst = new SubscriptionStatusNotificationEventComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubscriptionStatusNotificationEventComponent dst) {
            super.copyValues(dst);
            dst.eventNumber = this.eventNumber == null ? null : this.eventNumber.copy();
            dst.timestamp = this.timestamp == null ? null : this.timestamp.copy();
            Reference reference = dst.focus = this.focus == null ? null : this.focus.copy();
            if (this.additionalContext != null) {
                dst.additionalContext = new ArrayList<Reference>();
                for (Reference i2 : this.additionalContext) {
                    dst.additionalContext.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionStatusNotificationEventComponent)) {
                return false;
            }
            SubscriptionStatusNotificationEventComponent o = (SubscriptionStatusNotificationEventComponent)other_;
            return SubscriptionStatusNotificationEventComponent.compareDeep(this.eventNumber, o.eventNumber, true) && SubscriptionStatusNotificationEventComponent.compareDeep(this.timestamp, o.timestamp, true) && SubscriptionStatusNotificationEventComponent.compareDeep(this.focus, o.focus, true) && SubscriptionStatusNotificationEventComponent.compareDeep(this.additionalContext, o.additionalContext, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionStatusNotificationEventComponent)) {
                return false;
            }
            SubscriptionStatusNotificationEventComponent o = (SubscriptionStatusNotificationEventComponent)other_;
            return SubscriptionStatusNotificationEventComponent.compareValues(this.eventNumber, o.eventNumber, true) && SubscriptionStatusNotificationEventComponent.compareValues(this.timestamp, o.timestamp, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.eventNumber, this.timestamp, this.focus, this.additionalContext);
        }

        @Override
        public String fhirType() {
            return "SubscriptionStatus.notificationEvent";
        }
    }

    public static class SubscriptionNotificationTypeEnumFactory
    implements EnumFactory<SubscriptionNotificationType> {
        @Override
        public SubscriptionNotificationType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("handshake".equals(codeString)) {
                return SubscriptionNotificationType.HANDSHAKE;
            }
            if ("heartbeat".equals(codeString)) {
                return SubscriptionNotificationType.HEARTBEAT;
            }
            if ("event-notification".equals(codeString)) {
                return SubscriptionNotificationType.EVENTNOTIFICATION;
            }
            if ("query-status".equals(codeString)) {
                return SubscriptionNotificationType.QUERYSTATUS;
            }
            if ("query-event".equals(codeString)) {
                return SubscriptionNotificationType.QUERYEVENT;
            }
            throw new IllegalArgumentException("Unknown SubscriptionNotificationType code '" + codeString + "'");
        }

        public Enumeration<SubscriptionNotificationType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SubscriptionNotificationType>(this, SubscriptionNotificationType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<SubscriptionNotificationType>(this, SubscriptionNotificationType.NULL, code);
            }
            if ("handshake".equals(codeString)) {
                return new Enumeration<SubscriptionNotificationType>(this, SubscriptionNotificationType.HANDSHAKE, code);
            }
            if ("heartbeat".equals(codeString)) {
                return new Enumeration<SubscriptionNotificationType>(this, SubscriptionNotificationType.HEARTBEAT, code);
            }
            if ("event-notification".equals(codeString)) {
                return new Enumeration<SubscriptionNotificationType>(this, SubscriptionNotificationType.EVENTNOTIFICATION, code);
            }
            if ("query-status".equals(codeString)) {
                return new Enumeration<SubscriptionNotificationType>(this, SubscriptionNotificationType.QUERYSTATUS, code);
            }
            if ("query-event".equals(codeString)) {
                return new Enumeration<SubscriptionNotificationType>(this, SubscriptionNotificationType.QUERYEVENT, code);
            }
            throw new FHIRException("Unknown SubscriptionNotificationType code '" + codeString + "'");
        }

        @Override
        public String toCode(SubscriptionNotificationType code) {
            if (code == SubscriptionNotificationType.HANDSHAKE) {
                return "handshake";
            }
            if (code == SubscriptionNotificationType.HEARTBEAT) {
                return "heartbeat";
            }
            if (code == SubscriptionNotificationType.EVENTNOTIFICATION) {
                return "event-notification";
            }
            if (code == SubscriptionNotificationType.QUERYSTATUS) {
                return "query-status";
            }
            if (code == SubscriptionNotificationType.QUERYEVENT) {
                return "query-event";
            }
            return "?";
        }

        @Override
        public String toSystem(SubscriptionNotificationType code) {
            return code.getSystem();
        }
    }

    public static enum SubscriptionNotificationType {
        HANDSHAKE,
        HEARTBEAT,
        EVENTNOTIFICATION,
        QUERYSTATUS,
        QUERYEVENT,
        NULL;


        public static SubscriptionNotificationType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("handshake".equals(codeString)) {
                return HANDSHAKE;
            }
            if ("heartbeat".equals(codeString)) {
                return HEARTBEAT;
            }
            if ("event-notification".equals(codeString)) {
                return EVENTNOTIFICATION;
            }
            if ("query-status".equals(codeString)) {
                return QUERYSTATUS;
            }
            if ("query-event".equals(codeString)) {
                return QUERYEVENT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SubscriptionNotificationType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case HANDSHAKE: {
                    return "handshake";
                }
                case HEARTBEAT: {
                    return "heartbeat";
                }
                case EVENTNOTIFICATION: {
                    return "event-notification";
                }
                case QUERYSTATUS: {
                    return "query-status";
                }
                case QUERYEVENT: {
                    return "query-event";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case HANDSHAKE: {
                    return "http://hl7.org/fhir/subscription-notification-type";
                }
                case HEARTBEAT: {
                    return "http://hl7.org/fhir/subscription-notification-type";
                }
                case EVENTNOTIFICATION: {
                    return "http://hl7.org/fhir/subscription-notification-type";
                }
                case QUERYSTATUS: {
                    return "http://hl7.org/fhir/subscription-notification-type";
                }
                case QUERYEVENT: {
                    return "http://hl7.org/fhir/subscription-notification-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case HANDSHAKE: {
                    return "The status was generated as part of the setup or verification of a communications channel.";
                }
                case HEARTBEAT: {
                    return "The status was generated to perform a heartbeat notification to the subscriber.";
                }
                case EVENTNOTIFICATION: {
                    return "The status was generated for an event to the subscriber.";
                }
                case QUERYSTATUS: {
                    return "The status was generated in response to a status query/request.";
                }
                case QUERYEVENT: {
                    return "The status was generated in response to an event query/request.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case HANDSHAKE: {
                    return "Handshake";
                }
                case HEARTBEAT: {
                    return "Heartbeat";
                }
                case EVENTNOTIFICATION: {
                    return "Event Notification";
                }
                case QUERYSTATUS: {
                    return "Query Status";
                }
                case QUERYEVENT: {
                    return "Query Event";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

