/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MolecularSequence", profile="http://hl7.org/fhir/StructureDefinition/MolecularSequence")
public class MolecularSequence
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique ID for this particular sequence", formalDefinition="A unique identifier for this particular sequence instance.")
    protected List<Identifier> identifier;
    @Child(name="type", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="aa | dna | rna", formalDefinition="Amino Acid Sequence/ DNA Sequence / RNA Sequence.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/sequence-type")
    protected Enumeration<SequenceType> type;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, Location.class, Organization.class, Procedure.class, Practitioner.class, Medication.class, Substance.class, BiologicallyDerivedProduct.class, NutritionProduct.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Subject this sequence is associated too", formalDefinition="Indicates the subject this sequence is associated too.")
    protected Reference subject;
    @Child(name="specimen", type={Specimen.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Specimen used for sequencing", formalDefinition="Specimen used for sequencing.")
    protected Reference specimen;
    @Child(name="device", type={Device.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The method for sequencing", formalDefinition="The method for sequencing, for example, chip information.")
    protected Reference device;
    @Child(name="performer", type={Organization.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who should be responsible for test result", formalDefinition="The organization or lab that should be responsible for this result.")
    protected Reference performer;
    @Child(name="literal", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Sequence that was observed", formalDefinition="Sequence that was observed.")
    protected StringType literal;
    @Child(name="formatted", type={Attachment.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Embedded file or a link (URL) which contains content to represent the sequence", formalDefinition="Sequence that was observed as file content. Can be an actual file contents, or referenced by a URL to an external system.")
    protected List<Attachment> formatted;
    @Child(name="relative", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A sequence defined relative to another sequence", formalDefinition="A sequence defined relative to another sequence.")
    protected List<MolecularSequenceRelativeComponent> relative;
    private static final long serialVersionUID = -191255113L;
    @SearchParamDefinition(name="identifier", path="MolecularSequence.identifier", description="The unique identity for a particular sequence", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="MolecularSequence.subject", description="The subject that the sequence is about", type="reference", target={BiologicallyDerivedProduct.class, Device.class, Group.class, Location.class, Medication.class, NutritionProduct.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Substance.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("MolecularSequence:patient").toLocked();
    @SearchParamDefinition(name="subject", path="MolecularSequence.subject", description="The subject that the sequence is about", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={BiologicallyDerivedProduct.class, Device.class, Group.class, Location.class, Medication.class, NutritionProduct.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Substance.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("MolecularSequence:subject").toLocked();
    @SearchParamDefinition(name="type", path="MolecularSequence.type", description="Amino Acid Sequence/ DNA Sequence / RNA Sequence", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MolecularSequence setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MolecularSequence addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<SequenceType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MolecularSequence.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<SequenceType>(new SequenceTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public MolecularSequence setTypeElement(Enumeration<SequenceType> value) {
        this.type = value;
        return this;
    }

    public SequenceType getType() {
        return this.type == null ? null : (SequenceType)((Object)this.type.getValue());
    }

    public MolecularSequence setType(SequenceType value) {
        if (value == null) {
            this.type = null;
        } else {
            if (this.type == null) {
                this.type = new Enumeration<SequenceType>(new SequenceTypeEnumFactory());
            }
            this.type.setValue((Object)value);
        }
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MolecularSequence.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public MolecularSequence setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getSpecimen() {
        if (this.specimen == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MolecularSequence.specimen");
            }
            if (Configuration.doAutoCreate()) {
                this.specimen = new Reference();
            }
        }
        return this.specimen;
    }

    public boolean hasSpecimen() {
        return this.specimen != null && !this.specimen.isEmpty();
    }

    public MolecularSequence setSpecimen(Reference value) {
        this.specimen = value;
        return this;
    }

    public Reference getDevice() {
        if (this.device == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MolecularSequence.device");
            }
            if (Configuration.doAutoCreate()) {
                this.device = new Reference();
            }
        }
        return this.device;
    }

    public boolean hasDevice() {
        return this.device != null && !this.device.isEmpty();
    }

    public MolecularSequence setDevice(Reference value) {
        this.device = value;
        return this;
    }

    public Reference getPerformer() {
        if (this.performer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MolecularSequence.performer");
            }
            if (Configuration.doAutoCreate()) {
                this.performer = new Reference();
            }
        }
        return this.performer;
    }

    public boolean hasPerformer() {
        return this.performer != null && !this.performer.isEmpty();
    }

    public MolecularSequence setPerformer(Reference value) {
        this.performer = value;
        return this;
    }

    public StringType getLiteralElement() {
        if (this.literal == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MolecularSequence.literal");
            }
            if (Configuration.doAutoCreate()) {
                this.literal = new StringType();
            }
        }
        return this.literal;
    }

    public boolean hasLiteralElement() {
        return this.literal != null && !this.literal.isEmpty();
    }

    public boolean hasLiteral() {
        return this.literal != null && !this.literal.isEmpty();
    }

    public MolecularSequence setLiteralElement(StringType value) {
        this.literal = value;
        return this;
    }

    public String getLiteral() {
        return this.literal == null ? null : (String)this.literal.getValue();
    }

    public MolecularSequence setLiteral(String value) {
        if (Utilities.noString(value)) {
            this.literal = null;
        } else {
            if (this.literal == null) {
                this.literal = new StringType();
            }
            this.literal.setValue(value);
        }
        return this;
    }

    public List<Attachment> getFormatted() {
        if (this.formatted == null) {
            this.formatted = new ArrayList<Attachment>();
        }
        return this.formatted;
    }

    public MolecularSequence setFormatted(List<Attachment> theFormatted) {
        this.formatted = theFormatted;
        return this;
    }

    public boolean hasFormatted() {
        if (this.formatted == null) {
            return false;
        }
        for (Attachment item : this.formatted) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addFormatted() {
        Attachment t = new Attachment();
        if (this.formatted == null) {
            this.formatted = new ArrayList<Attachment>();
        }
        this.formatted.add(t);
        return t;
    }

    public MolecularSequence addFormatted(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.formatted == null) {
            this.formatted = new ArrayList<Attachment>();
        }
        this.formatted.add(t);
        return this;
    }

    public Attachment getFormattedFirstRep() {
        if (this.getFormatted().isEmpty()) {
            this.addFormatted();
        }
        return this.getFormatted().get(0);
    }

    public List<MolecularSequenceRelativeComponent> getRelative() {
        if (this.relative == null) {
            this.relative = new ArrayList<MolecularSequenceRelativeComponent>();
        }
        return this.relative;
    }

    public MolecularSequence setRelative(List<MolecularSequenceRelativeComponent> theRelative) {
        this.relative = theRelative;
        return this;
    }

    public boolean hasRelative() {
        if (this.relative == null) {
            return false;
        }
        for (MolecularSequenceRelativeComponent item : this.relative) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MolecularSequenceRelativeComponent addRelative() {
        MolecularSequenceRelativeComponent t = new MolecularSequenceRelativeComponent();
        if (this.relative == null) {
            this.relative = new ArrayList<MolecularSequenceRelativeComponent>();
        }
        this.relative.add(t);
        return t;
    }

    public MolecularSequence addRelative(MolecularSequenceRelativeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.relative == null) {
            this.relative = new ArrayList<MolecularSequenceRelativeComponent>();
        }
        this.relative.add(t);
        return this;
    }

    public MolecularSequenceRelativeComponent getRelativeFirstRep() {
        if (this.getRelative().isEmpty()) {
            this.addRelative();
        }
        return this.getRelative().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier for this particular sequence instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_TYPE, "code", "Amino Acid Sequence/ DNA Sequence / RNA Sequence.", 0, 1, this.type));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location|Organization|Procedure|Practitioner|Medication|Substance|BiologicallyDerivedProduct|NutritionProduct)", "Indicates the subject this sequence is associated too.", 0, 1, this.subject));
        children.add(new Property("specimen", "Reference(Specimen)", "Specimen used for sequencing.", 0, 1, this.specimen));
        children.add(new Property("device", "Reference(Device)", "The method for sequencing, for example, chip information.", 0, 1, this.device));
        children.add(new Property("performer", "Reference(Organization)", "The organization or lab that should be responsible for this result.", 0, 1, this.performer));
        children.add(new Property("literal", "string", "Sequence that was observed.", 0, 1, this.literal));
        children.add(new Property("formatted", "Attachment", "Sequence that was observed as file content. Can be an actual file contents, or referenced by a URL to an external system.", 0, Integer.MAX_VALUE, this.formatted));
        children.add(new Property("relative", "", "A sequence defined relative to another sequence.", 0, Integer.MAX_VALUE, this.relative));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier for this particular sequence instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3575610: {
                return new Property(SP_TYPE, "code", "Amino Acid Sequence/ DNA Sequence / RNA Sequence.", 0, 1, this.type);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location|Organization|Procedure|Practitioner|Medication|Substance|BiologicallyDerivedProduct|NutritionProduct)", "Indicates the subject this sequence is associated too.", 0, 1, this.subject);
            }
            case -2132868344: {
                return new Property("specimen", "Reference(Specimen)", "Specimen used for sequencing.", 0, 1, this.specimen);
            }
            case -1335157162: {
                return new Property("device", "Reference(Device)", "The method for sequencing, for example, chip information.", 0, 1, this.device);
            }
            case 481140686: {
                return new Property("performer", "Reference(Organization)", "The organization or lab that should be responsible for this result.", 0, 1, this.performer);
            }
            case 182460591: {
                return new Property("literal", "string", "Sequence that was observed.", 0, 1, this.literal);
            }
            case 1811591356: {
                return new Property("formatted", "Attachment", "Sequence that was observed as file content. Can be an actual file contents, or referenced by a URL to an external system.", 0, Integer.MAX_VALUE, this.formatted);
            }
            case -554435892: {
                return new Property("relative", "", "A sequence defined relative to another sequence.", 0, Integer.MAX_VALUE, this.relative);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.subject;
                }
                return baseArray;
            }
            case -2132868344: {
                Base[] baseArray;
                if (this.specimen == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.specimen;
                }
                return baseArray;
            }
            case -1335157162: {
                Base[] baseArray;
                if (this.device == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.device;
                }
                return baseArray;
            }
            case 481140686: {
                Base[] baseArray;
                if (this.performer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.performer;
                }
                return baseArray;
            }
            case 182460591: {
                Base[] baseArray;
                if (this.literal == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.literal;
                }
                return baseArray;
            }
            case 1811591356: {
                return this.formatted == null ? new Base[]{} : this.formatted.toArray(new Base[this.formatted.size()]);
            }
            case -554435892: {
                return this.relative == null ? new Base[]{} : this.relative.toArray(new Base[this.relative.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 3575610: {
                value = new SequenceTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case -2132868344: {
                this.specimen = TypeConvertor.castToReference(value);
                return value;
            }
            case -1335157162: {
                this.device = TypeConvertor.castToReference(value);
                return value;
            }
            case 481140686: {
                this.performer = TypeConvertor.castToReference(value);
                return value;
            }
            case 182460591: {
                this.literal = TypeConvertor.castToString(value);
                return value;
            }
            case 1811591356: {
                this.getFormatted().add(TypeConvertor.castToAttachment(value));
                return value;
            }
            case -554435892: {
                this.getRelative().add((MolecularSequenceRelativeComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_TYPE)) {
            value = new SequenceTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.type = value;
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("specimen")) {
            this.specimen = TypeConvertor.castToReference(value);
        } else if (name.equals("device")) {
            this.device = TypeConvertor.castToReference(value);
        } else if (name.equals("performer")) {
            this.performer = TypeConvertor.castToReference(value);
        } else if (name.equals("literal")) {
            this.literal = TypeConvertor.castToString(value);
        } else if (name.equals("formatted")) {
            this.getFormatted().add(TypeConvertor.castToAttachment(value));
        } else if (name.equals("relative")) {
            this.getRelative().add((MolecularSequenceRelativeComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case -2132868344: {
                return this.getSpecimen();
            }
            case -1335157162: {
                return this.getDevice();
            }
            case 481140686: {
                return this.getPerformer();
            }
            case 182460591: {
                return this.getLiteralElement();
            }
            case 1811591356: {
                return this.addFormatted();
            }
            case -554435892: {
                return this.addRelative();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3575610: {
                return new String[]{"code"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case -2132868344: {
                return new String[]{"Reference"};
            }
            case -1335157162: {
                return new String[]{"Reference"};
            }
            case 481140686: {
                return new String[]{"Reference"};
            }
            case 182460591: {
                return new String[]{"string"};
            }
            case 1811591356: {
                return new String[]{"Attachment"};
            }
            case -554435892: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.type");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("specimen")) {
            this.specimen = new Reference();
            return this.specimen;
        }
        if (name.equals("device")) {
            this.device = new Reference();
            return this.device;
        }
        if (name.equals("performer")) {
            this.performer = new Reference();
            return this.performer;
        }
        if (name.equals("literal")) {
            throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.literal");
        }
        if (name.equals("formatted")) {
            return this.addFormatted();
        }
        if (name.equals("relative")) {
            return this.addRelative();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MolecularSequence";
    }

    @Override
    public MolecularSequence copy() {
        MolecularSequence dst = new MolecularSequence();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MolecularSequence dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.specimen = this.specimen == null ? null : this.specimen.copy();
        dst.device = this.device == null ? null : this.device.copy();
        dst.performer = this.performer == null ? null : this.performer.copy();
        StringType stringType = dst.literal = this.literal == null ? null : this.literal.copy();
        if (this.formatted != null) {
            dst.formatted = new ArrayList<Attachment>();
            for (Attachment attachment : this.formatted) {
                dst.formatted.add(attachment.copy());
            }
        }
        if (this.relative != null) {
            dst.relative = new ArrayList<MolecularSequenceRelativeComponent>();
            for (MolecularSequenceRelativeComponent molecularSequenceRelativeComponent : this.relative) {
                dst.relative.add(molecularSequenceRelativeComponent.copy());
            }
        }
    }

    protected MolecularSequence typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MolecularSequence)) {
            return false;
        }
        MolecularSequence o = (MolecularSequence)other_;
        return MolecularSequence.compareDeep(this.identifier, o.identifier, true) && MolecularSequence.compareDeep(this.type, o.type, true) && MolecularSequence.compareDeep(this.subject, o.subject, true) && MolecularSequence.compareDeep(this.specimen, o.specimen, true) && MolecularSequence.compareDeep(this.device, o.device, true) && MolecularSequence.compareDeep(this.performer, o.performer, true) && MolecularSequence.compareDeep(this.literal, o.literal, true) && MolecularSequence.compareDeep(this.formatted, o.formatted, true) && MolecularSequence.compareDeep(this.relative, o.relative, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MolecularSequence)) {
            return false;
        }
        MolecularSequence o = (MolecularSequence)other_;
        return MolecularSequence.compareValues(this.type, o.type, true) && MolecularSequence.compareValues(this.literal, o.literal, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.type, this.subject, this.specimen, this.device, this.performer, this.literal, this.formatted, this.relative);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MolecularSequence;
    }

    @Block
    public static class MolecularSequenceRelativeEditComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="start", type={IntegerType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Start position of the edit on the starting sequence", formalDefinition="Start position of the edit on the starting sequence. If the coordinate system is either 0-based or 1-based, then start position is inclusive.")
        protected IntegerType start;
        @Child(name="end", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="End position of the edit on the starting sequence", formalDefinition="End position of the edit on the starting sequence. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.")
        protected IntegerType end;
        @Child(name="replacementSequence", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Allele that was observed", formalDefinition="Allele that was observed. Nucleotide(s)/amino acids from start position of sequence to stop position of sequence on the positive (+) strand of the observed sequence. When the sequence type is DNA, it should be the sequence on the positive (+) strand. This will lay in the range between variant.start and variant.end.")
        protected StringType replacementSequence;
        @Child(name="replacedSequence", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Allele in the starting sequence", formalDefinition="Allele in the starting sequence. Nucleotide(s)/amino acids from start position of sequence to stop position of sequence on the positive (+) strand of the starting sequence. When the sequence  type is DNA, it should be the sequence on the positive (+) strand. This will lay in the range between variant.start and variant.end.")
        protected StringType replacedSequence;
        private static final long serialVersionUID = 550127909L;

        public IntegerType getStartElement() {
            if (this.start == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRelativeEditComponent.start");
                }
                if (Configuration.doAutoCreate()) {
                    this.start = new IntegerType();
                }
            }
            return this.start;
        }

        public boolean hasStartElement() {
            return this.start != null && !this.start.isEmpty();
        }

        public boolean hasStart() {
            return this.start != null && !this.start.isEmpty();
        }

        public MolecularSequenceRelativeEditComponent setStartElement(IntegerType value) {
            this.start = value;
            return this;
        }

        public int getStart() {
            return this.start == null || this.start.isEmpty() ? 0 : (Integer)this.start.getValue();
        }

        public MolecularSequenceRelativeEditComponent setStart(int value) {
            if (this.start == null) {
                this.start = new IntegerType();
            }
            this.start.setValue((Object)value);
            return this;
        }

        public IntegerType getEndElement() {
            if (this.end == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRelativeEditComponent.end");
                }
                if (Configuration.doAutoCreate()) {
                    this.end = new IntegerType();
                }
            }
            return this.end;
        }

        public boolean hasEndElement() {
            return this.end != null && !this.end.isEmpty();
        }

        public boolean hasEnd() {
            return this.end != null && !this.end.isEmpty();
        }

        public MolecularSequenceRelativeEditComponent setEndElement(IntegerType value) {
            this.end = value;
            return this;
        }

        public int getEnd() {
            return this.end == null || this.end.isEmpty() ? 0 : (Integer)this.end.getValue();
        }

        public MolecularSequenceRelativeEditComponent setEnd(int value) {
            if (this.end == null) {
                this.end = new IntegerType();
            }
            this.end.setValue((Object)value);
            return this;
        }

        public StringType getReplacementSequenceElement() {
            if (this.replacementSequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRelativeEditComponent.replacementSequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.replacementSequence = new StringType();
                }
            }
            return this.replacementSequence;
        }

        public boolean hasReplacementSequenceElement() {
            return this.replacementSequence != null && !this.replacementSequence.isEmpty();
        }

        public boolean hasReplacementSequence() {
            return this.replacementSequence != null && !this.replacementSequence.isEmpty();
        }

        public MolecularSequenceRelativeEditComponent setReplacementSequenceElement(StringType value) {
            this.replacementSequence = value;
            return this;
        }

        public String getReplacementSequence() {
            return this.replacementSequence == null ? null : (String)this.replacementSequence.getValue();
        }

        public MolecularSequenceRelativeEditComponent setReplacementSequence(String value) {
            if (Utilities.noString(value)) {
                this.replacementSequence = null;
            } else {
                if (this.replacementSequence == null) {
                    this.replacementSequence = new StringType();
                }
                this.replacementSequence.setValue(value);
            }
            return this;
        }

        public StringType getReplacedSequenceElement() {
            if (this.replacedSequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRelativeEditComponent.replacedSequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.replacedSequence = new StringType();
                }
            }
            return this.replacedSequence;
        }

        public boolean hasReplacedSequenceElement() {
            return this.replacedSequence != null && !this.replacedSequence.isEmpty();
        }

        public boolean hasReplacedSequence() {
            return this.replacedSequence != null && !this.replacedSequence.isEmpty();
        }

        public MolecularSequenceRelativeEditComponent setReplacedSequenceElement(StringType value) {
            this.replacedSequence = value;
            return this;
        }

        public String getReplacedSequence() {
            return this.replacedSequence == null ? null : (String)this.replacedSequence.getValue();
        }

        public MolecularSequenceRelativeEditComponent setReplacedSequence(String value) {
            if (Utilities.noString(value)) {
                this.replacedSequence = null;
            } else {
                if (this.replacedSequence == null) {
                    this.replacedSequence = new StringType();
                }
                this.replacedSequence.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("start", "integer", "Start position of the edit on the starting sequence. If the coordinate system is either 0-based or 1-based, then start position is inclusive.", 0, 1, this.start));
            children.add(new Property("end", "integer", "End position of the edit on the starting sequence. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.", 0, 1, this.end));
            children.add(new Property("replacementSequence", "string", "Allele that was observed. Nucleotide(s)/amino acids from start position of sequence to stop position of sequence on the positive (+) strand of the observed sequence. When the sequence type is DNA, it should be the sequence on the positive (+) strand. This will lay in the range between variant.start and variant.end.", 0, 1, this.replacementSequence));
            children.add(new Property("replacedSequence", "string", "Allele in the starting sequence. Nucleotide(s)/amino acids from start position of sequence to stop position of sequence on the positive (+) strand of the starting sequence. When the sequence  type is DNA, it should be the sequence on the positive (+) strand. This will lay in the range between variant.start and variant.end.", 0, 1, this.replacedSequence));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 109757538: {
                    return new Property("start", "integer", "Start position of the edit on the starting sequence. If the coordinate system is either 0-based or 1-based, then start position is inclusive.", 0, 1, this.start);
                }
                case 100571: {
                    return new Property("end", "integer", "End position of the edit on the starting sequence. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.", 0, 1, this.end);
                }
                case -1784940557: {
                    return new Property("replacementSequence", "string", "Allele that was observed. Nucleotide(s)/amino acids from start position of sequence to stop position of sequence on the positive (+) strand of the observed sequence. When the sequence type is DNA, it should be the sequence on the positive (+) strand. This will lay in the range between variant.start and variant.end.", 0, 1, this.replacementSequence);
                }
                case 1972719633: {
                    return new Property("replacedSequence", "string", "Allele in the starting sequence. Nucleotide(s)/amino acids from start position of sequence to stop position of sequence on the positive (+) strand of the starting sequence. When the sequence  type is DNA, it should be the sequence on the positive (+) strand. This will lay in the range between variant.start and variant.end.", 0, 1, this.replacedSequence);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    Base[] baseArray;
                    if (this.start == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.start;
                    }
                    return baseArray;
                }
                case 100571: {
                    Base[] baseArray;
                    if (this.end == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.end;
                    }
                    return baseArray;
                }
                case -1784940557: {
                    Base[] baseArray;
                    if (this.replacementSequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.replacementSequence;
                    }
                    return baseArray;
                }
                case 1972719633: {
                    Base[] baseArray;
                    if (this.replacedSequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.replacedSequence;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    this.start = TypeConvertor.castToInteger(value);
                    return value;
                }
                case 100571: {
                    this.end = TypeConvertor.castToInteger(value);
                    return value;
                }
                case -1784940557: {
                    this.replacementSequence = TypeConvertor.castToString(value);
                    return value;
                }
                case 1972719633: {
                    this.replacedSequence = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("start")) {
                this.start = TypeConvertor.castToInteger(value);
            } else if (name.equals("end")) {
                this.end = TypeConvertor.castToInteger(value);
            } else if (name.equals("replacementSequence")) {
                this.replacementSequence = TypeConvertor.castToString(value);
            } else if (name.equals("replacedSequence")) {
                this.replacedSequence = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    return this.getStartElement();
                }
                case 100571: {
                    return this.getEndElement();
                }
                case -1784940557: {
                    return this.getReplacementSequenceElement();
                }
                case 1972719633: {
                    return this.getReplacedSequenceElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    return new String[]{"integer"};
                }
                case 100571: {
                    return new String[]{"integer"};
                }
                case -1784940557: {
                    return new String[]{"string"};
                }
                case 1972719633: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("start")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.relative.edit.start");
            }
            if (name.equals("end")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.relative.edit.end");
            }
            if (name.equals("replacementSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.relative.edit.replacementSequence");
            }
            if (name.equals("replacedSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.relative.edit.replacedSequence");
            }
            return super.addChild(name);
        }

        @Override
        public MolecularSequenceRelativeEditComponent copy() {
            MolecularSequenceRelativeEditComponent dst = new MolecularSequenceRelativeEditComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MolecularSequenceRelativeEditComponent dst) {
            super.copyValues(dst);
            dst.start = this.start == null ? null : this.start.copy();
            dst.end = this.end == null ? null : this.end.copy();
            dst.replacementSequence = this.replacementSequence == null ? null : this.replacementSequence.copy();
            dst.replacedSequence = this.replacedSequence == null ? null : this.replacedSequence.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceRelativeEditComponent)) {
                return false;
            }
            MolecularSequenceRelativeEditComponent o = (MolecularSequenceRelativeEditComponent)other_;
            return MolecularSequenceRelativeEditComponent.compareDeep(this.start, o.start, true) && MolecularSequenceRelativeEditComponent.compareDeep(this.end, o.end, true) && MolecularSequenceRelativeEditComponent.compareDeep(this.replacementSequence, o.replacementSequence, true) && MolecularSequenceRelativeEditComponent.compareDeep(this.replacedSequence, o.replacedSequence, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceRelativeEditComponent)) {
                return false;
            }
            MolecularSequenceRelativeEditComponent o = (MolecularSequenceRelativeEditComponent)other_;
            return MolecularSequenceRelativeEditComponent.compareValues(this.start, o.start, true) && MolecularSequenceRelativeEditComponent.compareValues(this.end, o.end, true) && MolecularSequenceRelativeEditComponent.compareValues(this.replacementSequence, o.replacementSequence, true) && MolecularSequenceRelativeEditComponent.compareValues(this.replacedSequence, o.replacedSequence, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.start, this.end, this.replacementSequence, this.replacedSequence);
        }

        @Override
        public String fhirType() {
            return "MolecularSequence.relative.edit";
        }
    }

    @Block
    public static class MolecularSequenceRelativeStartingSequenceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="genomeAssembly", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The genome assembly used for starting sequence, e.g. GRCh38", formalDefinition="The genome assembly used for starting sequence, e.g. GRCh38.")
        @Binding(valueSet="http://loinc.org/LL1040-6/")
        protected CodeableConcept genomeAssembly;
        @Child(name="chromosome", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Chromosome Identifier", formalDefinition="Structural unit composed of a nucleic acid molecule which controls its own replication through the interaction of specific proteins at one or more origins of replication ([SO:0000340](http://www.sequenceontology.org/browser/current_svn/term/SO:0000340)).")
        @Binding(valueSet="http://loinc.org/LL2938-0/")
        protected CodeableConcept chromosome;
        @Child(name="sequence", type={CodeableConcept.class, StringType.class, MolecularSequence.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The reference sequence that represents the starting sequence", formalDefinition="The reference sequence that represents the starting sequence.")
        protected DataType sequence;
        @Child(name="windowStart", type={IntegerType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Start position of the window on the starting sequence", formalDefinition="Start position of the window on the starting sequence. This value should honor the rules of the coordinateSystem.")
        protected IntegerType windowStart;
        @Child(name="windowEnd", type={IntegerType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="End position of the window on the starting sequence", formalDefinition="End position of the window on the starting sequence. This value should honor the rules of the  coordinateSystem.")
        protected IntegerType windowEnd;
        @Child(name="orientation", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="sense | antisense", formalDefinition="A relative reference to a DNA strand based on gene orientation. The strand that contains the open reading frame of the gene is the \"sense\" strand, and the opposite complementary strand is the \"antisense\" strand.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/orientation-type")
        protected Enumeration<OrientationType> orientation;
        @Child(name="strand", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="watson | crick", formalDefinition="An absolute reference to a strand. The Watson strand is the strand whose 5'-end is on the short arm of the chromosome, and the Crick strand as the one whose 5'-end is on the long arm.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/strand-type")
        protected Enumeration<StrandType> strand;
        private static final long serialVersionUID = 502438613L;

        public CodeableConcept getGenomeAssembly() {
            if (this.genomeAssembly == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRelativeStartingSequenceComponent.genomeAssembly");
                }
                if (Configuration.doAutoCreate()) {
                    this.genomeAssembly = new CodeableConcept();
                }
            }
            return this.genomeAssembly;
        }

        public boolean hasGenomeAssembly() {
            return this.genomeAssembly != null && !this.genomeAssembly.isEmpty();
        }

        public MolecularSequenceRelativeStartingSequenceComponent setGenomeAssembly(CodeableConcept value) {
            this.genomeAssembly = value;
            return this;
        }

        public CodeableConcept getChromosome() {
            if (this.chromosome == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRelativeStartingSequenceComponent.chromosome");
                }
                if (Configuration.doAutoCreate()) {
                    this.chromosome = new CodeableConcept();
                }
            }
            return this.chromosome;
        }

        public boolean hasChromosome() {
            return this.chromosome != null && !this.chromosome.isEmpty();
        }

        public MolecularSequenceRelativeStartingSequenceComponent setChromosome(CodeableConcept value) {
            this.chromosome = value;
            return this;
        }

        public DataType getSequence() {
            return this.sequence;
        }

        public CodeableConcept getSequenceCodeableConcept() throws FHIRException {
            if (this.sequence == null) {
                this.sequence = new CodeableConcept();
            }
            if (!(this.sequence instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.sequence.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.sequence;
        }

        public boolean hasSequenceCodeableConcept() {
            return this != null && this.sequence instanceof CodeableConcept;
        }

        public StringType getSequenceStringType() throws FHIRException {
            if (this.sequence == null) {
                this.sequence = new StringType();
            }
            if (!(this.sequence instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.sequence.getClass().getName() + " was encountered");
            }
            return (StringType)this.sequence;
        }

        public boolean hasSequenceStringType() {
            return this != null && this.sequence instanceof StringType;
        }

        public Reference getSequenceReference() throws FHIRException {
            if (this.sequence == null) {
                this.sequence = new Reference();
            }
            if (!(this.sequence instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.sequence.getClass().getName() + " was encountered");
            }
            return (Reference)this.sequence;
        }

        public boolean hasSequenceReference() {
            return this != null && this.sequence instanceof Reference;
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public MolecularSequenceRelativeStartingSequenceComponent setSequence(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof StringType || value instanceof Reference)) {
                throw new Error("Not the right type for MolecularSequence.relative.startingSequence.sequence[x]: " + value.fhirType());
            }
            this.sequence = value;
            return this;
        }

        public IntegerType getWindowStartElement() {
            if (this.windowStart == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRelativeStartingSequenceComponent.windowStart");
                }
                if (Configuration.doAutoCreate()) {
                    this.windowStart = new IntegerType();
                }
            }
            return this.windowStart;
        }

        public boolean hasWindowStartElement() {
            return this.windowStart != null && !this.windowStart.isEmpty();
        }

        public boolean hasWindowStart() {
            return this.windowStart != null && !this.windowStart.isEmpty();
        }

        public MolecularSequenceRelativeStartingSequenceComponent setWindowStartElement(IntegerType value) {
            this.windowStart = value;
            return this;
        }

        public int getWindowStart() {
            return this.windowStart == null || this.windowStart.isEmpty() ? 0 : (Integer)this.windowStart.getValue();
        }

        public MolecularSequenceRelativeStartingSequenceComponent setWindowStart(int value) {
            if (this.windowStart == null) {
                this.windowStart = new IntegerType();
            }
            this.windowStart.setValue((Object)value);
            return this;
        }

        public IntegerType getWindowEndElement() {
            if (this.windowEnd == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRelativeStartingSequenceComponent.windowEnd");
                }
                if (Configuration.doAutoCreate()) {
                    this.windowEnd = new IntegerType();
                }
            }
            return this.windowEnd;
        }

        public boolean hasWindowEndElement() {
            return this.windowEnd != null && !this.windowEnd.isEmpty();
        }

        public boolean hasWindowEnd() {
            return this.windowEnd != null && !this.windowEnd.isEmpty();
        }

        public MolecularSequenceRelativeStartingSequenceComponent setWindowEndElement(IntegerType value) {
            this.windowEnd = value;
            return this;
        }

        public int getWindowEnd() {
            return this.windowEnd == null || this.windowEnd.isEmpty() ? 0 : (Integer)this.windowEnd.getValue();
        }

        public MolecularSequenceRelativeStartingSequenceComponent setWindowEnd(int value) {
            if (this.windowEnd == null) {
                this.windowEnd = new IntegerType();
            }
            this.windowEnd.setValue((Object)value);
            return this;
        }

        public Enumeration<OrientationType> getOrientationElement() {
            if (this.orientation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRelativeStartingSequenceComponent.orientation");
                }
                if (Configuration.doAutoCreate()) {
                    this.orientation = new Enumeration<OrientationType>(new OrientationTypeEnumFactory());
                }
            }
            return this.orientation;
        }

        public boolean hasOrientationElement() {
            return this.orientation != null && !this.orientation.isEmpty();
        }

        public boolean hasOrientation() {
            return this.orientation != null && !this.orientation.isEmpty();
        }

        public MolecularSequenceRelativeStartingSequenceComponent setOrientationElement(Enumeration<OrientationType> value) {
            this.orientation = value;
            return this;
        }

        public OrientationType getOrientation() {
            return this.orientation == null ? null : (OrientationType)((Object)this.orientation.getValue());
        }

        public MolecularSequenceRelativeStartingSequenceComponent setOrientation(OrientationType value) {
            if (value == null) {
                this.orientation = null;
            } else {
                if (this.orientation == null) {
                    this.orientation = new Enumeration<OrientationType>(new OrientationTypeEnumFactory());
                }
                this.orientation.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<StrandType> getStrandElement() {
            if (this.strand == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRelativeStartingSequenceComponent.strand");
                }
                if (Configuration.doAutoCreate()) {
                    this.strand = new Enumeration<StrandType>(new StrandTypeEnumFactory());
                }
            }
            return this.strand;
        }

        public boolean hasStrandElement() {
            return this.strand != null && !this.strand.isEmpty();
        }

        public boolean hasStrand() {
            return this.strand != null && !this.strand.isEmpty();
        }

        public MolecularSequenceRelativeStartingSequenceComponent setStrandElement(Enumeration<StrandType> value) {
            this.strand = value;
            return this;
        }

        public StrandType getStrand() {
            return this.strand == null ? null : (StrandType)((Object)this.strand.getValue());
        }

        public MolecularSequenceRelativeStartingSequenceComponent setStrand(StrandType value) {
            if (value == null) {
                this.strand = null;
            } else {
                if (this.strand == null) {
                    this.strand = new Enumeration<StrandType>(new StrandTypeEnumFactory());
                }
                this.strand.setValue((Object)value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("genomeAssembly", "CodeableConcept", "The genome assembly used for starting sequence, e.g. GRCh38.", 0, 1, this.genomeAssembly));
            children.add(new Property("chromosome", "CodeableConcept", "Structural unit composed of a nucleic acid molecule which controls its own replication through the interaction of specific proteins at one or more origins of replication ([SO:0000340](http://www.sequenceontology.org/browser/current_svn/term/SO:0000340)).", 0, 1, this.chromosome));
            children.add(new Property("sequence[x]", "CodeableConcept|string|Reference(MolecularSequence)", "The reference sequence that represents the starting sequence.", 0, 1, this.sequence));
            children.add(new Property("windowStart", "integer", "Start position of the window on the starting sequence. This value should honor the rules of the coordinateSystem.", 0, 1, this.windowStart));
            children.add(new Property("windowEnd", "integer", "End position of the window on the starting sequence. This value should honor the rules of the  coordinateSystem.", 0, 1, this.windowEnd));
            children.add(new Property("orientation", "code", "A relative reference to a DNA strand based on gene orientation. The strand that contains the open reading frame of the gene is the \"sense\" strand, and the opposite complementary strand is the \"antisense\" strand.", 0, 1, this.orientation));
            children.add(new Property("strand", "code", "An absolute reference to a strand. The Watson strand is the strand whose 5'-end is on the short arm of the chromosome, and the Crick strand as the one whose 5'-end is on the long arm.", 0, 1, this.strand));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1196021757: {
                    return new Property("genomeAssembly", "CodeableConcept", "The genome assembly used for starting sequence, e.g. GRCh38.", 0, 1, this.genomeAssembly);
                }
                case -1499470472: {
                    return new Property("chromosome", "CodeableConcept", "Structural unit composed of a nucleic acid molecule which controls its own replication through the interaction of specific proteins at one or more origins of replication ([SO:0000340](http://www.sequenceontology.org/browser/current_svn/term/SO:0000340)).", 0, 1, this.chromosome);
                }
                case -805222113: {
                    return new Property("sequence[x]", "CodeableConcept|string|Reference(MolecularSequence)", "The reference sequence that represents the starting sequence.", 0, 1, this.sequence);
                }
                case 1349547969: {
                    return new Property("sequence[x]", "CodeableConcept|string|Reference(MolecularSequence)", "The reference sequence that represents the starting sequence.", 0, 1, this.sequence);
                }
                case 1508480416: {
                    return new Property("sequence[x]", "CodeableConcept", "The reference sequence that represents the starting sequence.", 0, 1, this.sequence);
                }
                case -1211617486: {
                    return new Property("sequence[x]", "string", "The reference sequence that represents the starting sequence.", 0, 1, this.sequence);
                }
                case -1127149430: {
                    return new Property("sequence[x]", "Reference(MolecularSequence)", "The reference sequence that represents the starting sequence.", 0, 1, this.sequence);
                }
                case 1903685202: {
                    return new Property("windowStart", "integer", "Start position of the window on the starting sequence. This value should honor the rules of the coordinateSystem.", 0, 1, this.windowStart);
                }
                case -217026869: {
                    return new Property("windowEnd", "integer", "End position of the window on the starting sequence. This value should honor the rules of the  coordinateSystem.", 0, 1, this.windowEnd);
                }
                case -1439500848: {
                    return new Property("orientation", "code", "A relative reference to a DNA strand based on gene orientation. The strand that contains the open reading frame of the gene is the \"sense\" strand, and the opposite complementary strand is the \"antisense\" strand.", 0, 1, this.orientation);
                }
                case -891993594: {
                    return new Property("strand", "code", "An absolute reference to a strand. The Watson strand is the strand whose 5'-end is on the short arm of the chromosome, and the Crick strand as the one whose 5'-end is on the long arm.", 0, 1, this.strand);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1196021757: {
                    Base[] baseArray;
                    if (this.genomeAssembly == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.genomeAssembly;
                    }
                    return baseArray;
                }
                case -1499470472: {
                    Base[] baseArray;
                    if (this.chromosome == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.chromosome;
                    }
                    return baseArray;
                }
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 1903685202: {
                    Base[] baseArray;
                    if (this.windowStart == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.windowStart;
                    }
                    return baseArray;
                }
                case -217026869: {
                    Base[] baseArray;
                    if (this.windowEnd == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.windowEnd;
                    }
                    return baseArray;
                }
                case -1439500848: {
                    Base[] baseArray;
                    if (this.orientation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.orientation;
                    }
                    return baseArray;
                }
                case -891993594: {
                    Base[] baseArray;
                    if (this.strand == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.strand;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1196021757: {
                    this.genomeAssembly = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1499470472: {
                    this.chromosome = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1349547969: {
                    this.sequence = TypeConvertor.castToType(value);
                    return value;
                }
                case 1903685202: {
                    this.windowStart = TypeConvertor.castToInteger(value);
                    return value;
                }
                case -217026869: {
                    this.windowEnd = TypeConvertor.castToInteger(value);
                    return value;
                }
                case -1439500848: {
                    value = new OrientationTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.orientation = value;
                    return value;
                }
                case -891993594: {
                    value = new StrandTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.strand = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("genomeAssembly")) {
                this.genomeAssembly = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("chromosome")) {
                this.chromosome = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("sequence[x]")) {
                this.sequence = TypeConvertor.castToType(value);
            } else if (name.equals("windowStart")) {
                this.windowStart = TypeConvertor.castToInteger(value);
            } else if (name.equals("windowEnd")) {
                this.windowEnd = TypeConvertor.castToInteger(value);
            } else if (name.equals("orientation")) {
                value = new OrientationTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.orientation = value;
            } else if (name.equals("strand")) {
                value = new StrandTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.strand = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1196021757: {
                    return this.getGenomeAssembly();
                }
                case -1499470472: {
                    return this.getChromosome();
                }
                case -805222113: {
                    return this.getSequence();
                }
                case 1349547969: {
                    return this.getSequence();
                }
                case 1903685202: {
                    return this.getWindowStartElement();
                }
                case -217026869: {
                    return this.getWindowEndElement();
                }
                case -1439500848: {
                    return this.getOrientationElement();
                }
                case -891993594: {
                    return this.getStrandElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1196021757: {
                    return new String[]{"CodeableConcept"};
                }
                case -1499470472: {
                    return new String[]{"CodeableConcept"};
                }
                case 1349547969: {
                    return new String[]{"CodeableConcept", "string", "Reference"};
                }
                case 1903685202: {
                    return new String[]{"integer"};
                }
                case -217026869: {
                    return new String[]{"integer"};
                }
                case -1439500848: {
                    return new String[]{"code"};
                }
                case -891993594: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("genomeAssembly")) {
                this.genomeAssembly = new CodeableConcept();
                return this.genomeAssembly;
            }
            if (name.equals("chromosome")) {
                this.chromosome = new CodeableConcept();
                return this.chromosome;
            }
            if (name.equals("sequenceCodeableConcept")) {
                this.sequence = new CodeableConcept();
                return this.sequence;
            }
            if (name.equals("sequenceString")) {
                this.sequence = new StringType();
                return this.sequence;
            }
            if (name.equals("sequenceReference")) {
                this.sequence = new Reference();
                return this.sequence;
            }
            if (name.equals("windowStart")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.relative.startingSequence.windowStart");
            }
            if (name.equals("windowEnd")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.relative.startingSequence.windowEnd");
            }
            if (name.equals("orientation")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.relative.startingSequence.orientation");
            }
            if (name.equals("strand")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.relative.startingSequence.strand");
            }
            return super.addChild(name);
        }

        @Override
        public MolecularSequenceRelativeStartingSequenceComponent copy() {
            MolecularSequenceRelativeStartingSequenceComponent dst = new MolecularSequenceRelativeStartingSequenceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MolecularSequenceRelativeStartingSequenceComponent dst) {
            super.copyValues(dst);
            dst.genomeAssembly = this.genomeAssembly == null ? null : this.genomeAssembly.copy();
            dst.chromosome = this.chromosome == null ? null : this.chromosome.copy();
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.windowStart = this.windowStart == null ? null : this.windowStart.copy();
            dst.windowEnd = this.windowEnd == null ? null : this.windowEnd.copy();
            dst.orientation = this.orientation == null ? null : this.orientation.copy();
            dst.strand = this.strand == null ? null : this.strand.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceRelativeStartingSequenceComponent)) {
                return false;
            }
            MolecularSequenceRelativeStartingSequenceComponent o = (MolecularSequenceRelativeStartingSequenceComponent)other_;
            return MolecularSequenceRelativeStartingSequenceComponent.compareDeep(this.genomeAssembly, o.genomeAssembly, true) && MolecularSequenceRelativeStartingSequenceComponent.compareDeep(this.chromosome, o.chromosome, true) && MolecularSequenceRelativeStartingSequenceComponent.compareDeep(this.sequence, o.sequence, true) && MolecularSequenceRelativeStartingSequenceComponent.compareDeep(this.windowStart, o.windowStart, true) && MolecularSequenceRelativeStartingSequenceComponent.compareDeep(this.windowEnd, o.windowEnd, true) && MolecularSequenceRelativeStartingSequenceComponent.compareDeep(this.orientation, o.orientation, true) && MolecularSequenceRelativeStartingSequenceComponent.compareDeep(this.strand, o.strand, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceRelativeStartingSequenceComponent)) {
                return false;
            }
            MolecularSequenceRelativeStartingSequenceComponent o = (MolecularSequenceRelativeStartingSequenceComponent)other_;
            return MolecularSequenceRelativeStartingSequenceComponent.compareValues(this.windowStart, o.windowStart, true) && MolecularSequenceRelativeStartingSequenceComponent.compareValues(this.windowEnd, o.windowEnd, true) && MolecularSequenceRelativeStartingSequenceComponent.compareValues(this.orientation, o.orientation, true) && MolecularSequenceRelativeStartingSequenceComponent.compareValues(this.strand, o.strand, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.genomeAssembly, this.chromosome, this.sequence, this.windowStart, this.windowEnd, this.orientation, this.strand);
        }

        @Override
        public String fhirType() {
            return "MolecularSequence.relative.startingSequence";
        }
    }

    @Block
    public static class MolecularSequenceRelativeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="coordinateSystem", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Ways of identifying nucleotides or amino acids within a sequence", formalDefinition="These are different ways of identifying nucleotides or amino acids within a sequence. Different databases and file types may use different systems. For detail definitions, see https://loinc.org/92822-6/ for more detail.")
        @Binding(valueSet="http://loinc.org/LL5323-2/")
        protected CodeableConcept coordinateSystem;
        @Child(name="ordinalPosition", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates the order in which the sequence should be considered when putting multiple 'relative' elements together", formalDefinition="Indicates the order in which the sequence should be considered when putting multiple 'relative' elements together.")
        protected IntegerType ordinalPosition;
        @Child(name="sequenceRange", type={Range.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates the nucleotide range in the composed sequence when multiple 'relative' elements are used together", formalDefinition="Indicates the nucleotide range in the composed sequence when multiple 'relative' elements are used together.")
        protected Range sequenceRange;
        @Child(name="startingSequence", type={}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A sequence used as starting sequence", formalDefinition="A sequence that is used as a starting sequence to describe variants that are present in a sequence analyzed.")
        protected MolecularSequenceRelativeStartingSequenceComponent startingSequence;
        @Child(name="edit", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Changes in sequence from the starting sequence", formalDefinition="Changes in sequence from the starting sequence.")
        protected List<MolecularSequenceRelativeEditComponent> edit;
        private static final long serialVersionUID = -1455983973L;

        public MolecularSequenceRelativeComponent() {
        }

        public MolecularSequenceRelativeComponent(CodeableConcept coordinateSystem) {
            this.setCoordinateSystem(coordinateSystem);
        }

        public CodeableConcept getCoordinateSystem() {
            if (this.coordinateSystem == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRelativeComponent.coordinateSystem");
                }
                if (Configuration.doAutoCreate()) {
                    this.coordinateSystem = new CodeableConcept();
                }
            }
            return this.coordinateSystem;
        }

        public boolean hasCoordinateSystem() {
            return this.coordinateSystem != null && !this.coordinateSystem.isEmpty();
        }

        public MolecularSequenceRelativeComponent setCoordinateSystem(CodeableConcept value) {
            this.coordinateSystem = value;
            return this;
        }

        public IntegerType getOrdinalPositionElement() {
            if (this.ordinalPosition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRelativeComponent.ordinalPosition");
                }
                if (Configuration.doAutoCreate()) {
                    this.ordinalPosition = new IntegerType();
                }
            }
            return this.ordinalPosition;
        }

        public boolean hasOrdinalPositionElement() {
            return this.ordinalPosition != null && !this.ordinalPosition.isEmpty();
        }

        public boolean hasOrdinalPosition() {
            return this.ordinalPosition != null && !this.ordinalPosition.isEmpty();
        }

        public MolecularSequenceRelativeComponent setOrdinalPositionElement(IntegerType value) {
            this.ordinalPosition = value;
            return this;
        }

        public int getOrdinalPosition() {
            return this.ordinalPosition == null || this.ordinalPosition.isEmpty() ? 0 : (Integer)this.ordinalPosition.getValue();
        }

        public MolecularSequenceRelativeComponent setOrdinalPosition(int value) {
            if (this.ordinalPosition == null) {
                this.ordinalPosition = new IntegerType();
            }
            this.ordinalPosition.setValue((Object)value);
            return this;
        }

        public Range getSequenceRange() {
            if (this.sequenceRange == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRelativeComponent.sequenceRange");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequenceRange = new Range();
                }
            }
            return this.sequenceRange;
        }

        public boolean hasSequenceRange() {
            return this.sequenceRange != null && !this.sequenceRange.isEmpty();
        }

        public MolecularSequenceRelativeComponent setSequenceRange(Range value) {
            this.sequenceRange = value;
            return this;
        }

        public MolecularSequenceRelativeStartingSequenceComponent getStartingSequence() {
            if (this.startingSequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MolecularSequenceRelativeComponent.startingSequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.startingSequence = new MolecularSequenceRelativeStartingSequenceComponent();
                }
            }
            return this.startingSequence;
        }

        public boolean hasStartingSequence() {
            return this.startingSequence != null && !this.startingSequence.isEmpty();
        }

        public MolecularSequenceRelativeComponent setStartingSequence(MolecularSequenceRelativeStartingSequenceComponent value) {
            this.startingSequence = value;
            return this;
        }

        public List<MolecularSequenceRelativeEditComponent> getEdit() {
            if (this.edit == null) {
                this.edit = new ArrayList<MolecularSequenceRelativeEditComponent>();
            }
            return this.edit;
        }

        public MolecularSequenceRelativeComponent setEdit(List<MolecularSequenceRelativeEditComponent> theEdit) {
            this.edit = theEdit;
            return this;
        }

        public boolean hasEdit() {
            if (this.edit == null) {
                return false;
            }
            for (MolecularSequenceRelativeEditComponent item : this.edit) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MolecularSequenceRelativeEditComponent addEdit() {
            MolecularSequenceRelativeEditComponent t = new MolecularSequenceRelativeEditComponent();
            if (this.edit == null) {
                this.edit = new ArrayList<MolecularSequenceRelativeEditComponent>();
            }
            this.edit.add(t);
            return t;
        }

        public MolecularSequenceRelativeComponent addEdit(MolecularSequenceRelativeEditComponent t) {
            if (t == null) {
                return this;
            }
            if (this.edit == null) {
                this.edit = new ArrayList<MolecularSequenceRelativeEditComponent>();
            }
            this.edit.add(t);
            return this;
        }

        public MolecularSequenceRelativeEditComponent getEditFirstRep() {
            if (this.getEdit().isEmpty()) {
                this.addEdit();
            }
            return this.getEdit().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("coordinateSystem", "CodeableConcept", "These are different ways of identifying nucleotides or amino acids within a sequence. Different databases and file types may use different systems. For detail definitions, see https://loinc.org/92822-6/ for more detail.", 0, 1, this.coordinateSystem));
            children.add(new Property("ordinalPosition", "integer", "Indicates the order in which the sequence should be considered when putting multiple 'relative' elements together.", 0, 1, this.ordinalPosition));
            children.add(new Property("sequenceRange", "Range", "Indicates the nucleotide range in the composed sequence when multiple 'relative' elements are used together.", 0, 1, this.sequenceRange));
            children.add(new Property("startingSequence", "", "A sequence that is used as a starting sequence to describe variants that are present in a sequence analyzed.", 0, 1, this.startingSequence));
            children.add(new Property("edit", "", "Changes in sequence from the starting sequence.", 0, Integer.MAX_VALUE, this.edit));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 354212295: {
                    return new Property("coordinateSystem", "CodeableConcept", "These are different ways of identifying nucleotides or amino acids within a sequence. Different databases and file types may use different systems. For detail definitions, see https://loinc.org/92822-6/ for more detail.", 0, 1, this.coordinateSystem);
                }
                case 626439866: {
                    return new Property("ordinalPosition", "integer", "Indicates the order in which the sequence should be considered when putting multiple 'relative' elements together.", 0, 1, this.ordinalPosition);
                }
                case -733314564: {
                    return new Property("sequenceRange", "Range", "Indicates the nucleotide range in the composed sequence when multiple 'relative' elements are used together.", 0, 1, this.sequenceRange);
                }
                case 1493400609: {
                    return new Property("startingSequence", "", "A sequence that is used as a starting sequence to describe variants that are present in a sequence analyzed.", 0, 1, this.startingSequence);
                }
                case 3108362: {
                    return new Property("edit", "", "Changes in sequence from the starting sequence.", 0, Integer.MAX_VALUE, this.edit);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 354212295: {
                    Base[] baseArray;
                    if (this.coordinateSystem == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.coordinateSystem;
                    }
                    return baseArray;
                }
                case 626439866: {
                    Base[] baseArray;
                    if (this.ordinalPosition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.ordinalPosition;
                    }
                    return baseArray;
                }
                case -733314564: {
                    Base[] baseArray;
                    if (this.sequenceRange == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.sequenceRange;
                    }
                    return baseArray;
                }
                case 1493400609: {
                    Base[] baseArray;
                    if (this.startingSequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.startingSequence;
                    }
                    return baseArray;
                }
                case 3108362: {
                    return this.edit == null ? new Base[]{} : this.edit.toArray(new Base[this.edit.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 354212295: {
                    this.coordinateSystem = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 626439866: {
                    this.ordinalPosition = TypeConvertor.castToInteger(value);
                    return value;
                }
                case -733314564: {
                    this.sequenceRange = TypeConvertor.castToRange(value);
                    return value;
                }
                case 1493400609: {
                    this.startingSequence = (MolecularSequenceRelativeStartingSequenceComponent)value;
                    return value;
                }
                case 3108362: {
                    this.getEdit().add((MolecularSequenceRelativeEditComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("coordinateSystem")) {
                this.coordinateSystem = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("ordinalPosition")) {
                this.ordinalPosition = TypeConvertor.castToInteger(value);
            } else if (name.equals("sequenceRange")) {
                this.sequenceRange = TypeConvertor.castToRange(value);
            } else if (name.equals("startingSequence")) {
                this.startingSequence = (MolecularSequenceRelativeStartingSequenceComponent)value;
            } else if (name.equals("edit")) {
                this.getEdit().add((MolecularSequenceRelativeEditComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 354212295: {
                    return this.getCoordinateSystem();
                }
                case 626439866: {
                    return this.getOrdinalPositionElement();
                }
                case -733314564: {
                    return this.getSequenceRange();
                }
                case 1493400609: {
                    return this.getStartingSequence();
                }
                case 3108362: {
                    return this.addEdit();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 354212295: {
                    return new String[]{"CodeableConcept"};
                }
                case 626439866: {
                    return new String[]{"integer"};
                }
                case -733314564: {
                    return new String[]{"Range"};
                }
                case 1493400609: {
                    return new String[0];
                }
                case 3108362: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("coordinateSystem")) {
                this.coordinateSystem = new CodeableConcept();
                return this.coordinateSystem;
            }
            if (name.equals("ordinalPosition")) {
                throw new FHIRException("Cannot call addChild on a primitive type MolecularSequence.relative.ordinalPosition");
            }
            if (name.equals("sequenceRange")) {
                this.sequenceRange = new Range();
                return this.sequenceRange;
            }
            if (name.equals("startingSequence")) {
                this.startingSequence = new MolecularSequenceRelativeStartingSequenceComponent();
                return this.startingSequence;
            }
            if (name.equals("edit")) {
                return this.addEdit();
            }
            return super.addChild(name);
        }

        @Override
        public MolecularSequenceRelativeComponent copy() {
            MolecularSequenceRelativeComponent dst = new MolecularSequenceRelativeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MolecularSequenceRelativeComponent dst) {
            super.copyValues(dst);
            dst.coordinateSystem = this.coordinateSystem == null ? null : this.coordinateSystem.copy();
            dst.ordinalPosition = this.ordinalPosition == null ? null : this.ordinalPosition.copy();
            dst.sequenceRange = this.sequenceRange == null ? null : this.sequenceRange.copy();
            MolecularSequenceRelativeStartingSequenceComponent molecularSequenceRelativeStartingSequenceComponent = dst.startingSequence = this.startingSequence == null ? null : this.startingSequence.copy();
            if (this.edit != null) {
                dst.edit = new ArrayList<MolecularSequenceRelativeEditComponent>();
                for (MolecularSequenceRelativeEditComponent i2 : this.edit) {
                    dst.edit.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceRelativeComponent)) {
                return false;
            }
            MolecularSequenceRelativeComponent o = (MolecularSequenceRelativeComponent)other_;
            return MolecularSequenceRelativeComponent.compareDeep(this.coordinateSystem, o.coordinateSystem, true) && MolecularSequenceRelativeComponent.compareDeep(this.ordinalPosition, o.ordinalPosition, true) && MolecularSequenceRelativeComponent.compareDeep(this.sequenceRange, o.sequenceRange, true) && MolecularSequenceRelativeComponent.compareDeep(this.startingSequence, o.startingSequence, true) && MolecularSequenceRelativeComponent.compareDeep(this.edit, o.edit, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MolecularSequenceRelativeComponent)) {
                return false;
            }
            MolecularSequenceRelativeComponent o = (MolecularSequenceRelativeComponent)other_;
            return MolecularSequenceRelativeComponent.compareValues(this.ordinalPosition, o.ordinalPosition, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.coordinateSystem, this.ordinalPosition, this.sequenceRange, this.startingSequence, this.edit);
        }

        @Override
        public String fhirType() {
            return "MolecularSequence.relative";
        }
    }

    public static class StrandTypeEnumFactory
    implements EnumFactory<StrandType> {
        @Override
        public StrandType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("watson".equals(codeString)) {
                return StrandType.WATSON;
            }
            if ("crick".equals(codeString)) {
                return StrandType.CRICK;
            }
            throw new IllegalArgumentException("Unknown StrandType code '" + codeString + "'");
        }

        public Enumeration<StrandType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<StrandType>(this, StrandType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<StrandType>(this, StrandType.NULL, code);
            }
            if ("watson".equals(codeString)) {
                return new Enumeration<StrandType>(this, StrandType.WATSON, code);
            }
            if ("crick".equals(codeString)) {
                return new Enumeration<StrandType>(this, StrandType.CRICK, code);
            }
            throw new FHIRException("Unknown StrandType code '" + codeString + "'");
        }

        @Override
        public String toCode(StrandType code) {
            if (code == StrandType.WATSON) {
                return "watson";
            }
            if (code == StrandType.CRICK) {
                return "crick";
            }
            return "?";
        }

        @Override
        public String toSystem(StrandType code) {
            return code.getSystem();
        }
    }

    public static enum StrandType {
        WATSON,
        CRICK,
        NULL;


        public static StrandType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("watson".equals(codeString)) {
                return WATSON;
            }
            if ("crick".equals(codeString)) {
                return CRICK;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown StrandType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case WATSON: {
                    return "watson";
                }
                case CRICK: {
                    return "crick";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case WATSON: {
                    return "http://hl7.org/fhir/strand-type";
                }
                case CRICK: {
                    return "http://hl7.org/fhir/strand-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case WATSON: {
                    return "Watson strand of starting sequence.";
                }
                case CRICK: {
                    return "Crick strand of starting sequence.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case WATSON: {
                    return "Watson strand of starting sequence";
                }
                case CRICK: {
                    return "Crick strand of starting sequence";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class SequenceTypeEnumFactory
    implements EnumFactory<SequenceType> {
        @Override
        public SequenceType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("aa".equals(codeString)) {
                return SequenceType.AA;
            }
            if ("dna".equals(codeString)) {
                return SequenceType.DNA;
            }
            if ("rna".equals(codeString)) {
                return SequenceType.RNA;
            }
            throw new IllegalArgumentException("Unknown SequenceType code '" + codeString + "'");
        }

        public Enumeration<SequenceType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SequenceType>(this, SequenceType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<SequenceType>(this, SequenceType.NULL, code);
            }
            if ("aa".equals(codeString)) {
                return new Enumeration<SequenceType>(this, SequenceType.AA, code);
            }
            if ("dna".equals(codeString)) {
                return new Enumeration<SequenceType>(this, SequenceType.DNA, code);
            }
            if ("rna".equals(codeString)) {
                return new Enumeration<SequenceType>(this, SequenceType.RNA, code);
            }
            throw new FHIRException("Unknown SequenceType code '" + codeString + "'");
        }

        @Override
        public String toCode(SequenceType code) {
            if (code == SequenceType.AA) {
                return "aa";
            }
            if (code == SequenceType.DNA) {
                return "dna";
            }
            if (code == SequenceType.RNA) {
                return "rna";
            }
            return "?";
        }

        @Override
        public String toSystem(SequenceType code) {
            return code.getSystem();
        }
    }

    public static enum SequenceType {
        AA,
        DNA,
        RNA,
        NULL;


        public static SequenceType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("aa".equals(codeString)) {
                return AA;
            }
            if ("dna".equals(codeString)) {
                return DNA;
            }
            if ("rna".equals(codeString)) {
                return RNA;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SequenceType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case AA: {
                    return "aa";
                }
                case DNA: {
                    return "dna";
                }
                case RNA: {
                    return "rna";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case AA: {
                    return "http://hl7.org/fhir/sequence-type";
                }
                case DNA: {
                    return "http://hl7.org/fhir/sequence-type";
                }
                case RNA: {
                    return "http://hl7.org/fhir/sequence-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case AA: {
                    return "Amino acid sequence.";
                }
                case DNA: {
                    return "DNA Sequence.";
                }
                case RNA: {
                    return "RNA Sequence.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case AA: {
                    return "AA Sequence";
                }
                case DNA: {
                    return "DNA Sequence";
                }
                case RNA: {
                    return "RNA Sequence";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class OrientationTypeEnumFactory
    implements EnumFactory<OrientationType> {
        @Override
        public OrientationType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("sense".equals(codeString)) {
                return OrientationType.SENSE;
            }
            if ("antisense".equals(codeString)) {
                return OrientationType.ANTISENSE;
            }
            throw new IllegalArgumentException("Unknown OrientationType code '" + codeString + "'");
        }

        public Enumeration<OrientationType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<OrientationType>(this, OrientationType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<OrientationType>(this, OrientationType.NULL, code);
            }
            if ("sense".equals(codeString)) {
                return new Enumeration<OrientationType>(this, OrientationType.SENSE, code);
            }
            if ("antisense".equals(codeString)) {
                return new Enumeration<OrientationType>(this, OrientationType.ANTISENSE, code);
            }
            throw new FHIRException("Unknown OrientationType code '" + codeString + "'");
        }

        @Override
        public String toCode(OrientationType code) {
            if (code == OrientationType.SENSE) {
                return "sense";
            }
            if (code == OrientationType.ANTISENSE) {
                return "antisense";
            }
            return "?";
        }

        @Override
        public String toSystem(OrientationType code) {
            return code.getSystem();
        }
    }

    public static enum OrientationType {
        SENSE,
        ANTISENSE,
        NULL;


        public static OrientationType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("sense".equals(codeString)) {
                return SENSE;
            }
            if ("antisense".equals(codeString)) {
                return ANTISENSE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown OrientationType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SENSE: {
                    return "sense";
                }
                case ANTISENSE: {
                    return "antisense";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SENSE: {
                    return "http://hl7.org/fhir/orientation-type";
                }
                case ANTISENSE: {
                    return "http://hl7.org/fhir/orientation-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SENSE: {
                    return "Sense orientation of reference sequence.";
                }
                case ANTISENSE: {
                    return "Antisense orientation of reference sequence.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SENSE: {
                    return "Sense orientation of referenceSeq";
                }
                case ANTISENSE: {
                    return "Antisense orientation of referenceSeq";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

